/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.internal;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.adagio.synchro.intercept.SynchroWriteBuffer;
import java.sql.SQLException;

public class RemoteIdWriteInterceptor
extends SynchroInterceptorBase {
    private final String tableName;
    private final int columnIndex;
    private final boolean isNullable;

    public RemoteIdWriteInterceptor(SynchroInterceptor next, String tableName, int columnIndex, boolean isNullable) {
        super(next);
        Preconditions.checkArgument((columnIndex >= 0 ? 1 : 0) != 0);
        this.tableName = tableName;
        this.columnIndex = columnIndex;
        this.isNullable = isNullable;
    }

    public RemoteIdWriteInterceptor(String tableName, int columnIndex, boolean isNullable) {
        Preconditions.checkArgument((columnIndex >= 0 ? 1 : 0) != 0);
        this.tableName = tableName;
        this.columnIndex = columnIndex;
        this.isNullable = isNullable;
    }

    @Override
    protected void doOnWrite(Object[] data, SynchroTableDao dao, SynchroWriteBuffer buffer) throws SQLException {
        Integer remoteId = (Integer)data[this.columnIndex];
        if (remoteId == null) {
            return;
        }
        Integer localId = dao.getIdFromRemoteId(this.tableName, remoteId);
        if (localId == null) {
            if (!this.isNullable) {
                throw new SynchroTechnicalException(String.format("Could not retrieve ID corresponding to REMOTE_ID=%s, for table %s", remoteId, this.tableName));
            }
            buffer.addMissingRemoteId(this.tableName, this.columnIndex, null, remoteId);
            data[this.columnIndex] = null;
        } else {
            data[this.columnIndex] = localId;
        }
    }

    @Override
    public boolean enableOnWrite() {
        return true;
    }
}

