/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.dao;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.SQLExceptionConverter;

public class DaoUtils {
    private static final Log log = LogFactory.getLog(DaoUtils.class);
    private static final String JDBC_URL_PREFIX_HSQLDB = "jdbc:hsqldb:file:";

    protected DaoUtils() {
    }

    public static Properties getConnectionProperties(String jdbcUrl, String username, String password, String schema, String dialect, String driver) {
        Properties p = new Properties();
        p.setProperty("hibernate.connection.driver_class", driver);
        p.setProperty("hibernate.dialect", dialect);
        p.setProperty("hibernate.connection.url", jdbcUrl);
        p.setProperty("hibernate.connection.username", username);
        p.setProperty("hibernate.connection.password", password);
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            p.setProperty("hibernate.default_schema", schema);
        }
        p.setProperty("hibernate.synonyms", "true");
        if (jdbcUrl.startsWith("jdbc:oracle")) {
            p.setProperty("hibernatetool.metadatadialect", "org.hibernate.cfg.rveng.dialect.OracleMetaDataDialect");
        }
        return p;
    }

    public static SQLExceptionConverter newSQLExceptionConverter(final Dialect dialect) {
        return new SQLExceptionConverter(){
            private static final long serialVersionUID = 5458961195167573495L;
            SQLExceptionConversionDelegate delegate;
            {
                this.delegate = dialect.buildSQLExceptionConversionDelegate();
            }

            public JDBCException convert(SQLException sqlException, String message, String sql) {
                JDBCException exception = this.delegate.convert(sqlException, message, sql);
                if (exception != null) {
                    return exception;
                }
                return new GenericJDBCException(message, sqlException, sql);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownDatabase(Properties connectionProperties) throws SQLException {
        Connection conn = DaoUtils.createConnection(connectionProperties);
        try {
            DaoUtils.shutdownDatabase(conn);
        }
        finally {
            DaoUtils.closeSilently(conn);
        }
    }

    public static void closeSilently(Statement statement) {
        block9: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(Connection connection) {
        block3: {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Could not close connection, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(ResultSet statement) {
        block9: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(Session session) {
        block3: {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Could not close session, but do not care", (Throwable)e);
            }
        }
    }

    public static Connection createConnection(Properties connectionProperties) throws SQLException {
        return DaoUtils.createConnection(connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    public static Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    public static void fillConnectionProperties(Properties p, String url, String username, String password) {
        p.put("hibernate.connection.url", url);
        p.put("hibernate.connection.username", username);
        p.put("hibernate.connection.password", password);
    }

    public static String getJdbcUrl(File directory, String dbName) {
        String jdbcUrl = JDBC_URL_PREFIX_HSQLDB + directory.getAbsolutePath() + "/" + dbName;
        jdbcUrl = jdbcUrl.replaceAll("\\\\", "/");
        return jdbcUrl;
    }

    public static boolean isFileDatabase(String jdbcUrl) {
        Preconditions.checkNotNull((Object)jdbcUrl);
        return jdbcUrl.startsWith(JDBC_URL_PREFIX_HSQLDB);
    }

    public static boolean isValidConnectionProperties(Properties connectionProperties) {
        return DaoUtils.isValidConnectionProperties(connectionProperties.getProperty("hibernate.connection.driver_class"), connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidConnectionProperties(String jdbcDriver, String jdbcUrl, String user, String password) {
        boolean bl;
        String driverClassName = jdbcDriver;
        try {
            Class<?> driverClass = Class.forName(driverClassName);
            DriverManager.registerDriver((Driver)driverClass.newInstance());
        }
        catch (Exception e) {
            log.error((Object)("Could not load JDBC Driver: " + e.getMessage()), (Throwable)e);
            return false;
        }
        Connection connection = null;
        try {
            connection = DaoUtils.createConnection(jdbcUrl, user, password);
            bl = true;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Could not connect to database: " + e.getMessage().trim()));
            }
            catch (Throwable throwable) {
                DaoUtils.closeSilently(connection);
                throw throwable;
            }
            DaoUtils.closeSilently(connection);
            return false;
        }
        DaoUtils.closeSilently(connection);
        return bl;
    }

    public static String getUrl(Properties connectionProperties) {
        return connectionProperties.getProperty("hibernate.connection.url");
    }

    public static Dialect getDialect(Properties connectionProperties) {
        return Dialect.getDialect((Properties)connectionProperties);
    }

    public static Configuration getConfiguration(Properties connectionProperties) {
        return new Configuration().setProperties(connectionProperties);
    }

    public static void shutdownDatabase(Connection connection) {
        try {
            String jdbcUrl = connection.getMetaData().getURL();
            if (jdbcUrl.startsWith(JDBC_URL_PREFIX_HSQLDB)) {
                DaoUtils.sqlUpdate(connection, "SHUTDOWN");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static int sqlUpdate(Connection connection, String sql) {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
        }
        catch (SQLException ex) {
            DaoUtils.closeSilently(stmt);
            throw new SynchroTechnicalException("Could not open database connection", ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sql);
        }
        try {
            int ex = stmt.executeUpdate(sql);
            return ex;
        }
        catch (SQLException ex) {
            throw new SynchroTechnicalException("Could not execute query: " + sql, ex);
        }
        finally {
            DaoUtils.closeSilently(stmt);
        }
    }
}

