/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.synchro.service.SynchroPendingOperationBuffer;
import fr.ifremer.adagio.synchro.service.SynchroResult;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SynchroContext {
    protected Properties sourceConnectionProperties;
    protected Properties targetConnectionProperties;
    protected SynchroResult result;
    protected Predicate<String> tableFilter;
    protected Set<String> tableNames;
    protected Map<String, SynchroPendingOperationBuffer> tableContextMap = Maps.newHashMap();

    public static SynchroContext newContext(Set<String> tableNames, Predicate<String> tableFilter, Properties sourceConnectionProperties, Properties targetConnectionProperties, SynchroResult result) {
        SynchroContext context = new SynchroContext();
        context.setTableNames(tableNames);
        context.setTableFilter(tableFilter);
        context.setSourceConnectionProperties(sourceConnectionProperties);
        context.setTargetConnectionProperties(targetConnectionProperties);
        context.setResult(result);
        return context;
    }

    public static SynchroContext newContext(Set<String> tableNames, Properties sourceConnectionProperties, Properties targetConnectionProperties, SynchroResult result) {
        return SynchroContext.newContext(tableNames, null, sourceConnectionProperties, targetConnectionProperties, result);
    }

    public SynchroResult getResult() {
        return this.result;
    }

    public void setResult(SynchroResult result) {
        this.result = result;
    }

    public void setSourceConnectionProperties(Properties sourceConnectionProperties) {
        this.sourceConnectionProperties = sourceConnectionProperties;
    }

    public void setTargetConnectionProperties(Properties targetConnectionProperties) {
        this.targetConnectionProperties = targetConnectionProperties;
    }

    public void setTableFilter(Predicate<String> tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setTableNames(Set<String> tableNames) {
        this.tableNames = tableNames;
    }

    public Properties getSourceConnectionProperties() {
        return this.sourceConnectionProperties;
    }

    public Properties getTargetConnectionProperties() {
        return this.targetConnectionProperties;
    }

    public Predicate<String> getTableFilter() {
        return this.tableFilter;
    }

    public Set<String> getTableNames() {
        return this.tableNames;
    }

    public SynchroPendingOperationBuffer getTableContext(String tableName) {
        return this.tableContextMap.get(tableName);
    }

    public void addTableContext(String tableName, SynchroPendingOperationBuffer tableContext) {
        this.tableContextMap.put(tableName, tableContext);
    }

    public void removeTableContext(String tableName) {
        this.tableContextMap.remove(tableName);
    }
}

