/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.SelectSequencesStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectSequencesGeneratorDerby
extends AbstractSqlGenerator<SelectSequencesStatement> {
    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public boolean supports(SelectSequencesStatement statement, Database database) {
        return database instanceof DerbyDatabase;
    }

    @Override
    public ValidationErrors validate(SelectSequencesStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new ValidationErrors();
    }

    @Override
    public Sql[] generateSql(SelectSequencesStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        try {
            String schemaName = database.convertRequestedSchemaToSchema(statement.getSchemaName());
            return new Sql[]{new UnparsedSql("SELECT   seq.SEQUENCENAME AS SEQUENCE_NAME FROM   SYS.SYSSEQUENCES seq,   SYS.SYSSCHEMAS sch WHERE   sch.SCHEMANAME = '" + schemaName + "' AND " + "  sch.SCHEMAID = seq.SCHEMAID", new DatabaseObject[0])};
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }
}

