/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.model.api.CellContextInfo;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandAction;
import org.eclipse.birt.report.model.api.ColumnBandAdapter;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ColumnHelper;
import org.eclipse.birt.report.model.elements.TableColumn;

abstract class ColumnBandCopyAction
extends ColumnBandAction {
    public ColumnBandCopyAction(ColumnBandAdapter adapter) {
        super(adapter);
    }

    protected ColumnBandData copyColumnBand(int columnNumber) throws SemanticException {
        ColumnBandData data = new ColumnBandData();
        if (columnNumber <= 0) {
            return null;
        }
        TableColumn clonedColumn = this.copyColumn(this.adapter.getColumns(), columnNumber);
        List cells = this.cloneCells(this.adapter.getCellsUnderColumn(columnNumber), columnNumber);
        data.setColumn(clonedColumn);
        data.setCells(cells);
        if (!this.isRectangleArea(cells, 1)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{Integer.toString(columnNumber), this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_COPY_FORBIDDEN");
        }
        if (this.adapter.hasDroppingCell(cells)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{Integer.toString(columnNumber), this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_COPY_FORBIDDEN");
        }
        return data;
    }

    private List cloneCells(List cells, int columnNumber) {
        ArrayList<CellContextInfo> list = new ArrayList<CellContextInfo>();
        int i = 0;
        while (i < cells.size()) {
            Cell clonedCell;
            CellHandle originalCell;
            block3: {
                originalCell = (CellHandle)cells.get(i);
                clonedCell = null;
                try {
                    clonedCell = (Cell)originalCell.getElement().clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
            list.add(this.getCellContextInfo(clonedCell, (RowHandle)originalCell.getContainer()));
            ++i;
        }
        return list;
    }

    @Override
    protected CellContextInfo getCellContextInfo(Cell cell, RowHandle row) {
        DesignElementHandle rowContainer = row.getContainer();
        int slotId = rowContainer.findContentSlot(row);
        int groupId = -1;
        SlotHandle slot = rowContainer.getSlot(slotId);
        if (rowContainer instanceof TableGroupHandle) {
            TableHandle rowGrandPa = (TableHandle)rowContainer.getContainer();
            groupId = rowGrandPa.getGroups().findPosn(rowContainer);
        }
        CellContextInfo cellInfo = new CellContextInfo(cell, cell.getRowSpan(this.adapter.getModule()), cell.getColSpan(this.adapter.getModule()), cell.getStringProperty(this.adapter.getModule(), "drop"));
        int rowNumber = slot.findPosn(row);
        cellInfo.setContainerDefnName(rowContainer.getDefn().getName());
        cellInfo.setSlotId(slotId);
        cellInfo.setGroupId(groupId);
        cellInfo.setRowIndex(rowNumber);
        return cellInfo;
    }

    private int[] getInsertPosition(int size, int columnIndex, boolean isInsert) {
        int[] insertPosition = null;
        int columnCount = this.adapter.getColumnCount();
        if (isInsert && (columnIndex == 0 || columnIndex == columnCount - 1)) {
            insertPosition = new int[size];
            if (columnIndex == 0) {
                Arrays.fill(insertPosition, 0);
            } else {
                Arrays.fill(insertPosition, -1);
            }
        }
        return insertPosition;
    }

    protected void pasteCells(List copiedCells, List originalCells, int columnIndex, boolean isInsert) throws SemanticException {
        CellContextInfo contextInfo;
        int[] insertPosition = this.getInsertPosition(copiedCells.size(), columnIndex, isInsert);
        int i = 0;
        while (!isInsert && i < originalCells.size()) {
            contextInfo = (CellContextInfo)originalCells.get(i);
            CellHandle cell = contextInfo.getCell().handle(this.adapter.getModule());
            if (!isInsert) {
                cell.getContainerSlotHandle().drop(cell);
            }
            ++i;
        }
        i = 0;
        while (i < copiedCells.size()) {
            contextInfo = (CellContextInfo)copiedCells.get(i);
            RowHandle row = this.adapter.getRow(contextInfo.getSlotId(), contextInfo.getGroupId(), contextInfo.getRowIndex());
            assert (row != null);
            int pos = insertPosition == null ? this.adapter.findCellPosition(row, columnIndex, isInsert) : insertPosition[i];
            CellHandle cell = contextInfo.getCell().handle(this.adapter.getModule());
            this.adapter.getModule().getModuleHandle().rename(cell);
            if (pos != -1) {
                row.addElement(cell, 0, pos);
            } else {
                row.addElement(cell, 0);
            }
            ++i;
        }
    }

    protected TableColumn copyColumn(SlotHandle columns, int columnIndex) {
        TableColumn clonedColumn;
        block3: {
            TableColumn column = ColumnHelper.findColumn(this.adapter.getModule(), columns.getSlot(), columnIndex);
            if (column == null) {
                return null;
            }
            clonedColumn = null;
            try {
                clonedColumn = (TableColumn)column.clone();
                clonedColumn.setProperty("repeat", (Object)1);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return clonedColumn;
    }
}

