/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchModel;
import fr.ifremer.tutti.service.genericformat.csv.CatchModel;
import fr.ifremer.tutti.service.genericformat.csv.GearCaracteristicModel;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationModel;
import fr.ifremer.tutti.service.genericformat.csv.MarineLitterModel;
import fr.ifremer.tutti.service.genericformat.csv.OperationModel;
import fr.ifremer.tutti.service.genericformat.csv.ParameterModel;
import fr.ifremer.tutti.service.genericformat.csv.SampleCategoryModel;
import fr.ifremer.tutti.service.genericformat.csv.SpeciesExportModel;
import fr.ifremer.tutti.service.genericformat.csv.SurveyModel;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForAccidentalCatch;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForCatch;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForGearCaracteristics;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForIndividualObservation;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForMarineLitter;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForOperation;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForParameter;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSampleCategory;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSpecies;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSurvey;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryGear;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryPerson;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporarySpecies;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryVessel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.nuiton.decorator.Decorator;

public class GenericFormatExportContext
implements Closeable {
    private final fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel sampleCategoryModel;
    protected Map<String, GenericFormatExportOperationContext> operationContexts = Maps.newTreeMap();
    private final GenericFormatArchive archive;
    private final Decorator<FishingOperation> fishingOperationDecorator;
    protected final PersistenceService persistenceService;
    protected final WeightComputingService weightComputingService;
    protected final Caracteristic deadOrAliveCaracteristic;
    protected final Caracteristic genderCaracteristic;
    protected final Caracteristic weightMeasuredCaracteristic;
    protected final Caracteristic pmfmIdCaracteristic;
    private final CsvProducerForSurvey producerForSurvey;
    private final CsvProducerForGearCaracteristics producerForGearCaracteristics;
    private final CsvProducerForOperation producerForOperation;
    private final CsvProducerForParameter producerForParameter;
    private final CsvProducerForIndividualObservation producerForIndividualObservation;
    private final CsvProducerForAccidentalCatch producerForAccidentalCatch;
    private final CsvProducerForCatch producerForCatch;
    private final CsvProducerForSpecies producerForSpecies;
    private final CsvProducerForMarineLitter producerForMarineLitter;
    private final CsvProducerForTemporaryGear producerForTemporaryGear;
    private final CsvProducerForTemporaryPerson producerForTemporaryPerson;
    private final CsvProducerForTemporarySpecies producerForTemporarySpecies;
    private final CsvProducerForTemporaryVessel producerForTemporaryVessel;
    private final CsvProducerForSampleCategory producerForSampleCategory;
    protected final ProgressionModel progressionModel;
    protected String checkError;

    GenericFormatExportContext(ProgressionModel progressionModel, GenericFormatArchive archive, char csvSeparator, PersistenceService persistenceService, WeightComputingService weightComputingService, Decorator<FishingOperation> fishingOperationDecorator, fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel sampleCategoryModel) {
        Preconditions.checkNotNull((Object)progressionModel);
        this.progressionModel = progressionModel;
        this.archive = archive;
        this.persistenceService = persistenceService;
        this.weightComputingService = weightComputingService;
        this.fishingOperationDecorator = fishingOperationDecorator;
        this.sampleCategoryModel = sampleCategoryModel;
        this.weightMeasuredCaracteristic = persistenceService.getWeightMeasuredCaracteristic();
        this.pmfmIdCaracteristic = persistenceService.getPmfmIdCaracteristic();
        this.deadOrAliveCaracteristic = persistenceService.getDeadOrAliveCaracteristic();
        this.genderCaracteristic = persistenceService.getSexCaracteristic();
        List<Species> allReferentSpecies = persistenceService.getAllReferentSpecies();
        Map speciesByReferenceTaxonId = Speciess.splitReferenceSpeciesByReferenceTaxonId(allReferentSpecies);
        this.producerForSurvey = new CsvProducerForSurvey(archive.getSurveyPath(), SurveyModel.forExport(csvSeparator));
        this.producerForGearCaracteristics = new CsvProducerForGearCaracteristics(archive.getGearCaracteristicsPath(), GearCaracteristicModel.forExport(csvSeparator));
        this.producerForOperation = new CsvProducerForOperation(archive.getOperationPath(), OperationModel.forExport(csvSeparator));
        this.producerForIndividualObservation = new CsvProducerForIndividualObservation(archive.getIndividualObservationPath(), IndividualObservationModel.forExport(csvSeparator));
        this.producerForSpecies = new CsvProducerForSpecies(archive.getSpeciesPath(), SpeciesExportModel.forExport(csvSeparator), speciesByReferenceTaxonId);
        this.producerForCatch = new CsvProducerForCatch(archive.getCatchPath(), CatchModel.forExport(csvSeparator, sampleCategoryModel));
        this.producerForAccidentalCatch = new CsvProducerForAccidentalCatch(archive.getAccidentalCatchPath(), AccidentalCatchModel.forExport(csvSeparator));
        this.producerForParameter = new CsvProducerForParameter(archive.getParameterPath(), ParameterModel.forExport(csvSeparator));
        this.producerForMarineLitter = new CsvProducerForMarineLitter(archive.getMarineLitterPath(), MarineLitterModel.forExport(csvSeparator));
        this.producerForSampleCategory = new CsvProducerForSampleCategory(archive.getSampleCategoryModelPath(), SampleCategoryModel.forExport(csvSeparator));
        this.producerForTemporaryGear = new CsvProducerForTemporaryGear(archive.getTemporaryReferentialGearsPath(), csvSeparator);
        this.producerForTemporaryPerson = new CsvProducerForTemporaryPerson(archive.getTemporaryReferentialPersonsPath(), csvSeparator);
        this.producerForTemporarySpecies = new CsvProducerForTemporarySpecies(archive.getTemporaryReferentialSpeciesPath(), csvSeparator);
        this.producerForTemporaryVessel = new CsvProducerForTemporaryVessel(archive.getTemporaryReferentialVesselsPath(), csvSeparator);
    }

    public GenericFormatExportOperationContext newOperationContext(Cruise cruise, FishingOperation operation) {
        String operationLabel = this.fishingOperationDecorator.toString((Object)operation);
        GenericFormatExportOperationContext operationExportContext = new GenericFormatExportOperationContext(cruise, operation, operationLabel, this.persistenceService, this.weightComputingService, this.sampleCategoryModel, this.weightMeasuredCaracteristic, this.pmfmIdCaracteristic, this.deadOrAliveCaracteristic, this.genderCaracteristic);
        return operationExportContext;
    }

    public GenericFormatExportOperationContext getOperationContext(Cruise cruise, FishingOperation operation) {
        String operationId = operation.getId();
        GenericFormatExportOperationContext operationExportContext = this.operationContexts.get(operationId);
        if (operationExportContext == null) {
            String operationLabel = this.fishingOperationDecorator.toString((Object)operation);
            operationExportContext = new GenericFormatExportOperationContext(cruise, operation, operationLabel, this.persistenceService, this.weightComputingService, this.sampleCategoryModel, this.weightMeasuredCaracteristic, this.pmfmIdCaracteristic, this.deadOrAliveCaracteristic, this.genderCaracteristic);
            this.operationContexts.put(operationId, operationExportContext);
        }
        return operationExportContext;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.producerForSurvey);
        IOUtils.closeQuietly((Closeable)this.producerForSpecies);
        IOUtils.closeQuietly((Closeable)this.producerForGearCaracteristics);
        IOUtils.closeQuietly((Closeable)this.producerForOperation);
        IOUtils.closeQuietly((Closeable)this.producerForParameter);
        IOUtils.closeQuietly((Closeable)this.producerForAccidentalCatch);
        IOUtils.closeQuietly((Closeable)this.producerForIndividualObservation);
        IOUtils.closeQuietly((Closeable)this.producerForCatch);
        IOUtils.closeQuietly((Closeable)this.producerForMarineLitter);
        IOUtils.closeQuietly((Closeable)this.producerForTemporaryGear);
        IOUtils.closeQuietly((Closeable)this.producerForTemporaryPerson);
        IOUtils.closeQuietly((Closeable)this.producerForTemporarySpecies);
        IOUtils.closeQuietly((Closeable)this.producerForTemporaryVessel);
        IOUtils.closeQuietly((Closeable)this.producerForSampleCategory);
    }

    public String getCheckError() {
        return this.checkError;
    }

    public void setCheckError(String checkError) {
        this.checkError = checkError;
    }

    public CsvProducerForSurvey getProducerForSurvey() {
        return this.producerForSurvey;
    }

    public CsvProducerForGearCaracteristics getProducerForGearCaracteristics() {
        return this.producerForGearCaracteristics;
    }

    public CsvProducerForOperation getProducerForOperation() {
        return this.producerForOperation;
    }

    public CsvProducerForParameter getProducerForParameter() {
        return this.producerForParameter;
    }

    public CsvProducerForIndividualObservation getProducerForIndividualObservation() {
        return this.producerForIndividualObservation;
    }

    public CsvProducerForAccidentalCatch getProducerForAccidentalCatch() {
        return this.producerForAccidentalCatch;
    }

    public CsvProducerForCatch getProducerForCatch() {
        return this.producerForCatch;
    }

    public CsvProducerForSpecies getProducerForSpecies() {
        return this.producerForSpecies;
    }

    public CsvProducerForMarineLitter getProducerForMarineLitter() {
        return this.producerForMarineLitter;
    }

    public CsvProducerForTemporaryGear getProducerForTemporaryGear() {
        return this.producerForTemporaryGear;
    }

    public CsvProducerForTemporaryPerson getProducerForTemporaryPerson() {
        return this.producerForTemporaryPerson;
    }

    public CsvProducerForTemporarySpecies getProducerForTemporarySpecies() {
        return this.producerForTemporarySpecies;
    }

    public CsvProducerForTemporaryVessel getProducerForTemporaryVessel() {
        return this.producerForTemporaryVessel;
    }

    public CsvProducerForSampleCategory getProducerForSampleCategory() {
        return this.producerForSampleCategory;
    }

    public File getProtocolFile() {
        return this.archive.getProtocolPath().toFile();
    }

    public fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel getSampleCategoryModel() {
        return this.sampleCategoryModel;
    }

    public void increments(String message) {
        this.progressionModel.increments(message);
    }
}

