/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class ValidateCruiseOperationsService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ValidateCruiseOperationsService.class);
    protected PersistenceService persistenceService;
    protected ValidationService validationService;
    protected WeightComputingService weightComputingService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.validationService = this.getService(ValidationService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public NuitonValidatorResult validateCruise(ProgressionModel progressionModel, String cruiseId) {
        progressionModel.increments(I18n.t((String)"tutti.service.validateCruise.cruise.loading", (Object[])new Object[]{cruiseId}));
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Decorator<Cruise> decorator = this.decoratorService.getDecoratorByType(Cruise.class);
        progressionModel.increments(I18n.t((String)"tutti.service.validateCruise.cruise.check", (Object[])new Object[]{cruiseId, decorator.toString((Object)cruise)}));
        NuitonValidatorResult validator = this.validationService.validateValidateCruise(cruise);
        return validator;
    }

    public LinkedHashMap<FishingOperation, NuitonValidatorResult> validateOperations(ProgressionModel progressionModel, List<String> operationIds) {
        LinkedHashMap<FishingOperation, NuitonValidatorResult> result = new LinkedHashMap<FishingOperation, NuitonValidatorResult>();
        Decorator<FishingOperation> decorator = this.decoratorService.getDecoratorByType(FishingOperation.class);
        for (String operationId : operationIds) {
            progressionModel.increments(I18n.t((String)"tutti.service.validateCruise.operations.loading", (Object[])new Object[]{operationId}));
            FishingOperation operation = this.persistenceService.getFishingOperation(operationId);
            progressionModel.increments(I18n.t((String)"tutti.service.validateCruise.operations.check", (Object[])new Object[]{operationId, decorator.toString((Object)operation)}));
            NuitonValidatorResult validator = this.validationService.validateValidateFishingOperation(operation);
            this.checkOperation(operation, validator);
            result.put(operation, validator);
        }
        return result;
    }

    public NuitonValidatorResult validateCruiseCruise(Cruise cruise) {
        NuitonValidatorResult validator = this.validationService.validateValidateCruise(cruise);
        return validator;
    }

    public NuitonValidatorResult validateCruiseOperation(FishingOperation operation) {
        NuitonValidatorResult validator = this.validationService.validateValidateFishingOperation(operation);
        this.checkOperation(operation, validator);
        return validator;
    }

    public NuitonValidatorResult validateCruiseOperation(CatchBatch catches) {
        FishingOperation operation = this.persistenceService.getFishingOperation(catches.getFishingOperation().getId());
        NuitonValidatorResult validator = this.validationService.validateValidateFishingOperation(operation);
        this.checkOperation(operation, catches, validator);
        return validator;
    }

    public void exportValidationResults(File file, Map<FishingOperation, NuitonValidatorResult> validationResults) {
        try {
            ArrayList lines = Lists.newArrayList();
            for (FishingOperation operation : validationResults.keySet()) {
                lines.addAll(this.getExportLines(operation, validationResults.get(operation)));
                lines.add("");
            }
            FileUtils.writeLines((File)file, (Collection)lines);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.validateCruise.exportResult.error", (Object[])new Object[]{file}));
        }
    }

    public void exportValidationResult(File file, FishingOperation operation, NuitonValidatorResult validationResult) {
        try {
            List<String> lines = this.getExportLines(operation, validationResult);
            FileUtils.writeLines((File)file, lines);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.validateCruise.exportResult.error", (Object[])new Object[]{file}));
        }
    }

    protected void checkOperation(FishingOperation fishingOperation, NuitonValidatorResult validator) {
        String fishingOperationId = fishingOperation.getId();
        boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        if (!withCatchBatch) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skip fishing operation " + fishingOperation + " since no catchBatch associated."));
            }
            HashMap errorMap = Maps.newHashMap();
            errorMap.put("catches", Lists.newArrayList((Object[])new String[]{I18n.t((String)"tutti.validator.warning.fishingOperation.batch.notFound", (Object[])new Object[0])}));
            validator.addMessagesForScope(NuitonValidatorScope.WARNING, (Map)errorMap);
        } else {
            try {
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(fishingOperationId);
                this.checkOperation(fishingOperation, catchBatch, validator);
            }
            catch (InvalidBatchModelException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Invalid batch model", (Throwable)e);
                }
                HashMap errorMap = Maps.newHashMap();
                errorMap.put("catches", Lists.newArrayList((Object[])new String[]{I18n.t((String)"tutti.validator.warning.fishingOperation.invalid.batch.model", (Object[])new Object[0])}));
                validator.addMessagesForScope(NuitonValidatorScope.WARNING, (Map)errorMap);
            }
        }
    }

    protected void transfertValidatorResult(NuitonValidatorResult validatorResult, List<String> errors) {
        if (validatorResult.hasFatalMessages()) {
            errors.addAll(validatorResult.getMessagesForScope(NuitonValidatorScope.FATAL));
        }
        if (validatorResult.hasErrorMessagess()) {
            errors.addAll(validatorResult.getMessagesForScope(NuitonValidatorScope.ERROR));
        }
    }

    protected void checkOperation(FishingOperation fishingOperation, CatchBatch catchBatch, NuitonValidatorResult validator) {
        TuttiDataContext dataContext;
        BatchContainer<MarineLitterBatch> rootMarineLitterBatch;
        List roots;
        boolean error;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will check fishingOperation: " + fishingOperation));
        }
        ArrayList errors = Lists.newArrayList();
        String fishingOperationId = fishingOperation.getId();
        NuitonValidatorResult fishingOperationValidationResult = this.validationService.validateValidateFishingOperation(fishingOperation);
        this.transfertValidatorResult(fishingOperationValidationResult, errors);
        BatchContainer<SpeciesBatch> rootSpeciesBatch = null;
        boolean isCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        boolean bl = error = !isCatchBatch;
        if (isCatchBatch) {
            NuitonValidatorResult catchBatchValidatorResult = this.validationService.validateValidateCatchBatch(catchBatch);
            this.transfertValidatorResult(catchBatchValidatorResult, errors);
            rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, true);
            if (rootSpeciesBatch != null) {
                roots = rootSpeciesBatch.getChildren();
                for (BenthosBatch batch : roots) {
                    NuitonValidatorResult speciesValidatorResult = this.validationService.validateValidateSpeciesBatch((SpeciesBatch)batch);
                    this.transfertValidatorResult(speciesValidatorResult, errors);
                    try {
                        this.weightComputingService.computeSpeciesBatch((SpeciesBatch)batch);
                    }
                    catch (ApplicationBusinessException e) {
                        errors.add(e.getMessage());
                        error = true;
                    }
                }
            }
        }
        if (error) {
            rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, true);
        }
        BatchContainer<BenthosBatch> rootBenthosBatch = null;
        error = false;
        if (isCatchBatch && (rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, true)) != null) {
            roots = rootBenthosBatch.getChildren();
            for (BenthosBatch batch : roots) {
                NuitonValidatorResult benthosValidatorResult = this.validationService.validateValidateBenthosBatch(batch);
                this.transfertValidatorResult(benthosValidatorResult, errors);
                try {
                    this.weightComputingService.computeBenthosBatch(batch);
                }
                catch (ApplicationBusinessException e) {
                    errors.add(e.getMessage());
                    error = true;
                }
            }
        }
        if (error) {
            rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, true);
        }
        if (isCatchBatch) {
            List<IndividualObservationBatch> individualObservationBatchs;
            List<AccidentalBatch> accidentalBatchs = this.persistenceService.getAllAccidentalBatch(fishingOperationId);
            if (accidentalBatchs != null) {
                for (AccidentalBatch accidentalBatch : accidentalBatchs) {
                    NuitonValidatorResult accidentalBatchValidatorResult = this.validationService.validateValidateAccidentalBatch(accidentalBatch);
                    this.transfertValidatorResult(accidentalBatchValidatorResult, errors);
                }
            }
            if ((individualObservationBatchs = this.persistenceService.getAllIndividualObservationBatch(fishingOperationId)) != null) {
                for (IndividualObservationBatch individualObservationBatch : individualObservationBatchs) {
                    NuitonValidatorResult individualObservationBatchValidatorResult = this.validationService.validateValidateIndividualObservationBatch(individualObservationBatch);
                    this.transfertValidatorResult(individualObservationBatchValidatorResult, errors);
                }
            }
        }
        try {
            Float weight = catchBatch == null ? null : catchBatch.getMarineLitterTotalWeight();
            rootMarineLitterBatch = this.weightComputingService.getComputedMarineLitterBatches(fishingOperationId, weight);
        }
        catch (ApplicationBusinessException e) {
            errors.add(e.getMessage());
            rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
        }
        try {
            if (catchBatch != null) {
                this.weightComputingService.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, rootMarineLitterBatch);
            }
        }
        catch (ApplicationBusinessException e) {
            errors.add(e.getMessage());
        }
        if (CollectionUtils.isNotEmpty((Collection)errors)) {
            HashMap errorMap = Maps.newHashMap();
            errorMap.put("catches", errors);
            validator.addMessagesForScope(NuitonValidatorScope.ERROR, (Map)errorMap);
        }
        if ((dataContext = this.context.getDataContext()).isProtocolFilled()) {
            String categoryValue;
            String species;
            HashMap warningMap = Maps.newHashMap();
            Decorator<Species> speciesDecorator = this.decoratorService.getDecoratorByType(Species.class);
            if (rootSpeciesBatch != null) {
                for (SpeciesBatch batch : rootSpeciesBatch.getChildren()) {
                    if (!this.isSpeciesBatchInvalid(batch)) continue;
                    species = speciesDecorator.toString((Object)batch.getSpecies());
                    categoryValue = this.decoratorService.getDecorator(batch.getSampleCategoryValue()).toString((Object)batch.getSampleCategoryValue());
                    warningMap.put("species", Lists.newArrayList((Object[])new String[]{I18n.t((String)"tutti.validator.warning.species.protocolNotRespected", (Object[])new Object[]{species, categoryValue})}));
                    break;
                }
            }
            if (rootBenthosBatch != null) {
                for (SpeciesBatch batch : rootBenthosBatch.getChildren()) {
                    if (!this.isBenthosBatchInvalid((BenthosBatch)batch)) continue;
                    species = speciesDecorator.toString((Object)batch.getSpecies());
                    categoryValue = this.decoratorService.getDecorator(batch.getSampleCategoryValue()).toString((Object)batch.getSampleCategoryValue());
                    warningMap.put("benthos", Lists.newArrayList((Object[])new String[]{I18n.t((String)"tutti.validator.warning.benthos.protocolNotRespected", (Object[])new Object[]{species, categoryValue})}));
                    break;
                }
            }
            if (MapUtils.isNotEmpty((Map)warningMap)) {
                validator.addMessagesForScope(NuitonValidatorScope.WARNING, (Map)warningMap);
            }
        }
    }

    public boolean isSpeciesBatchValid(SpeciesBatch batch, List<SpeciesBatchFrequency> frequencies) {
        List speciesProtocols;
        Species species;
        SpeciesProtocol speciesProtocol;
        boolean result = true;
        TuttiProtocol protocol = this.persistenceService.getProtocol();
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesProtocol((Species)(species = batch.getSpecies()), (List)(speciesProtocols = protocol.getSpecies()))) != null) {
            List mandatoryCategories = speciesProtocol.getMandatorySampleCategoryId();
            SpeciesBatch browsingBatch = batch;
            while (browsingBatch.getParentBatch() != null) {
                mandatoryCategories.remove(browsingBatch.getSampleCategoryId());
                browsingBatch = browsingBatch.getParentBatch();
            }
            result = mandatoryCategories.isEmpty() && (!speciesProtocol.isCountIfNoFrequencyEnabled() || CollectionUtils.isNotEmpty(frequencies) || batch.getNumber() != null);
        }
        return result;
    }

    protected boolean isSpeciesBatchInvalid(SpeciesBatch batch) {
        if (batch.isChildBatchsEmpty()) {
            List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
            return !this.isSpeciesBatchValid(batch, frequencies);
        }
        for (SpeciesBatch child : batch.getChildBatchs()) {
            boolean invalid = this.isSpeciesBatchInvalid(child);
            if (!invalid) continue;
            return true;
        }
        return false;
    }

    protected boolean isBenthosBatchInvalid(BenthosBatch batch) {
        if (batch.isChildBatchsEmpty()) {
            List<BenthosBatchFrequency> frequencies = this.persistenceService.getAllBenthosBatchFrequency(batch.getId());
            return !this.isBenthosBatchValid(batch, frequencies);
        }
        for (BenthosBatch child : batch.getChildBatchs()) {
            boolean invalid = this.isBenthosBatchInvalid(child);
            if (!invalid) continue;
            return true;
        }
        return false;
    }

    protected List<String> getExportLines(FishingOperation operation, NuitonValidatorResult validationResult) {
        ArrayList lines = Lists.newArrayList();
        lines.add(I18n.t((String)"tutti.validator.export.operation", (Object[])new Object[]{this.decoratorService.getDecoratorByType(FishingOperation.class).toString((Object)operation)}));
        List messages = validationResult.getMessagesForScope(NuitonValidatorScope.ERROR);
        for (String message : messages) {
            lines.add(I18n.t((String)"tutti.validator.export.message.error", (Object[])new Object[]{I18n.t((String)message, (Object[])new Object[0])}));
        }
        messages = validationResult.getMessagesForScope(NuitonValidatorScope.WARNING);
        for (String message : messages) {
            lines.add(I18n.t((String)"tutti.validator.export.message.warning", (Object[])new Object[]{I18n.t((String)message, (Object[])new Object[0])}));
        }
        return lines;
    }

    public boolean isBenthosBatchValid(BenthosBatch batch, List<BenthosBatchFrequency> frequencies) {
        List speciesProtocols;
        Species species;
        SpeciesProtocol speciesProtocol;
        TuttiProtocol protocol = this.persistenceService.getProtocol();
        boolean result = true;
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesProtocol((Species)(species = batch.getSpecies()), (List)(speciesProtocols = protocol.getBenthos()))) != null) {
            List mandatoryCategories = speciesProtocol.getMandatorySampleCategoryId();
            BenthosBatch browsingBatch = batch;
            while (browsingBatch.getParentBatch() != null) {
                mandatoryCategories.remove(browsingBatch.getSampleCategoryId());
                browsingBatch = browsingBatch.getParentBatch();
            }
            result = mandatoryCategories.isEmpty() && (!speciesProtocol.isCountIfNoFrequencyEnabled() || CollectionUtils.isNotEmpty(frequencies) || batch.getNumber() != null);
        }
        return result;
    }
}

