/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractSelectingDelegate
implements InsertGeneratedIdentifierDelegate {
    private final PostInsertIdentityPersister persister;

    protected AbstractSelectingDelegate(PostInsertIdentityPersister persister) {
        this.persister = persister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Serializable performInsert(String insertSQL, SessionImplementor session, Binder binder) {
        try {
            PreparedStatement insert = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(insertSQL, 2);
            try {
                binder.bindValues(insert);
                session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(insert);
            }
            finally {
                session.getTransactionCoordinator().getJdbcCoordinator().release(insert);
            }
        }
        catch (SQLException sqle) {
            throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not insert: " + MessageHelper.infoString(this.persister), insertSQL);
        }
        String selectSQL = this.getSelectSQL();
        try {
            PreparedStatement idSelect = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(selectSQL, false);
            try {
                this.bindParameters(session, idSelect, binder.getEntity());
                ResultSet rs = session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(idSelect);
                try {
                    Serializable serializable = this.getResult(session, rs, binder.getEntity());
                    session.getTransactionCoordinator().getJdbcCoordinator().release(rs, idSelect);
                    return serializable;
                }
                catch (Throwable throwable) {
                    session.getTransactionCoordinator().getJdbcCoordinator().release(rs, idSelect);
                    throw throwable;
                }
            }
            finally {
                session.getTransactionCoordinator().getJdbcCoordinator().release(idSelect);
            }
        }
        catch (SQLException sqle) {
            throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not retrieve generated id after insert: " + MessageHelper.infoString(this.persister), insertSQL);
        }
    }

    protected abstract String getSelectSQL();

    protected void bindParameters(SessionImplementor session, PreparedStatement ps, Object entity) throws SQLException {
    }

    protected abstract Serializable getResult(SessionImplementor var1, ResultSet var2, Object var3) throws SQLException;
}

