/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModelCache;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.jfree.data.xy.XYSeries;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class SpeciesFrequencyTableModel
extends AbstractApplicationTableModel<SpeciesFrequencyRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> LENGTH_STEP = ColumnIdentifier.newId((String)"lengthStep", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> NUMBER = ColumnIdentifier.newId((String)"number", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> WEIGHT = ColumnIdentifier.newId((String)"weight", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]));
    private final SpeciesFrequencyUIModel uiModel;
    private final SpeciesFrequencyUIModelCache modelCache;
    protected final WeightUnit weightUnit;
    protected transient PropertyChangeListener onLengthStepChangedListener;
    protected transient PropertyChangeListener onWeightChangedListener;
    protected transient PropertyChangeListener onNumberChangedListener;
    protected final XYSeries series;

    public SpeciesFrequencyTableModel(WeightUnit weightUnit, TableColumnModelExt columnModel, SpeciesFrequencyUIModel uiModel) {
        super(columnModel, true, true);
        this.weightUnit = weightUnit;
        this.uiModel = uiModel;
        this.modelCache = uiModel.cache;
        this.series = uiModel.dataset.getSeries(0);
        this.setNoneEditableCols(new ColumnIdentifier[0]);
    }

    public SpeciesFrequencyRowModel createNewRow() {
        return this.createNewRow(true);
    }

    public SpeciesFrequencyRowModel createNewRow(boolean attachListeners) {
        SpeciesFrequencyRowModel rowModel;
        Float lengthStep;
        Float defaultStep = null;
        int rowCount = this.getRowCount();
        if (rowCount > 0 && (lengthStep = (rowModel = (SpeciesFrequencyRowModel)this.getEntry(rowCount - 1)).getLengthStep()) != null) {
            defaultStep = Float.valueOf(this.uiModel.getLengthStep(lengthStep.floatValue() + this.uiModel.getStep().floatValue()));
        }
        SpeciesFrequencyRowModel result = new SpeciesFrequencyRowModel(this.weightUnit);
        if (attachListeners) {
            this.attachListeners(result);
        }
        result.setLengthStepCaracteristic(this.uiModel.getLengthStepCaracteristic());
        result.setLengthStep(defaultStep);
        result.setValid(defaultStep != null);
        return result;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<SpeciesFrequencyRowModel> propertyName, SpeciesFrequencyRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, (Serializable)entry);
    }

    protected void onRowAdded(int rowIndex, SpeciesFrequencyRowModel row) {
        this.uiModel.recomputeCanEditLengthStep();
    }

    protected void onRowUpdated(int rowIndex, SpeciesFrequencyRowModel row) {
        this.uiModel.recomputeCanEditLengthStep();
    }

    protected void onRowRemoved(int rowIndex, SpeciesFrequencyRowModel row) {
        this.dettachListeners(row);
        this.uiModel.recomputeCanEditLengthStep();
    }

    protected void onBeforeRowsChanged(List<SpeciesFrequencyRowModel> oldRows) {
        if (oldRows != null) {
            for (SpeciesFrequencyRowModel row : oldRows) {
                this.dettachListeners(row);
            }
        }
    }

    protected void onRowsChanged(List<SpeciesFrequencyRowModel> newRows) {
        if (newRows != null) {
            for (SpeciesFrequencyRowModel row : newRows) {
                this.dettachListeners(row);
                this.attachListeners(row);
            }
        }
        this.uiModel.recomputeCanEditLengthStep();
    }

    public void decrementNumberForLengthStep(Float lengthStep) {
        SpeciesFrequencyRowModel row = this.modelCache.getRowCache().get(lengthStep);
        if (row != null) {
            Integer number = row.getNumber();
            if (number != null) {
                if (number > 1) {
                    row.setNumber(number - 1);
                } else {
                    row.setNumber(null);
                }
                int rowIndex = this.getRowIndex(row);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
            this.uiModel.recomputeCanEditLengthStep();
        }
    }

    private PropertyChangeListener getOnLengthStepChangedListener() {
        if (this.onLengthStepChangedListener == null) {
            this.onLengthStepChangedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Float oldValue = (Float)evt.getOldValue();
                    if (oldValue != null) {
                        SpeciesFrequencyTableModel.this.modelCache.removeLengthStep(oldValue);
                        if (SpeciesFrequencyTableModel.this.series.indexOf((Number)oldValue) >= 0) {
                            SpeciesFrequencyTableModel.this.series.remove((Number)oldValue);
                        }
                    }
                    SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)evt.getSource();
                    Float newValue = (Float)evt.getNewValue();
                    if (newValue != null) {
                        SpeciesFrequencyTableModel.this.modelCache.addLengthStep(row);
                        if (row.getNumber() != null) {
                            SpeciesFrequencyTableModel.this.series.addOrUpdate((Number)newValue, (Number)row.getNumber());
                        }
                    }
                    SpeciesFrequencyTableModel.this.uiModel.recomputeCanEditLengthStep();
                    SpeciesFrequencyTableModel.this.uiModel.recomputeRowsValidateState();
                    SpeciesFrequencyTableModel.this.uiModel.updateEmptyRow(row);
                    SpeciesFrequencyTableModel.this.uiModel.recomputeTotalNumberAndWeight();
                    SpeciesFrequencyTableModel.this.fireTableDataChanged();
                }
            };
        }
        return this.onLengthStepChangedListener;
    }

    private PropertyChangeListener getOnNumberChangedListener() {
        if (this.onNumberChangedListener == null) {
            this.onNumberChangedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)evt.getSource();
                    Integer newValue = (Integer)evt.getNewValue();
                    Float lengthStep = row.getLengthStep();
                    if (lengthStep != null) {
                        if (newValue == null) {
                            if (SpeciesFrequencyTableModel.this.series.indexOf((Number)lengthStep) >= 0) {
                                SpeciesFrequencyTableModel.this.series.remove((Number)lengthStep);
                            }
                        } else {
                            SpeciesFrequencyTableModel.this.series.addOrUpdate((Number)lengthStep, (Number)row.getNumber());
                        }
                    }
                    SpeciesFrequencyTableModel.this.uiModel.recomputeCanEditLengthStep();
                    SpeciesFrequencyTableModel.this.uiModel.recomputeRowValidState(row);
                    SpeciesFrequencyTableModel.this.uiModel.updateEmptyRow(row);
                    SpeciesFrequencyTableModel.this.uiModel.recomputeTotalNumberAndWeight();
                }
            };
        }
        return this.onNumberChangedListener;
    }

    private PropertyChangeListener getOnWeightChangedListener() {
        if (this.onWeightChangedListener == null) {
            this.onWeightChangedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)evt.getSource();
                    SpeciesFrequencyTableModel.this.modelCache.updateRowWithWeight(row);
                    SpeciesFrequencyTableModel.this.uiModel.recomputeRowsValidateState();
                    SpeciesFrequencyTableModel.this.uiModel.updateEmptyRow(row);
                    SpeciesFrequencyTableModel.this.uiModel.recomputeTotalNumberAndWeight();
                }
            };
        }
        return this.onWeightChangedListener;
    }

    private void dettachListeners(SpeciesFrequencyRowModel result) {
        result.removePropertyChangeListener("lengthStep", this.getOnLengthStepChangedListener());
        result.removePropertyChangeListener("weight", this.getOnWeightChangedListener());
        result.removePropertyChangeListener("number", this.getOnNumberChangedListener());
    }

    private void attachListeners(SpeciesFrequencyRowModel result) {
        result.addPropertyChangeListener("lengthStep", this.getOnLengthStepChangedListener());
        result.addPropertyChangeListener("weight", this.getOnWeightChangedListener());
        result.addPropertyChangeListener("number", this.getOnNumberChangedListener());
    }
}

