/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.querymodel;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.util.DataTypeUtil;
import org.eclipse.birt.data.oda.pojo.util.MethodParameterType;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConstantParameter
implements IMethodParameter {
    private String stringValue;
    private String dataType;
    private Object targetTypeValue;

    public ConstantParameter(String stringValue, String dataType) {
        assert (dataType != null);
        this.stringValue = stringValue;
        this.dataType = dataType;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public Element createElement(Document doc) {
        Element ele = doc.createElement("ConstantParameter");
        if (this.stringValue != null) {
            ele.setAttribute("value", this.stringValue);
        }
        ele.setAttribute("type", this.getDataType());
        return ele;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + (this.stringValue == null ? 0 : this.stringValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantParameter other = (ConstantParameter)obj;
        if (!this.dataType.equals(other.dataType)) {
            return false;
        }
        return !(this.stringValue == null ? other.stringValue != null : !this.stringValue.equals(other.stringValue));
    }

    @Override
    public Object getTargetValue() {
        return this.targetTypeValue;
    }

    @Override
    public void prepareValue(Map<String, Object> paramValues, ClassLoader pojoClassLoader) throws OdaException {
        MethodParameterType mpt = MethodParameterType.getInstance(this.dataType, pojoClassLoader);
        Class c = mpt.getJavaType();
        this.targetTypeValue = Boolean.class == c || Boolean.TYPE == c ? DataTypeUtil.toBooleanFromString(this.stringValue) : (Byte.class == c || Byte.TYPE == c ? DataTypeUtil.toByteFromString(this.stringValue) : (Short.class == c || Short.TYPE == c ? DataTypeUtil.toShortFromString(this.stringValue) : (Character.class == c || Character.TYPE == c ? DataTypeUtil.toCharFromString(this.stringValue) : (Integer.class == c || Integer.TYPE == c ? DataTypeUtil.toIntegerFromString(this.stringValue) : (Float.class == c || Float.TYPE == c ? DataTypeUtil.toFloatFromString(this.stringValue) : (Double.class == c || Double.TYPE == c ? DataTypeUtil.toDoubleFromString(this.stringValue) : (BigDecimal.class == c ? DataTypeUtil.toBigDecimalFromString(this.stringValue) : (java.util.Date.class == c || Date.class == c ? DataTypeUtil.toDateFromString(this.stringValue) : (Time.class == c ? DataTypeUtil.toTimeFromString(this.stringValue) : (Timestamp.class == c ? DataTypeUtil.toTimestampFromString(this.stringValue) : this.stringValue))))))))));
    }

    @Override
    public void setDataType(String type) {
        this.dataType = type;
    }

    @Override
    public void setStringValue(String value) {
        this.stringValue = value;
    }
}

