/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.naming;

import org.hibernate.AssertionFailure;
import org.hibernate.cfg.naming.NamingStrategyDelegateAdapter;
import org.hibernate.internal.util.StringHelper;

public class JpaNamingStrategyDelegate
extends NamingStrategyDelegateAdapter {
    @Override
    public String determineImplicitPrimaryTableName(String entityName, String jpaEntityName) {
        return StringHelper.unqualify(this.determineEntityNameToUse(entityName, jpaEntityName));
    }

    @Override
    public String determineImplicitElementCollectionTableName(String ownerEntityName, String ownerJpaEntityName, String ownerEntityTable, String propertyPath) {
        return this.determineEntityNameToUse(ownerEntityName, ownerJpaEntityName) + '_' + StringHelper.unqualify(propertyPath);
    }

    @Override
    public String determineImplicitElementCollectionJoinColumnName(String ownerEntityName, String ownerJpaEntityName, String ownerEntityTable, String referencedColumnName, String propertyPath) {
        return this.determineEntityNameToUse(ownerEntityName, ownerJpaEntityName) + '_' + referencedColumnName;
    }

    @Override
    public String determineImplicitEntityAssociationJoinTableName(String ownerEntityName, String ownerJpaEntityName, String ownerEntityTable, String associatedEntityName, String associatedJpaEntityName, String associatedEntityTable, String propertyPath) {
        return ownerEntityTable + '_' + associatedEntityTable;
    }

    @Override
    public String determineImplicitEntityAssociationJoinColumnName(String propertyEntityName, String propertyJpaEntityName, String propertyTableName, String referencedColumnName, String referencingPropertyName) {
        String header = referencingPropertyName == null ? this.determineEntityNameToUse(propertyEntityName, propertyJpaEntityName) : StringHelper.unqualify(referencingPropertyName);
        if (header == null) {
            throw new AssertionFailure("propertyJpaEntityName and referencingPropertyName cannot both be empty.");
        }
        return this.toPhysicalColumnName(header + "_" + referencedColumnName);
    }

    @Override
    public String determineLogicalElementCollectionTableName(String tableName, String ownerEntityName, String ownerJpaEntityName, String ownerEntityTable, String propertyName) {
        if (tableName != null) {
            return tableName;
        }
        return this.determineImplicitElementCollectionTableName(ownerEntityName, ownerJpaEntityName, ownerEntityTable, propertyName);
    }

    @Override
    public String determineLogicalEntityAssociationJoinTableName(String tableName, String ownerEntityName, String ownerJpaEntityName, String ownerEntityTable, String associatedEntityName, String associatedJpaEntityName, String associatedEntityTable, String propertyName) {
        if (tableName != null) {
            return tableName;
        }
        return this.determineImplicitEntityAssociationJoinTableName(ownerEntityName, ownerJpaEntityName, ownerEntityTable, associatedEntityName, associatedJpaEntityName, associatedEntityTable, propertyName);
    }

    private String determineEntityNameToUse(String entityName, String jpaEntityName) {
        if (StringHelper.isNotEmpty(jpaEntityName)) {
            return jpaEntityName;
        }
        return StringHelper.unqualifyEntityName(entityName);
    }
}

