package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.type.CoordinateEditorType;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.GearUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.VesselUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.SimpleTimeEditor;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.gis.DmdCoordinateEditor;
import jaxx.runtime.swing.editor.gis.DmsCoordinateEditor;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class EditFishingOperationUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditFishingOperationUIModel, EditFishingOperationUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_DURATION_FIELD_TEXT = "durationField.text";
    public static final String BINDING_FILTER_SECONDARY_VESSEL_ALL_BUTTON_SELECTED = "filterSecondaryVesselAllButton.selected";
    public static final String BINDING_FILTER_SECONDARY_VESSEL_FISHING_BUTTON_SELECTED = "filterSecondaryVesselFishingButton.selected";
    public static final String BINDING_FILTER_SECONDARY_VESSEL_ONLY_CRUISE_BUTTON_SELECTED = "filterSecondaryVesselOnlyCruiseButton.selected";
    public static final String BINDING_FILTER_SECONDARY_VESSEL_SCIENTIFIC_BUTTON_SELECTED = "filterSecondaryVesselScientificButton.selected";
    public static final String BINDING_FISHING_OPERATION_ATTACHMENTS_BUTTON_ENABLED = "fishingOperationAttachmentsButton.enabled";
    public static final String BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED = "fishingOperationInvalidRadio.selected";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL = "fishingOperationNumberField.model";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN = "fishingOperationNumberField.numberPattern";
    public static final String BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED = "fishingOperationRectiligneCheckBox.selected";
    public static final String BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED = "fishingOperationResetRadio.selected";
    public static final String BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED = "fishingOperationValidRadio.selected";
    public static final String BINDING_GEAR_COMBO_BOX_SELECTED_ITEM = "gearComboBox.selectedItem";
    public static final String BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE = "gearShootingEndDateField.date";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL = "gearShootingEndLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDFIELD_VALUE = "gearShootingEndLatitudeDMDField.value";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSFIELD_VALUE = "gearShootingEndLatitudeDMSField.value";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL = "gearShootingEndLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDFIELD_VALUE = "gearShootingEndLongitudeDMDField.value";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSFIELD_VALUE = "gearShootingEndLongitudeDMSField.value";
    public static final String BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE = "gearShootingEndTimeField.date";
    public static final String BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE = "gearShootingStartDateField.date";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL = "gearShootingStartLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDFIELD_VALUE = "gearShootingStartLatitudeDMDField.value";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSFIELD_VALUE = "gearShootingStartLatitudeDMSField.value";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL = "gearShootingStartLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDFIELD_VALUE = "gearShootingStartLongitudeDMDField.value";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSFIELD_VALUE = "gearShootingStartLongitudeDMSField.value";
    public static final String BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE = "gearShootingStartTimeField.date";
    public static final String BINDING_IMPORT_FROM_COLUMN_FILE_ENABLED = "importFromColumnFile.enabled";
    public static final String BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM = "locationComboBox.selectedItem";
    public static final String BINDING_MULTIRIG_AGGREGATION_FIELD_TEXT = "multirigAggregationField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_STATION_NUMBER_FIELD_TEXT = "stationNumberField.text";
    public static final String BINDING_STRATA_COMBO_BOX_SELECTED_ITEM = "strataComboBox.selectedItem";
    public static final String BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM = "subStrataComboBox.selectedItem";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_ENABLED = "trawlDistanceField.enabled";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_MODEL = "trawlDistanceField.model";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_NUMBER_PATTERN = "trawlDistanceField.numberPattern";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_TOOL_TIP_TEXT = "trawlDistanceField.toolTipText";
    public static final String BINDING_VESSEL_FIELD_TEXT = "vesselField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditFishingOperationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected JPanel createFishingOperationActions;
    protected JTextField durationField;
    protected JLabel durationLabel;
    protected EditFishingOperationUI editFishingOperationTopPanel = this;
    protected JRadioButton filterSecondaryVesselAllButton;
    protected JRadioButton filterSecondaryVesselFishingButton;
    protected JLabel filterSecondaryVesselLabel;
    protected JRadioButton filterSecondaryVesselOnlyCruiseButton;
    protected JRadioButton filterSecondaryVesselScientificButton;
    protected JAXXButtonGroup filterSecondaryVesselType;
    protected ButtonAttachment fishingOperationAttachmentsButton;
    protected JRadioButton fishingOperationInvalidRadio;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationNumber",  editorName = "fishingOperationNumberField")
    protected NumberEditor fishingOperationNumberField;
    protected JLabel fishingOperationNumberLabel;
    protected JPanel fishingOperationPane;
    protected JCheckBox fishingOperationRectiligneCheckBox;
    protected JRadioButton fishingOperationResetRadio;
    protected JTabbedPane fishingOperationTabPane;
    protected JScrollPane fishingOperationTabScrollPane;
    protected JAXXButtonGroup fishingOperationValid;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationValid",  editorName = "fishingOperationValidPanel")
    protected JToolBar fishingOperationValidPanel;
    protected JRadioButton fishingOperationValidRadio;
    protected Table gearCaracteristicsTable;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearComboBox")
    protected BeanFilterableComboBox<Gear> gearComboBox;
    protected JLabel gearDateLabel;
    protected JLabel gearLabel;
    protected JLabel gearLatitudeLabel;
    protected JLabel gearLongitudeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndDate",  editorName = "gearShootingEndDateField")
    protected JXDatePicker gearShootingEndDateField;
    protected JLabel gearShootingEndLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitude",  editorName = "gearShootingEndLatitudeDDField")
    protected NumberEditor gearShootingEndLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = { "gearShootingEndLatitudeDmdDegree", "gearShootingEndLatitudeDmdMinute", "gearShootingEndLatitudeDmdDecimal" },  editorName = "gearShootingEndLatitudeDMDField")
    protected DmdCoordinateEditor gearShootingEndLatitudeDMDField;
    @ValidatorField( validatorId = "validator",  propertyName = { "gearShootingEndLatitudeDmsDegree", "gearShootingEndLatitudeDmsMinute", "gearShootingEndLatitudeDmsSecond" },  editorName = "gearShootingEndLatitudeDMSField")
    protected DmsCoordinateEditor gearShootingEndLatitudeDMSField;
    protected CardLayout2Ext gearShootingEndLatitudeLayout;
    protected JPanel gearShootingEndLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitude",  editorName = "gearShootingEndLongitudeDDField")
    protected NumberEditor gearShootingEndLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = { "gearShootingEndLongitudeDmdDegree", "gearShootingEndLongitudeDmdMinute", "gearShootingEndLongitudeDmdDecimal" },  editorName = "gearShootingEndLongitudeDMDField")
    protected DmdCoordinateEditor gearShootingEndLongitudeDMDField;
    @ValidatorField( validatorId = "validator",  propertyName = { "gearShootingEndLongitudeDmsDegree", "gearShootingEndLongitudeDmsMinute", "gearShootingEndLongitudeDmsSecond" },  editorName = "gearShootingEndLongitudeDMSField")
    protected DmsCoordinateEditor gearShootingEndLongitudeDMSField;
    protected CardLayout2Ext gearShootingEndLongitudeLayout;
    protected JPanel gearShootingEndLongitudePanel;
    protected SimpleTimeEditor gearShootingEndTimeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartDate",  editorName = "gearShootingStartDateField")
    protected JXDatePicker gearShootingStartDateField;
    protected JLabel gearShootingStartLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitude",  editorName = "gearShootingStartLatitudeDDField")
    protected NumberEditor gearShootingStartLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = { "gearShootingStartLatitudeDmdDegree", "gearShootingStartLatitudeDmdMinute", "gearShootingStartLatitudeDmdDecimal" },  editorName = "gearShootingStartLatitudeDMDField")
    protected DmdCoordinateEditor gearShootingStartLatitudeDMDField;
    @ValidatorField( validatorId = "validator",  propertyName = { "gearShootingStartLatitudeDmsDegree", "gearShootingStartLatitudeDmsMinute", "gearShootingStartLatitudeDmsSecond" },  editorName = "gearShootingStartLatitudeDMSField")
    protected DmsCoordinateEditor gearShootingStartLatitudeDMSField;
    protected CardLayout2Ext gearShootingStartLatitudeLayout;
    protected JPanel gearShootingStartLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitude",  editorName = "gearShootingStartLongitudeDDField")
    protected NumberEditor gearShootingStartLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = { "gearShootingStartLongitudeDmdDegree", "gearShootingStartLongitudeDmdMinute", "gearShootingStartLongitudeDmdDecimal" },  editorName = "gearShootingStartLongitudeDMDField")
    protected DmdCoordinateEditor gearShootingStartLongitudeDMDField;
    @ValidatorField( validatorId = "validator",  propertyName = { "gearShootingStartLongitudeDmsDegree", "gearShootingStartLongitudeDmsMinute", "gearShootingStartLongitudeDmsSecond" },  editorName = "gearShootingStartLongitudeDMSField")
    protected DmsCoordinateEditor gearShootingStartLongitudeDMSField;
    protected CardLayout2Ext gearShootingStartLongitudeLayout;
    protected JPanel gearShootingStartLongitudePanel;
    protected SimpleTimeEditor gearShootingStartTimeField;
    protected JLabel gearTimeLabel;
    protected TabInfo gearUseFeatureTab;
    protected GearUseFeatureTabUI gearUseFeatureTabContent;
    protected JXTitledPanel gearUseFeatureTabPane;
    protected Table generalForm;
    protected final EditFishingOperationUIHandler handler = new EditFishingOperationUIHandler();
    protected JButton importFromColumnFile;
    @ValidatorField( validatorId = "validator",  propertyName = "location",  editorName = "locationComboBox")
    protected BeanFilterableComboBox<TuttiLocation> locationComboBox;
    protected JLabel locationLabel;
    protected EditFishingOperationUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "multirigAggregation",  editorName = "multirigAggregationField")
    protected JTextField multirigAggregationField;
    protected JLabel multirigAggregationLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "recorderPerson",  editorName = "recorderPersonList")
    protected BeanDoubleList<Person> recorderPersonList;
    protected JButton resetValidStateButton;
    protected JButton saveButton;
    protected JPanel secondaryVesselFilterPane;
    protected BeanDoubleList<Vessel> secondaryVesselList;
    @ValidatorField( validatorId = "validator",  propertyName = "stationNumber",  editorName = "stationNumberField")
    protected JTextField stationNumberField;
    protected JLabel stationNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "strata",  editorName = "strataComboBox")
    protected BeanFilterableComboBox<TuttiLocation> strataComboBox;
    protected JLabel strataLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "subStrata",  editorName = "subStrataComboBox")
    protected BeanFilterableComboBox<TuttiLocation> subStrataComboBox;
    protected JLabel subStrataLabel;
    protected TabInfo traitGeneralTab;
    protected JXTitledPanel traitGeneralTabPane;
    protected JToolBar traitGeneralTabPaneToolBar;
    protected Table traitVesselPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "trawlDistance",  editorName = "trawlDistanceField")
    protected NumberEditor trawlDistanceField;
    protected JLabel trawlDistanceLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditFishingOperationUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JLabel vesselField;
    protected JLabel vesselLabel;
    protected TabInfo vesselUseFeatureTab;
    protected VesselUseFeatureTabUI vesselUseFeatureTabContent;
    protected JXTitledPanel vesselUseFeatureTabPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private HBox $HBox0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JPanel $JPanel6;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditFishingOperationUI(FishingOperationsUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI() {
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__filterSecondaryVesselAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSecondaryVesselType(SecondaryVesselTypeEnum.ALL);
    }

    public void doActionPerformed__on__filterSecondaryVesselFishingButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSecondaryVesselType(SecondaryVesselTypeEnum.FISHING);
    }

    public void doActionPerformed__on__filterSecondaryVesselOnlyCruiseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSecondaryVesselType(SecondaryVesselTypeEnum.ONLY_CRUISE);
    }

    public void doActionPerformed__on__filterSecondaryVesselScientificButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSecondaryVesselType(SecondaryVesselTypeEnum.SCIENTIFIC);
    }

    public void doActionPerformed__on__fishingOperationInvalidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.FALSE);
    }

    public void doActionPerformed__on__fishingOperationValidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.TRUE);
    }

    public void doActionPerformed__on__gearShootingEndDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingEndDate");
    }

    public void doActionPerformed__on__gearShootingStartDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingStartDate");
    }

    public void doActionPerformed__on__resetValidStateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(null);
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doItemStateChanged__on__fishingOperationRectiligneCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "fishingOperationRectiligne");
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__multirigAggregationField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "multirigAggregation");
    }

    public void doKeyReleased__on__stationNumberField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "stationNumber");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JPanel getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public JTextField getDurationField() {
        return durationField;
    }

    public JLabel getDurationLabel() {
        return durationLabel;
    }

    public JRadioButton getFilterSecondaryVesselAllButton() {
        return filterSecondaryVesselAllButton;
    }

    public JRadioButton getFilterSecondaryVesselFishingButton() {
        return filterSecondaryVesselFishingButton;
    }

    public JLabel getFilterSecondaryVesselLabel() {
        return filterSecondaryVesselLabel;
    }

    public JRadioButton getFilterSecondaryVesselOnlyCruiseButton() {
        return filterSecondaryVesselOnlyCruiseButton;
    }

    public JRadioButton getFilterSecondaryVesselScientificButton() {
        return filterSecondaryVesselScientificButton;
    }

    public JAXXButtonGroup getFilterSecondaryVesselType() {
        return filterSecondaryVesselType;
    }

    public ButtonAttachment getFishingOperationAttachmentsButton() {
        return fishingOperationAttachmentsButton;
    }

    public JRadioButton getFishingOperationInvalidRadio() {
        return fishingOperationInvalidRadio;
    }

    public NumberEditor getFishingOperationNumberField() {
        return fishingOperationNumberField;
    }

    public JLabel getFishingOperationNumberLabel() {
        return fishingOperationNumberLabel;
    }

    public JPanel getFishingOperationPane() {
        return fishingOperationPane;
    }

    public JCheckBox getFishingOperationRectiligneCheckBox() {
        return fishingOperationRectiligneCheckBox;
    }

    public JRadioButton getFishingOperationResetRadio() {
        return fishingOperationResetRadio;
    }

    public JTabbedPane getFishingOperationTabPane() {
        return fishingOperationTabPane;
    }

    public JScrollPane getFishingOperationTabScrollPane() {
        return fishingOperationTabScrollPane;
    }

    public JAXXButtonGroup getFishingOperationValid() {
        return fishingOperationValid;
    }

    public JToolBar getFishingOperationValidPanel() {
        return fishingOperationValidPanel;
    }

    public JRadioButton getFishingOperationValidRadio() {
        return fishingOperationValidRadio;
    }

    public Table getGearCaracteristicsTable() {
        return gearCaracteristicsTable;
    }

    public BeanFilterableComboBox<Gear> getGearComboBox() {
        return gearComboBox;
    }

    public JLabel getGearDateLabel() {
        return gearDateLabel;
    }

    public JLabel getGearLabel() {
        return gearLabel;
    }

    public JLabel getGearLatitudeLabel() {
        return gearLatitudeLabel;
    }

    public JLabel getGearLongitudeLabel() {
        return gearLongitudeLabel;
    }

    public JXDatePicker getGearShootingEndDateField() {
        return gearShootingEndDateField;
    }

    public JLabel getGearShootingEndLabel() {
        return gearShootingEndLabel;
    }

    public NumberEditor getGearShootingEndLatitudeDDField() {
        return gearShootingEndLatitudeDDField;
    }

    public DmdCoordinateEditor getGearShootingEndLatitudeDMDField() {
        return gearShootingEndLatitudeDMDField;
    }

    public DmsCoordinateEditor getGearShootingEndLatitudeDMSField() {
        return gearShootingEndLatitudeDMSField;
    }

    public CardLayout2Ext getGearShootingEndLatitudeLayout() {
        return gearShootingEndLatitudeLayout;
    }

    public JPanel getGearShootingEndLatitudePanel() {
        return gearShootingEndLatitudePanel;
    }

    public NumberEditor getGearShootingEndLongitudeDDField() {
        return gearShootingEndLongitudeDDField;
    }

    public DmdCoordinateEditor getGearShootingEndLongitudeDMDField() {
        return gearShootingEndLongitudeDMDField;
    }

    public DmsCoordinateEditor getGearShootingEndLongitudeDMSField() {
        return gearShootingEndLongitudeDMSField;
    }

    public CardLayout2Ext getGearShootingEndLongitudeLayout() {
        return gearShootingEndLongitudeLayout;
    }

    public JPanel getGearShootingEndLongitudePanel() {
        return gearShootingEndLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingEndTimeField() {
        return gearShootingEndTimeField;
    }

    public JXDatePicker getGearShootingStartDateField() {
        return gearShootingStartDateField;
    }

    public JLabel getGearShootingStartLabel() {
        return gearShootingStartLabel;
    }

    public NumberEditor getGearShootingStartLatitudeDDField() {
        return gearShootingStartLatitudeDDField;
    }

    public DmdCoordinateEditor getGearShootingStartLatitudeDMDField() {
        return gearShootingStartLatitudeDMDField;
    }

    public DmsCoordinateEditor getGearShootingStartLatitudeDMSField() {
        return gearShootingStartLatitudeDMSField;
    }

    public CardLayout2Ext getGearShootingStartLatitudeLayout() {
        return gearShootingStartLatitudeLayout;
    }

    public JPanel getGearShootingStartLatitudePanel() {
        return gearShootingStartLatitudePanel;
    }

    public NumberEditor getGearShootingStartLongitudeDDField() {
        return gearShootingStartLongitudeDDField;
    }

    public DmdCoordinateEditor getGearShootingStartLongitudeDMDField() {
        return gearShootingStartLongitudeDMDField;
    }

    public DmsCoordinateEditor getGearShootingStartLongitudeDMSField() {
        return gearShootingStartLongitudeDMSField;
    }

    public CardLayout2Ext getGearShootingStartLongitudeLayout() {
        return gearShootingStartLongitudeLayout;
    }

    public JPanel getGearShootingStartLongitudePanel() {
        return gearShootingStartLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingStartTimeField() {
        return gearShootingStartTimeField;
    }

    public JLabel getGearTimeLabel() {
        return gearTimeLabel;
    }

    public TabInfo getGearUseFeatureTab() {
        return gearUseFeatureTab;
    }

    public GearUseFeatureTabUI getGearUseFeatureTabContent() {
        return gearUseFeatureTabContent;
    }

    public JXTitledPanel getGearUseFeatureTabPane() {
        return gearUseFeatureTabPane;
    }

    public Table getGeneralForm() {
        return generalForm;
    }

    public EditFishingOperationUIHandler getHandler() {
        return handler;
    }

    public JButton getImportFromColumnFile() {
        return importFromColumnFile;
    }

    public BeanFilterableComboBox<TuttiLocation> getLocationComboBox() {
        return locationComboBox;
    }

    public JLabel getLocationLabel() {
        return locationLabel;
    }

    public EditFishingOperationUIModel getModel() {
        return model;
    }

    public JTextField getMultirigAggregationField() {
        return multirigAggregationField;
    }

    public JLabel getMultirigAggregationLabel() {
        return multirigAggregationLabel;
    }

    public BeanDoubleList<Person> getRecorderPersonList() {
        return recorderPersonList;
    }

    public JButton getResetValidStateButton() {
        return resetValidStateButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JPanel getSecondaryVesselFilterPane() {
        return secondaryVesselFilterPane;
    }

    public BeanDoubleList<Vessel> getSecondaryVesselList() {
        return secondaryVesselList;
    }

    public JTextField getStationNumberField() {
        return stationNumberField;
    }

    public JLabel getStationNumberLabel() {
        return stationNumberLabel;
    }

    public BeanFilterableComboBox<TuttiLocation> getStrataComboBox() {
        return strataComboBox;
    }

    public JLabel getStrataLabel() {
        return strataLabel;
    }

    public BeanFilterableComboBox<TuttiLocation> getSubStrataComboBox() {
        return subStrataComboBox;
    }

    public JLabel getSubStrataLabel() {
        return subStrataLabel;
    }

    public TabInfo getTraitGeneralTab() {
        return traitGeneralTab;
    }

    public JXTitledPanel getTraitGeneralTabPane() {
        return traitGeneralTabPane;
    }

    public JToolBar getTraitGeneralTabPaneToolBar() {
        return traitGeneralTabPaneToolBar;
    }

    public Table getTraitVesselPanel() {
        return traitVesselPanel;
    }

    public NumberEditor getTrawlDistanceField() {
        return trawlDistanceField;
    }

    public JLabel getTrawlDistanceLabel() {
        return trawlDistanceLabel;
    }

    public SwingValidator<EditFishingOperationUIModel> getValidator() {
        return validator;
    }

    public JLabel getVesselField() {
        return vesselField;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    public TabInfo getVesselUseFeatureTab() {
        return vesselUseFeatureTab;
    }

    public VesselUseFeatureTabUI getVesselUseFeatureTabContent() {
        return vesselUseFeatureTabContent;
    }

    public JXTitledPanel getVesselUseFeatureTabPane() {
        return vesselUseFeatureTabPane;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JPanel get$JPanel6() {
        return $JPanel6;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton);
        createFishingOperationActions.add(saveButton);
    }

    protected void addChildrenToEditFishingOperationTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(traitGeneralTabPaneToolBar);
        add(fishingOperationPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFilterSecondaryVesselAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSecondaryVesselType; filterSecondaryVesselAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSecondaryVesselAllButton); }
    }

    protected void addChildrenToFilterSecondaryVesselFishingButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSecondaryVesselType; filterSecondaryVesselFishingButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSecondaryVesselFishingButton); }
    }

    protected void addChildrenToFilterSecondaryVesselOnlyCruiseButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSecondaryVesselType; filterSecondaryVesselOnlyCruiseButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSecondaryVesselOnlyCruiseButton); }
    }

    protected void addChildrenToFilterSecondaryVesselScientificButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSecondaryVesselType; filterSecondaryVesselScientificButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSecondaryVesselScientificButton); }
    }

    protected void addChildrenToFishingOperationInvalidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationInvalidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationInvalidRadio); }
    }

    protected void addChildrenToFishingOperationPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationPane.add(fishingOperationTabPane, BorderLayout.CENTER);
        fishingOperationPane.add($JPanel6, BorderLayout.SOUTH);
    }

    protected void addChildrenToFishingOperationResetRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationResetRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationResetRadio); }
    }

    protected void addChildrenToFishingOperationTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationTabPane.add(traitGeneralTabPane);
        fishingOperationTabPane.add(gearUseFeatureTabPane);
        fishingOperationTabPane.add(vesselUseFeatureTabPane);
        traitGeneralTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 0));
        gearUseFeatureTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 1));
        vesselUseFeatureTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 2));
    }

    protected void addChildrenToFishingOperationTabScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationTabScrollPane.getViewport().add(generalForm);
    }

    protected void addChildrenToFishingOperationValidPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationValidPanel.add(resetValidStateButton, BorderLayout.WEST);
        fishingOperationValidPanel.add(fishingOperationResetRadio, BorderLayout.EAST);
    }

    protected void addChildrenToFishingOperationValidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationValidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationValidRadio); }
    }

    protected void addChildrenToGearCaracteristicsTable() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsTable.add($JPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLatitudeLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLongitudeLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearDateLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearTimeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLatitudePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLongitudePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartDateField), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartTimeField, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLatitudePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLongitudePanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndDateField), new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndTimeField, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel0, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(fishingOperationRectiligneCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel2, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel1, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel3, new GridBagConstraints(4, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(fishingOperationValidPanel), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($HBox0, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel4, new GridBagConstraints(2, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToGearShootingEndLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDDField), "DD");
        gearShootingEndLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSField), "DMS");
        gearShootingEndLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMDField), "DMD");
    }

    protected void addChildrenToGearShootingEndLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDDField), "DD");
        gearShootingEndLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSField), "DMS");
        gearShootingEndLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMDField), "DMD");
    }

    protected void addChildrenToGearShootingStartLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDDField), "DD");
        gearShootingStartLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSField), "DMS");
        gearShootingStartLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMDField), "DMD");
    }

    protected void addChildrenToGearShootingStartLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDDField), "DD");
        gearShootingStartLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSField), "DMS");
        gearShootingStartLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMDField), "DMD");
    }

    protected void addChildrenToGearUseFeatureTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        gearUseFeatureTabPane.add(gearUseFeatureTabContent);
    }

    protected void addChildrenToGeneralForm() {
        if (!allComponentsCreated) {
            return;
        }
        generalForm.add(stationNumberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(stationNumberField), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationNumberLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(fishingOperationNumberField), new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(multirigAggregationLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(multirigAggregationField), new GridBagConstraints(5, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(strataComboBox), new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(subStrataComboBox), new GridBagConstraints(3, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(locationLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(locationComboBox), new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel0, new GridBagConstraints(0, 2, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel5, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.2, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 4, 6, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSecondaryVesselFilterPane() {
        if (!allComponentsCreated) {
            return;
        }
        secondaryVesselFilterPane.add(filterSecondaryVesselLabel);
        secondaryVesselFilterPane.add(filterSecondaryVesselAllButton);
        secondaryVesselFilterPane.add(filterSecondaryVesselScientificButton);
        secondaryVesselFilterPane.add(filterSecondaryVesselFishingButton);
        secondaryVesselFilterPane.add(filterSecondaryVesselOnlyCruiseButton);
    }

    protected void addChildrenToTraitGeneralTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        traitGeneralTabPane.add(fishingOperationTabScrollPane);
    }

    protected void addChildrenToTraitGeneralTabPaneToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        traitGeneralTabPaneToolBar.add(importFromColumnFile);
        traitGeneralTabPaneToolBar.add(fishingOperationAttachmentsButton);
    }

    protected void addChildrenToTraitVesselPanel() {
        if (!allComponentsCreated) {
            return;
        }
        traitVesselPanel.add(vesselLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(vesselField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(gearLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(SwingUtil.boxComponentWithJxLayer(gearComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(secondaryVesselFilterPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(secondaryVesselList, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToVesselUseFeatureTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        vesselUseFeatureTabPane.add(vesselUseFeatureTabContent);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editeditFishingOperation.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.editFishingOperation.action.cancelEditFishingOperation"));
        cancelButton.setToolTipText(t("tutti.editFishingOperation.action.cancelEditFishingOperation.tip"));
        cancelButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.CancelEditFishingOperationAction.class);
        cancelButton.putClientProperty("help", "tutti.editFishingOperation.action.cancelEditFishingOperation.help");
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(t("tutti.editFishingOperation.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editFishingOperation.field.comment.help");
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new JPanel());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        createFishingOperationActions.setLayout(new GridLayout(1,0));
    }

    protected void createDurationField() {
        $objectMap.put("durationField", durationField = new JTextField());
        
        durationField.setName("durationField");
        durationField.setColumns(15);
        durationField.setEnabled(false);
        durationField.putClientProperty("help", "tutti.editFishingOperation.field.duration.help");
        durationField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.duration"));
    }

    protected void createDurationLabel() {
        $objectMap.put("durationLabel", durationLabel = new JLabel());
        
        durationLabel.setName("durationLabel");
        durationLabel.setText(t("tutti.editFishingOperation.field.duration"));
        durationLabel.setToolTipText(t("tutti.editFishingOperation.field.duration.tip"));
        durationLabel.putClientProperty("help", "tutti.editFishingOperation.field.duration.help");
    }

    protected void createFilterSecondaryVesselAllButton() {
        $objectMap.put("filterSecondaryVesselAllButton", filterSecondaryVesselAllButton = new JRadioButton());
        
        filterSecondaryVesselAllButton.setName("filterSecondaryVesselAllButton");
        filterSecondaryVesselAllButton.setText(t("tutti.editFishingOperation.filterSecondaryVesselType.all"));
        { filterSecondaryVesselAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterSecondaryVesselAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSecondaryVesselAllButton.setToolTipText(t("tutti.editFishingOperation.filterSecondaryVesselType.all.tip"));
        filterSecondaryVesselAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSecondaryVesselAllButton"));
    }

    protected void createFilterSecondaryVesselFishingButton() {
        $objectMap.put("filterSecondaryVesselFishingButton", filterSecondaryVesselFishingButton = new JRadioButton());
        
        filterSecondaryVesselFishingButton.setName("filterSecondaryVesselFishingButton");
        filterSecondaryVesselFishingButton.setText(t("tutti.editFishingOperation.filterSecondaryVesselType.fishing"));
        { filterSecondaryVesselFishingButton.putClientProperty("$value", "fishing");  Object $buttonGroup = filterSecondaryVesselFishingButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSecondaryVesselFishingButton.setToolTipText(t("tutti.editFishingOperation.filterSecondaryVesselType.fishing.tip"));
        filterSecondaryVesselFishingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSecondaryVesselFishingButton"));
    }

    protected void createFilterSecondaryVesselLabel() {
        $objectMap.put("filterSecondaryVesselLabel", filterSecondaryVesselLabel = new JLabel());
        
        filterSecondaryVesselLabel.setName("filterSecondaryVesselLabel");
        filterSecondaryVesselLabel.setText(t("tutti.editFishingOperation.filterSecondaryVesselType"));
        filterSecondaryVesselLabel.setToolTipText(t("tutti.editFishingOperation.filterSecondaryVesselType.tip"));
        filterSecondaryVesselLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterSecondaryVesselOnlyCruiseButton() {
        $objectMap.put("filterSecondaryVesselOnlyCruiseButton", filterSecondaryVesselOnlyCruiseButton = new JRadioButton());
        
        filterSecondaryVesselOnlyCruiseButton.setName("filterSecondaryVesselOnlyCruiseButton");
        filterSecondaryVesselOnlyCruiseButton.setText(t("tutti.editFishingOperation.filterSecondaryVesselType.onlyCruise"));
        { filterSecondaryVesselOnlyCruiseButton.putClientProperty("$value", "onlyCruise");  Object $buttonGroup = filterSecondaryVesselOnlyCruiseButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSecondaryVesselOnlyCruiseButton.setToolTipText(t("tutti.editFishingOperation.filterSecondaryVesselType.onlyCruise.tip"));
        filterSecondaryVesselOnlyCruiseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSecondaryVesselOnlyCruiseButton"));
    }

    protected void createFilterSecondaryVesselScientificButton() {
        $objectMap.put("filterSecondaryVesselScientificButton", filterSecondaryVesselScientificButton = new JRadioButton());
        
        filterSecondaryVesselScientificButton.setName("filterSecondaryVesselScientificButton");
        filterSecondaryVesselScientificButton.setText(t("tutti.editFishingOperation.filterSecondaryVesselType.scientific"));
        { filterSecondaryVesselScientificButton.putClientProperty("$value", "scientific");  Object $buttonGroup = filterSecondaryVesselScientificButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSecondaryVesselScientificButton.setToolTipText(t("tutti.editFishingOperation.filterSecondaryVesselType.scientific.tip"));
        filterSecondaryVesselScientificButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSecondaryVesselScientificButton"));
    }

    protected void createFilterSecondaryVesselType() {
        $objectMap.put("filterSecondaryVesselType", filterSecondaryVesselType = new JAXXButtonGroup());
    }

    protected void createFishingOperationAttachmentsButton() {
        $objectMap.put("fishingOperationAttachmentsButton", fishingOperationAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        fishingOperationAttachmentsButton.setName("fishingOperationAttachmentsButton");
        fishingOperationAttachmentsButton.setToolTipText(t("tutti.editFishingOperation.action.attachments.tip"));
        fishingOperationAttachmentsButton.putClientProperty("help", "tutti.editFishingOperation.action.attachments.help");
    }

    protected void createFishingOperationInvalidRadio() {
        $objectMap.put("fishingOperationInvalidRadio", fishingOperationInvalidRadio = new JRadioButton());
        
        fishingOperationInvalidRadio.setName("fishingOperationInvalidRadio");
        fishingOperationInvalidRadio.setText(t("tutti.editFishingOperation.field.fishingOperationInvalid"));
        fishingOperationInvalidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationInvalidRadio"));
        fishingOperationInvalidRadio.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationValid.help");
    }

    protected void createFishingOperationNumberField() {
        $objectMap.put("fishingOperationNumberField", fishingOperationNumberField = new NumberEditor(this));
        
        fishingOperationNumberField.setName("fishingOperationNumberField");
        fishingOperationNumberField.setProperty("fishingOperationNumber");
        fishingOperationNumberField.setUseFloat(false);
        fishingOperationNumberField.setShowReset(true);
        fishingOperationNumberField.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationNumber.help");
        fishingOperationNumberField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.fishingOperationNumber"));
        fishingOperationNumberField.putClientProperty("selectOnFocus", true);
    }

    protected void createFishingOperationNumberLabel() {
        $objectMap.put("fishingOperationNumberLabel", fishingOperationNumberLabel = new JLabel());
        
        fishingOperationNumberLabel.setName("fishingOperationNumberLabel");
        fishingOperationNumberLabel.setText(t("tutti.editFishingOperation.field.fishingOperationNumber"));
        fishingOperationNumberLabel.setToolTipText(t("tutti.editFishingOperation.field.fishingOperationNumber.tip"));
        fishingOperationNumberLabel.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationNumber.help");
    }

    protected void createFishingOperationPane() {
        $objectMap.put("fishingOperationPane", fishingOperationPane = new JPanel());
        
        fishingOperationPane.setName("fishingOperationPane");
        fishingOperationPane.setLayout(new BorderLayout());
    }

    protected void createFishingOperationRectiligneCheckBox() {
        $objectMap.put("fishingOperationRectiligneCheckBox", fishingOperationRectiligneCheckBox = new JCheckBox());
        
        fishingOperationRectiligneCheckBox.setName("fishingOperationRectiligneCheckBox");
        fishingOperationRectiligneCheckBox.setText(t("tutti.editFishingOperation.field.fishingOperationRectiligne"));
        fishingOperationRectiligneCheckBox.setToolTipText(t("tutti.editFishingOperation.field.fishingOperationRectiligne.tip"));
        fishingOperationRectiligneCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fishingOperationRectiligneCheckBox"));
        fishingOperationRectiligneCheckBox.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationRectiligne.help");
    }

    protected void createFishingOperationResetRadio() {
        $objectMap.put("fishingOperationResetRadio", fishingOperationResetRadio = new JRadioButton());
        
        fishingOperationResetRadio.setName("fishingOperationResetRadio");
        fishingOperationResetRadio.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationValid.help");
    }

    protected void createFishingOperationTabPane() {
        $objectMap.put("fishingOperationTabPane", fishingOperationTabPane = new JTabbedPane());
        
        fishingOperationTabPane.setName("fishingOperationTabPane");
    }

    protected void createFishingOperationTabScrollPane() {
        $objectMap.put("fishingOperationTabScrollPane", fishingOperationTabScrollPane = new JScrollPane());
        
        fishingOperationTabScrollPane.setName("fishingOperationTabScrollPane");
        fishingOperationTabScrollPane.putClientProperty("onlyVerticalScrollable", true);
    }

    protected void createFishingOperationValid() {
        $objectMap.put("fishingOperationValid", fishingOperationValid = new JAXXButtonGroup());
    }

    protected void createFishingOperationValidPanel() {
        $objectMap.put("fishingOperationValidPanel", fishingOperationValidPanel = new JToolBar());
        
        fishingOperationValidPanel.setName("fishingOperationValidPanel");
        fishingOperationValidPanel.setLayout(new BorderLayout());
        fishingOperationValidPanel.setFloatable(false);
        fishingOperationValidPanel.setOpaque(false);
        fishingOperationValidPanel.setToolTipText(t("tutti.editFishingOperation.field.fishingOperationValid.tip"));
        fishingOperationValidPanel.setBorderPainted(false);
        fishingOperationValidPanel.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationValid.help");
        fishingOperationValidPanel.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.fishingOperationValidity"));
    }

    protected void createFishingOperationValidRadio() {
        $objectMap.put("fishingOperationValidRadio", fishingOperationValidRadio = new JRadioButton());
        
        fishingOperationValidRadio.setName("fishingOperationValidRadio");
        fishingOperationValidRadio.setText(t("tutti.editFishingOperation.field.fishingOperationValid"));
        fishingOperationValidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationValidRadio"));
        fishingOperationValidRadio.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationValid.help");
    }

    protected void createGearCaracteristicsTable() {
        $objectMap.put("gearCaracteristicsTable", gearCaracteristicsTable = new Table());
        
        gearCaracteristicsTable.setName("gearCaracteristicsTable");
    }

    protected void createGearComboBox() {
        $objectMap.put("gearComboBox", gearComboBox = new BeanFilterableComboBox<Gear>(this));
        
        gearComboBox.setName("gearComboBox");
        gearComboBox.setProperty("gear");
        gearComboBox.setShowReset(true);
        gearComboBox.putClientProperty("help", "tutti.editFishingOperation.field.gear.help");
        gearComboBox.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gear"));
    }

    protected void createGearDateLabel() {
        $objectMap.put("gearDateLabel", gearDateLabel = new JLabel());
        
        gearDateLabel.setName("gearDateLabel");
        gearDateLabel.setText(t("tutti.editFishingOperation.field.gearDate"));
        gearDateLabel.setToolTipText(t("tutti.editFishingOperation.field.gearDate.tip"));
        gearDateLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearDate.help");
    }

    protected void createGearLabel() {
        $objectMap.put("gearLabel", gearLabel = new JLabel());
        
        gearLabel.setName("gearLabel");
        gearLabel.setText(t("tutti.editFishingOperation.field.gear"));
        gearLabel.setToolTipText(t("tutti.editFishingOperation.field.gear.tip"));
        gearLabel.putClientProperty("help", "tutti.editFishingOperation.field.gear.help");
    }

    protected void createGearLatitudeLabel() {
        $objectMap.put("gearLatitudeLabel", gearLatitudeLabel = new JLabel());
        
        gearLatitudeLabel.setName("gearLatitudeLabel");
        gearLatitudeLabel.setToolTipText(t("tutti.editFishingOperation.field.gearLatitude.tip"));
        gearLatitudeLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearLatitude.help");
    }

    protected void createGearLongitudeLabel() {
        $objectMap.put("gearLongitudeLabel", gearLongitudeLabel = new JLabel());
        
        gearLongitudeLabel.setName("gearLongitudeLabel");
        gearLongitudeLabel.setToolTipText(t("tutti.editFishingOperation.field.gearLongitude.tip"));
        gearLongitudeLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearLongitude.help");
    }

    protected void createGearShootingEndDateField() {
        $objectMap.put("gearShootingEndDateField", gearShootingEndDateField = new JXDatePicker());
        
        gearShootingEndDateField.setName("gearShootingEndDateField");
        gearShootingEndDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingEndDateField"));
        gearShootingEndDateField.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEndDate.help");
        gearShootingEndDateField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingEndDate"));
        gearShootingEndDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLabel() {
        $objectMap.put("gearShootingEndLabel", gearShootingEndLabel = new JLabel());
        
        gearShootingEndLabel.setName("gearShootingEndLabel");
        gearShootingEndLabel.setText(t("tutti.editFishingOperation.field.gearShootingEnd"));
        gearShootingEndLabel.setToolTipText(t("tutti.editFishingOperation.field.gearShootingEnd.tip"));
        gearShootingEndLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEnd.help");
    }

    protected void createGearShootingEndLatitudeDDField() {
        $objectMap.put("gearShootingEndLatitudeDDField", gearShootingEndLatitudeDDField = new NumberEditor(this));
        
        gearShootingEndLatitudeDDField.setName("gearShootingEndLatitudeDDField");
        gearShootingEndLatitudeDDField.setUseSign(true);
        gearShootingEndLatitudeDDField.setProperty("gearShootingEndLatitude");
        gearShootingEndLatitudeDDField.setUseFloat(true);
        gearShootingEndLatitudeDDField.setShowReset(false);
        gearShootingEndLatitudeDDField.setToolTipText(t("tutti.editFishingOperation.field.gearShootingEndLatitude.tip"));
        gearShootingEndLatitudeDDField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingEndLatitude"));
        gearShootingEndLatitudeDDField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLatitudeDMDField() {
        $objectMap.put("gearShootingEndLatitudeDMDField", gearShootingEndLatitudeDMDField = new DmdCoordinateEditor());
        
        gearShootingEndLatitudeDMDField.setName("gearShootingEndLatitudeDMDField");
        gearShootingEndLatitudeDMDField.setPropertyDegree("gearShootingEndLatitudeDmdDegree");
        gearShootingEndLatitudeDMDField.setPropertyMinute("gearShootingEndLatitudeDmdMinute");
        gearShootingEndLatitudeDMDField.setShowReset(true);
        gearShootingEndLatitudeDMDField.setPropertySign("gearShootingEndLatitudeDmdSign");
        gearShootingEndLatitudeDMDField.setPropertyDecimal("gearShootingEndLatitudeDmdDecimal");
        gearShootingEndLatitudeDMDField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingEndLatitude"));
    }

    protected void createGearShootingEndLatitudeDMSField() {
        $objectMap.put("gearShootingEndLatitudeDMSField", gearShootingEndLatitudeDMSField = new DmsCoordinateEditor());
        
        gearShootingEndLatitudeDMSField.setName("gearShootingEndLatitudeDMSField");
        gearShootingEndLatitudeDMSField.setPropertySecond("gearShootingEndLatitudeDmsSecond");
        gearShootingEndLatitudeDMSField.setPropertyDegree("gearShootingEndLatitudeDmsDegree");
        gearShootingEndLatitudeDMSField.setPropertyMinute("gearShootingEndLatitudeDmsMinute");
        gearShootingEndLatitudeDMSField.setShowReset(true);
        gearShootingEndLatitudeDMSField.setPropertySign("gearShootingEndLatitudeDmsSign");
        gearShootingEndLatitudeDMSField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingEndLatitude"));
    }

    protected void createGearShootingEndLatitudeLayout() {
        $objectMap.put("gearShootingEndLatitudeLayout", gearShootingEndLatitudeLayout = new CardLayout2Ext(this, "gearShootingEndLatitudePanel"));
    }

    protected void createGearShootingEndLatitudePanel() {
        $objectMap.put("gearShootingEndLatitudePanel", gearShootingEndLatitudePanel = new JPanel());
        
        gearShootingEndLatitudePanel.setName("gearShootingEndLatitudePanel");
        gearShootingEndLatitudePanel.setLayout(gearShootingEndLatitudeLayout);
        gearShootingEndLatitudePanel.setToolTipText(t("tutti.editFishingOperation.field.gearShootingEndLatitude.tip"));
        gearShootingEndLatitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEndLatitude.help");
    }

    protected void createGearShootingEndLongitudeDDField() {
        $objectMap.put("gearShootingEndLongitudeDDField", gearShootingEndLongitudeDDField = new NumberEditor(this));
        
        gearShootingEndLongitudeDDField.setName("gearShootingEndLongitudeDDField");
        gearShootingEndLongitudeDDField.setUseSign(true);
        gearShootingEndLongitudeDDField.setProperty("gearShootingEndLongitude");
        gearShootingEndLongitudeDDField.setUseFloat(true);
        gearShootingEndLongitudeDDField.setShowReset(false);
        gearShootingEndLongitudeDDField.setToolTipText(t("tutti.editFishingOperation.field.gearShootingEndLongitude.tip"));
        gearShootingEndLongitudeDDField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingEndLongitude"));
        gearShootingEndLongitudeDDField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLongitudeDMDField() {
        $objectMap.put("gearShootingEndLongitudeDMDField", gearShootingEndLongitudeDMDField = new DmdCoordinateEditor());
        
        gearShootingEndLongitudeDMDField.setName("gearShootingEndLongitudeDMDField");
        gearShootingEndLongitudeDMDField.setPropertyDegree("gearShootingEndLongitudeDmdDegree");
        gearShootingEndLongitudeDMDField.setPropertyMinute("gearShootingEndLongitudeDmdMinute");
        gearShootingEndLongitudeDMDField.setShowReset(true);
        gearShootingEndLongitudeDMDField.setPropertySign("gearShootingEndLongitudeDmdSign");
        gearShootingEndLongitudeDMDField.setPropertyDecimal("gearShootingEndLongitudeDmdDecimal");
        gearShootingEndLongitudeDMDField.putClientProperty("longitudeEditor", true);
        gearShootingEndLongitudeDMDField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingEndLongitude"));
    }

    protected void createGearShootingEndLongitudeDMSField() {
        $objectMap.put("gearShootingEndLongitudeDMSField", gearShootingEndLongitudeDMSField = new DmsCoordinateEditor());
        
        gearShootingEndLongitudeDMSField.setName("gearShootingEndLongitudeDMSField");
        gearShootingEndLongitudeDMSField.setPropertySecond("gearShootingEndLongitudeDmsSecond");
        gearShootingEndLongitudeDMSField.setPropertyDegree("gearShootingEndLongitudeDmsDegree");
        gearShootingEndLongitudeDMSField.setPropertyMinute("gearShootingEndLongitudeDmsMinute");
        gearShootingEndLongitudeDMSField.setShowReset(true);
        gearShootingEndLongitudeDMSField.setPropertySign("gearShootingEndLongitudeDmsSign");
        gearShootingEndLongitudeDMSField.putClientProperty("longitudeEditor", true);
        gearShootingEndLongitudeDMSField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingEndLongitude"));
    }

    protected void createGearShootingEndLongitudeLayout() {
        $objectMap.put("gearShootingEndLongitudeLayout", gearShootingEndLongitudeLayout = new CardLayout2Ext(this, "gearShootingEndLongitudePanel"));
    }

    protected void createGearShootingEndLongitudePanel() {
        $objectMap.put("gearShootingEndLongitudePanel", gearShootingEndLongitudePanel = new JPanel());
        
        gearShootingEndLongitudePanel.setName("gearShootingEndLongitudePanel");
        gearShootingEndLongitudePanel.setLayout(gearShootingEndLongitudeLayout);
        gearShootingEndLongitudePanel.setToolTipText(t("tutti.editFishingOperation.field.gearShootingEndLongitude.tip"));
        gearShootingEndLongitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEndLongitude.help");
    }

    protected void createGearShootingEndTimeField() {
        $objectMap.put("gearShootingEndTimeField", gearShootingEndTimeField = new SimpleTimeEditor(this));
        
        gearShootingEndTimeField.setName("gearShootingEndTimeField");
        gearShootingEndTimeField.setProperty("gearShootingEndTime");
        gearShootingEndTimeField.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEndTime.help");
        gearShootingEndTimeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartDateField() {
        $objectMap.put("gearShootingStartDateField", gearShootingStartDateField = new JXDatePicker());
        
        gearShootingStartDateField.setName("gearShootingStartDateField");
        gearShootingStartDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingStartDateField"));
        gearShootingStartDateField.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStartDate.help");
        gearShootingStartDateField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingStartDate"));
        gearShootingStartDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLabel() {
        $objectMap.put("gearShootingStartLabel", gearShootingStartLabel = new JLabel());
        
        gearShootingStartLabel.setName("gearShootingStartLabel");
        gearShootingStartLabel.setText(t("tutti.editFishingOperation.field.gearShootingStart"));
        gearShootingStartLabel.setToolTipText(t("tutti.editFishingOperation.field.gearShootingStart.tip"));
        gearShootingStartLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStart.help");
    }

    protected void createGearShootingStartLatitudeDDField() {
        $objectMap.put("gearShootingStartLatitudeDDField", gearShootingStartLatitudeDDField = new NumberEditor(this));
        
        gearShootingStartLatitudeDDField.setName("gearShootingStartLatitudeDDField");
        gearShootingStartLatitudeDDField.setUseSign(true);
        gearShootingStartLatitudeDDField.setProperty("gearShootingStartLatitude");
        gearShootingStartLatitudeDDField.setUseFloat(true);
        gearShootingStartLatitudeDDField.setShowReset(false);
        gearShootingStartLatitudeDDField.setToolTipText(t("tutti.editFishingOperation.field.gearShootingStartLatitude.tip"));
        gearShootingStartLatitudeDDField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingStartLatitude"));
        gearShootingStartLatitudeDDField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLatitudeDMDField() {
        $objectMap.put("gearShootingStartLatitudeDMDField", gearShootingStartLatitudeDMDField = new DmdCoordinateEditor());
        
        gearShootingStartLatitudeDMDField.setName("gearShootingStartLatitudeDMDField");
        gearShootingStartLatitudeDMDField.setPropertyDegree("gearShootingStartLatitudeDmdDegree");
        gearShootingStartLatitudeDMDField.setPropertyMinute("gearShootingStartLatitudeDmdMinute");
        gearShootingStartLatitudeDMDField.setShowReset(true);
        gearShootingStartLatitudeDMDField.setPropertySign("gearShootingStartLatitudeDmdSign");
        gearShootingStartLatitudeDMDField.setPropertyDecimal("gearShootingStartLatitudeDmdDecimal");
        gearShootingStartLatitudeDMDField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingStartLatitude"));
    }

    protected void createGearShootingStartLatitudeDMSField() {
        $objectMap.put("gearShootingStartLatitudeDMSField", gearShootingStartLatitudeDMSField = new DmsCoordinateEditor());
        
        gearShootingStartLatitudeDMSField.setName("gearShootingStartLatitudeDMSField");
        gearShootingStartLatitudeDMSField.setPropertySecond("gearShootingStartLatitudeDmsSecond");
        gearShootingStartLatitudeDMSField.setPropertyDegree("gearShootingStartLatitudeDmsDegree");
        gearShootingStartLatitudeDMSField.setPropertyMinute("gearShootingStartLatitudeDmsMinute");
        gearShootingStartLatitudeDMSField.setShowReset(true);
        gearShootingStartLatitudeDMSField.setPropertySign("gearShootingStartLatitudeDmsSign");
        gearShootingStartLatitudeDMSField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingStartLatitude"));
    }

    protected void createGearShootingStartLatitudeLayout() {
        $objectMap.put("gearShootingStartLatitudeLayout", gearShootingStartLatitudeLayout = new CardLayout2Ext(this, "gearShootingStartLatitudePanel"));
    }

    protected void createGearShootingStartLatitudePanel() {
        $objectMap.put("gearShootingStartLatitudePanel", gearShootingStartLatitudePanel = new JPanel());
        
        gearShootingStartLatitudePanel.setName("gearShootingStartLatitudePanel");
        gearShootingStartLatitudePanel.setLayout(gearShootingStartLatitudeLayout);
        gearShootingStartLatitudePanel.setToolTipText(t("tutti.editFishingOperation.field.gearShootingStartLatitude.tip"));
        gearShootingStartLatitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStartLatitude.help");
    }

    protected void createGearShootingStartLongitudeDDField() {
        $objectMap.put("gearShootingStartLongitudeDDField", gearShootingStartLongitudeDDField = new NumberEditor(this));
        
        gearShootingStartLongitudeDDField.setName("gearShootingStartLongitudeDDField");
        gearShootingStartLongitudeDDField.setUseSign(true);
        gearShootingStartLongitudeDDField.setProperty("gearShootingStartLongitude");
        gearShootingStartLongitudeDDField.setUseFloat(true);
        gearShootingStartLongitudeDDField.setShowReset(false);
        gearShootingStartLongitudeDDField.setToolTipText(t("tutti.editFishingOperation.field.gearShootingStartLongitude.tip"));
        gearShootingStartLongitudeDDField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingStartLongitude"));
        gearShootingStartLongitudeDDField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLongitudeDMDField() {
        $objectMap.put("gearShootingStartLongitudeDMDField", gearShootingStartLongitudeDMDField = new DmdCoordinateEditor());
        
        gearShootingStartLongitudeDMDField.setName("gearShootingStartLongitudeDMDField");
        gearShootingStartLongitudeDMDField.setPropertyDegree("gearShootingStartLongitudeDmdDegree");
        gearShootingStartLongitudeDMDField.setPropertyMinute("gearShootingStartLongitudeDmdMinute");
        gearShootingStartLongitudeDMDField.setShowReset(true);
        gearShootingStartLongitudeDMDField.setPropertySign("gearShootingStartLongitudeDmdSign");
        gearShootingStartLongitudeDMDField.setPropertyDecimal("gearShootingStartLongitudeDmdDecimal");
        gearShootingStartLongitudeDMDField.putClientProperty("longitudeEditor", true);
        gearShootingStartLongitudeDMDField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingStartLongitude"));
    }

    protected void createGearShootingStartLongitudeDMSField() {
        $objectMap.put("gearShootingStartLongitudeDMSField", gearShootingStartLongitudeDMSField = new DmsCoordinateEditor());
        
        gearShootingStartLongitudeDMSField.setName("gearShootingStartLongitudeDMSField");
        gearShootingStartLongitudeDMSField.setPropertySecond("gearShootingStartLongitudeDmsSecond");
        gearShootingStartLongitudeDMSField.setPropertyDegree("gearShootingStartLongitudeDmsDegree");
        gearShootingStartLongitudeDMSField.setPropertyMinute("gearShootingStartLongitudeDmsMinute");
        gearShootingStartLongitudeDMSField.setShowReset(true);
        gearShootingStartLongitudeDMSField.setPropertySign("gearShootingStartLongitudeDmsSign");
        gearShootingStartLongitudeDMSField.putClientProperty("longitudeEditor", true);
        gearShootingStartLongitudeDMSField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.gearShootingStartLongitude"));
    }

    protected void createGearShootingStartLongitudeLayout() {
        $objectMap.put("gearShootingStartLongitudeLayout", gearShootingStartLongitudeLayout = new CardLayout2Ext(this, "gearShootingStartLongitudePanel"));
    }

    protected void createGearShootingStartLongitudePanel() {
        $objectMap.put("gearShootingStartLongitudePanel", gearShootingStartLongitudePanel = new JPanel());
        
        gearShootingStartLongitudePanel.setName("gearShootingStartLongitudePanel");
        gearShootingStartLongitudePanel.setLayout(gearShootingStartLongitudeLayout);
        gearShootingStartLongitudePanel.setToolTipText(t("tutti.editFishingOperation.field.gearShootingStartLongitude.tip"));
        gearShootingStartLongitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStartLongitude.help");
    }

    protected void createGearShootingStartTimeField() {
        $objectMap.put("gearShootingStartTimeField", gearShootingStartTimeField = new SimpleTimeEditor(this));
        
        gearShootingStartTimeField.setName("gearShootingStartTimeField");
        gearShootingStartTimeField.setProperty("gearShootingStartTime");
        gearShootingStartTimeField.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStartTime.help");
        gearShootingStartTimeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearTimeLabel() {
        $objectMap.put("gearTimeLabel", gearTimeLabel = new JLabel());
        
        gearTimeLabel.setName("gearTimeLabel");
        gearTimeLabel.setText(t("tutti.editFishingOperation.field.gearTime"));
        gearTimeLabel.setToolTipText(t("tutti.editFishingOperation.field.gearTime.tip"));
        gearTimeLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearTime.help");
    }

    protected void createGearUseFeatureTab() {
        $objectMap.put("gearUseFeatureTab", gearUseFeatureTab = new TabInfo());
    }

    protected void createGearUseFeatureTabContent() {
        $objectMap.put("gearUseFeatureTabContent", gearUseFeatureTabContent = new GearUseFeatureTabUI(this));
        
        gearUseFeatureTabContent.setName("gearUseFeatureTabContent");
    }

    protected void createGearUseFeatureTabPane() {
        $objectMap.put("gearUseFeatureTabPane", gearUseFeatureTabPane = new JXTitledPanel());
        
        gearUseFeatureTabPane.setName("gearUseFeatureTabPane");
    }

    protected void createGeneralForm() {
        $objectMap.put("generalForm", generalForm = new Table());
        
        generalForm.setName("generalForm");
    }

    protected void createImportFromColumnFile() {
        $objectMap.put("importFromColumnFile", importFromColumnFile = new JButton());
        
        importFromColumnFile.setName("importFromColumnFile");
        importFromColumnFile.setText(t("tutti.editFishingOperation.action.importFromColumnFile"));
        importFromColumnFile.setToolTipText(t("tutti.editFishingOperation.action.importFromColumnFile.tip"));
        importFromColumnFile.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportFishingOperationCaracteristicsFromColumnFileAction.class);
        importFromColumnFile.putClientProperty("help", "tutti.editFishingOperation.action.importFromColumnFile.help");
    }

    protected void createLocationComboBox() {
        $objectMap.put("locationComboBox", locationComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        locationComboBox.setName("locationComboBox");
        locationComboBox.setProperty("location");
        locationComboBox.setShowReset(true);
        locationComboBox.putClientProperty("help", "tutti.editFishingOperation.field.location.help");
        locationComboBox.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.location"));
    }

    protected void createLocationLabel() {
        $objectMap.put("locationLabel", locationLabel = new JLabel());
        
        locationLabel.setName("locationLabel");
        locationLabel.setText(t("tutti.editFishingOperation.field.location"));
        locationLabel.setToolTipText(t("tutti.editFishingOperation.field.location.tip"));
        locationLabel.putClientProperty("help", "tutti.editFishingOperation.field.location.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditFishingOperationUIModel.class));
    }

    protected void createMultirigAggregationField() {
        $objectMap.put("multirigAggregationField", multirigAggregationField = new JTextField());
        
        multirigAggregationField.setName("multirigAggregationField");
        multirigAggregationField.setColumns(15);
        multirigAggregationField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__multirigAggregationField"));
        multirigAggregationField.putClientProperty("help", "tutti.editFishingOperation.field.multirigAggregation.help");
        multirigAggregationField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.multirigAggregation"));
    }

    protected void createMultirigAggregationLabel() {
        $objectMap.put("multirigAggregationLabel", multirigAggregationLabel = new JLabel());
        
        multirigAggregationLabel.setName("multirigAggregationLabel");
        multirigAggregationLabel.setText(t("tutti.editFishingOperation.field.multirigAggregation"));
        multirigAggregationLabel.setToolTipText(t("tutti.editFishingOperation.field.multirigAggregation.tip"));
        multirigAggregationLabel.putClientProperty("help", "tutti.editFishingOperation.field.multirigAggregation.help");
    }

    protected void createRecorderPersonList() {
        $objectMap.put("recorderPersonList", recorderPersonList = new BeanDoubleList<Person>());
        
        recorderPersonList.setName("recorderPersonList");
        recorderPersonList.setProperty("recorderPerson");
        recorderPersonList.setShowReset(true);
        recorderPersonList.setToolTipText(t("tutti.editFishingOperation.field.recorderPerson.tip"));
        recorderPersonList.putClientProperty("help", "tutti.editFishingOperation.field.recorderPerson.help");
        recorderPersonList.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.recorderPerson"));
    }

    protected void createResetValidStateButton() {
        $objectMap.put("resetValidStateButton", resetValidStateButton = new JButton());
        
        resetValidStateButton.setName("resetValidStateButton");
        resetValidStateButton.setText(t("tutti.editFishingOperation.action.resetFishingOperationValidState"));
        resetValidStateButton.setToolTipText(t("tutti.editFishingOperation.action.resetFishingOperationValidState.tip"));
        resetValidStateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetValidStateButton"));
        resetValidStateButton.putClientProperty("help", "tutti.editFishingOperation.action.resetFishingOperationValidState.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editFishingOperation.action.saveFishingOperation"));
        saveButton.setToolTipText(t("tutti.editFishingOperation.action.saveEditFishingOperation.tip"));
        saveButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SaveFishingOperationAction.class);
        saveButton.putClientProperty("help", "tutti.editFishingOperation.action.saveEditFishingOperation.help");
    }

    protected void createSecondaryVesselFilterPane() {
        $objectMap.put("secondaryVesselFilterPane", secondaryVesselFilterPane = new JPanel());
        
        secondaryVesselFilterPane.setName("secondaryVesselFilterPane");
        secondaryVesselFilterPane.putClientProperty("help", "tutti.editFishingOperation.filterSecondaryVesselType.help");
    }

    protected void createSecondaryVesselList() {
        $objectMap.put("secondaryVesselList", secondaryVesselList = new BeanDoubleList<Vessel>());
        
        secondaryVesselList.setName("secondaryVesselList");
        secondaryVesselList.setShowSelectPopupEnabled(false);
        secondaryVesselList.setUseMultiSelect(false);
        secondaryVesselList.setProperty("secondaryVessel");
        secondaryVesselList.setShowReset(true);
        secondaryVesselList.setToolTipText(t("tutti.editFishingOperation.field.secondaryVessel.tip"));
        secondaryVesselList.putClientProperty("help", "tutti.editFishingOperation.field.secondaryVessel.help");
        secondaryVesselList.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.secondaryVessel"));
    }

    protected void createStationNumberField() {
        $objectMap.put("stationNumberField", stationNumberField = new JTextField());
        
        stationNumberField.setName("stationNumberField");
        stationNumberField.setColumns(15);
        stationNumberField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__stationNumberField"));
        stationNumberField.putClientProperty("help", "tutti.editFishingOperation.field.stationNumber.help");
        stationNumberField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.stationNumber"));
        stationNumberField.putClientProperty("selectOnFocus", true);
    }

    protected void createStationNumberLabel() {
        $objectMap.put("stationNumberLabel", stationNumberLabel = new JLabel());
        
        stationNumberLabel.setName("stationNumberLabel");
        stationNumberLabel.setText(t("tutti.editFishingOperation.field.stationNumber"));
        stationNumberLabel.setToolTipText(t("tutti.editFishingOperation.field.stationNumber.tip"));
        stationNumberLabel.putClientProperty("help", "tutti.editFishingOperation.field.stationNumber.help");
    }

    protected void createStrataComboBox() {
        $objectMap.put("strataComboBox", strataComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        strataComboBox.setName("strataComboBox");
        strataComboBox.setProperty("strata");
        strataComboBox.setShowReset(true);
        strataComboBox.putClientProperty("help", "tutti.editFishingOperation.field.strata.help");
        strataComboBox.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.strata"));
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new JLabel());
        
        strataLabel.setName("strataLabel");
        strataLabel.setText(t("tutti.editFishingOperation.field.strata"));
        strataLabel.setToolTipText(t("tutti.editFishingOperation.field.strata.tip"));
        strataLabel.putClientProperty("help", "tutti.editFishingOperation.field.strata.help");
    }

    protected void createSubStrataComboBox() {
        $objectMap.put("subStrataComboBox", subStrataComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        subStrataComboBox.setName("subStrataComboBox");
        subStrataComboBox.setProperty("subStrata");
        subStrataComboBox.setShowReset(true);
        subStrataComboBox.putClientProperty("help", "tutti.editFishingOperation.field.subStrata.help");
        subStrataComboBox.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.subStrata"));
    }

    protected void createSubStrataLabel() {
        $objectMap.put("subStrataLabel", subStrataLabel = new JLabel());
        
        subStrataLabel.setName("subStrataLabel");
        subStrataLabel.setText(t("tutti.editFishingOperation.field.subStrata"));
        subStrataLabel.setToolTipText(t("tutti.editFishingOperation.field.subStrata.tip"));
        subStrataLabel.putClientProperty("help", "tutti.editFishingOperation.field.subStrata.help");
    }

    protected void createTraitGeneralTab() {
        $objectMap.put("traitGeneralTab", traitGeneralTab = new TabInfo());
    }

    protected void createTraitGeneralTabPane() {
        $objectMap.put("traitGeneralTabPane", traitGeneralTabPane = new JXTitledPanel());
        
        traitGeneralTabPane.setName("traitGeneralTabPane");
    }

    protected void createTraitGeneralTabPaneToolBar() {
        $objectMap.put("traitGeneralTabPaneToolBar", traitGeneralTabPaneToolBar = new JToolBar());
        
        traitGeneralTabPaneToolBar.setName("traitGeneralTabPaneToolBar");
        traitGeneralTabPaneToolBar.setFloatable(false);
        traitGeneralTabPaneToolBar.setOpaque(false);
        traitGeneralTabPaneToolBar.setBorderPainted(false);
    }

    protected void createTraitVesselPanel() {
        $objectMap.put("traitVesselPanel", traitVesselPanel = new Table());
        
        traitVesselPanel.setName("traitVesselPanel");
    }

    protected void createTrawlDistanceField() {
        $objectMap.put("trawlDistanceField", trawlDistanceField = new NumberEditor(this));
        
        trawlDistanceField.setName("trawlDistanceField");
        trawlDistanceField.setProperty("trawlDistance");
        trawlDistanceField.setUseFloat(false);
        trawlDistanceField.setShowReset(true);
        trawlDistanceField.putClientProperty("help", "tutti.editFishingOperation.field.trawlDistance.help");
        trawlDistanceField.putClientProperty("validatorLabel", t("tutti.editFishingOperation.field.trawlDistance"));
        trawlDistanceField.putClientProperty("selectOnFocus", true);
    }

    protected void createTrawlDistanceLabel() {
        $objectMap.put("trawlDistanceLabel", trawlDistanceLabel = new JLabel());
        
        trawlDistanceLabel.setName("trawlDistanceLabel");
        trawlDistanceLabel.setText(t("tutti.editFishingOperation.field.trawlDistance"));
        trawlDistanceLabel.setToolTipText(t("tutti.editFishingOperation.field.trawlDistance.tip"));
        trawlDistanceLabel.putClientProperty("help", "tutti.editFishingOperation.field.trawlDistance.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditFishingOperationUIModel.class, "validate"));
    }

    protected void createVesselField() {
        $objectMap.put("vesselField", vesselField = new JLabel());
        
        vesselField.setName("vesselField");
        vesselField.putClientProperty("help", "tutti.editFishingOperation.field.vessel.help");
        vesselField.putClientProperty("strongStyle", true);
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(t("tutti.editFishingOperation.field.vessel"));
        vesselLabel.setToolTipText(t("tutti.editFishingOperation.field.vessel.tip"));
        vesselLabel.putClientProperty("help", "tutti.editFishingOperation.field.vessel.help");
    }

    protected void createVesselUseFeatureTab() {
        $objectMap.put("vesselUseFeatureTab", vesselUseFeatureTab = new TabInfo());
    }

    protected void createVesselUseFeatureTabContent() {
        $objectMap.put("vesselUseFeatureTabContent", vesselUseFeatureTabContent = new VesselUseFeatureTabUI(this));
        
        vesselUseFeatureTabContent.setName("vesselUseFeatureTabContent");
    }

    protected void createVesselUseFeatureTabPane() {
        $objectMap.put("vesselUseFeatureTabPane", vesselUseFeatureTabPane = new JXTitledPanel());
        
        vesselUseFeatureTabPane.setName("vesselUseFeatureTabPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditFishingOperationTopPanel();
        addChildrenToValidator();
        addChildrenToTraitGeneralTabPaneToolBar();
        addChildrenToFishingOperationPane();
        addChildrenToFishingOperationTabPane();
        addChildrenToTraitGeneralTabPane();
        addChildrenToFishingOperationTabScrollPane();
        addChildrenToGeneralForm();
        // inline complete setup of $JPanel0
        $JPanel0.add(gearCaracteristicsTable, BorderLayout.CENTER);
        addChildrenToGearCaracteristicsTable();
        addChildrenToGearShootingStartLatitudePanel();
        addChildrenToGearShootingStartLongitudePanel();
        addChildrenToGearShootingEndLatitudePanel();
        addChildrenToGearShootingEndLongitudePanel();
        // inline complete setup of $JPanel2
        $JPanel2.add(trawlDistanceLabel, BorderLayout.WEST);
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(trawlDistanceField), BorderLayout.CENTER);
        // inline complete setup of $JPanel3
        $JPanel3.add(durationLabel, BorderLayout.WEST);
        $JPanel3.add(durationField, BorderLayout.CENTER);
        addChildrenToFishingOperationValidPanel();
        addChildrenToFishingOperationResetRadio();
        // inline complete setup of $HBox0
        $HBox0.add(fishingOperationValidRadio);
        $HBox0.add(fishingOperationInvalidRadio);
        addChildrenToFishingOperationValidRadio();
        addChildrenToFishingOperationInvalidRadio();
        // inline complete setup of $JPanel5
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(recorderPersonList));
        $JPanel5.add(traitVesselPanel);
        addChildrenToTraitVesselPanel();
        addChildrenToSecondaryVesselFilterPane();
        addChildrenToFilterSecondaryVesselAllButton();
        addChildrenToFilterSecondaryVesselScientificButton();
        addChildrenToFilterSecondaryVesselFishingButton();
        addChildrenToFilterSecondaryVesselOnlyCruiseButton();
        addChildrenToCommentPane();
        addChildrenToGearUseFeatureTabPane();
        addChildrenToVesselUseFeatureTabPane();
        // inline complete setup of $JPanel6
        $JPanel6.add(createFishingOperationActions, BorderLayout.CENTER);
        addChildrenToCreateFishingOperationActions();
        
        // apply 42 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 97 property setters
        strataComboBox.setBeanType(TuttiLocation.class);
        subStrataComboBox.setBeanType(TuttiLocation.class);
        locationComboBox.setBeanType(TuttiLocation.class);
        recorderPersonList.setBeanType(Person.class);
        gearComboBox.setBeanType(Gear.class);
        secondaryVesselList.setBeanType(Vessel.class);
        gearShootingStartLongitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingStartLatitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingEndLongitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingEndLatitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        importFromColumnFile.setIcon(SwingUtil.createActionIcon("import"));
        importFromColumnFile.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editFishingOperation.action.importFromColumnFile.mnemonic"),'Z'));
        traitGeneralTabPane.setRightDecoration(traitGeneralTabPaneToolBar);
        stationNumberLabel.setLabelFor(stationNumberField);
        fishingOperationNumberLabel.setLabelFor(fishingOperationNumberField);
        fishingOperationNumberField.setBean(model);
        fishingOperationNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        fishingOperationNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        multirigAggregationLabel.setLabelFor(multirigAggregationField);
        strataLabel.setLabelFor(strataComboBox);
        strataComboBox.setBean(model);
        subStrataLabel.setLabelFor(subStrataComboBox);
        subStrataComboBox.setBean(model);
        locationLabel.setLabelFor(locationComboBox);
        locationComboBox.setBean(model);
        gearLatitudeLabel.setText(t(handler.getGearLatitudeLabelText(handler.getConfig().getCoordinateEditorType())));
        gearLatitudeLabel.setIcon(SwingUtil.createActionIcon("coordinates"));
        gearLongitudeLabel.setText(t(handler.getGearLongitudeLabelText(handler.getConfig().getCoordinateEditorType())));
        gearLongitudeLabel.setIcon(SwingUtil.createActionIcon("coordinates"));
        gearDateLabel.setIcon(SwingUtil.createActionIcon("calendar"));
        gearTimeLabel.setIcon(SwingUtil.createActionIcon("time"));
        gearShootingStartLatitudeDDField.setBean(model);
        gearShootingStartLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSField.setShowResetTip(t("tutti.coordinate.action.reset.latitude.tip"));
        gearShootingStartLatitudeDMSField.setBean(model);
        gearShootingStartLatitudeDMDField.setShowResetTip(t("tutti.coordinate.action.reset.latitude.tip"));
        gearShootingStartLatitudeDMDField.setBean(model);
        gearShootingStartLongitudeDDField.setBean(model);
        gearShootingStartLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSField.setShowResetTip(t("tutti.coordinate.action.reset.longitude.tip"));
        gearShootingStartLongitudeDMSField.setBean(model);
        gearShootingStartLongitudeDMDField.setShowResetTip(t("tutti.coordinate.action.reset.longitude.tip"));
        gearShootingStartLongitudeDMDField.setBean(model);
        gearShootingStartTimeField.setBean(model);
        gearShootingEndLatitudeDDField.setBean(model);
        gearShootingEndLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSField.setShowResetTip(t("tutti.coordinate.action.reset.latitude.tip"));
        gearShootingEndLatitudeDMSField.setBean(model);
        gearShootingEndLatitudeDMDField.setShowResetTip(t("tutti.coordinate.action.reset.latitude.tip"));
        gearShootingEndLatitudeDMDField.setBean(model);
        gearShootingEndLongitudeDDField.setBean(model);
        gearShootingEndLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSField.setShowResetTip(t("tutti.coordinate.action.reset.longitude.tip"));
        gearShootingEndLongitudeDMSField.setBean(model);
        gearShootingEndLongitudeDMDField.setShowResetTip(t("tutti.coordinate.action.reset.longitude.tip"));
        gearShootingEndLongitudeDMDField.setBean(model);
        gearShootingEndTimeField.setBean(model);
        trawlDistanceLabel.setLabelFor(trawlDistanceField);
        trawlDistanceField.setBean(model);
        trawlDistanceField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        trawlDistanceField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        durationLabel.setLabelFor(durationField);
        resetValidStateButton.setIcon(SwingUtil.createActionIcon("reset"));
        resetValidStateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editFishingOperation.action.resetFishingOperationValidState.mnemonic"),'Z'));
        recorderPersonList.setBean(model);
        recorderPersonList.setBorder(BorderFactory.createTitledBorder(t("tutti.editFishingOperation.field.recorderPerson")));
        traitVesselPanel.setBorder(BorderFactory.createTitledBorder(t("tutti.editFishingOperation.pane.other")));
        vesselLabel.setLabelFor(vesselField);
        vesselLabel.setIcon(SwingUtil.createActionIcon("vessel"));
        gearLabel.setLabelFor(gearComboBox);
        gearLabel.setIcon(SwingUtil.createActionIcon("gear"));
        gearComboBox.setBean(model);
        filterSecondaryVesselLabel.setIcon(SwingUtil.createActionIcon("filter"));
        secondaryVesselList.setBean(model);
        secondaryVesselList.setBorder(BorderFactory.createTitledBorder(t("tutti.editFishingOperation.field.secondaryVessel")));
        commentPane.setBorder(BorderFactory.createTitledBorder(t("tutti.editFishingOperation.field.comment")));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editFishingOperation.action.cancelEditFishingOperation.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editFishingOperation.action.saveEditFishingOperation.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editFishingOperationTopPanel, "tutti.editFishingOperation.help");
        registerHelpId(_broker, importFromColumnFile, "tutti.editFishingOperation.action.importFromColumnFile.help");
        registerHelpId(_broker, fishingOperationAttachmentsButton, "tutti.editFishingOperation.action.attachments.help");
        registerHelpId(_broker, stationNumberLabel, "tutti.editFishingOperation.field.stationNumber.help");
        registerHelpId(_broker, stationNumberField, "tutti.editFishingOperation.field.stationNumber.help");
        registerHelpId(_broker, fishingOperationNumberLabel, "tutti.editFishingOperation.field.fishingOperationNumber.help");
        registerHelpId(_broker, fishingOperationNumberField, "tutti.editFishingOperation.field.fishingOperationNumber.help");
        registerHelpId(_broker, multirigAggregationLabel, "tutti.editFishingOperation.field.multirigAggregation.help");
        registerHelpId(_broker, multirigAggregationField, "tutti.editFishingOperation.field.multirigAggregation.help");
        registerHelpId(_broker, strataLabel, "tutti.editFishingOperation.field.strata.help");
        registerHelpId(_broker, strataComboBox, "tutti.editFishingOperation.field.strata.help");
        registerHelpId(_broker, subStrataLabel, "tutti.editFishingOperation.field.subStrata.help");
        registerHelpId(_broker, subStrataComboBox, "tutti.editFishingOperation.field.subStrata.help");
        registerHelpId(_broker, locationLabel, "tutti.editFishingOperation.field.location.help");
        registerHelpId(_broker, locationComboBox, "tutti.editFishingOperation.field.location.help");
        registerHelpId(_broker, gearLatitudeLabel, "tutti.editFishingOperation.field.gearLatitude.help");
        registerHelpId(_broker, gearLongitudeLabel, "tutti.editFishingOperation.field.gearLongitude.help");
        registerHelpId(_broker, gearDateLabel, "tutti.editFishingOperation.field.gearDate.help");
        registerHelpId(_broker, gearTimeLabel, "tutti.editFishingOperation.field.gearTime.help");
        registerHelpId(_broker, gearShootingStartLabel, "tutti.editFishingOperation.field.gearShootingStart.help");
        registerHelpId(_broker, gearShootingStartLatitudePanel, "tutti.editFishingOperation.field.gearShootingStartLatitude.help");
        registerHelpId(_broker, gearShootingStartLongitudePanel, "tutti.editFishingOperation.field.gearShootingStartLongitude.help");
        registerHelpId(_broker, gearShootingStartDateField, "tutti.editFishingOperation.field.gearShootingStartDate.help");
        registerHelpId(_broker, gearShootingStartTimeField, "tutti.editFishingOperation.field.gearShootingStartTime.help");
        registerHelpId(_broker, gearShootingEndLabel, "tutti.editFishingOperation.field.gearShootingEnd.help");
        registerHelpId(_broker, gearShootingEndLatitudePanel, "tutti.editFishingOperation.field.gearShootingEndLatitude.help");
        registerHelpId(_broker, gearShootingEndLongitudePanel, "tutti.editFishingOperation.field.gearShootingEndLongitude.help");
        registerHelpId(_broker, gearShootingEndDateField, "tutti.editFishingOperation.field.gearShootingEndDate.help");
        registerHelpId(_broker, gearShootingEndTimeField, "tutti.editFishingOperation.field.gearShootingEndTime.help");
        registerHelpId(_broker, fishingOperationRectiligneCheckBox, "tutti.editFishingOperation.field.fishingOperationRectiligne.help");
        registerHelpId(_broker, trawlDistanceLabel, "tutti.editFishingOperation.field.trawlDistance.help");
        registerHelpId(_broker, trawlDistanceField, "tutti.editFishingOperation.field.trawlDistance.help");
        registerHelpId(_broker, durationLabel, "tutti.editFishingOperation.field.duration.help");
        registerHelpId(_broker, durationField, "tutti.editFishingOperation.field.duration.help");
        registerHelpId(_broker, fishingOperationValidPanel, "tutti.editFishingOperation.field.fishingOperationValid.help");
        registerHelpId(_broker, resetValidStateButton, "tutti.editFishingOperation.action.resetFishingOperationValidState.help");
        registerHelpId(_broker, fishingOperationResetRadio, "tutti.editFishingOperation.field.fishingOperationValid.help");
        registerHelpId(_broker, fishingOperationValidRadio, "tutti.editFishingOperation.field.fishingOperationValid.help");
        registerHelpId(_broker, fishingOperationInvalidRadio, "tutti.editFishingOperation.field.fishingOperationValid.help");
        registerHelpId(_broker, recorderPersonList, "tutti.editFishingOperation.field.recorderPerson.help");
        registerHelpId(_broker, vesselLabel, "tutti.editFishingOperation.field.vessel.help");
        registerHelpId(_broker, vesselField, "tutti.editFishingOperation.field.vessel.help");
        registerHelpId(_broker, gearLabel, "tutti.editFishingOperation.field.gear.help");
        registerHelpId(_broker, gearComboBox, "tutti.editFishingOperation.field.gear.help");
        registerHelpId(_broker, secondaryVesselFilterPane, "tutti.editFishingOperation.filterSecondaryVesselType.help");
        registerHelpId(_broker, secondaryVesselList, "tutti.editFishingOperation.field.secondaryVessel.help");
        registerHelpId(_broker, commentPane, "tutti.editFishingOperation.field.comment.help");
        registerHelpId(_broker, cancelButton, "tutti.editFishingOperation.action.cancelEditFishingOperation.help");
        registerHelpId(_broker, saveButton, "tutti.editFishingOperation.action.saveEditFishingOperation.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editFishingOperationTopPanel", editFishingOperationTopPanel);
        createModel();
        createValidator();
        createGearShootingStartLongitudeLayout();
        createGearShootingStartLatitudeLayout();
        createGearShootingEndLongitudeLayout();
        createGearShootingEndLatitudeLayout();
        createBroker();
        createTraitGeneralTabPaneToolBar();
        createImportFromColumnFile();
        createFishingOperationAttachmentsButton();
        createFishingOperationPane();
        createFishingOperationTabPane();
        createTraitGeneralTabPane();
        createFishingOperationTabScrollPane();
        createGeneralForm();
        createStationNumberLabel();
        createStationNumberField();
        createFishingOperationNumberLabel();
        createFishingOperationNumberField();
        createMultirigAggregationLabel();
        createMultirigAggregationField();
        createStrataLabel();
        createStrataComboBox();
        createSubStrataLabel();
        createSubStrataComboBox();
        createLocationLabel();
        createLocationComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createGearCaracteristicsTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createGearLatitudeLabel();
        createGearLongitudeLabel();
        createGearDateLabel();
        createGearTimeLabel();
        createGearShootingStartLabel();
        createGearShootingStartLatitudePanel();
        createGearShootingStartLatitudeDDField();
        createGearShootingStartLatitudeDMSField();
        createGearShootingStartLatitudeDMDField();
        createGearShootingStartLongitudePanel();
        createGearShootingStartLongitudeDDField();
        createGearShootingStartLongitudeDMSField();
        createGearShootingStartLongitudeDMDField();
        createGearShootingStartDateField();
        createGearShootingStartTimeField();
        createGearShootingEndLabel();
        createGearShootingEndLatitudePanel();
        createGearShootingEndLatitudeDDField();
        createGearShootingEndLatitudeDMSField();
        createGearShootingEndLatitudeDMDField();
        createGearShootingEndLongitudePanel();
        createGearShootingEndLongitudeDDField();
        createGearShootingEndLongitudeDMSField();
        createGearShootingEndLongitudeDMDField();
        createGearShootingEndDateField();
        createGearShootingEndTimeField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createFishingOperationRectiligneCheckBox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createTrawlDistanceLabel();
        createTrawlDistanceField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new BorderLayout());
        createDurationLabel();
        createDurationField();
        createFishingOperationValidPanel();
        createResetValidStateButton();
        createFishingOperationResetRadio();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        createFishingOperationValidRadio();
        createFishingOperationInvalidRadio();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new GridLayout(1,0));
        createRecorderPersonList();
        createTraitVesselPanel();
        createVesselLabel();
        createVesselField();
        createGearLabel();
        createGearComboBox();
        createSecondaryVesselFilterPane();
        createFilterSecondaryVesselLabel();
        createFilterSecondaryVesselAllButton();
        createFilterSecondaryVesselScientificButton();
        createFilterSecondaryVesselFishingButton();
        createFilterSecondaryVesselOnlyCruiseButton();
        createSecondaryVesselList();
        createCommentPane();
        createCommentField();
        createGearUseFeatureTabPane();
        createGearUseFeatureTabContent();
        createVesselUseFeatureTabPane();
        createVesselUseFeatureTabContent();
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new JPanel());
        
        $JPanel6.setName("$JPanel6");
        $JPanel6.setLayout(new BorderLayout());
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createTraitGeneralTab();
        createGearUseFeatureTab();
        createVesselUseFeatureTab();
        createFishingOperationValid();
        createFilterSecondaryVesselType();
        // inline creation of editFishingOperationTopPanel
        setName("editFishingOperationTopPanel");
        setLayout(new BorderLayout());
        editFishingOperationTopPanel.putClientProperty("help", "tutti.editFishingOperation.help");
        
        // registers 42 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 42 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_FROM_COLUMN_FILE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importFromColumnFileEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importFromColumnFile.setEnabled(model.isImportFromColumnFileEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importFromColumnFileEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationAttachmentsButton.setEnabled(model.getId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATION_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(stationNumberField, model.getStationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stationNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationNumberField.setModel(model.getFishingOperationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                fishingOperationNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MULTIRIG_AGGREGATION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("multirigAggregation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(multirigAggregationField, model.getMultirigAggregation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("multirigAggregation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("strata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    strataComboBox.setSelectedItem(model.getStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("strata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subStrata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subStrataComboBox.setSelectedItem(model.getSubStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subStrata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("location", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    locationComboBox.setSelectedItem(model.getLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("location", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDDField.setModel(model.getGearShootingStartLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSFIELD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSField.setValue(model.getGearShootingStartLatitudeDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDms", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDFIELD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMDField.setValue(model.getGearShootingStartLatitudeDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDmd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDDField.setModel(model.getGearShootingStartLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSFIELD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSField.setValue(model.getGearShootingStartLongitudeDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDms", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDFIELD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMDField.setValue(model.getGearShootingStartLongitudeDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDmd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartDateField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartTimeField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDDField.setModel(model.getGearShootingEndLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSFIELD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSField.setValue(model.getGearShootingEndLatitudeDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDms", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDFIELD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMDField.setValue(model.getGearShootingEndLatitudeDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDmd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDDField.setModel(model.getGearShootingEndLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSFIELD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSField.setValue(model.getGearShootingEndLongitudeDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDms", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDFIELD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMDField.setValue(model.getGearShootingEndLongitudeDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDmd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndDateField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndTimeField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationRectiligneCheckBox.setSelected(model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setEnabled(!model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("trawlDistance", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setModel(model.getTrawlDistance());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("trawlDistance", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TRAWL_DISTANCE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                trawlDistanceField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("trawlDistance", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setToolTipText(t(handler.getTrawlDistanceTooltipText(model.getTrawlDistance())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("trawlDistance", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DURATION_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(durationField, handler.getDuration(model.getGearShootingStartDate(), model.getGearShootingEndDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationResetRadio.setSelected(model.getFishingOperationValid() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationValidRadio.setSelected(model.getFishingOperationValid() == Boolean.TRUE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationInvalidRadio.setSelected(model.getFishingOperationValid() == Boolean.FALSE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VESSEL_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vessel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    vesselField.setText(t(handler.decorateVessel(model.getVessel())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vessel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gear", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearComboBox.setSelectedItem(model.getGear());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gear", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SECONDARY_VESSEL_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("secondaryVesselTypeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSecondaryVesselAllButton.setSelected(model.isSecondaryVesselTypeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("secondaryVesselTypeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SECONDARY_VESSEL_SCIENTIFIC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("secondaryVesselTypeScientific", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSecondaryVesselScientificButton.setSelected(model.isSecondaryVesselTypeScientific());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("secondaryVesselTypeScientific", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SECONDARY_VESSEL_FISHING_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("secondaryVesselTypeFishing", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSecondaryVesselFishingButton.setSelected(model.isSecondaryVesselTypeFishing());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("secondaryVesselTypeFishing", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SECONDARY_VESSEL_ONLY_CRUISE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("secondaryVesselTypeOnlyCruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSecondaryVesselOnlyCruiseButton.setSelected(model.isSecondaryVesselTypeOnlyCruise());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("secondaryVesselTypeOnlyCruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid() && model.isModify());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
            }
        });
    }

}