/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveIndividualObservationBatchAction
extends AbstractTuttiAction<IndividualObservationBatchUIModel, IndividualObservationBatchUI, IndividualObservationBatchUIHandler> {
    private static final Log log = LogFactory.getLog(RemoveIndividualObservationBatchAction.class);
    int rowIndex;

    public RemoveIndividualObservationBatchAction(IndividualObservationBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), I18n._((String)"tutti.editIndividualObservationBatch.action.removeBatch.confirm.message", (Object[])new Object[0]), I18n._((String)"tutti.editIndividualObservationBatch.action.removeBatch.confirm.title", (Object[])new Object[0]), 0);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        boolean persisted;
        JXTable table = ((IndividualObservationBatchUIHandler)this.handler).getTable();
        this.rowIndex = table.getSelectedRow();
        Preconditions.checkState((this.rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove batch if none is selected");
        IndividualObservationBatchTableModel tableModel = ((IndividualObservationBatchUIHandler)this.handler).getTableModel();
        IndividualObservationBatchRowModel selectedBatch = (IndividualObservationBatchRowModel)tableModel.getEntry(this.rowIndex);
        boolean bl = persisted = !TuttiEntities.isNew((TuttiEntity)selectedBatch);
        if (persisted) {
            String id = selectedBatch.getId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Remove individual observation with id: " + id));
            }
            PersistenceService persistenceService = this.getContext().getPersistenceService();
            persistenceService.deleteIndividualObservationBatch(id);
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((IndividualObservationBatchUIHandler)this.handler).getTable();
        IndividualObservationBatchTableModel tableModel = ((IndividualObservationBatchUIHandler)this.handler).getTableModel();
        tableModel.removeRow(this.rowIndex);
        TuttiUIUtil.selectFirstCellOnFirstRowAndStopEditing((JXTable)table);
    }
}

