/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.concurrency;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.constructs.nonstop.ClusterOperation;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;

public class NonStopCacheKeySet
extends AbstractList {
    private final NonstopStore nonstopStore;
    private final NonstopActiveDelegateHolder nonstopActiveDelegateHolder;
    private final List keys;

    public NonStopCacheKeySet(NonstopActiveDelegateHolder nonstopActiveDelegateHolder, List keys) {
        this.nonstopStore = nonstopActiveDelegateHolder.getNonstopStore();
        this.nonstopActiveDelegateHolder = nonstopActiveDelegateHolder;
        this.keys = keys;
    }

    @Override
    public Iterator iterator() {
        return new NonStopCacheKeySetIterator(this.nonstopStore, this.keys);
    }

    @Override
    public int size() {
        return this.nonstopStore.executeClusterOperation(new ClusterOperation<Integer>(){

            @Override
            public Integer performClusterOperation() throws Exception {
                return NonStopCacheKeySet.this.keys.size();
            }

            @Override
            public Integer performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                switch (configuredTimeoutBehavior) {
                    case LOCAL_READS: {
                        return NonStopCacheKeySet.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getLocalKeys().size();
                    }
                    case NOOP: {
                        return 0;
                    }
                    case EXCEPTION: {
                        throw new NonStopCacheException("keySet.size() timed out");
                    }
                }
                throw new AssertionError((Object)"configuredTimeoutBehavior of unknown type");
            }
        });
    }

    @Override
    public Object get(int index) {
        throw new UnsupportedOperationException();
    }

    private static class NonStopCacheKeySetIterator
    implements Iterator {
        private final NonstopStore nonstopStore;
        private final Iterator iterator;

        public NonStopCacheKeySetIterator(NonstopStore nonstopStore, final List keys) {
            this.nonstopStore = nonstopStore;
            this.iterator = this.nonstopStore.executeClusterOperation(new ClusterOperation<Iterator>(){

                @Override
                public Iterator performClusterOperation() throws Exception {
                    return keys.iterator();
                }

                @Override
                public Iterator performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                    throw new NonStopCacheException("keySet timed out");
                }
            });
        }

        @Override
        public boolean hasNext() {
            return this.nonstopStore.executeClusterOperation(new ClusterOperation<Boolean>(){

                @Override
                public Boolean performClusterOperation() throws Exception {
                    return NonStopCacheKeySetIterator.this.iterator.hasNext();
                }

                @Override
                public Boolean performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                    throw new NonStopCacheException("hasNext on keySet timed out");
                }
            });
        }

        public Object next() {
            return this.nonstopStore.executeClusterOperation(new ClusterOperation<Object>(){

                @Override
                public Object performClusterOperation() throws Exception {
                    return NonStopCacheKeySetIterator.this.iterator.next();
                }

                @Override
                public Object performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                    throw new NonStopCacheException("next on keySet timed out");
                }
            });
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

