/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.ui.swing.action.AbstractImportMultiPostAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.MultiPostImportLogDialog;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import java.awt.Dialog;
import java.util.Collection;
import java.util.Map;
import javax.swing.JTextArea;
import org.nuiton.i18n.I18n;

public class ImportSpeciesMultiPostAction
extends AbstractImportMultiPostAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected Map<String, Object> notImportedData;

    public ImportSpeciesMultiPostAction(SpeciesBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiSpecies";
    }

    @Override
    protected String getFileExtensionDescription() {
        return I18n._((String)"tutti.common.file.tuttiSpecies", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserTitle() {
        return I18n._((String)"tutti.editSpeciesBatch.action.importMultiPost.sourceFile.title", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserButton() {
        return I18n._((String)"tutti.editSpeciesBatch.action.importMultiPost.sourceFile.button", (Object[])new Object[0]);
    }

    @Override
    public void releaseAction() {
        this.notImportedData = null;
        super.releaseAction();
    }

    @Override
    protected void importBatches(FishingOperation operation) {
        this.notImportedData = this.multiPostImportExportService.importSpecies(this.file, operation);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (!this.notImportedData.isEmpty()) {
            Float livingNotItemizedWeight;
            Float inertWeight;
            MultiPostImportLogDialog dialog = new MultiPostImportLogDialog((Dialog)this.getContext().getActionUI());
            Collection notImportedSpeciesBatches = (Collection)this.notImportedData.get("batchesKey");
            StringBuffer stringBuffer = new StringBuffer();
            Float totalSortedWeight = (Float)this.notImportedData.get("speciesTotalSortedWeight");
            if (totalSortedWeight != null) {
                stringBuffer.append("- " + I18n._((String)"tutti.multiPostImportLog.totalSortedWeight", (Object[])new Object[]{totalSortedWeight}) + "\n");
            }
            if ((inertWeight = (Float)this.notImportedData.get("speciesTotalInertWeight")) != null) {
                stringBuffer.append("- " + I18n._((String)"tutti.multiPostImportLog.inertWeight", (Object[])new Object[]{inertWeight}) + "\n");
            }
            if ((livingNotItemizedWeight = (Float)this.notImportedData.get("speciesTotalLivingNotItemizedWeight")) != null) {
                stringBuffer.append("- " + I18n._((String)"tutti.multiPostImportLog.livingNotItemizedWeight", (Object[])new Object[]{livingNotItemizedWeight}) + "\n");
            }
            for (SpeciesBatch sb : notImportedSpeciesBatches) {
                stringBuffer.append("- " + this.decorate(sb.getSpecies()) + " / " + this.decorate(sb.getSampleCategoryValue()) + "\n");
            }
            if (stringBuffer.length() > 0) {
                JTextArea batchList = dialog.getBatchList();
                batchList.setText(stringBuffer.toString());
                dialog.setSize(400, 300);
                dialog.setLocationRelativeTo(this.getContext().getMainUI());
                dialog.setVisible(true);
            }
        }
        this.sendMessage(I18n._((String)"tutti.editSpeciesBatch.action.importMultiPost.success", (Object[])new Object[]{this.file}));
    }
}

