/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.technical.synchro;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroDatabaseMetadata;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroResult;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroService;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTable;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTableMetadata;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTableTool;
import fr.ifremer.adagio.core.service.technical.synchro.specific.ReferentialSynchroSpecificTableTask;
import fr.ifremer.tutti.persistence.ProgressionModel;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.nuiton.i18n.I18n;
import org.nuiton.util.TimeLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Service;

@Service(value="referentialSynchroService")
public class ReferentialSynchroServiceImpl
implements ReferentialSynchroService {
    private static final Log log = LogFactory.getLog(ReferentialSynchroServiceImpl.class);
    private static final TimeLog TIME = new TimeLog(ReferentialSynchroServiceImpl.class);
    @Autowired
    protected DriverManagerDataSource dataSource;
    @Autowired
    protected SessionFactory sessionFactory;
    protected Dialect localDialect;
    protected Properties dbconnexionProperties;
    protected EnumMap<ReferentialSynchroTable, ReferentialSynchroSpecificTableTask> extraTasks;

    @Override
    public Properties getLocalConnectionProperties() {
        if (this.dbconnexionProperties == null) {
            this.dbconnexionProperties = new Properties();
            this.dbconnexionProperties.put("hibernate.connection.url", this.dataSource.getUrl());
            this.dbconnexionProperties.put("hibernate.connection.username", this.dataSource.getUsername());
            this.dbconnexionProperties.put("hibernate.connection.password", this.dataSource.getPassword());
        }
        return this.dbconnexionProperties;
    }

    @Override
    public Dialect getLocalDialect() {
        if (this.localDialect == null) {
            this.localDialect = ((SessionFactoryImplementor)this.sessionFactory).getSettings().getDialect();
        }
        return this.localDialect;
    }

    public EnumMap<ReferentialSynchroTable, ReferentialSynchroSpecificTableTask> getExtraTasks() {
        if (this.extraTasks == null) {
            this.extraTasks = Maps.newEnumMap(ReferentialSynchroTable.class);
            ServiceLoader<ReferentialSynchroSpecificTableTask> loader = ServiceLoader.load(ReferentialSynchroSpecificTableTask.class);
            for (ReferentialSynchroSpecificTableTask task : loader) {
                this.extraTasks.put(task.getTable(), task);
            }
        }
        return this.extraTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(Properties remoteConnectionProperties, ReferentialSynchroResult result) {
        Connection remoteConnection;
        Connection localConnection;
        block12: {
            Preconditions.checkNotNull((Object)result);
            Preconditions.checkNotNull((Object)remoteConnectionProperties);
            result.setLocalUrl(this.getUrl(this.getLocalConnectionProperties()));
            result.setRemoteUrl(this.getUrl(remoteConnectionProperties));
            this.dbconnexionProperties = null;
            this.localDialect = null;
            this.extraTasks = null;
            localConnection = null;
            remoteConnection = null;
            try {
                ProgressionModel progressionModel = result.getProgressionModel();
                progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.prepare.step1", (Object[])new Object[0]));
                localConnection = this.createConnection(this.getLocalConnectionProperties());
                progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.prepare.step2", (Object[])new Object[0]));
                remoteConnection = this.createConnection(remoteConnectionProperties);
                ReferentialSynchroDatabaseMetadata localMeta = ReferentialSynchroDatabaseMetadata.loadDatabaseMetadata(localConnection, this.getLocalDialect());
                ReferentialSynchroDatabaseMetadata remoteMeta = ReferentialSynchroDatabaseMetadata.loadDatabaseMetadata(remoteConnection, this.getLocalDialect());
                progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.prepare.step3", (Object[])new Object[0]));
                try {
                    this.checkSchemas(localMeta, remoteMeta);
                }
                catch (DataRetrievalFailureException e) {
                    result.setError((Exception)((Object)e));
                }
                if (!result.isSuccess()) break block12;
                for (ReferentialSynchroTable tuttiTable : ReferentialSynchroTable.values()) {
                    long t0 = TimeLog.getTime();
                    String tableName = tuttiTable.name();
                    progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.prepare.step4", (Object[])new Object[]{tableName}));
                    ReferentialSynchroTableMetadata table = remoteMeta.getTable(tableName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Prepare table: " + tableName));
                    }
                    this.prepareTable(table, localConnection, remoteConnection, result);
                    TIME.log(t0, "prepare table " + tableName);
                }
                long totalRows = result.getTotalRows();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Total rows to update: " + totalRows));
                }
                localConnection.rollback();
            }
            catch (SQLException e) {
                try {
                    try {
                        if (localConnection != null) {
                            localConnection.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    result.setError(e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeConnection(remoteConnection);
                    JdbcUtils.closeConnection(localConnection);
                    throw throwable;
                }
                JdbcUtils.closeConnection(remoteConnection);
                JdbcUtils.closeConnection((Connection)localConnection);
            }
        }
        JdbcUtils.closeConnection((Connection)remoteConnection);
        JdbcUtils.closeConnection((Connection)localConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(Properties remoteConnectionProperties, ReferentialSynchroResult result) {
        Preconditions.checkNotNull((Object)result);
        Preconditions.checkNotNull((Object)remoteConnectionProperties);
        Connection localConnection = null;
        Connection remoteConnection = null;
        try {
            localConnection = this.createConnection(this.getLocalConnectionProperties());
            remoteConnection = this.createConnection(remoteConnectionProperties);
            ReferentialSynchroDatabaseMetadata dbMetas = ReferentialSynchroDatabaseMetadata.loadDatabaseMetadata(remoteConnection, this.getLocalDialect());
            ProgressionModel progressionModel = result.getProgressionModel();
            progressionModel.setTotal(result.getTotalRows());
            this.prepareSynch(localConnection);
            try {
                for (ReferentialSynchroTable tuttiTable : ReferentialSynchroTable.values()) {
                    long countToUpdate;
                    long t0 = TimeLog.getTime();
                    String tableName = tuttiTable.name();
                    progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.synchronize.step1", (Object[])new Object[]{tableName}));
                    ReferentialSynchroTableMetadata table = dbMetas.getTable(tableName);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Synchronize table: " + tableName));
                    }
                    if ((countToUpdate = (long)result.getNbRows(tableName)) > 0L) {
                        ReferentialSynchroSpecificTableTask extraTask = this.getExtraTasks().get((Object)tuttiTable);
                        this.synchronizeTable(dbMetas, table, localConnection, remoteConnection, extraTask, result);
                    }
                    TIME.log(t0, "synchronize table " + tableName);
                }
                if (log.isInfoEnabled()) {
                    long totalInserts = result.getTotalInserts();
                    long totalUpdates = result.getTotalUpdates();
                    log.info((Object)("Total rows to treat: " + result.getTotalRows()));
                    log.info((Object)("Total rows inserted: " + totalInserts));
                    log.info((Object)("Total rows  updated: " + totalUpdates));
                    log.info((Object)("Total rows  treated: " + (totalInserts + totalUpdates)));
                }
            }
            finally {
                this.releaseSynch(localConnection);
            }
            progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.synchronize.step2", (Object[])new Object[0]));
            localConnection.commit();
        }
        catch (SQLException e) {
            try {
                try {
                    if (localConnection != null) {
                        localConnection.rollback();
                    }
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                result.setError(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeConnection(remoteConnection);
                JdbcUtils.closeConnection((Connection)localConnection);
                throw throwable;
            }
            JdbcUtils.closeConnection((Connection)remoteConnection);
            JdbcUtils.closeConnection((Connection)localConnection);
        }
        JdbcUtils.closeConnection((Connection)remoteConnection);
        JdbcUtils.closeConnection((Connection)localConnection);
    }

    protected void checkSchemas(ReferentialSynchroDatabaseMetadata schema1, ReferentialSynchroDatabaseMetadata schema2) {
        Set<String> externalSchemaTableNames;
        Set<String> internalSchemaTableNames = schema1.getTableNames();
        if (!internalSchemaTableNames.equals(externalSchemaTableNames = schema2.getTableNames())) {
            throw new DataRetrievalFailureException("Incompatible schemas");
        }
        for (String tableName : internalSchemaTableNames) {
            Set<String> externalColumnNames;
            ReferentialSynchroTableMetadata internalTable = schema1.getTable(tableName);
            ReferentialSynchroTableMetadata externalTable = schema2.getTable(tableName);
            Set<String> internalColumnNames = internalTable.getColumnNames();
            if (!internalColumnNames.equals(externalColumnNames = externalTable.getColumnNames())) {
                throw new DataRetrievalFailureException("Incompatible schema of table: " + tableName);
            }
            for (String columnName : internalColumnNames) {
                String externalColumnTypeName;
                ColumnMetadata internalColumn = internalTable.getColumnMetadata(columnName);
                ColumnMetadata externalColumn = externalTable.getColumnMetadata(columnName);
                String internalColumnTypeName = internalColumn.getTypeName();
                if (internalColumnTypeName.equals(externalColumnTypeName = externalColumn.getTypeName())) continue;
                throw new DataRetrievalFailureException("Incompatible column type of table / column: " + tableName + " / " + columnName);
            }
        }
    }

    protected void prepareTable(ReferentialSynchroTableMetadata table, Connection localConnection, Connection remoteConnection, ReferentialSynchroResult result) throws SQLException {
        String tablePrefix = table.getTableLogPrefix();
        String tableName = table.getName();
        ReferentialSynchroTableTool localDao = new ReferentialSynchroTableTool(localConnection, table);
        long localCount = localDao.count();
        Timestamp updateDate = null;
        if (localCount < 50000L && (updateDate = localDao.getLastUpdateDate()) != null) {
            updateDate = new Timestamp(DateUtils.setMilliseconds((Date)updateDate, (int)0).getTime());
            updateDate = new Timestamp(DateUtils.addSeconds((Date)updateDate, (int)1).getTime());
        }
        ReferentialSynchroTableTool remoteDao = new ReferentialSynchroTableTool(remoteConnection, table);
        long countToUpdate = remoteDao.countDataToUpdate(updateDate);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s nb rows to update: %s", tablePrefix, countToUpdate));
        }
        result.setUpdateDate(tableName, updateDate);
        result.addRows(tableName, (int)countToUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeTable(ReferentialSynchroDatabaseMetadata dbMetas, ReferentialSynchroTableMetadata table, Connection localConnection, Connection remoteConnection, ReferentialSynchroSpecificTableTask extraTask, ReferentialSynchroResult result) throws SQLException {
        String tableName = table.getName();
        result.getProgressionModel().setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.synchronizeTable", (Object[])new Object[]{tableName}));
        String tablePrefix = table.getTableLogPrefix();
        if (extraTask != null && log.isInfoEnabled()) {
            log.info((Object)(tablePrefix + " Will use specific task: " + extraTask));
        }
        ReferentialSynchroTableTool localDao = new ReferentialSynchroTableTool(localConnection, table);
        ReferentialSynchroTableTool remoteDao = new ReferentialSynchroTableTool(remoteConnection, table);
        Timestamp updateDate = result.getUpdateDate(tableName);
        long count = localDao.count();
        Set<String> existingIds = localDao.getExistingPrimaryKeys();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " existingIds: " + existingIds.size()));
        }
        boolean bigTable = count > 50000L;
        ResultSet dataToUpdate = remoteDao.getDataToUpdate(bigTable ? null : updateDate);
        try {
            if (bigTable) {
                this.updateBigTable(dbMetas, localDao, remoteDao, dataToUpdate, extraTask, result);
            } else {
                this.updateTable(localDao, dataToUpdate, result);
            }
            dataToUpdate.close();
        }
        finally {
            Closeables.closeQuietly((Closeable)localDao);
            Closeables.closeQuietly((Closeable)remoteDao);
            JdbcUtils.closeResultSet((ResultSet)dataToUpdate);
        }
    }

    protected void updateTable(ReferentialSynchroTableTool localDao, ResultSet incomingData, ReferentialSynchroResult result) throws SQLException {
        ReferentialSynchroTableMetadata table = localDao.getTable();
        Set<String> existingIds = localDao.getExistingPrimaryKeys();
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        result.addTableName(tableName);
        int countR = 0;
        while (incomingData.next()) {
            List<Object> pk = table.getPk(incomingData);
            String pkStr = table.toPkStr(pk);
            boolean doUpdate = existingIds.contains(pkStr);
            if (doUpdate) {
                localDao.executeUpdate(pk, incomingData);
            } else {
                localDao.executeInsert(pk, incomingData);
            }
            this.reportProgress(result, localDao, ++countR, tablePrefix);
        }
        localDao.flushQueries();
        int insertCount = localDao.getInsertCount();
        int updateCount = localDao.getUpdateCount();
        result.addInserts(tableName, insertCount);
        result.addUpdates(tableName, updateCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (inserts: %s, updates: %s)", tablePrefix, countR, insertCount, updateCount));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s INSERT count: %s", tablePrefix, result.getNbInserts(tableName)));
            log.debug((Object)String.format("%s UPDATE count: %s", tablePrefix, result.getNbUpdates(tableName)));
        }
        result.getProgressionModel().increments(countR % 1000);
    }

    protected void updateBigTable(ReferentialSynchroDatabaseMetadata dbMetas, ReferentialSynchroTableTool localDao, ReferentialSynchroTableTool remoteDao, ResultSet incomingData, ReferentialSynchroSpecificTableTask extraTask, ReferentialSynchroResult result) throws SQLException {
        ReferentialSynchroTableMetadata table = localDao.getTable();
        String tableName = localDao.table.getName();
        result.addTableName(tableName);
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        Set<String> existingIds = localDao.getExistingPrimaryKeys();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " local existingIds: " + existingIds.size()));
        }
        Set<String> remoteExistingIds = remoteDao.getExistingPrimaryKeys();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " remote existingIds: " + existingIds.size()));
        }
        existingIds.removeAll(remoteExistingIds);
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " local data existingIds not in remote: " + existingIds.size()));
        }
        if (log.isTraceEnabled()) {
            for (String existingId : existingIds) {
                log.trace((Object)("- " + existingId));
            }
        }
        Map<Object, Object> extraRows = Maps.newLinkedHashMap();
        for (String pkStr : existingIds) {
            List<Object> pk = table.fromPkStr(pkStr);
            Object[] extraRow = localDao.findByPk(pk);
            extraRows.put(pk, extraRow);
        }
        if (extraTask != null) {
            extraRows = extraTask.transformExtraLocalData(dbMetas, localDao, remoteDao, (Map<List<Object>, Object[]>)extraRows);
            if (log.isDebugEnabled()) {
                log.debug((Object)(tablePrefix + " local data existingIds not in remote (after apply task): " + extraRows.size()));
            }
        }
        localDao.deleteAll();
        int countR = 0;
        while (incomingData.next()) {
            List<Object> pk = table.getPk(incomingData);
            localDao.executeInsert(pk, incomingData);
            this.reportProgress(result, localDao, ++countR, tablePrefix);
        }
        for (Map.Entry<Object, Object> entry : extraRows.entrySet()) {
            List pk = (List)entry.getKey();
            Object[] row = (Object[])entry.getValue();
            localDao.executeInsert((List<Object>)pk, row);
            this.reportProgress(result, localDao, ++countR, tablePrefix);
        }
        localDao.flushQueries();
        int insertCount = localDao.getInsertCount();
        result.addInserts(tableName, insertCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (inserts: %s)", tablePrefix, countR, insertCount));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s INSERT count: %s", tablePrefix, result.getNbInserts(tableName)));
        }
        result.getProgressionModel().increments(countR % 1000);
    }

    protected void reportProgress(ReferentialSynchroResult result, ReferentialSynchroTableTool dao, int countR, String tablePrefix) {
        if (countR % 1000 == 0) {
            result.getProgressionModel().increments(1000);
        }
        if (countR % 10000 == 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("%s Done: %s (inserts: %s, updates: %s)", tablePrefix, countR, dao.getInsertCount(), dao.getUpdateCount()));
        }
    }

    Connection createConnection(Properties connectionProperties) throws SQLException {
        return this.createConnection(connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    String getUrl(Properties connectionProperties) {
        return connectionProperties.getProperty("hibernate.connection.url");
    }

    Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    void prepareSynch(Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("SET REFERENTIAL_INTEGRITY FALSE;");
        statement.executeUpdate();
    }

    void releaseSynch(Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("SET REFERENTIAL_INTEGRITY TRUE;");
        statement.executeUpdate();
    }
}

