/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatchs;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.AbstractCaracteristicTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.GearUseFeatureTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.VesselUseFeatureTabUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaveFishingOperationAction
extends AbstractTuttiAction<EditFishingOperationUIModel, EditFishingOperationUI, EditFishingOperationUIHandler> {
    private static final Log log = LogFactory.getLog(SaveFishingOperationAction.class);
    protected boolean updateUI;

    public SaveFishingOperationAction(EditFishingOperationUIHandler handler) {
        super(handler, true);
    }

    public void setUpdateUI(boolean updateUI) {
        this.updateUI = updateUI;
    }

    public void releaseAction() {
        this.updateUI = true;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        boolean mustSave;
        TuttiBeanMonitor<EditFishingOperationUIModel> monitor = ((EditFishingOperationUIHandler)this.handler).getFishingOperationMonitor();
        EditFishingOperationUIModel beanToSave = monitor.getBean();
        boolean bl = mustSave = beanToSave.getFishingOperation() != null && beanToSave.isValid();
        if (mustSave) {
            AbstractCaracteristicTabUIModel[] subModels;
            beanToSave.convertGearShootingCoordinatesToDD();
            FishingOperation toSave = (FishingOperation)beanToSave.toBean();
            for (AbstractCaracteristicTabUIModel subModel : subModels = ((EditFishingOperationUIHandler)this.handler).getSubModels()) {
                Class<AbstractCaracteristicTabUIModel> modelClass = ((Object)((Object)subModel)).getClass();
                CaracteristicMap caracteristics = subModel.getCaracteristicMap();
                if (modelClass.isAssignableFrom(VesselUseFeatureTabUIModel.class)) {
                    toSave.setVesselUseFeatures(caracteristics);
                } else if (modelClass.isAssignableFrom(GearUseFeatureTabUIModel.class)) {
                    toSave.setGearUseFeatures(caracteristics);
                }
                subModel.setModify(false);
            }
            this.sendMessage("[ Trait - Caract\u00e9ristiques g\u00e9n\u00e9rales ] Sauvegarde des modifications de " + this.decorate(toSave) + ".");
            if (log.isInfoEnabled()) {
                log.info((Object)("FishingOperation " + toSave.getId() + " was modified, will save it."));
            }
            monitor.clearModified();
            ((EditFishingOperationUIModel)this.getModel()).setModify(false);
            this.saveFishingOperation(toSave);
            if ("edit".equals(this.getContext().getValidationContext())) {
                ((EditFishingOperationUIHandler)this.handler).getParentUi().getTabPane().setSelectedIndex(1);
                ((EditFishingOperationUIHandler)this.handler).getParentUi().getCatchesTabContent().getTabPane().setSelectedIndex(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFishingOperation(FishingOperation toSave) {
        PersistenceService service = this.getContext().getPersistenceService();
        boolean create = TuttiEntities.isNew((TuttiEntity)toSave);
        FishingOperationsUIModel model = ((EditFishingOperationUIHandler)this.getHandler()).getParentUi().getModel();
        if (create) {
            FishingOperation savedFishingOperation = service.createFishingOperation(toSave);
            CatchBatch catchBatch = CatchBatchs.newCatchBatch();
            catchBatch.setFishingOperation(savedFishingOperation);
            service.createCatchBatch(catchBatch);
            model.addFishingOperation(savedFishingOperation);
            model.setSelectedFishingOperation(savedFishingOperation);
        } else {
            model.setEditionAdjusting(true);
            try {
                FishingOperation savedFishingOperation = service.saveFishingOperation(toSave);
                model.setSelectedFishingOperation(null);
                model.updateFishingOperation(savedFishingOperation);
                model.setSelectedFishingOperation(savedFishingOperation);
            }
            finally {
                model.setEditionAdjusting(false);
            }
        }
    }
}

