package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportTemporaryGearAction.java 1388 2013-11-26 08:03:42Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-3.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/ImportTemporaryGearAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.referential.ReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Import temporary gear referential.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportTemporaryGearAction extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportTemporaryGearAction.class);

    private File file;

    public ImportTemporaryGearAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to import
            file = chooseFile(
                    _("tutti.manageTemporaryReferential.title.choose.importTemporaryGearFile"),
                    _("tutti.manageTemporaryReferential.action.chooseReferentialGearFile.import"),
                    "^.*\\.csv", _("tutti.common.file.csv"));

            doAction = file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull(file);
        if (log.isInfoEnabled()) {
            log.info("Will import gear temporary " +
                     "referential from file: " + file);
        }

        ReferentialImportExportService service =
                getContext().getTuttiReferentialImportExportService();

        service.importTemporaryGear(file);

        // reset ui cache
        getDataContext().resetGears();

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        sendMessage(_("tutti.manageTemporaryReferential.action.chooseReferentialGearFile.import.success", file));
    }
}