/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.beans.annotation.AnnotationBeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedNotification;
import org.springframework.jmx.export.annotation.ManagedNotifications;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationJmxAttributeSource
implements JmxAttributeSource,
BeanFactoryAware {
    private StringValueResolver embeddedValueResolver;

    public void setBeanFactory(final BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new StringValueResolver(){

                public String resolveStringValue(String strVal) {
                    return ((ConfigurableBeanFactory)beanFactory).resolveEmbeddedValue(strVal);
                }
            };
        }
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedResource getManagedResource(Class<?> beanClass) throws InvalidMetadataException {
        ManagedResource ann = beanClass.getAnnotation(ManagedResource.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedResource managedResource = new org.springframework.jmx.export.metadata.ManagedResource();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedResource, (StringValueResolver)this.embeddedValueResolver, (String[])new String[0]);
        if (!"".equals(ann.value()) && !StringUtils.hasLength((String)managedResource.getObjectName())) {
            String value = ann.value();
            if (this.embeddedValueResolver != null) {
                value = this.embeddedValueResolver.resolveStringValue(value);
            }
            managedResource.setObjectName(value);
        }
        return managedResource;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedAttribute getManagedAttribute(Method method) throws InvalidMetadataException {
        ManagedAttribute ann = (ManagedAttribute)AnnotationUtils.findAnnotation((Method)method, ManagedAttribute.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedAttribute managedAttribute = new org.springframework.jmx.export.metadata.ManagedAttribute();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedAttribute, (String[])new String[]{"defaultValue"});
        if (ann.defaultValue().length() > 0) {
            managedAttribute.setDefaultValue(ann.defaultValue());
        }
        return managedAttribute;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedMetric getManagedMetric(Method method) throws InvalidMetadataException {
        ManagedMetric ann = (ManagedMetric)AnnotationUtils.findAnnotation((Method)method, ManagedMetric.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedMetric managedMetric = new org.springframework.jmx.export.metadata.ManagedMetric();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedMetric, (String[])new String[0]);
        return managedMetric;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedOperation getManagedOperation(Method method) throws InvalidMetadataException {
        Annotation ann = AnnotationUtils.findAnnotation((Method)method, ManagedOperation.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedOperation op = new org.springframework.jmx.export.metadata.ManagedOperation();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)op, (String[])new String[0]);
        return op;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedOperationParameter[] getManagedOperationParameters(Method method) throws InvalidMetadataException {
        ManagedOperationParameters params = (ManagedOperationParameters)AnnotationUtils.findAnnotation((Method)method, ManagedOperationParameters.class);
        org.springframework.jmx.export.metadata.ManagedOperationParameter[] result = null;
        if (params == null) {
            result = new org.springframework.jmx.export.metadata.ManagedOperationParameter[]{};
        } else {
            ManagedOperationParameter[] paramData = params.value();
            result = new org.springframework.jmx.export.metadata.ManagedOperationParameter[paramData.length];
            for (int i = 0; i < paramData.length; ++i) {
                ManagedOperationParameter annotation = paramData[i];
                org.springframework.jmx.export.metadata.ManagedOperationParameter managedOperationParameter = new org.springframework.jmx.export.metadata.ManagedOperationParameter();
                AnnotationBeanUtils.copyPropertiesToBean((Annotation)annotation, (Object)managedOperationParameter, (String[])new String[0]);
                result[i] = managedOperationParameter;
            }
        }
        return result;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedNotification[] getManagedNotifications(Class<?> clazz) throws InvalidMetadataException {
        ManagedNotifications notificationsAnn = clazz.getAnnotation(ManagedNotifications.class);
        if (notificationsAnn == null) {
            return new org.springframework.jmx.export.metadata.ManagedNotification[0];
        }
        ManagedNotification[] notifications = notificationsAnn.value();
        org.springframework.jmx.export.metadata.ManagedNotification[] result = new org.springframework.jmx.export.metadata.ManagedNotification[notifications.length];
        for (int i = 0; i < notifications.length; ++i) {
            ManagedNotification notification = notifications[i];
            org.springframework.jmx.export.metadata.ManagedNotification managedNotification = new org.springframework.jmx.export.metadata.ManagedNotification();
            AnnotationBeanUtils.copyPropertiesToBean((Annotation)notification, (Object)managedNotification, (String[])new String[0]);
            result[i] = managedNotification;
        }
        return result;
    }
}

