/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import liquibase.change.ConstraintsConfig;
import liquibase.database.structure.Column;
import liquibase.statement.DatabaseFunction;
import liquibase.util.ISODateFormat;

public class ColumnConfig {
    private String name;
    private String type;
    private String value;
    private Number valueNumeric;
    private Date valueDate;
    private Boolean valueBoolean;
    private DatabaseFunction valueComputed;
    private String defaultValue;
    private Number defaultValueNumeric;
    private Date defaultValueDate;
    private Boolean defaultValueBoolean;
    private DatabaseFunction defaultValueComputed;
    private ConstraintsConfig constraints;
    private Boolean autoIncrement;
    private BigInteger startWith;
    private BigInteger incrementBy;
    private String remarks;

    public ColumnConfig(Column columnStructure) {
        this.setName(columnStructure.getName());
        this.setType(columnStructure.getTypeName());
        if (columnStructure.getDefaultValue() != null) {
            this.setDefaultValue(columnStructure.getDefaultValue().toString());
        }
        this.setAutoIncrement(columnStructure.isAutoIncrement());
        this.setStartWith(columnStructure.getStartWith());
        this.setIncrementBy(columnStructure.getIncrementBy());
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(columnStructure.isNullable());
        constraints.setPrimaryKey(columnStructure.isPrimaryKey());
        constraints.setUnique(columnStructure.isUnique());
        this.setConstraints(constraints);
    }

    public ColumnConfig(ColumnConfig column) {
        this.setName(column.getName());
        this.setType(column.getType());
        this.setDefaultValue(column.getDefaultValue());
        this.setAutoIncrement(column.isAutoIncrement());
        this.setStartWith(column.getStartWith());
        this.setIncrementBy(column.getIncrementBy());
        if (column.getConstraints() != null) {
            ConstraintsConfig constraints = new ConstraintsConfig();
            constraints.setNullable(column.getConstraints().isNullable());
            constraints.setPrimaryKey(column.getConstraints().isPrimaryKey());
            constraints.setPrimaryKeyTablespace(column.getConstraints().getPrimaryKeyTablespace());
            constraints.setUnique(column.getConstraints().isUnique());
        }
        this.setConstraints(this.constraints);
    }

    public ColumnConfig() {
    }

    public String getName() {
        return this.name;
    }

    public ColumnConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public ColumnConfig setType(String type) {
        this.type = type;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Number getValueNumeric() {
        return this.valueNumeric;
    }

    public ColumnConfig setValueNumeric(String valueNumeric) {
        if (valueNumeric == null || valueNumeric.equalsIgnoreCase("null")) {
            this.valueNumeric = null;
        } else {
            valueNumeric = valueNumeric.replaceFirst("^\\(", "");
            if ((valueNumeric = valueNumeric.replaceFirst("\\)$", "")).matches("\\d+\\.?\\d*")) {
                try {
                    this.valueNumeric = NumberFormat.getInstance(Locale.US).parse(valueNumeric);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.valueComputed = new DatabaseFunction(valueNumeric);
            }
        }
        return this;
    }

    public ColumnConfig setValueNumeric(Number valueNumeric) {
        this.valueNumeric = valueNumeric;
        return this;
    }

    public Boolean getValueBoolean() {
        return this.valueBoolean;
    }

    public ColumnConfig setValueBoolean(Boolean valueBoolean) {
        this.valueBoolean = valueBoolean;
        return this;
    }

    public DatabaseFunction getValueComputed() {
        return this.valueComputed;
    }

    public ColumnConfig setValueComputed(DatabaseFunction valueComputed) {
        this.valueComputed = valueComputed;
        return this;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public ColumnConfig setValueDate(Date valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    public ColumnConfig setValueDate(String valueDate) {
        if (valueDate == null || valueDate.equalsIgnoreCase("null")) {
            this.valueDate = null;
        } else {
            try {
                this.valueDate = new ISODateFormat().parse(valueDate);
            }
            catch (ParseException e) {
                this.valueComputed = new DatabaseFunction(valueDate);
            }
        }
        return this;
    }

    public Object getValueObject() {
        if (this.getValue() != null) {
            return this.getValue();
        }
        if (this.getValueBoolean() != null) {
            return this.getValueBoolean();
        }
        if (this.getValueNumeric() != null) {
            return this.getValueNumeric();
        }
        if (this.getValueDate() != null) {
            return this.getValueDate();
        }
        if (this.getValueComputed() != null) {
            return this.getValueComputed();
        }
        return null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ColumnConfig setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Number getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    public ColumnConfig setDefaultValueNumeric(Number defaultValueNumeric) {
        this.defaultValueNumeric = defaultValueNumeric;
        return this;
    }

    public ColumnConfig setDefaultValueNumeric(String defaultValueNumeric) throws ParseException {
        if (defaultValueNumeric == null || defaultValueNumeric.equalsIgnoreCase("null")) {
            this.defaultValueNumeric = null;
        } else if ("GENERATED_BY_DEFAULT".equals(defaultValueNumeric)) {
            this.setAutoIncrement(true);
        } else {
            defaultValueNumeric = defaultValueNumeric.replaceFirst("^\\(", "");
            defaultValueNumeric = defaultValueNumeric.replaceFirst("\\)$", "");
            try {
                this.defaultValueNumeric = NumberFormat.getInstance(Locale.US).parse(defaultValueNumeric);
            }
            catch (ParseException e) {
                this.defaultValueComputed = new DatabaseFunction(defaultValueNumeric);
            }
        }
        return this;
    }

    public Date getDefaultValueDate() {
        return this.defaultValueDate;
    }

    public ColumnConfig setDefaultValueDate(String defaultValueDate) {
        if (defaultValueDate == null || defaultValueDate.equalsIgnoreCase("null")) {
            this.defaultValueDate = null;
        } else {
            try {
                this.defaultValueDate = new ISODateFormat().parse(defaultValueDate);
            }
            catch (ParseException e) {
                this.defaultValueComputed = new DatabaseFunction(defaultValueDate);
            }
        }
        return this;
    }

    public ColumnConfig setDefaultValueDate(Date defaultValueDate) {
        this.defaultValueDate = defaultValueDate;
        return this;
    }

    public Boolean getDefaultValueBoolean() {
        return this.defaultValueBoolean;
    }

    public ColumnConfig setDefaultValueBoolean(Boolean defaultValueBoolean) {
        this.defaultValueBoolean = defaultValueBoolean;
        return this;
    }

    public DatabaseFunction getDefaultValueComputed() {
        return this.defaultValueComputed;
    }

    public ColumnConfig setDefaultValueComputed(DatabaseFunction defaultValueComputed) {
        this.defaultValueComputed = defaultValueComputed;
        return this;
    }

    public Object getDefaultValueObject() {
        if (this.getDefaultValue() != null) {
            return this.getDefaultValue();
        }
        if (this.getDefaultValueBoolean() != null) {
            return this.getDefaultValueBoolean();
        }
        if (this.getDefaultValueNumeric() != null) {
            return this.getDefaultValueNumeric();
        }
        if (this.getDefaultValueDate() != null) {
            return this.getDefaultValueDate();
        }
        if (this.getDefaultValueComputed() != null) {
            return this.getDefaultValueComputed();
        }
        return null;
    }

    public ConstraintsConfig getConstraints() {
        return this.constraints;
    }

    public ColumnConfig setConstraints(ConstraintsConfig constraints) {
        this.constraints = constraints;
        return this;
    }

    public Boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public ColumnConfig setAutoIncrement(Boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
        return this;
    }

    public BigInteger getStartWith() {
        return this.startWith;
    }

    public ColumnConfig setStartWith(BigInteger startWith) {
        this.startWith = startWith;
        return this;
    }

    public BigInteger getIncrementBy() {
        return this.incrementBy;
    }

    public ColumnConfig setIncrementBy(BigInteger incrementBy) {
        this.incrementBy = incrementBy;
        return this;
    }

    public boolean isPrimaryKey() {
        return this.getConstraints() != null && this.getConstraints().isPrimaryKey() != null && this.getConstraints().isPrimaryKey() != false;
    }

    public boolean isNullable() {
        return this.getConstraints() == null || this.getConstraints().isNullable() != false;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null || this.getDefaultValueBoolean() != null || this.getDefaultValueDate() != null || this.getDefaultValueNumeric() != null || this.getDefaultValueComputed() != null;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public ColumnConfig setRemarks(String remarks) {
        this.remarks = remarks;
        return this;
    }
}

