/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.text.ParseException;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.CurrencyType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.structure.type.NumberType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;

public class DB2TypeConverter
extends AbstractTypeConverter {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof DB2Database;
    }

    public Object convertDatabaseValueToObject(Object defaultValue, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            if (dataType == 93) {
                defaultValue = ((String)defaultValue).replaceFirst("^\"SYSIBM\".\"TIMESTAMP\"\\('", "").replaceFirst("'\\)", "");
            } else if (dataType == 92) {
                defaultValue = ((String)defaultValue).replaceFirst("^\"SYSIBM\".\"TIME\"\\('", "").replaceFirst("'\\)", "");
            } else if (dataType == 91) {
                defaultValue = ((String)defaultValue).replaceFirst("^\"SYSIBM\".\"DATE\"\\('", "").replaceFirst("'\\)", "");
            }
        }
        return super.convertDatabaseValueToObject(defaultValue, dataType, columnSize, decimalDigits, database);
    }

    public BooleanType getBooleanType() {
        return new BooleanType.NumericBooleanType("SMALLINT");
    }

    public CurrencyType getCurrencyType() {
        return new CurrencyType("DECIMAL(19,4)");
    }

    public DateTimeType getDateTimeType() {
        return new DateTimeType("TIMESTAMP");
    }

    public NumberType getNumberType() {
        return new NumberType("DECFLOAT(16)");
    }
}

