/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class BenthosBatchTableModel
extends AbstractTuttiTableModel<BenthosBatchRowModel> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BenthosBatchTableModel.class);
    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES = ColumnIdentifier.newId("species", I18n.n_((String)"tutti.editBenthosBatch.table.header.species", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.species.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> WEIGHT = ColumnIdentifier.newId("computedOrNotWeight", I18n.n_((String)"tutti.editBenthosBatch.table.header.weight", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.weight.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId("computedOrNotNumber", I18n.n_((String)"tutti.editBenthosBatch.table.header.computedNumber", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.computedNumber.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> COMMENT = ColumnIdentifier.newId("comment", I18n.n_((String)"tutti.editBenthosBatch.table.header.comment", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.comment.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId("attachment", I18n.n_((String)"tutti.editBenthosBatch.table.header.file", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.file.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId("speciesToConfirm", I18n.n_((String)"tutti.editBenthosBatch.table.header.toConfirm", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.toConfirm.tip", (Object[])new Object[0]));
    protected final Set<ColumnIdentifier<BenthosBatchRowModel>> frequencyCols;
    protected final Set<SampleCategoryColumnIdentifier<BenthosBatchRowModel>> sampleCols;
    protected final SampleCategoryModel sampleCategoryModel;

    public BenthosBatchTableModel(SampleCategoryModel sampleCategoryModel, TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        this.sampleCategoryModel = sampleCategoryModel;
        this.setNoneEditableCols(SPECIES);
        this.frequencyCols = Sets.newHashSet();
        this.frequencyCols.add(COMPUTED_NUMBER);
        this.frequencyCols.add(WEIGHT);
        this.sampleCols = Sets.newHashSet();
        Enumeration columns = columnModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)columns.nextElement();
            Object identifier = tableColumn.getIdentifier();
            if (!(identifier instanceof SampleCategoryColumnIdentifier)) continue;
            SampleCategoryColumnIdentifier categoryColumnIdentifier = (SampleCategoryColumnIdentifier)identifier;
            this.sampleCols.add(categoryColumnIdentifier);
        }
    }

    @Override
    public BenthosBatchRowModel createNewRow() {
        BenthosBatchRowModel result = new BenthosBatchRowModel(this.sampleCategoryModel);
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<BenthosBatchRowModel> propertyName, BenthosBatchRowModel entry) {
        if (this.sampleCols.contains(propertyName)) {
            SampleCategoryColumnIdentifier sampleCategoryColumnIdentifier = (SampleCategoryColumnIdentifier)propertyName;
            sampleCategoryColumnIdentifier.setWeightValue(entry, aValue);
            Integer sampleCategoryId = sampleCategoryColumnIdentifier.getSampleCategoryId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sample category: " + sampleCategoryId + " modified at row: " + rowIndex));
            }
            SampleCategory<?> sampleCategory = entry.getSampleCategoryById(sampleCategoryId);
            SampleCategoryAble firstAncestor = entry.getFirstAncestor((SampleCategory)sampleCategory);
            int firstRowIndex = this.getRowIndex(firstAncestor);
            if (log.isDebugEnabled()) {
                log.debug((Object)("First ancestor row: " + firstRowIndex));
            }
            HashSet shell = Sets.newHashSet();
            ((BenthosBatchRowModel)firstAncestor).collectShell(shell);
            for (BenthosBatchRowModel batchRowModel : shell) {
                int currentRowIndex = this.getRowIndex(batchRowModel);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Update shell row: " + currentRowIndex));
                }
                this.fireTableCellUpdated(currentRowIndex, columnIndex);
            }
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        }
    }

    @Override
    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<BenthosBatchRowModel> propertyName) {
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result) {
            if (this.frequencyCols.contains(propertyName)) {
                BenthosBatchRowModel entry = (BenthosBatchRowModel)this.getEntry(rowIndex);
                result = entry.isBatchLeaf();
            } else if (this.sampleCols.contains(propertyName)) {
                SampleCategory value;
                BenthosBatchRowModel entry = (BenthosBatchRowModel)this.getEntry(rowIndex);
                Species species = entry.getSpecies();
                result = species == null ? false : (value = (SampleCategory)propertyName.getValue(entry)).getCategoryValue() != null;
            }
        }
        return result;
    }
}

