/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.andromda.cartridges.hibernate.HibernateProfile;
import org.andromda.cartridges.hibernate.HibernateUtils;
import org.andromda.cartridges.hibernate.metafacades.HibernateAssociationEnd;
import org.andromda.cartridges.hibernate.metafacades.HibernateAssociationEndLogic;
import org.andromda.cartridges.hibernate.metafacades.HibernateEntity;
import org.andromda.cartridges.hibernate.metafacades.HibernateType;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.EntityAssociationEnd;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class HibernateAssociationEndLogicImpl
extends HibernateAssociationEndLogic {
    private static final String COLLECTION_TYPE_SET = "set";
    private static final String COLLECTION_TYPE_MAP = "map";
    private static final String COLLECTION_TYPE_BAG = "bag";
    private static final String COLLECTION_TYPE_LIST = "list";
    private static final String COLLECTION_TYPE_COLLECTION = "collection";
    private static final Collection collectionTypes = new ArrayList();
    private static final String COMPOSITION_DEFINES_EAGER_LOADING = "compositionDefinesEagerLoading";
    private static final String PROPERTY_ASSOCIATION_END_OUTERJOIN = "hibernateAssociationEndOuterJoin";
    private static final String COLLECTION_INDEX_NAME = "associationEndCollectionIndexName";
    private static final String COLLECTION_INDEX_TYPE = "associationEndCollectionIndexType";
    private static final String HIBERNATE_AGGREGATION_CASCADE = "hibernateAggregationCascade";
    private static final String HIBERNATE_COMPOSITION_CASCADE = "hibernateCompositionCascade";
    private static final String HIBERNATE_OUTER_JOIN_YES = "yes";
    private static final String HIBERNATE_OUTER_JOIN_AUTO = "auto";
    static /* synthetic */ Class class$org$andromda$cartridges$hibernate$metafacades$HibernateEntity;

    public HibernateAssociationEndLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected boolean handleIsOne2OnePrimary() {
        boolean primary;
        boolean bl = primary = !BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.getOtherEnd().findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_ASSOCIATION_END_PRIMARY)));
        if (primary) {
            primary = this.isOne2One() && (this.isAggregation() || this.isComposition()) || BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_ASSOCIATION_END_PRIMARY)));
        }
        return primary;
    }

    public String getGetterSetterTypeName() {
        String getterSetterTypeName = null;
        if (this.isMany()) {
            boolean specificInterfaces = Boolean.valueOf(ObjectUtils.toString((Object)this.getConfiguredProperty("specificCollectionInterfaces")));
            TypeMappings mappings = this.getLanguageMappings();
            if (mappings != null) {
                if (this.isMap()) {
                    getterSetterTypeName = mappings.getTo(UMLProfile.MAP_TYPE_NAME);
                } else if (specificInterfaces) {
                    if (this.isSet()) {
                        getterSetterTypeName = mappings.getTo(UMLProfile.SET_TYPE_NAME);
                    } else if (this.isList()) {
                        getterSetterTypeName = mappings.getTo(UMLProfile.LIST_TYPE_NAME);
                    }
                } else {
                    getterSetterTypeName = ObjectUtils.toString((Object)this.getConfiguredProperty("defaultCollectionInterface"));
                }
            } else {
                getterSetterTypeName = ObjectUtils.toString((Object)this.getConfiguredProperty("defaultCollectionInterface"));
            }
        } else {
            String typeName;
            ClassifierFacade type = this.getType();
            if (type instanceof HibernateEntity && StringUtils.isNotEmpty((String)(typeName = ((HibernateEntity)type).getFullyQualifiedEntityName()))) {
                getterSetterTypeName = typeName;
            }
        }
        if (getterSetterTypeName == null) {
            getterSetterTypeName = super.getGetterSetterTypeName();
        } else if (this.isMany() && Boolean.valueOf(String.valueOf(this.getConfiguredProperty("enableTemplating"))).booleanValue()) {
            getterSetterTypeName = getterSetterTypeName + "<" + this.getType().getFullyQualifiedName() + ">";
        }
        return getterSetterTypeName;
    }

    protected boolean handleIsLazy() {
        String lazyString = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_LAZY);
        boolean lazy = true;
        if (lazyString == null) {
            boolean compositionDefinesEagerLoading = Boolean.valueOf(String.valueOf(this.getConfiguredProperty(COMPOSITION_DEFINES_EAGER_LOADING)));
            if (compositionDefinesEagerLoading) {
                lazy = !this.getOtherEnd().isComposition();
            }
        } else {
            lazy = Boolean.valueOf(lazyString);
        }
        return lazy;
    }

    protected String handleGetHibernateCascade() {
        String cascade = null;
        String individualCascade = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_CASCADE);
        if (individualCascade != null && individualCascade.length() > 0) {
            cascade = individualCascade;
        } else if (this.isChild()) {
            if (StringUtils.isBlank((String)this.getHibernateCompositionCascade())) {
                HibernateEntity entity;
                String defaultCascade;
                cascade = "delete";
                ClassifierFacade type = this.getType();
                if (type != null && type instanceof HibernateEntity && ((defaultCascade = (entity = (HibernateEntity)type).getHibernateDefaultCascade()).equalsIgnoreCase("save-update") || defaultCascade.equalsIgnoreCase("all"))) {
                    cascade = this.isMany() ? "all-delete-orphan" : "all";
                }
            } else {
                cascade = this.getHibernateCompositionCascade();
            }
        } else if (this.isComposition()) {
            cascade = "none";
        } else if (StringUtils.isNotBlank((String)this.getHibernateAggregationCascade())) {
            if (this.isAggregation()) {
                cascade = "none";
            } else if (this.getOtherEnd() != null && this.getOtherEnd().isAggregation()) {
                cascade = this.getHibernateAggregationCascade();
            }
        }
        if (cascade != null && (this.isOne2Many() || this.isOne2One()) && cascade.equalsIgnoreCase("all-delete-orphan")) {
            cascade = "all";
        }
        return cascade;
    }

    protected boolean handleIsHibernateInverse() {
        boolean inverse;
        boolean bl = inverse = this.isNavigable() && this.getOtherEnd().isNavigable();
        if (inverse) {
            inverse = this.isMany2One();
            if (this.isMany2Many() && !inverse) {
                if (this.isAggregation() || this.isComposition()) {
                    inverse = false;
                } else if (this.getOtherEnd().isAggregation() || this.getOtherEnd().isComposition()) {
                    inverse = true;
                } else {
                    String otherEndTypeName;
                    String endTypeName = StringUtils.trimToEmpty((String)this.getType().getFullyQualifiedName(true));
                    int compareTo = endTypeName.compareTo(otherEndTypeName = StringUtils.trimToEmpty((String)this.getOtherEnd().getType().getFullyQualifiedName(true)));
                    if (compareTo == 0) {
                        String endName = StringUtils.trimToEmpty((String)this.getName());
                        String otherEndName = StringUtils.trimToEmpty((String)this.getOtherEnd().getName());
                        compareTo = endName.compareTo(otherEndName);
                    }
                    boolean bl2 = inverse = compareTo < 0;
                }
                if (inverse && this.isBidirectionalOrderedListChild() && this.isVersion3()) {
                    inverse = false;
                }
            }
        }
        return inverse;
    }

    protected String handleGetOuterJoin() {
        Object value = this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_OUTER_JOIN);
        if (value == null) {
            value = this.getConfiguredProperty(PROPERTY_ASSOCIATION_END_OUTERJOIN);
        }
        String outerValue = StringUtils.trimToEmpty((String)String.valueOf(value));
        String version = (String)this.getConfiguredProperty("hibernateVersion");
        if (version.equals("3")) {
            outerValue = outerValue.equals(HIBERNATE_OUTER_JOIN_AUTO) || outerValue.equals(HIBERNATE_OUTER_JOIN_YES) ? "select" : "join";
        }
        return outerValue;
    }

    public boolean isRequired() {
        HibernateEntity entity;
        boolean required = super.isRequired();
        ClassifierFacade type = this.getOtherEnd().getType();
        if (type != null && (class$org$andromda$cartridges$hibernate$metafacades$HibernateEntity == null ? (class$org$andromda$cartridges$hibernate$metafacades$HibernateEntity = HibernateAssociationEndLogicImpl.class$("org.andromda.cartridges.hibernate.metafacades.HibernateEntity")) : class$org$andromda$cartridges$hibernate$metafacades$HibernateEntity).isAssignableFrom(type.getClass()) && (entity = (HibernateEntity)type).isHibernateInheritanceClass() && entity.getGeneralization() != null) {
            required = false;
        }
        return required;
    }

    protected String handleGetCollectionType() {
        String collectionType = this.getSpecificCollectionType();
        if (!collectionTypes.contains(collectionType)) {
            collectionType = this.isOrdered() ? COLLECTION_TYPE_LIST : (String)this.getConfiguredProperty("hibernateAssociationCollectionType");
        }
        return collectionType;
    }

    private String getSpecificCollectionType() {
        return ObjectUtils.toString((Object)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_COLLECTION_TYPE));
    }

    protected String handleGetSortType() {
        return ObjectUtils.toString((Object)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_SORT_TYPE));
    }

    protected String handleGetOrderByColumns() {
        String orderColumns = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_ORDER_BY_COLUMNS);
        if (orderColumns == null) {
            orderColumns = ((EntityAssociationEnd)this.getOtherEnd()).getColumnName();
        }
        return orderColumns;
    }

    protected String handleGetWhereClause() {
        return (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_WHERE_CLAUSE);
    }

    protected boolean handleIsIndexedCollection() {
        boolean indexed = false;
        if (this.isOrdered() && (this.getCollectionType().equals(COLLECTION_TYPE_LIST) || this.getCollectionType().equals(COLLECTION_TYPE_MAP)) && StringUtils.isNotBlank((String)this.getCollectionIndexName())) {
            indexed = true;
        }
        return indexed;
    }

    protected String handleGetCollectionIndexName() {
        Object value = this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_INDEX);
        if (value == null && this.isConfiguredProperty(COLLECTION_INDEX_NAME) && StringUtils.isBlank((String)ObjectUtils.toString((Object)(value = this.getConfiguredProperty(COLLECTION_INDEX_NAME))))) {
            value = null;
        }
        if (value != null) {
            return ObjectUtils.toString((Object)value);
        }
        String otherEntityName = ((HibernateEntity)this.getOtherEnd().getType()).getEntityName();
        Object separator = this.getConfiguredProperty("sqlNameSeparator");
        return EntityMetafacadeUtils.toSqlName((String)otherEntityName, (Object)separator) + separator + EntityMetafacadeUtils.toSqlName((String)this.getName(), (Object)separator) + separator + "IDX";
    }

    protected String handleGetCollectionIndexType() {
        Object value = this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_INDEX_TYPE);
        if (value == null && StringUtils.isBlank((String)ObjectUtils.toString((Object)(value = this.getConfiguredProperty(COLLECTION_INDEX_TYPE))))) {
            value = null;
        }
        if (value != null) {
            if (value instanceof String) {
                value = this.getRootPackage().findModelElement((String)value);
            }
            if (value instanceof HibernateType) {
                value = ((HibernateType)value).getFullyQualifiedHibernateType();
            }
        }
        return value != null ? ObjectUtils.toString((Object)value) : null;
    }

    protected boolean handleIsMap() {
        boolean isMap = this.getCollectionType().equalsIgnoreCase(COLLECTION_TYPE_MAP);
        if (isMap && StringUtils.isBlank((String)this.getSpecificCollectionType())) {
            isMap = !this.isOrdered();
        }
        return isMap;
    }

    protected boolean handleIsList() {
        boolean isList = this.getCollectionType().equalsIgnoreCase(COLLECTION_TYPE_LIST);
        if (!isList && StringUtils.isBlank((String)this.getSpecificCollectionType())) {
            isList = this.isOrdered();
        }
        return isList;
    }

    protected boolean handleIsSet() {
        boolean isSet = this.getCollectionType().equalsIgnoreCase(COLLECTION_TYPE_SET);
        if (isSet && StringUtils.isBlank((String)this.getSpecificCollectionType())) {
            isSet = !this.isOrdered();
        }
        return isSet;
    }

    protected boolean handleIsBag() {
        return this.getCollectionType().equalsIgnoreCase(COLLECTION_TYPE_BAG);
    }

    protected String handleGetCollectionTypeImplementation() {
        StringBuffer implementation = new StringBuffer();
        if (this.isMany()) {
            implementation.append("new ");
            if (this.isSet()) {
                implementation.append(this.getConfiguredProperty("setTypeImplementation"));
            } else if (this.isMap()) {
                implementation.append(this.getConfiguredProperty("mapTypeImplementation"));
            } else if (this.isBag()) {
                implementation.append(this.getConfiguredProperty("bagTypeImplementation"));
            } else if (this.isList()) {
                implementation.append(this.getConfiguredProperty("listTypeImplementation"));
            }
            if (Boolean.valueOf(String.valueOf(this.getConfiguredProperty("enableTemplating"))).booleanValue()) {
                implementation.append("<");
                if (this.isMap()) {
                    implementation.append(this.getCollectionIndexType());
                    implementation.append(", ");
                }
                implementation.append(this.getType().getFullyQualifiedName());
                implementation.append(">");
            }
            implementation.append("()");
        }
        return implementation.toString();
    }

    protected String handleGetHibernateAggregationCascade() {
        return StringUtils.trimToEmpty((String)ObjectUtils.toString((Object)this.getConfiguredProperty(HIBERNATE_AGGREGATION_CASCADE)));
    }

    protected String handleGetHibernateCompositionCascade() {
        return StringUtils.trimToEmpty((String)ObjectUtils.toString((Object)this.getConfiguredProperty(HIBERNATE_COMPOSITION_CASCADE)));
    }

    protected boolean handleIsBidirectionalOrderedListParent() {
        boolean biDirectional;
        boolean isBidirectionalOrderedListParent = false;
        boolean bl = biDirectional = this.isNavigable() && this.getOtherEnd().isNavigable();
        if (biDirectional && this.isOne2Many() && this.getOtherEnd() instanceof HibernateAssociationEnd) {
            HibernateAssociationEnd otherEnd = (HibernateAssociationEnd)this.getOtherEnd();
            isBidirectionalOrderedListParent = otherEnd.getCollectionType().equals(COLLECTION_TYPE_LIST) && otherEnd.isIndexedCollection();
        }
        return isBidirectionalOrderedListParent;
    }

    protected boolean handleIsBidirectionalOrderedListChild() {
        boolean biDirectional = false;
        if (this.getOtherEnd() instanceof HibernateAssociationEnd) {
            HibernateAssociationEnd otherEnd = (HibernateAssociationEnd)this.getOtherEnd();
            biDirectional = otherEnd.isBidirectionalOrderedListParent();
        }
        return biDirectional;
    }

    protected boolean handleIsUsingHibernate3() {
        boolean usingHibernate3 = false;
        String property = (String)this.getConfiguredProperty("hibernateVersion");
        if (property != null) {
            usingHibernate3 = property.equals("3");
        }
        return usingHibernate3;
    }

    protected String handleGetCollectionIndexNameGetter() {
        return "get" + NameMasker.mask((String)this.getCollectionIndexName(), (String)"uppercamelcase");
    }

    protected String handleGetCollectionIndexNameSetter() {
        return COLLECTION_TYPE_SET + NameMasker.mask((String)this.getCollectionIndexName(), (String)"uppercamelcase");
    }

    private boolean isVersion3() {
        return HibernateUtils.isVersion3((String)this.getConfiguredProperty("hibernateVersion"));
    }

    private boolean isXMLPersistenceActive() {
        return HibernateUtils.isXmlPersistenceActive((String)this.getConfiguredProperty("hibernateVersion"), (String)this.getConfiguredProperty("hibernateXMLPersistence"));
    }

    protected String handleGetEmbedXML() {
        String embedVal = null;
        if (this.isXMLPersistenceActive() && (embedVal = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_XML_EMBED)) == null) {
            boolean isBiDirectional = this.isNavigable() && this.getOtherEnd().isNavigable();
            embedVal = isBiDirectional && this.isMany() ? "false" : "true";
        }
        return StringUtils.isBlank(embedVal) ? null : embedVal;
    }

    protected String handleGetXmlTagName() {
        String tagName = null;
        if (this.isXMLPersistenceActive() && (tagName = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_XML_TAG_NAME)) == null) {
            tagName = this.getName();
        }
        return StringUtils.isBlank(tagName) ? null : tagName;
    }

    protected String handleGetComments() {
        return HibernateUtils.convertDocumentationIntoComments(this.getDocumentation(""));
    }

    protected boolean handleIsDatabaseOnDeleteCascade() {
        String hibernateCascade = this.getHibernateCascade();
        boolean generateDatabaseOnDeleteCascade = Boolean.parseBoolean((String)this.getConfiguredProperty("generateDatabaseOnDeleteCascade"));
        return generateDatabaseOnDeleteCascade && hibernateCascade != null && hibernateCascade.equalsIgnoreCase("all-delete-orphan");
    }

    protected boolean handleIsNaturalId() {
        return this.hasStereotype(HibernateProfile.STEREOTYPE_NATURALID);
    }

    public String getColumnName() {
        String columnName = null;
        if (this.getType() instanceof Entity) {
            String columnNamePrefix = this.isConfiguredProperty("columnNamePrefix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("columnNamePrefix")) : null;
            columnName = HibernateAssociationEndLogicImpl.getSqlNameFromTaggedValueLinkedByTable(columnNamePrefix, this, UMLProfile.TAGGEDVALUE_PERSISTENCE_COLUMN, ((Entity)this.getType()).getMaxSqlNameLength(), this.getForeignKeySuffix(), this.getConfiguredProperty("sqlNameSeparator"));
        }
        return columnName;
    }

    public static String getSqlNameFromTaggedValueLinkedByTable(String prefix, EntityAssociationEnd element, String name, Short nameMaxLength, String suffix, Object separator) {
        if (element != null) {
            Object value = element.findTaggedValue(name);
            StringBuffer buffer = new StringBuffer(StringUtils.trimToEmpty((String)((String)value)));
            if (StringUtils.isEmpty((String)buffer.toString())) {
                buffer = new StringBuffer(EntityMetafacadeUtils.toSqlName((String)element.getName(), (Object)separator));
                ClassifierFacade type = element.getType();
                if (type instanceof Entity) {
                    Entity entity = (Entity)type;
                    if (element.getName().equalsIgnoreCase(entity.getName())) {
                        buffer = new StringBuffer(HibernateAssociationEndLogicImpl.getEntityTableName(entity));
                    }
                }
                suffix = StringUtils.trimToEmpty((String)suffix);
                prefix = StringUtils.trimToEmpty((String)prefix);
                if (nameMaxLength != null) {
                    short maxLength = (short)(nameMaxLength - suffix.length() - prefix.length());
                    buffer = new StringBuffer(EntityMetafacadeUtils.ensureMaximumNameLength((String)buffer.toString(), (Short)new Short(maxLength)));
                }
                if (StringUtils.isNotBlank((String)prefix)) {
                    buffer.insert(0, prefix);
                }
                if (StringUtils.isNotBlank((String)suffix)) {
                    buffer.append(suffix);
                }
            }
            name = buffer.toString();
        }
        return name;
    }

    private static String getEntityTableName(Entity entity) {
        if (HibernateAssociationEndLogicImpl.isEntityTableName(entity)) {
            return entity.getTableName();
        }
        Entity entityInTable = HibernateAssociationEndLogicImpl.getHibernateEntity(entity);
        if (entityInTable != null) {
            return entityInTable.getTableName();
        }
        return entity.getTableName();
    }

    private static boolean isEntityTableName(Entity entity) {
        if (entity instanceof HibernateEntity) {
            HibernateEntity e = (HibernateEntity)entity;
            return e.isTableRequired() || e.isRequiresMapping();
        }
        return false;
    }

    private static Entity getHibernateEntity(Entity entity) {
        Collection collectionGen = entity.getGeneralizations();
        Iterator iterator = collectionGen.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Entity)) continue;
            Entity e = (Entity)object;
            if (HibernateAssociationEndLogicImpl.isEntityTableName(e)) {
                return e;
            }
            Entity r = HibernateAssociationEndLogicImpl.getHibernateEntity(e);
            if (r == null) continue;
            return r;
        }
        Collection collectionSpec = entity.getSpecializations();
        Iterator iterator2 = collectionSpec.iterator();
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            if (!(object instanceof Entity)) continue;
            Entity e = (Entity)object;
            if (HibernateAssociationEndLogicImpl.isEntityTableName(e)) {
                return e;
            }
            Entity r = HibernateAssociationEndLogicImpl.getHibernateEntity(e);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        collectionTypes.add(COLLECTION_TYPE_SET);
        collectionTypes.add(COLLECTION_TYPE_MAP);
        collectionTypes.add(COLLECTION_TYPE_BAG);
        collectionTypes.add(COLLECTION_TYPE_LIST);
        collectionTypes.add(COLLECTION_TYPE_COLLECTION);
    }
}

