/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.translation.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.translation.TranslationUtils;
import org.andromda.core.translation.library.Fragment;
import org.andromda.core.translation.library.LibraryException;
import org.andromda.core.translation.library.LibraryTranslation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Translation {
    private String name;
    private final Map fragments = new LinkedHashMap();
    private final Collection ignorePatterns = new ArrayList();
    private Collection validatePatterns;
    private LibraryTranslation libraryTranslation;

    protected LibraryTranslation getLibraryTranslation() {
        String methodName = "Translation.getLibraryTranslation";
        if (this.libraryTranslation == null) {
            throw new LibraryException("Translation.getLibraryTranslation - libraryTranslation can not be null");
        }
        return this.libraryTranslation;
    }

    protected void setLibraryTranslation(LibraryTranslation translation) {
        this.libraryTranslation = translation;
    }

    protected Fragment getFragment(String name) {
        Fragment fragment = null;
        Iterator names = this.fragments.keySet().iterator();
        while (names.hasNext()) {
            String nextName = (String)names.next();
            if (!name.matches(nextName)) continue;
            fragment = (Fragment)this.fragments.get(nextName);
        }
        if (fragment != null || !this.isIgnorePattern(name)) {
            // empty if block
        }
        return fragment;
    }

    public void addFragment(Fragment fragment) {
        ExceptionUtils.checkNull("fragment", fragment);
        fragment.setTranslation(this);
        this.fragments.put(fragment.getName(), fragment);
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public void addIgnorePattern(String ignorePattern) {
        this.ignorePatterns.add(StringUtils.trimToEmpty((String)ignorePattern));
    }

    public void addValidatePattern(String validatePattern) {
        this.validatePatterns.add(StringUtils.trimToEmpty((String)validatePattern));
    }

    public boolean isIgnorePattern(String pattern) {
        String nextIgnorePattern;
        boolean isIgnorePattern = false;
        pattern = StringUtils.trimToEmpty((String)pattern);
        Iterator ignorePatterns = this.ignorePatterns.iterator();
        while (ignorePatterns.hasNext() && !(isIgnorePattern = pattern.matches(nextIgnorePattern = StringUtils.trimToEmpty((String)((String)ignorePatterns.next()))))) {
        }
        return isIgnorePattern;
    }

    protected String getTranslated(String name, String kind) {
        name = StringUtils.trimToEmpty((String)name);
        kind = StringUtils.trimToEmpty((String)kind);
        ExceptionUtils.checkEmpty("name", name);
        Fragment fragment = this.getFragment(name);
        String translated = "";
        if (fragment != null) {
            translated = fragment.getKind(kind);
            String begin = "fragment{";
            int beginLength = begin.length();
            String end = "}";
            int beginIndex = translated.indexOf(begin);
            while (beginIndex != -1) {
                String fragmentName = translated.substring(beginIndex + beginLength, translated.length());
                int endIndex = fragmentName.indexOf(end);
                if (endIndex != -1) {
                    fragmentName = fragmentName.substring(0, endIndex);
                }
                StringBuffer toReplace = new StringBuffer(begin);
                toReplace.append(fragmentName);
                toReplace.append(end);
                translated = StringUtils.replace((String)translated, (String)toReplace.toString(), (String)this.getTranslated(fragmentName, kind));
                beginIndex = translated.indexOf(begin);
            }
        }
        return TranslationUtils.removeExtraWhitespace(translated);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

