/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.batch;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;

@Component(value="batchPersistenceHelper")
public class BatchPersistenceHelper
extends AbstractPersistenceService {
    public static final String BATCH_PMFM_ID = "pmfmId";
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;

    public List<SortingBatch> getFrequencyChilds(SortingBatch sortingBatch) {
        ArrayList result = Lists.newArrayList();
        for (Batch batch : sortingBatch.getChildBatchs()) {
            SortingBatch child = (SortingBatch)batch;
            if (!this.isFrequencyBatch(child)) continue;
            result.add(child);
        }
        return result;
    }

    public List<SortingBatch> getFrequencies(String batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Integer sortingBatchId = Integer.valueOf(batchId);
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(sortingBatchId);
        Preconditions.checkNotNull((Object)catchBatchId, (Object)("Could not find catchBatch for batch: " + batchId));
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        SortingBatch sortingBatch = this.catchBatchDao.getSortingBatchById(catchBatch, sortingBatchId);
        List<SortingBatch> frequencyChilds = this.getFrequencyChilds(sortingBatch);
        return frequencyChilds;
    }

    protected boolean isFrequencyBatch(SortingBatch sortingBatch) {
        boolean result = false;
        if (sortingBatch.getSortingMeasurements().size() == 1) {
            SortingMeasurement sm = (SortingMeasurement)sortingBatch.getSortingMeasurements().iterator().next();
            Pmfm pmfm = sm.getPmfm();
            SampleCategoryEnum sampleCategoryByPmfmId = this.enumeration.getSampleCategoryByPmfmId(pmfm.getId());
            result = sampleCategoryByPmfmId == null;
        }
        return result;
    }

    public void setBatchParents(SampleCategoryEnum sampleCategoryType, Serializable sampleCategoryValue, SortingBatch target, String parentBatchIdStr, CatchBatch catchBatch, Integer batchPmfmId) {
        SortingBatch parentBatch;
        Preconditions.checkNotNull((Object)target);
        if (parentBatchIdStr != null) {
            parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(parentBatchIdStr));
        } else {
            if (!sampleCategoryType.equals(SampleCategoryEnum.sortedUnsorted)) {
                throw new DataIntegrityViolationException(MessageFormat.format("A species or benthos batch with no parent should have a sampleCategoryType {0} (PMFM.ID={1})", SampleCategoryEnum.sortedUnsorted.name(), this.enumeration.PMFM_ID_SORTED_UNSORTED));
            }
            Integer qualitativeValueId = this.convertSampleCategoryValueIntoQualitativeId(sampleCategoryValue);
            if (this.enumeration.QUALITATIVE_VRAC_ID.equals(qualitativeValueId)) {
                parentBatch = this.catchBatchDao.getSortingBatch(catchBatch.getChildBatchs(), new Object[]{BATCH_PMFM_ID, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, BATCH_PMFM_ID, this.enumeration.PMFM_ID_SORTING_TYPE, batchPmfmId, BATCH_PMFM_ID, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED});
            } else if (this.enumeration.QUALITATIVE_HORS_VRAC_ID.equals(qualitativeValueId)) {
                parentBatch = this.catchBatchDao.getSortingBatch(catchBatch.getChildBatchs(), new Object[]{BATCH_PMFM_ID, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, BATCH_PMFM_ID, this.enumeration.PMFM_ID_SORTING_TYPE, batchPmfmId});
            } else {
                throw new DataIntegrityViolationException("Should have Vrac / Hor Vrac qualitative value, but had: " + qualitativeValueId);
            }
        }
        if (parentBatch == null) {
            throw new DataIntegrityViolationException("Could not retrieve parent batch, for a given speciesBatch or benthosBatch : invalid batch tree structure. Please make sure CatchBatch has been saved before to create a such batch.");
        }
        target.setParentBatch((Batch)parentBatch);
        target.setRootBatch(catchBatch);
    }

    public Integer convertSampleCategoryValueIntoQualitativeId(Serializable value) {
        if (value == null) {
            return null;
        }
        Integer qualitativeValueId = null;
        if (value instanceof CaracteristicQualitativeValue) {
            CaracteristicQualitativeValue cqValue = (CaracteristicQualitativeValue)value;
            qualitativeValueId = cqValue.getIdAsInt();
        } else if (value instanceof String) {
            qualitativeValueId = Integer.valueOf((String)((Object)value));
        }
        return qualitativeValueId;
    }

    public Integer getRecorderDepartmentId() {
        return this.enumeration.DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT;
    }

    public void setMeasurement(Measurement measurement, Caracteristic caracteristic, Serializable value) {
        if (caracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
            measurement.setAlphanumericalValue((String)((Object)value));
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
            measurement.setNumericalValue((Float)value);
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
            Integer qvId = value instanceof CaracteristicQualitativeValue ? ((CaracteristicQualitativeValue)value).getIdAsInt() : (value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString()));
            QualitativeValue qv = (QualitativeValue)this.load(QualitativeValueImpl.class, qvId);
            measurement.setQualitativeValue(qv);
        }
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer recorderDepartmentId, SampleCategoryEnum sampleCategory, Serializable value) {
        Preconditions.checkNotNull((Object)sampleCategory);
        Preconditions.checkNotNull((Object)value);
        Integer pmfmId = sampleCategory.getFieldValue();
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.catchBatchDao.getSortingMeasurement(sortingBatch, pmfmId, recorderDepartmentId, true);
        this.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer recorderDepartmentId, Integer pmfmId, Serializable value) {
        Preconditions.checkNotNull((Object)pmfmId);
        Preconditions.checkNotNull((Object)value);
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.catchBatchDao.getSortingMeasurement(sortingBatch, pmfmId, recorderDepartmentId, true);
        this.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }

    public Serializable getSampleCategoryQualitative(Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (numericalvalue != null) {
            return numericalvalue;
        }
        if (alphanumericalValue != null) {
            return alphanumericalValue;
        }
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        if (caracteristic == null || caracteristic.getCaracteristicType() != CaracteristicType.QUALITATIVE) {
            return null;
        }
        CaracteristicQualitativeValue value = null;
        for (CaracteristicQualitativeValue qv : caracteristic.getQualitativeValue()) {
            if (!qualitativeValueId.equals(qv.getIdAsInt())) continue;
            value = qv;
            break;
        }
        return value;
    }
}

