/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="individualObservationBatchPersistenceService")
public class IndividualObservationBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements IndividualObservationBatchPersistenceService {
    private static final Log log = LogFactory.getLog(IndividualObservationBatchPersistenceServiceImpl.class);
    @Autowired
    protected AttachmentPersistenceService attachmentPersistenceService;

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatch(String fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        ArrayList result = Lists.newArrayList();
        return result;
    }

    @Override
    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkState((boolean)TuttiEntities.isNew(bean));
        bean.setId(UUID.randomUUID().toString());
        return bean;
    }

    @Override
    public IndividualObservationBatch saveIndividualObservationBatch(IndividualObservationBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkState((!TuttiEntities.isNew(bean) ? 1 : 0) != 0);
        return bean;
    }

    @Override
    public void deleteIndividualObservationBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.attachmentPersistenceService.deleteAllAttachment(Integer.valueOf(id));
    }
}

