/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStore
implements Store {
    private transient List<StoreListener> listenerList;

    protected synchronized List<StoreListener> getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<StoreListener>();
        }
        return this.listenerList;
    }

    @Override
    public boolean isCacheCoherent() {
        return false;
    }

    @Override
    public boolean isClusterCoherent() {
        return false;
    }

    @Override
    public boolean isNodeCoherent() {
        return false;
    }

    @Override
    public void setNodeCoherent(boolean coherent) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void waitUntilClusterCoherent() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void addStoreListener(StoreListener listener) {
        this.removeStoreListener(listener);
        this.getEventListenerList().add(listener);
    }

    @Override
    public synchronized void removeStoreListener(StoreListener listener) {
        this.getEventListenerList().remove(listener);
    }

    public void fireNodeCoherent(boolean nodeCoherent) {
        List<StoreListener> listeners = this.getEventListenerList();
        for (StoreListener listener : listeners) {
            listener.nodeCoherent(nodeCoherent);
        }
    }

    public void fireClusterCoherent(boolean clusterCoherent) {
        List<StoreListener> listeners = this.getEventListenerList();
        for (StoreListener listener : listeners) {
            listener.clusterCoherent(clusterCoherent);
        }
    }
}

