/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics.sampled;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.util.FailSafeTimer;
import net.sf.ehcache.util.counter.CounterConfig;
import net.sf.ehcache.util.counter.CounterManager;
import net.sf.ehcache.util.counter.CounterManagerImpl;
import net.sf.ehcache.util.counter.sampled.SampledCounter;
import net.sf.ehcache.util.counter.sampled.SampledCounterConfig;
import net.sf.ehcache.util.counter.sampled.SampledRateCounter;
import net.sf.ehcache.util.counter.sampled.SampledRateCounterConfig;

public class SampledCacheStatisticsImpl
implements CacheUsageListener,
SampledCacheStatistics {
    private static final int DEFAULT_HISTORY_SIZE = 30;
    private static final int DEFAULT_INTERVAL_SECS = 1;
    private static final SampledCounterConfig DEFAULT_SAMPLED_COUNTER_CONFIG = new SampledCounterConfig(1, 30, true, 0L);
    private static final SampledRateCounterConfig DEFAULT_SAMPLED_RATE_COUNTER_CONFIG = new SampledRateCounterConfig(1, 30, true);
    private volatile CounterManager counterManager;
    private final SampledCounter cacheHitCount;
    private final SampledCounter cacheHitInMemoryCount;
    private final SampledCounter cacheHitOffHeapCount;
    private final SampledCounter cacheHitOnDiskCount;
    private final SampledCounter cacheMissCount;
    private final SampledCounter cacheMissInMemoryCount;
    private final SampledCounter cacheMissOffHeapCount;
    private final SampledCounter cacheMissOnDiskCount;
    private final SampledCounter cacheMissExpiredCount;
    private final SampledCounter cacheMissNotFoundCount;
    private final SampledCounter cacheElementEvictedCount;
    private final SampledCounter cacheElementRemoved;
    private final SampledCounter cacheElementExpired;
    private final SampledCounter cacheElementPut;
    private final SampledCounter cacheElementUpdated;
    private final SampledRateCounter averageGetTime;
    private final AtomicBoolean sampledStatisticsEnabled;
    private final AtomicInteger statisticsAccuracy;

    public SampledCacheStatisticsImpl(FailSafeTimer timer) {
        this.counterManager = new CounterManagerImpl(timer);
        this.cacheHitCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheHitInMemoryCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheHitOffHeapCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheHitOnDiskCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheMissCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheMissInMemoryCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheMissOffHeapCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheMissOnDiskCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheMissExpiredCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheMissNotFoundCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheElementEvictedCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheElementRemoved = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheElementExpired = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheElementPut = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.cacheElementUpdated = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
        this.averageGetTime = (SampledRateCounter)this.createSampledCounter(DEFAULT_SAMPLED_RATE_COUNTER_CONFIG);
        this.sampledStatisticsEnabled = new AtomicBoolean(true);
        this.statisticsAccuracy = new AtomicInteger(1);
    }

    private SampledCounter createSampledCounter(CounterConfig defaultCounterConfig) {
        return (SampledCounter)this.counterManager.createCounter(defaultCounterConfig);
    }

    private void incrementIfStatsEnabled(SampledCounter ... counters) {
        if (!this.sampledStatisticsEnabled.get()) {
            return;
        }
        for (SampledCounter counter : counters) {
            counter.increment();
        }
    }

    public void clearStatistics() {
        this.cacheHitCount.getAndReset();
        this.cacheHitInMemoryCount.getAndReset();
        this.cacheHitOffHeapCount.getAndReset();
        this.cacheHitOnDiskCount.getAndReset();
        this.cacheMissCount.getAndReset();
        this.cacheMissInMemoryCount.getAndReset();
        this.cacheMissOffHeapCount.getAndReset();
        this.cacheMissOnDiskCount.getAndReset();
        this.cacheMissExpiredCount.getAndReset();
        this.cacheMissNotFoundCount.getAndReset();
        this.cacheElementEvictedCount.getAndReset();
        this.cacheElementRemoved.getAndReset();
        this.cacheElementExpired.getAndReset();
        this.cacheElementPut.getAndReset();
        this.cacheElementUpdated.getAndReset();
        this.averageGetTime.setValue(0L, 1L);
    }

    public void notifyCacheElementEvicted() {
        this.incrementIfStatsEnabled(this.cacheElementEvictedCount);
    }

    public void notifyCacheHitInMemory() {
        this.incrementIfStatsEnabled(this.cacheHitCount, this.cacheHitInMemoryCount);
    }

    public void notifyCacheHitOffHeap() {
        this.incrementIfStatsEnabled(this.cacheHitCount, this.cacheHitOffHeapCount);
    }

    public void notifyCacheHitOnDisk() {
        this.incrementIfStatsEnabled(this.cacheHitCount, this.cacheHitOnDiskCount);
    }

    public void notifyCacheMissedWithExpired() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissExpiredCount);
    }

    public void notifyCacheMissedWithNotFound() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissNotFoundCount);
    }

    public void notifyCacheMissInMemory() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissInMemoryCount);
    }

    public void notifyCacheMissOffHeap() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissOffHeapCount);
    }

    public void notifyCacheMissOnDisk() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissOnDiskCount);
    }

    public void dispose() {
        this.counterManager.shutdown();
    }

    public void notifyCacheElementExpired() {
        this.incrementIfStatsEnabled(this.cacheElementExpired);
    }

    public void notifyCacheElementPut() throws CacheException {
        this.incrementIfStatsEnabled(this.cacheElementPut);
    }

    public void notifyCacheElementRemoved() throws CacheException {
        this.incrementIfStatsEnabled(this.cacheElementRemoved);
    }

    public void notifyCacheElementUpdated() throws CacheException {
        this.incrementIfStatsEnabled(this.cacheElementUpdated);
    }

    public void notifyTimeTakenForGet(long millis) {
        if (!this.sampledStatisticsEnabled.get()) {
            return;
        }
        this.averageGetTime.increment(millis, 1L);
    }

    public void notifyRemoveAll() {
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }

    public void notifyStatisticsEnabledChanged(boolean enableStatistics) {
        if (!enableStatistics) {
            this.sampledStatisticsEnabled.set(false);
        }
    }

    public void notifyStatisticsAccuracyChanged(int statisticsAccuracyValue) {
        if (Statistics.isValidStatisticsAccuracy(statisticsAccuracyValue)) {
            this.statisticsAccuracy.set(statisticsAccuracyValue);
            return;
        }
        throw new IllegalArgumentException("Invalid statistics accuracy value: " + statisticsAccuracyValue);
    }

    public void notifyStatisticsCleared() {
        this.cacheHitCount.getAndReset();
        this.cacheHitInMemoryCount.getAndReset();
        this.cacheHitOffHeapCount.getAndReset();
        this.cacheHitOnDiskCount.getAndReset();
        this.cacheMissCount.getAndReset();
        this.cacheMissInMemoryCount.getAndReset();
        this.cacheMissOffHeapCount.getAndReset();
        this.cacheMissOnDiskCount.getAndReset();
        this.cacheMissExpiredCount.getAndReset();
        this.cacheMissNotFoundCount.getAndReset();
        this.cacheElementEvictedCount.getAndReset();
        this.cacheElementRemoved.getAndReset();
        this.cacheElementExpired.getAndReset();
        this.cacheElementPut.getAndReset();
        this.cacheElementUpdated.getAndReset();
        this.averageGetTime.getAndReset();
    }

    public long getCacheHitMostRecentSample() {
        return this.cacheHitCount.getMostRecentSample().getCounterValue();
    }

    public long getAverageGetTimeMostRecentSample() {
        return this.averageGetTime.getMostRecentSample().getCounterValue();
    }

    public long getCacheElementEvictedMostRecentSample() {
        return this.cacheElementEvictedCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheHitInMemoryMostRecentSample() {
        return this.cacheHitInMemoryCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheHitOffHeapMostRecentSample() {
        return this.cacheHitOffHeapCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheHitOnDiskMostRecentSample() {
        return this.cacheHitOnDiskCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheMissExpiredMostRecentSample() {
        return this.cacheMissExpiredCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheMissMostRecentSample() {
        return this.cacheMissCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheMissInMemoryMostRecentSample() {
        return this.cacheMissInMemoryCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheMissOffHeapMostRecentSample() {
        return this.cacheMissOffHeapCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheMissOnDiskMostRecentSample() {
        return this.cacheMissOnDiskCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheMissNotFoundMostRecentSample() {
        return this.cacheMissNotFoundCount.getMostRecentSample().getCounterValue();
    }

    public long getCacheElementExpiredMostRecentSample() {
        return this.cacheElementExpired.getMostRecentSample().getCounterValue();
    }

    public long getCacheElementPutMostRecentSample() {
        return this.cacheElementPut.getMostRecentSample().getCounterValue();
    }

    public long getCacheElementRemovedMostRecentSample() {
        return this.cacheElementRemoved.getMostRecentSample().getCounterValue();
    }

    public long getCacheElementUpdatedMostRecentSample() {
        return this.cacheElementUpdated.getMostRecentSample().getCounterValue();
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy.get();
    }

    public String getStatisticsAccuracyDescription() {
        int value = this.statisticsAccuracy.get();
        if (value == 0) {
            return "None";
        }
        if (value == 1) {
            return "Best Effort";
        }
        return "Guaranteed";
    }

    public boolean isSampledStatisticsEnabled() {
        return this.sampledStatisticsEnabled.get();
    }
}

