/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;

public class HibernateConnectionProvider
implements ConnectionProvider {
    private static DataSource dataSource = null;

    public void configure(Properties props) throws HibernateException {
        if (dataSource == null) {
            throw new HibernateException("DataSource must be set before using ConnectionProvider.");
        }
    }

    public Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
    }

    public void close() throws HibernateException {
        dataSource = null;
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public static DataSource getDataSource() {
        return dataSource;
    }

    public static void setDataSource(DataSource dataSource) {
        HibernateConnectionProvider.dataSource = dataSource;
    }
}

