/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class BenthosBatchRowModel
extends AbstractTuttiBeanUIModel<BenthosBatch, BenthosBatchRowModel>
implements BenthosBatch,
AttachmentModelAware {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPECIES_TO_CONFIRM = "speciesToConfirm";
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SORTED_UNSORTED_CATEGORY = "sortedUnsortedCategory";
    public static final String PROPERTY_SORTED_UNSORTED_CATEGORY_VALUE = "sortedUnsortedCategoryValue";
    public static final String PROPERTY_SORTED_UNSORTED_CATEGORY_WEIGHT = "sortedUnsortedCategoryWeight";
    public static final String PROPERTY_SORTED_UNSORTED_CATEGORY_COMPUTED_WEIGHT = "sortedUnsortedComputedWeight";
    public static final String PROPERTY_SIZE_CATEGORY = "sizeCategory";
    public static final String PROPERTY_SIZE_CATEGORY_VALUE = "sizeCategoryValue";
    public static final String PROPERTY_SIZE_CATEGORY_WEIGHT = "sizeCategoryWeight";
    public static final String PROPERTY_SIZE_CATEGORY_COMPUTED_WEIGHT = "sexCategoryComputedWeight";
    public static final String PROPERTY_SEX_CATEGORY = "sexCategory";
    public static final String PROPERTY_SEX_CATEGORY_VALUE = "sexCategoryValue";
    public static final String PROPERTY_SEX_CATEGORY_WEIGHT = "sexCategoryWeight";
    public static final String PROPERTY_SEX_CATEGORY_COMPUTED_WEIGHT = "sexCategoryComputedWeight";
    public static final String PROPERTY_MATURITY_CATEGORY = "maturityCategory";
    public static final String PROPERTY_MATURITY_CATEGORY_VALUE = "maturityCategoryValue";
    public static final String PROPERTY_MATURITY_CATEGORY_COMPUTED_WEIGHT = "maturityCategoryComputedWeight";
    public static final String PROPERTY_MATURITY_CATEGORY_WEIGHT = "maturityCategoryWeight";
    public static final String PROPERTY_AGE_CATEGORY = "ageCategory";
    public static final String PROPERTY_AGE_CATEGORY_VALUE = "ageCategoryValue";
    public static final String PROPERTY_AGE_CATEGORY_COMPUTED_WEIGHT = "ageCategoryComputedWeight";
    public static final String PROPERTY_AGE_CATEGORY_WEIGHT = "ageCategoryWeight";
    public static final String PROPERTY_WEIGHT = "weight";
    public static final String PROPERTY_NUMBER = "number";
    public static final String PROPERTY_FREQUENCY = "frequency";
    public static final String PROPERTY_COMPUTED_NUMBER = "computedOrNotNumber";
    public static final String PROPERTY_COMPUTED_WEIGHT = "computedOrNotWeight";
    public static final String PROPERTY_PARENT_BATCH = "parentBatch";
    public static final String PROPERTY_CHILD_BATCH = "childBatch";
    public static final String PROPERTY_BATCH_LEAF = "batchLeaf";
    public static final String PROPERTY_BATCH_ROOT = "batchRoot";
    public static final String PROPERTY_SAMPLE_CATEGORY = "sampleCategory";
    protected Species species;
    protected SampleCategory<CaracteristicQualitativeValue> sortedUnsortedCategory;
    protected SampleCategory<CaracteristicQualitativeValue> sizeCategory;
    protected SampleCategory<CaracteristicQualitativeValue> sexCategory;
    protected SampleCategory<CaracteristicQualitativeValue> maturityCategory;
    protected SampleCategory<Float> ageCategory;
    private SampleCategory<?> sampleCategory;
    protected boolean speciesToConfirm;
    protected TuttiComputedOrNotData<Float> computedOrNotWeight = new TuttiComputedOrNotData();
    protected TuttiComputedOrNotData<Integer> computedOrNotNumber = new TuttiComputedOrNotData();
    protected String comment;
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected List<BenthosFrequencyRowModel> frequency = Lists.newArrayList();
    protected BenthosBatchRowModel parentBatch;
    protected List<BenthosBatchRowModel> childBatch;
    protected static final Binder<BenthosBatch, BenthosBatchRowModel> fromBeanBinder = BinderFactory.newBinder(BenthosBatch.class, BenthosBatchRowModel.class);
    protected static final Binder<BenthosBatchRowModel, BenthosBatch> toBeanBinder = BinderFactory.newBinder(BenthosBatchRowModel.class, BenthosBatch.class);

    public BenthosBatchRowModel() {
        super(BenthosBatch.class, fromBeanBinder, toBeanBinder);
        this.sortedUnsortedCategory = SampleCategory.newSample(SampleCategoryEnum.sortedUnsorted);
        this.sizeCategory = SampleCategory.newSample(SampleCategoryEnum.size);
        this.sexCategory = SampleCategory.newSample(SampleCategoryEnum.sex);
        this.maturityCategory = SampleCategory.newSample(SampleCategoryEnum.maturity);
        this.ageCategory = SampleCategory.newSample(SampleCategoryEnum.age);
        this.computedOrNotWeight.addPropagateListener(PROPERTY_WEIGHT, this);
        this.computedOrNotWeight.addPropagateListener(PROPERTY_COMPUTED_WEIGHT, this);
        this.computedOrNotNumber.addPropagateListener(PROPERTY_NUMBER, this);
        this.computedOrNotNumber.addPropagateListener(PROPERTY_COMPUTED_NUMBER, this);
    }

    public BenthosBatchRowModel(BenthosBatch aBatch, List<BenthosBatchFrequency> frequencies, List<Attachment> attachments) {
        this();
        this.fromBean(aBatch);
        List<BenthosFrequencyRowModel> frequencyRows = BenthosFrequencyRowModel.fromBeans(frequencies);
        this.frequency.addAll(frequencyRows);
        this.attachment.addAll(attachments);
        Collections.sort(this.frequency);
    }

    @Override
    protected BenthosBatch newEntity() {
        return TuttiBeanFactory.newBenthosBatch();
    }

    public SampleCategory<?> getSampleCategory() {
        return this.sampleCategory;
    }

    public void setSampleCategory(SampleCategory<?> sampleCategory) {
        SampleCategory<?> oldValue = this.getSampleCategory();
        this.sampleCategory = sampleCategory;
        this.firePropertyChange(PROPERTY_SAMPLE_CATEGORY, oldValue, sampleCategory);
    }

    public SampleCategory<?> getSampleCategory(SampleCategoryEnum sampleCategoryEnum) {
        switch (sampleCategoryEnum) {
            case sortedUnsorted: {
                this.sampleCategory = this.getSortedUnsortedCategory();
                break;
            }
            case size: {
                this.sampleCategory = this.getSizeCategory();
                break;
            }
            case sex: {
                this.sampleCategory = this.getSexCategory();
                break;
            }
            case maturity: {
                this.sampleCategory = this.getMaturityCategory();
                break;
            }
            case age: {
                this.sampleCategory = this.getAgeCategory();
                break;
            }
        }
        return this.sampleCategory;
    }

    public SampleCategory getFinestCategory() {
        SampleCategory<Serializable> finestCategory = this.ageCategory.isValid() ? this.ageCategory : (this.maturityCategory.isValid() ? this.maturityCategory : (this.sexCategory.isValid() ? this.sexCategory : (this.sizeCategory.isValid() ? this.sizeCategory : this.sortedUnsortedCategory)));
        return finestCategory;
    }

    @Override
    public Species getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(Species species) {
        Species oldCategory = this.getSpecies();
        this.species = species;
        this.firePropertyChange(PROPERTY_SPECIES, oldCategory, species);
    }

    public SampleCategory<CaracteristicQualitativeValue> getSortedUnsortedCategory() {
        return this.sortedUnsortedCategory;
    }

    public void setSortedUnsortedCategory(SampleCategory<CaracteristicQualitativeValue> sortedUnsortedCategory) {
        SampleCategory<CaracteristicQualitativeValue> oldCategory = this.getSortedUnsortedCategory();
        CaracteristicQualitativeValue oldValue = this.getSortedUnsortedCategoryValue();
        Float oldWeight = this.getSortedUnsortedCategoryWeight();
        Float oldComputedWeight = this.getSortedUnsortedCategoryComputedWeight();
        this.sortedUnsortedCategory = sortedUnsortedCategory;
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY, oldCategory, sortedUnsortedCategory);
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY_VALUE, oldValue, this.getSortedUnsortedCategoryValue());
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY_WEIGHT, oldWeight, this.getSortedUnsortedCategoryWeight());
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY_COMPUTED_WEIGHT, oldComputedWeight, this.getSortedUnsortedCategoryComputedWeight());
    }

    public CaracteristicQualitativeValue getSortedUnsortedCategoryValue() {
        return this.sortedUnsortedCategory.getCategoryValue();
    }

    public Float getSortedUnsortedCategoryWeight() {
        return this.sortedUnsortedCategory.getCategoryWeight();
    }

    public void setSortedUnsortedCategoryWeight(Float sortedUnsortedCategoryWeight) {
        Float oldValue = this.getSortedUnsortedCategoryWeight();
        this.sortedUnsortedCategory.setCategoryWeight(sortedUnsortedCategoryWeight);
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY_WEIGHT, oldValue, sortedUnsortedCategoryWeight);
    }

    public Float getSortedUnsortedCategoryComputedWeight() {
        return this.sortedUnsortedCategory.getComputedWeight();
    }

    public void setSortedUnsortedCategoryComputedWeight(Float sortedUnsortedCategoryComputedWeight) {
        Float oldValue = this.getSortedUnsortedCategoryComputedWeight();
        this.sortedUnsortedCategory.setComputedWeight(sortedUnsortedCategoryComputedWeight);
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY_COMPUTED_WEIGHT, oldValue, sortedUnsortedCategoryComputedWeight);
    }

    public SampleCategory<CaracteristicQualitativeValue> getSizeCategory() {
        return this.sizeCategory;
    }

    public void setSizeCategory(SampleCategory<CaracteristicQualitativeValue> sizeCategory) {
        SampleCategory<CaracteristicQualitativeValue> oldCategory = this.getSizeCategory();
        CaracteristicQualitativeValue oldValue = this.getSizeCategoryValue();
        Float oldWeight = this.getSizeCategoryWeight();
        Float oldComputedWeight = this.getSizeCategoryComputedWeight();
        this.sizeCategory = sizeCategory;
        this.firePropertyChange(PROPERTY_SIZE_CATEGORY, oldCategory, sizeCategory);
        this.firePropertyChange(PROPERTY_SIZE_CATEGORY_VALUE, oldValue, this.getSizeCategoryValue());
        this.firePropertyChange(PROPERTY_SIZE_CATEGORY_WEIGHT, oldWeight, this.getSizeCategoryWeight());
        this.firePropertyChange("sexCategoryComputedWeight", oldComputedWeight, this.getSizeCategoryComputedWeight());
    }

    public CaracteristicQualitativeValue getSizeCategoryValue() {
        return this.sizeCategory.getCategoryValue();
    }

    public Float getSizeCategoryWeight() {
        return this.sizeCategory.getCategoryWeight();
    }

    public void setSizeCategoryWeight(Float sizeCategoryWeight) {
        Float oldValue = this.getSizeCategoryWeight();
        this.sizeCategory.setCategoryWeight(sizeCategoryWeight);
        this.firePropertyChange(PROPERTY_SIZE_CATEGORY_WEIGHT, oldValue, sizeCategoryWeight);
    }

    public Float getSizeCategoryComputedWeight() {
        return this.sizeCategory.getComputedWeight();
    }

    public void setSizeCategoryComputedWeight(Float sizeCategoryComputedWeight) {
        Float oldValue = this.getSizeCategoryComputedWeight();
        this.sizeCategory.setComputedWeight(sizeCategoryComputedWeight);
        this.firePropertyChange("sexCategoryComputedWeight", oldValue, sizeCategoryComputedWeight);
    }

    public SampleCategory<CaracteristicQualitativeValue> getSexCategory() {
        return this.sexCategory;
    }

    public void setSexCategory(SampleCategory<CaracteristicQualitativeValue> sexCategory) {
        SampleCategory<CaracteristicQualitativeValue> oldCategory = this.getSexCategory();
        CaracteristicQualitativeValue oldValue = this.getSexCategoryValue();
        Float oldWeight = this.getSexCategoryWeight();
        Float oldComputedWeight = this.getSexCategoryComputedWeight();
        this.sexCategory = sexCategory;
        this.firePropertyChange(PROPERTY_SEX_CATEGORY, oldCategory, sexCategory);
        this.firePropertyChange(PROPERTY_SEX_CATEGORY_VALUE, oldValue, this.getSexCategoryValue());
        this.firePropertyChange(PROPERTY_SEX_CATEGORY_WEIGHT, oldWeight, this.getSexCategoryWeight());
        this.firePropertyChange("sexCategoryComputedWeight", oldComputedWeight, this.getSexCategoryComputedWeight());
    }

    public CaracteristicQualitativeValue getSexCategoryValue() {
        return this.sexCategory.getCategoryValue();
    }

    public Float getSexCategoryWeight() {
        return this.sexCategory.getCategoryWeight();
    }

    public void setSexCategoryWeight(Float sexCategoryWeight) {
        Float oldValue = this.getSexCategoryWeight();
        this.sexCategory.setCategoryWeight(sexCategoryWeight);
        this.firePropertyChange(PROPERTY_SEX_CATEGORY_WEIGHT, oldValue, sexCategoryWeight);
    }

    public Float getSexCategoryComputedWeight() {
        return this.sexCategory.getComputedWeight();
    }

    public void setSexCategoryComputedWeight(Float sexCategoryComputedWeight) {
        Float oldValue = this.getSexCategoryComputedWeight();
        this.sexCategory.setComputedWeight(sexCategoryComputedWeight);
        this.firePropertyChange("sexCategoryComputedWeight", oldValue, sexCategoryComputedWeight);
    }

    public SampleCategory<CaracteristicQualitativeValue> getMaturityCategory() {
        return this.maturityCategory;
    }

    public void setMaturityCategory(SampleCategory<CaracteristicQualitativeValue> maturityCategory) {
        SampleCategory<CaracteristicQualitativeValue> oldCategory = this.getMaturityCategory();
        CaracteristicQualitativeValue oldValue = this.getMaturityCategoryValue();
        Float oldWeight = this.getMaturityCategoryWeight();
        Float oldComputedWeight = this.getMaturityCategoryComputedWeight();
        this.maturityCategory = maturityCategory;
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY, oldCategory, maturityCategory);
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY_VALUE, oldValue, this.getMaturityCategoryValue());
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY_WEIGHT, oldWeight, this.getMaturityCategoryWeight());
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY_COMPUTED_WEIGHT, oldComputedWeight, this.getMaturityCategoryComputedWeight());
    }

    public CaracteristicQualitativeValue getMaturityCategoryValue() {
        return this.maturityCategory.getCategoryValue();
    }

    public Float getMaturityCategoryWeight() {
        return this.maturityCategory.getCategoryWeight();
    }

    public void setMaturityCategoryWeight(Float maturityCategoryWeight) {
        Float oldValue = this.getMaturityCategoryWeight();
        this.maturityCategory.setCategoryWeight(maturityCategoryWeight);
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY_WEIGHT, oldValue, maturityCategoryWeight);
    }

    public Float getMaturityCategoryComputedWeight() {
        return this.maturityCategory.getComputedWeight();
    }

    public void setMaturityCategoryComputedWeight(Float maturityCategoryComputedWeight) {
        Float oldValue = this.getMaturityCategoryComputedWeight();
        this.maturityCategory.setComputedWeight(maturityCategoryComputedWeight);
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY_COMPUTED_WEIGHT, oldValue, maturityCategoryComputedWeight);
    }

    public SampleCategory<Float> getAgeCategory() {
        return this.ageCategory;
    }

    public void setAgeCategory(SampleCategory<Float> ageCategory) {
        SampleCategory<Float> oldCategory = this.getAgeCategory();
        Float oldValue = this.getAgeCategoryValue();
        Float oldWeight = this.getAgeCategoryWeight();
        Float oldComputedWeight = this.getAgeCategoryComputedWeight();
        this.ageCategory = ageCategory;
        this.firePropertyChange(PROPERTY_AGE_CATEGORY, oldCategory, ageCategory);
        this.firePropertyChange(PROPERTY_AGE_CATEGORY_VALUE, oldValue, this.getAgeCategoryValue());
        this.firePropertyChange(PROPERTY_AGE_CATEGORY_WEIGHT, oldWeight, this.getAgeCategoryWeight());
        this.firePropertyChange(PROPERTY_AGE_CATEGORY_COMPUTED_WEIGHT, oldComputedWeight, this.getAgeCategoryComputedWeight());
    }

    public Float getAgeCategoryValue() {
        return this.ageCategory.getCategoryValue();
    }

    public Float getAgeCategoryWeight() {
        return this.ageCategory.getCategoryWeight();
    }

    public void setAgeCategoryWeight(Float ageCategoryWeight) {
        Float oldValue = this.getAgeCategoryWeight();
        this.ageCategory.setCategoryWeight(ageCategoryWeight);
        this.firePropertyChange(PROPERTY_AGE_CATEGORY_WEIGHT, oldValue, ageCategoryWeight);
    }

    public Float getAgeCategoryComputedWeight() {
        return this.ageCategory.getComputedWeight();
    }

    public void setAgeCategoryComputedWeight(Float ageCategoryComputedWeight) {
        Float oldValue = this.getAgeCategoryComputedWeight();
        this.ageCategory.setComputedWeight(ageCategoryComputedWeight);
        this.firePropertyChange(PROPERTY_AGE_CATEGORY_COMPUTED_WEIGHT, oldValue, ageCategoryComputedWeight);
    }

    @Override
    public BenthosBatchRowModel getParentBatch() {
        return this.parentBatch;
    }

    public void setParentBatch(BenthosBatchRowModel parentBatch) {
        BenthosBatchRowModel oldValue = this.getParentBatch();
        this.parentBatch = parentBatch;
        this.firePropertyChange(PROPERTY_PARENT_BATCH, oldValue, parentBatch);
        this.firePropertyChange(PROPERTY_BATCH_ROOT, null, this.isBatchRoot());
    }

    public List<BenthosBatchRowModel> getChildBatch() {
        return this.childBatch;
    }

    public void setChildBatch(List<BenthosBatchRowModel> childBatch) {
        this.childBatch = childBatch;
        this.firePropertyChange(PROPERTY_CHILD_BATCH, null, childBatch);
        this.firePropertyChange(PROPERTY_BATCH_LEAF, null, this.isBatchLeaf());
    }

    public boolean isBatchLeaf() {
        return CollectionUtils.isEmpty(this.childBatch);
    }

    public boolean isBatchRoot() {
        return this.parentBatch == null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.SAMPLE;
    }

    @Override
    public String getObjectId() {
        return this.getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public boolean isSpeciesToConfirm() {
        return this.speciesToConfirm;
    }

    @Override
    public void setSpeciesToConfirm(boolean speciesToConfirm) {
        Boolean oldValue = this.isSpeciesToConfirm();
        this.speciesToConfirm = speciesToConfirm;
        this.firePropertyChange(PROPERTY_SPECIES_TO_CONFIRM, oldValue, speciesToConfirm);
    }

    @Override
    public Float getWeight() {
        return this.computedOrNotWeight.getData();
    }

    @Override
    public void setWeight(Float weight) {
        this.computedOrNotWeight.setData(weight);
    }

    @Override
    public Integer getNumber() {
        return this.computedOrNotNumber.getData();
    }

    @Override
    public void setNumber(Integer number) {
        this.computedOrNotNumber.setData(number);
    }

    public List<BenthosFrequencyRowModel> getFrequency() {
        return this.frequency;
    }

    public void setFrequency(List<BenthosFrequencyRowModel> frequency) {
        this.frequency = frequency;
        this.firePropertyChange(PROPERTY_FREQUENCY, null, frequency);
    }

    @Override
    public Integer getComputedNumber() {
        return this.computedOrNotNumber.getComputedData();
    }

    @Override
    public void setComputedNumber(Integer computedNumber) {
        this.computedOrNotNumber.setComputedData(computedNumber);
    }

    @Override
    public Float getComputedWeight() {
        return this.computedOrNotWeight.getComputedData();
    }

    @Override
    public void setComputedWeight(Float computedWeight) {
        this.computedOrNotWeight.setComputedData(computedWeight);
    }

    public TuttiComputedOrNotData<Integer> getComputedOrNotNumber() {
        return this.computedOrNotNumber;
    }

    public void setComputedOrNotNumber(TuttiComputedOrNotData<Integer> computedOrNotNumber) {
        this.computedOrNotNumber = computedOrNotNumber;
    }

    public TuttiComputedOrNotData<Float> getComputedOrNotWeight() {
        return this.computedOrNotWeight;
    }

    public void setComputedOrNotWeight(TuttiComputedOrNotData<Float> computedOrNotWeight) {
        this.computedOrNotWeight = computedOrNotWeight;
    }

    @Override
    public SampleCategoryEnum getSampleCategoryType() {
        return null;
    }

    @Override
    public void setSampleCategoryType(SampleCategoryEnum sampleCategoryType) {
    }

    @Override
    public Serializable getSampleCategoryValue() {
        return null;
    }

    @Override
    public void setSampleCategoryValue(Serializable sampleCategoryValue) {
    }

    @Override
    public Float getSampleCategoryWeight() {
        return null;
    }

    @Override
    public void setSampleCategoryWeight(Float sampleCategoryWeight) {
    }

    @Override
    public Float getSampleCategoryComputedWeight() {
        return null;
    }

    @Override
    public void setSampleCategoryComputedWeight(Float sampleCategoryComputedWeight) {
    }

    @Override
    public BenthosBatch getChildBatchs(int index) {
        return null;
    }

    @Override
    public boolean isChildBatchsEmpty() {
        return false;
    }

    @Override
    public int sizeChildBatchs() {
        return 0;
    }

    @Override
    public void addChildBatchs(BenthosBatch childBatchs) {
    }

    @Override
    public void addAllChildBatchs(Collection<BenthosBatch> childBatchs) {
    }

    @Override
    public boolean removeChildBatchs(BenthosBatch childBatchs) {
        return false;
    }

    @Override
    public boolean removeAllChildBatchs(Collection<BenthosBatch> childBatchs) {
        return false;
    }

    @Override
    public boolean containsChildBatchs(BenthosBatch childBatchs) {
        return false;
    }

    @Override
    public boolean containsAllChildBatchs(Collection<BenthosBatch> childBatchs) {
        return false;
    }

    @Override
    public List<BenthosBatch> getChildBatchs() {
        return null;
    }

    @Override
    public void setChildBatchs(List<BenthosBatch> childBatchs) {
    }

    @Override
    public void setParentBatch(BenthosBatch parentBatch) {
    }

    @Override
    public FishingOperation getFishingOperation() {
        return null;
    }

    @Override
    public void setFishingOperation(FishingOperation fishingOperation) {
    }

    public void collectShell(Set<BenthosBatchRowModel> collectedRows) {
        if (!this.isBatchLeaf()) {
            for (BenthosBatchRowModel batchChild : this.getChildBatch()) {
                collectedRows.add(batchChild);
                batchChild.collectShell(collectedRows);
            }
        }
    }

    public BenthosBatchRowModel getFirstAncestor(SampleCategory<?> entrySampleCategory) {
        BenthosBatchRowModel parentBatch;
        SampleCategory<?> parentSampleCategory;
        BenthosBatchRowModel result = this;
        if (this.getParentBatch() != null && ObjectUtils.equals(entrySampleCategory, parentSampleCategory = (parentBatch = this.getParentBatch()).getSampleCategory(entrySampleCategory.getCategoryType()))) {
            result = parentBatch.getFirstAncestor(entrySampleCategory);
        }
        return result;
    }
}

