/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SexEnum;
import fr.ifremer.tutti.persistence.entities.data.SizeEnum;
import fr.ifremer.tutti.persistence.entities.data.SortedUnsortedEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.pupitri.CarrouselRow;
import fr.ifremer.tutti.service.pupitri.CarrouselRowModel;
import fr.ifremer.tutti.service.pupitri.PupitriCatch;
import fr.ifremer.tutti.service.pupitri.SpeciesRow;
import fr.ifremer.tutti.service.pupitri.SpeciesRowModel;
import fr.ifremer.tutti.service.pupitri.TrunkRow;
import fr.ifremer.tutti.service.pupitri.TrunkRowModel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.csv.Export;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.Import;
import org.nuiton.util.csv.ImportModel;

public class TuttiPupitriImportExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(TuttiPupitriImportExportService.class);
    protected PersistenceService persistenceService;
    protected TuttiDataContext dataContext;
    protected CaracteristicQualitativeValue sortedCaracteristic;
    protected CaracteristicQualitativeValue unsortedCaracteristic;
    protected CaracteristicQualitativeValue maleCaracteristic;
    protected CaracteristicQualitativeValue femaleCaracteristic;
    protected CaracteristicQualitativeValue smallCaracteristic;
    protected CaracteristicQualitativeValue mediumCaracteristic;
    protected CaracteristicQualitativeValue bigCaracteristic;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.dataContext = context.getDataContext();
        Caracteristic sortedUnsortedcaracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        this.sortedCaracteristic = SortedUnsortedEnum.SORTED.getValue(sortedUnsortedcaracteristic);
        this.unsortedCaracteristic = SortedUnsortedEnum.UNSORTED.getValue(sortedUnsortedcaracteristic);
        Caracteristic sexCaracteristic = this.persistenceService.getSexCaracteristic();
        this.maleCaracteristic = SexEnum.MALE.getValue(sexCaracteristic);
        this.femaleCaracteristic = SexEnum.FEMALE.getValue(sexCaracteristic);
        Caracteristic sizeCaracteristic = this.persistenceService.getSizeCategoryCaracteristic();
        this.smallCaracteristic = SizeEnum.SMALL.getValue(sizeCaracteristic);
        this.mediumCaracteristic = SizeEnum.MEDIUM.getValue(sizeCaracteristic);
        this.bigCaracteristic = SizeEnum.BIG.getValue(sizeCaracteristic);
    }

    public int importPupitri(File trunkFile, File carrouselFile, FishingOperation operation, CatchBatch catchBatch) {
        this.importPupitriTrunk(trunkFile, operation, catchBatch);
        int result = this.importPupitriCarrousel(carrouselFile, operation, catchBatch);
        this.addFileAsAttachment(trunkFile, catchBatch);
        this.addFileAsAttachment(carrouselFile, catchBatch);
        this.persistenceService.saveCatchBatch(catchBatch);
        return result;
    }

    protected void addFileAsAttachment(File f, CatchBatch catchBatch) {
        Attachment attachment = TuttiBeanFactory.newAttachment();
        attachment.setObjectType(AttachementObjectTypeEnum.CATCH_BATCH);
        attachment.setObjectId(Integer.valueOf(catchBatch.getId()));
        attachment.setName(f.getName());
        attachment.setComment("import pupitri");
        this.persistenceService.createAttachment(attachment, f);
    }

    protected void importPupitriTrunk(File file, FishingOperation operation, CatchBatch catchBatch) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import pupitri operation [" + operation.toString() + "] trunk from file: " + file));
        }
        char separator = ',';
        TrunkRowModel csvModel = new TrunkRowModel(separator);
        BufferedReader reader = null;
        File fileWithHeaders = null;
        Import importer = null;
        try {
            fileWithHeaders = new File(FileUtils.getTempDirectory(), file.getName());
            String headers = "fileOrigin" + separator + "date" + separator + "time" + separator + "balanceId" + separator + "sign" + separator + "operationCode" + separator + "rigNumber" + separator + "direction" + separator + "weight" + separator + "";
            FileUtils.writeLines((File)fileWithHeaders, Collections.singletonList(headers));
            log.info((Object)FileUtils.readFileToString((File)fileWithHeaders));
            FileUtils.writeLines((File)fileWithHeaders, (Collection)FileUtils.readLines((File)file), (boolean)true);
            log.info((Object)FileUtils.readFileToString((File)fileWithHeaders));
            reader = Files.newReader((File)fileWithHeaders, (Charset)Charsets.UTF_8);
            importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            Float sortedWeight = Float.valueOf(0.0f);
            Float rejectedWeight = Float.valueOf(0.0f);
            Integer operationNumber = operation.getFishingOperationNumber();
            String rigNumber = operation.getMultirigAggregation();
            for (TrunkRow bean : importer) {
                if (!bean.getOperationCode().equals(operationNumber) || !bean.getRigNumber().equals(rigNumber)) continue;
                switch (bean.getDirection()) {
                    case VAT: {
                        sortedWeight = Float.valueOf(sortedWeight.floatValue() + bean.getWeight().floatValue());
                        break;
                    }
                    case VNT: {
                        rejectedWeight = Float.valueOf(rejectedWeight.floatValue() + bean.getWeight().floatValue());
                    }
                }
            }
            catchBatch.setCatchTotalSortedTremisWeight(sortedWeight);
            catchBatch.setCatchTotalRejectedWeight(rejectedWeight);
            importer.close();
            ((Reader)reader).close();
        }
        catch (Exception e) {
            try {
                throw new TuttiTechnicalException("Could not import protocol [" + operation.toString() + "] caracteristic from file " + file, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(importer);
                IOUtils.closeQuietly(reader);
                FileUtils.deleteQuietly((File)fileWithHeaders);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)importer);
        IOUtils.closeQuietly((Reader)reader);
        FileUtils.deleteQuietly((File)fileWithHeaders);
    }

    protected int importPupitriCarrousel(File carrouselFile, FishingOperation operation, CatchBatch catchBatch) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import pupitri operation [" + operation.toString() + "] carrousel from file: " + carrouselFile));
        }
        int result = 0;
        BufferedReader reader = null;
        File fileWithHeaders = null;
        Import carrouselImporter = null;
        char carrouselSeparator = ',';
        CarrouselRowModel carrouselCsvModel = new CarrouselRowModel(carrouselSeparator);
        try {
            ArrayListMultimap speciesBySurveyCode = ArrayListMultimap.create();
            speciesBySurveyCode.putAll((Multimap)Multimaps.index(this.dataContext.getReferentSpeciesWithSurveyCode(), (Function)new Function<Species, String>(){

                public String apply(Species input) {
                    String surveyCode = String.valueOf(input.getSurveyCode());
                    int end = Math.min(surveyCode.length(), 7);
                    return surveyCode.substring(0, end);
                }
            }));
            speciesBySurveyCode.putAll(TuttiEntities.splitByRefTaxCode(this.dataContext.getReferentSpecies()));
            String[] header = new String[]{"fileOrigin", "date", "time", "balanceId", "toConfirm", "operationCode", "rigNumber", "boxType", "speciesId", "sign", "direction", "weight"};
            fileWithHeaders = this.createFileWithHeaders(carrouselFile, header, carrouselSeparator);
            reader = Files.newReader((File)fileWithHeaders, (Charset)Charsets.UTF_8);
            carrouselImporter = Import.newImport((ImportModel)carrouselCsvModel, (Reader)reader);
            Integer operationNumber = operation.getFishingOperationNumber();
            String rigNumber = operation.getMultirigAggregation();
            Float carrouselSortedWeight = Float.valueOf(0.0f);
            ArrayList catches = Lists.newArrayList();
            HashSet notFoundSpecies = Sets.newHashSet();
            for (CarrouselRow bean : carrouselImporter) {
                boolean sorted;
                if (!bean.getOperationCode().equals(operationNumber) || !bean.getRigNumber().equals(rigNumber)) continue;
                String speciesId = bean.getSpeciesId();
                List speciesList = speciesBySurveyCode.get((Object)speciesId);
                Float beanWeight = bean.getWeight();
                if (beanWeight.floatValue() < 0.0f) {
                    beanWeight = Float.valueOf(0.0f);
                }
                switch (bean.getDirection()) {
                    case HOV: {
                        sorted = false;
                        break;
                    }
                    default: {
                        sorted = true;
                        carrouselSortedWeight = Float.valueOf(carrouselSortedWeight.floatValue() + beanWeight.floatValue());
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)speciesList)) {
                    Species species = (Species)speciesList.get(0);
                    PupitriCatch pupitriCatch = new PupitriCatch(species, sorted);
                    int catchIndex = catches.indexOf(pupitriCatch);
                    if (catchIndex >= 0) {
                        pupitriCatch = (PupitriCatch)catches.get(catchIndex);
                    } else {
                        catches.add(pupitriCatch);
                    }
                    pupitriCatch.addToSign(bean.getSign(), beanWeight);
                    continue;
                }
                notFoundSpecies.add(speciesId);
            }
            result = notFoundSpecies.size();
            catchBatch.setCatchTotalSortedCarousselWeight(carrouselSortedWeight);
            BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operation.getId());
            for (SpeciesBatch batch : rootSpeciesBatch.getChildren()) {
                this.persistenceService.deleteSpeciesBatch(batch.getId());
            }
            for (PupitriCatch pupitriCatch : catches) {
                Float catchWeight = pupitriCatch.getWeightBySign().get((Object)PupitriCatch.Signs.DEFAULT);
                CaracteristicQualitativeValue cqv = pupitriCatch.isSorted() ? this.sortedCaracteristic : this.unsortedCaracteristic;
                SpeciesBatch batch = TuttiBeanFactory.newSpeciesBatch();
                batch.setFishingOperation(operation);
                batch.setSampleCategoryType(SampleCategoryEnum.sortedUnsorted);
                batch.setSampleCategoryValue((Serializable)cqv);
                batch.setSpecies(pupitriCatch.getSpecies());
                batch.setSampleCategoryWeight(catchWeight);
                batch = this.persistenceService.createSpeciesBatch(batch, null);
                if (catchWeight != null) continue;
                SampleCategoryEnum category = null;
                for (PupitriCatch.Signs s : pupitriCatch.getWeightBySign().keySet()) {
                    CaracteristicQualitativeValue splitCqv = null;
                    switch (s) {
                        case MALE: {
                            splitCqv = this.maleCaracteristic;
                            category = SampleCategoryEnum.sex;
                            break;
                        }
                        case FEMALE: {
                            splitCqv = this.femaleCaracteristic;
                            category = SampleCategoryEnum.sex;
                            break;
                        }
                        case SMALL: {
                            splitCqv = this.smallCaracteristic;
                            category = SampleCategoryEnum.size;
                            break;
                        }
                        case MEDIUM: {
                            splitCqv = this.mediumCaracteristic;
                            category = SampleCategoryEnum.size;
                            break;
                        }
                        case BIG: {
                            splitCqv = this.bigCaracteristic;
                            category = SampleCategoryEnum.size;
                        }
                    }
                    SpeciesBatch childBatch = TuttiBeanFactory.newSpeciesBatch();
                    childBatch.setFishingOperation(operation);
                    childBatch.setSampleCategoryType(category);
                    childBatch.setSampleCategoryValue((Serializable)splitCqv);
                    childBatch.setSpecies(pupitriCatch.getSpecies());
                    childBatch.setSampleCategoryWeight(pupitriCatch.getWeightBySign().get((Object)s));
                    this.persistenceService.createSpeciesBatch(childBatch, batch.getId());
                }
            }
            carrouselImporter.close();
            ((Reader)reader).close();
        }
        catch (Exception e) {
            try {
                throw new TuttiTechnicalException("Could not import carrousel data [" + operation.toString() + "] from file " + carrouselFile, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(carrouselImporter);
                IOUtils.closeQuietly(reader);
                FileUtils.deleteQuietly(fileWithHeaders);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)carrouselImporter);
        IOUtils.closeQuietly((Reader)reader);
        FileUtils.deleteQuietly((File)fileWithHeaders);
        return result;
    }

    public void exportSpecies(List<Species> species, File target) {
        SpeciesRowModel speciesCsvModel = new SpeciesRowModel(';');
        List rows = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(species)) {
            rows = Lists.transform(species, (Function)new Function<Species, SpeciesRow>(){

                public SpeciesRow apply(Species input) {
                    Preconditions.checkNotNull((Object)input.getSurveyCode(), (Object)("Unable to export a species with a null survey code : " + input));
                    SpeciesRow row = new SpeciesRow();
                    String codeFirstPart = StringUtils.substring((String)input.getSurveyCode(), (int)0, (int)4);
                    row.setCodeFirstPart(StringUtils.rightPad((String)codeFirstPart, (int)4));
                    String codeSecondPart = StringUtils.substring((String)input.getSurveyCode(), (int)4, (int)7);
                    row.setCodeSecondPart(StringUtils.rightPad((String)codeSecondPart, (int)3));
                    row.setScientificName(input.getName());
                    return row;
                }
            });
        }
        try {
            Export.exportToFile((ExportModel)speciesCsvModel, (Iterable)rows, (File)target, (Charset)Charsets.UTF_8, (boolean)false);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export all species to file " + target, (Throwable)e);
        }
    }

    protected File createFileWithHeaders(File file, String[] header, char separator) throws IOException {
        File fileWithHeaders = new File(FileUtils.getTempDirectory(), file.getName());
        String headers = StringUtils.join((Object[])header, (char)separator);
        FileUtils.writeLines((File)fileWithHeaders, Collections.singletonList(headers));
        FileUtils.writeLines((File)fileWithHeaders, (Collection)FileUtils.readLines((File)file), (boolean)true);
        return fileWithHeaders;
    }
}

