/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RenameSpeciesBatchAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RenameSpeciesBatchAction.class);
    protected Species selectedSpecies;

    public RenameSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, "renameSpeciesBatch", "batch-rename", I18n._((String)"tutti.action.renameSpeciesBatch", (Object[])new Object[0]), I18n._((String)"tutti.action.renameSpeciesBatch.tip", (Object[])new Object[0]), false);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean result = super.prepareAction(event);
        SpeciesBatchUIHandler handler = (SpeciesBatchUIHandler)this.getHandler();
        SpeciesBatchTableModel tableModel = handler.getTableModel();
        JXTable table = handler.getTable();
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)((Object)tableModel.getEntry(table.getSelectedRow()));
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)((Object)handler.getModel());
        ArrayList speciesList = Lists.newArrayList(model.getAllSpecies());
        speciesList.removeAll(model.getSpeciesUsed().get((Object)row.getSortedUnsortedCategoryValue()));
        this.selectedSpecies = ((SpeciesBatchUIHandler)this.getHandler()).openAddSpeciesDialog(I18n._((String)"tutti.title.selectSpecies", (Object[])new Object[0]), speciesList);
        return result &= this.selectedSpecies != null;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        this.selectedSpecies = null;
        super.releaseAction(event);
    }

    @Override
    protected void doAction(ActionEvent event) {
        SpeciesBatchUIHandler handler = (SpeciesBatchUIHandler)this.getHandler();
        SpeciesBatchTableModel tableModel = handler.getTableModel();
        JXTable table = handler.getTable();
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)((Object)tableModel.getEntry(table.getSelectedRow()));
        PersistenceService persistenceService = this.getService(PersistenceService.class);
        persistenceService.changeSpeciesBatchSpecies(row.getId(), this.selectedSpecies);
        Collection speciesUsed = ((SpeciesBatchUIModel)((Object)this.getModel())).getSpeciesUsed().get((Object)row.getSortedUnsortedCategoryValue());
        speciesUsed.remove(row.getSpecies());
        this.changeChildrenSpecies(row, this.selectedSpecies);
        speciesUsed.add(this.selectedSpecies);
    }

    protected void changeChildrenSpecies(SpeciesBatchRowModel row, Species species) {
        row.setSpecies(species);
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (children != null) {
            for (SpeciesBatchRowModel child : children) {
                this.changeChildrenSpecies(child, species);
            }
        }
    }
}

