/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComboBox;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SelectCruiseUIHandler
extends AbstractTuttiUIHandler<SelectCruiseUIModel, SelectCruiseUI> {
    private static final Log log = LogFactory.getLog(SelectCruiseUIHandler.class);
    protected final PersistenceService persistenceService;
    protected boolean resetEditProtolAction;

    public SelectCruiseUIHandler(TuttiUI<?, ?> parentUI, SelectCruiseUI ui) {
        super(((AbstractTuttiUIHandler)parentUI.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getService(PersistenceService.class);
    }

    @Override
    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return ((SelectCruiseUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        SelectCruiseUIModel model = new SelectCruiseUIModel();
        List programs = this.persistenceService.getAllProgram();
        ArrayList loadedPrograms = Lists.newArrayListWithCapacity((int)programs.size());
        for (Program program : programs) {
            loadedPrograms.add(this.persistenceService.getProgram(program.getId()));
        }
        programs = loadedPrograms;
        model.setPrograms(programs);
        if (programs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No program found.");
            }
        } else {
            String programId = this.context.getProgramId();
            Program selectedProgram = null;
            List cruises = null;
            if (programId != null) {
                selectedProgram = (Program)TuttiEntities.findById((Iterable)programs, (String)programId);
                cruises = this.persistenceService.getAllCruise(programId);
            }
            model.setProgram(selectedProgram);
            model.setCruises(cruises);
            if (!CollectionUtils.isEmpty(cruises)) {
                String cruiseId = this.context.getCruiseId();
                Cruise selectedCruise = null;
                if (cruiseId != null) {
                    selectedCruise = (Cruise)TuttiEntities.findById((Iterable)cruises, (String)cruiseId);
                }
                model.setCruise(selectedCruise);
            }
        }
        List protocols = this.persistenceService.getAllProtocol();
        model.setProtocols(protocols);
        if (protocols.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No protocol found.");
            }
        } else {
            String protocolId = this.context.getProtocolId();
            TuttiProtocol selectedProtocol = null;
            if (protocolId != null) {
                selectedProtocol = (TuttiProtocol)TuttiEntities.findById((Iterable)protocols, (String)protocolId);
            }
            model.setProtocol(selectedProtocol);
        }
        ((SelectCruiseUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        SelectCruiseUIModel model = (SelectCruiseUIModel)((Object)this.getModel());
        this.initBeanComboBox(((SelectCruiseUI)this.ui).getProgramCombobox(), model.getPrograms(), model.getProgram());
        this.initBeanComboBox(((SelectCruiseUI)this.ui).getCruiseCombobox(), model.getCruises(), model.getCruise());
        this.initBeanComboBox(((SelectCruiseUI)this.ui).getProtocolCombobox(), model.getProtocols(), model.getProtocol());
        model.addPropertyChangeListener("protocols", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanComboBox<TuttiProtocol> combobox = ((SelectCruiseUI)SelectCruiseUIHandler.this.ui).getProtocolCombobox();
                List protocols = (List)evt.getNewValue();
                combobox.setData(null);
                combobox.setData(protocols);
                ((SelectCruiseUI)SelectCruiseUIHandler.this.ui).applyDataBinding("protocolCombobox.enabled");
            }
        });
        model.addPropertyChangeListener("program", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Program newValue = (Program)evt.getNewValue();
                boolean noProgram = newValue == null;
                SelectCruiseUIHandler.this.context.setProgramId(noProgram ? null : newValue.getId());
                List campaigns = noProgram ? Lists.newArrayList() : SelectCruiseUIHandler.this.persistenceService.getAllCruise(newValue.getId());
                SelectCruiseUIModel source = (SelectCruiseUIModel)((Object)evt.getSource());
                source.setCruises(campaigns);
                source.setCruise(null);
            }
        });
        model.addPropertyChangeListener("cruises", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanComboBox<Cruise> combobox = ((SelectCruiseUI)SelectCruiseUIHandler.this.ui).getCruiseCombobox();
                List campaigns = (List)evt.getNewValue();
                combobox.setData(null);
                combobox.setData(campaigns);
            }
        });
        model.addPropertyChangeListener("cruise", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Cruise newValue = (Cruise)evt.getNewValue();
                SelectCruiseUIHandler.this.context.setCruiseId(newValue == null ? null : newValue.getId());
            }
        });
        model.addPropertyChangeListener("protocol", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiProtocol newValue = (TuttiProtocol)evt.getNewValue();
                SelectCruiseUIHandler.this.context.setProtocolId(newValue == null ? null : newValue.getId());
            }
        });
        this.registerValidators(this.getValidator());
        this.listenValidatorValid((SimpleBeanValidator)this.getValidator(), model);
        this.getValidator().setBean((Object)model);
        ((SelectCruiseUI)this.ui).applyDataBinding("editProgramButton.enabled");
        ((SelectCruiseUI)this.ui).applyDataBinding("editCruiseButton.enabled");
        ((SelectCruiseUI)this.ui).applyDataBinding("editCatchesButton.enabled");
        ((SelectCruiseUI)this.ui).applyDataBinding("validateCatchesButton.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEditProtolAction() {
        this.resetEditProtolAction = true;
        try {
            ((SelectCruiseUI)this.ui).getEditProtocolComboBox().setSelectedIndex(0);
        }
        finally {
            this.resetEditProtolAction = false;
        }
    }

    @Override
    public void onCloseUI() {
        PropertyChangeListener[] listeners;
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        for (PropertyChangeListener listener : listeners = ((SelectCruiseUIModel)((Object)this.getModel())).getPropertyChangeListeners()) {
            ((SelectCruiseUIModel)((Object)this.getModel())).removePropertyChangeListener(listener);
        }
        this.clearValidators();
    }

    public void startExistingProtocolAction(ActionEvent event) {
        if (!this.resetEditProtolAction) {
            JComboBox newProtocolCombo = (JComboBox)event.getSource();
            Action selectedAction = (Action)newProtocolCombo.getSelectedItem();
            selectedAction.actionPerformed(event);
        }
    }

    public void startNewProtocolAction(ActionEvent event) {
        JComboBox newProtocolCombo = (JComboBox)event.getSource();
        Action selectedAction = (Action)newProtocolCombo.getSelectedItem();
        selectedAction.actionPerformed(event);
    }
}

