/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.MultiRowItem;
import org.eclipse.birt.report.model.api.simpleapi.IDataBinding;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.IHideRule;
import org.eclipse.birt.report.model.api.simpleapi.IHighlightRule;
import org.eclipse.birt.report.model.api.simpleapi.IReportItem;
import org.eclipse.birt.report.model.simpleapi.DataBindingImpl;
import org.eclipse.birt.report.model.simpleapi.DesignElement;
import org.eclipse.birt.report.model.simpleapi.HideRuleMethodUtil;
import org.eclipse.birt.report.model.simpleapi.HighlightRuleMethodUtil;
import org.eclipse.birt.report.model.simpleapi.ReportElement;

public class ReportItem
extends ReportElement
implements IReportItem {
    public ReportItem(ReportItemHandle handle) {
        super(handle);
    }

    public DataSetHandle getDataSet() {
        return ((ReportItemHandle)this.handle).getDataSet();
    }

    public void setDataSet(DataSetHandle dataSet) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ReportItemHandle)this.handle).setDataSet(dataSet);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public String getX() {
        DimensionHandle x = ((ReportItemHandle)this.handle).getX();
        return x == null ? null : x.getStringValue();
    }

    @Override
    public String getY() {
        DimensionHandle y = ((ReportItemHandle)this.handle).getY();
        return y == null ? null : y.getStringValue();
    }

    @Override
    public void setX(String dimension) throws SemanticException {
        this.setProperty("x", dimension);
    }

    @Override
    public void setX(double dimension) throws SemanticException {
        this.setProperty("x", dimension);
    }

    @Override
    public void setY(String dimension) throws SemanticException {
        this.setProperty("y", dimension);
    }

    @Override
    public void setY(double dimension) throws SemanticException {
        this.setProperty("y", dimension);
    }

    @Override
    public void setHeight(String dimension) throws SemanticException {
        this.setProperty("height", dimension);
    }

    @Override
    public void setHeight(double dimension) throws SemanticException {
        this.setProperty("height", dimension);
    }

    @Override
    public void setWidth(String dimension) throws SemanticException {
        this.setProperty("width", dimension);
    }

    @Override
    public void setWidth(double dimension) throws SemanticException {
        this.setProperty("width", dimension);
    }

    @Override
    public String getWidth() {
        return ((ReportItemHandle)this.handle).getWidth().getDisplayValue();
    }

    @Override
    public String getHeight() {
        return ((ReportItemHandle)this.handle).getHeight().getDisplayValue();
    }

    @Override
    public String getBookmark() {
        return ((ReportItemHandle)this.handle).getBookmark();
    }

    @Override
    public void setBookmark(String value) throws SemanticException {
        this.setProperty("bookmark", value);
    }

    @Override
    public void setTocExpression(String expression) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ReportItemHandle)this.handle).setTocExpression(expression);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public String getTocExpression() {
        return ((ReportItemHandle)this.handle).getTocExpression();
    }

    @Override
    public String getDataBinding(String bindingName) {
        if (bindingName == null || bindingName.length() == 0) {
            return null;
        }
        Iterator iterator = ((ReportItemHandle)this.handle).columnBindingsIterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle columnHandle = (ComputedColumnHandle)iterator.next();
            if (!columnHandle.getName().equals(bindingName)) continue;
            return columnHandle.getExpression();
        }
        return null;
    }

    @Override
    public IDataBinding[] getDataBindings() {
        Iterator iterator = ((ReportItemHandle)this.handle).columnBindingsIterator();
        ArrayList<DataBindingImpl> rList = new ArrayList<DataBindingImpl>();
        int count = 0;
        while (iterator.hasNext()) {
            ComputedColumnHandle columnHandle = (ComputedColumnHandle)iterator.next();
            DataBindingImpl d = new DataBindingImpl(columnHandle);
            rList.add(d);
            ++count;
        }
        return rList.toArray(new IDataBinding[count]);
    }

    @Override
    public void removeDataBinding(String bindingName) throws SemanticException {
        if (bindingName == null || bindingName.length() == 0) {
            return;
        }
        PropertyHandle propHandle = ((ReportItemHandle)this.handle).getPropertyHandle("boundDataColumns");
        ArrayList<ComputedColumnHandle> structureList = new ArrayList<ComputedColumnHandle>();
        Iterator iterator = propHandle.iterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle columnHandle = (ComputedColumnHandle)iterator.next();
            if (!bindingName.equals(columnHandle.getName())) continue;
            structureList.add(columnHandle);
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            propHandle.removeItems(structureList);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void removeDataBindings() throws SemanticException {
        PropertyHandle propHandle = this.handle.getPropertyHandle("boundDataColumns");
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            propHandle.clearValue();
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void addDataBinding(IDataBinding binding) throws SemanticException {
        if (binding == null) {
            return;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle("boundDataColumns");
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            propHandle.addItem(binding.getStructure());
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public IHideRule[] getHideRules() {
        return HideRuleMethodUtil.getHideRules(this.handle);
    }

    @Override
    public void removeHideRule(IHideRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HideRuleMethodUtil.removeHideRule(this.handle, rule);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void addHideRule(IHideRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HideRuleMethodUtil.addHideRule(this.handle, rule);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void removeHideRules() throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HideRuleMethodUtil.removeHideRules(this.handle);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void addHighlightRule(IHighlightRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HighlightRuleMethodUtil.addHighlightRule(this.handle, rule);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public IHighlightRule[] getHighlightRules() {
        return HighlightRuleMethodUtil.getHighlightRules(this.handle);
    }

    @Override
    public void removeHighlightRule(IHighlightRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HighlightRuleMethodUtil.removeHighlightRule(this.handle, rule);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void removeHighlightRules() throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HighlightRuleMethodUtil.removeHighlightRules(this.handle);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void setCurrentView(IDesignElement viewElement) throws SemanticException {
        DesignElementHandle tmpElement = null;
        if (viewElement instanceof MultiRowItem) {
            DesignElement reportItem = (DesignElement)((Object)((MultiRowItem)viewElement).getExtensionElement());
            tmpElement = reportItem.handle;
        } else if (viewElement != null) {
            tmpElement = ((DesignElement)viewElement).handle;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ReportItemHandle)this.handle).setCurrentView(tmpElement);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }
}

