/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.cache.IsisCacheBackend;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.StringUtil;

public class IsisCacheBackendOnGuava
implements IsisCacheBackend {
    private static Log log = LogFactory.getLog(IsisCacheBackendOnGuava.class);
    public static final int POINTER_SIZE = 8;
    public static final int DOUBLE_SIZE = 8;
    public static final int CHAR_SIZE = 2;
    public static double CACHE_STEP = 2.0;
    public static IsisCacheBackend.Factory factory = new IsisCacheBackendOnGuavaFactory();
    protected Cache<String, Object> cache;
    protected IsisWeigher isisWeigher;
    protected long maxMemory;
    protected long maxCache;
    protected long sizeCache;
    protected TimeStep lastStep = null;
    protected boolean adjusted = false;
    protected long totalLastStepCached = 0L;
    protected long numberCached = 0L;
    protected long totalCached = 0L;
    protected long smallestCached = Long.MAX_VALUE;
    protected long biggestCached = 0L;
    double delta = 0.0;
    double mean = 0.0;
    double M2 = 0.0;
    protected long numberStepCached = 0L;
    protected long totalStepCached = 0L;
    protected long smallestStepCached = Long.MAX_VALUE;
    protected long biggestStepCached = 0L;
    double stepDelta = 0.0;
    double stepMean = 0.0;
    double stepM2 = 0.0;

    public IsisCacheBackendOnGuava() {
        this.isisWeigher = new IsisWeigher(this);
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.maxCache = this.maxMemory - 524288000L;
        this.maxCache = Math.max(this.maxCache, 0xC800000L);
        this.adjustedCache(this.maxCache);
    }

    public void addStat(long value) {
        ++this.numberCached;
        this.totalCached += value;
        this.delta = (double)value - this.mean;
        this.mean += this.delta / (double)this.numberCached;
        this.M2 += this.delta * ((double)value - this.mean);
        this.biggestCached = Math.max(this.biggestCached, value);
        this.smallestCached = Math.min(this.smallestCached, value);
    }

    public void addStepStat(long value) {
        ++this.numberStepCached;
        this.totalStepCached += value;
        this.stepDelta = (double)value - this.stepMean;
        this.stepMean += this.stepDelta / (double)this.numberStepCached;
        this.stepM2 += this.stepDelta * ((double)value - this.stepMean);
        this.biggestStepCached = Math.max(this.biggestStepCached, value);
        this.smallestStepCached = Math.min(this.smallestStepCached, value);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
        this.changeStep();
    }

    @Override
    public void removeStep(Object o) {
    }

    public void adjustedCache(long amount) {
        if (amount == 0L) {
            log.info((Object)"Cache size not ajusted because 0 is not acceptable amount");
        } else {
            long bytePerStep = this.totalCached / Math.max(1L, this.numberStepCached);
            long entriesPerStep = this.numberCached / Math.max(1L, this.numberStepCached);
            long initialCapacity = amount * entriesPerStep / Math.max(1L, bytePerStep);
            long stepEquivalent = initialCapacity / Math.max(1L, entriesPerStep);
            this.sizeCache = Math.min(this.maxCache, amount);
            CacheBuilder builder = CacheBuilder.newBuilder();
            builder.maximumWeight(this.sizeCache);
            builder.weigher((Weigher)this.isisWeigher);
            if (initialCapacity > 0L) {
                builder.initialCapacity((int)initialCapacity);
            }
            this.cache = builder.build();
            log.info((Object)String.format("Cache size ajusted to %s (equivalent to %s step need)", StringUtil.convertMemory((long)this.sizeCache), stepEquivalent));
        }
    }

    public void changeStep() {
        long stepAmount = this.totalCached - this.totalLastStepCached;
        this.totalLastStepCached = this.totalCached;
        this.addStepStat(stepAmount);
        if (!this.adjusted) {
            this.adjustedCache((long)((double)stepAmount * CACHE_STEP));
            this.adjusted = true;
        }
    }

    @Override
    public Object get(TimeStep step, String key) {
        Object result = this.cache.getIfPresent((Object)key);
        return result;
    }

    @Override
    public void put(TimeStep step, String key, Object value) {
        this.cache.put((Object)key, value);
        if (step != null) {
            if (this.lastStep == null) {
                this.lastStep = step;
            } else if (this.lastStep.getStep() != step.getStep()) {
                this.changeStep();
                this.lastStep = step;
            }
        }
    }

    @Override
    public String getStat() {
        long mean = this.totalCached / Math.max(1L, this.numberCached);
        long stepMean = this.totalStepCached / Math.max(1L, this.numberStepCached);
        double variance = this.M2 / (double)Math.max(1L, this.numberCached - 1L);
        double stepVariance = this.stepM2 / (double)Math.max(1L, this.numberStepCached - 1L);
        double standardDeviation = Math.sqrt(variance);
        double stepStandardDeviation = Math.sqrt(stepVariance);
        String trick = "";
        if (this.sizeCache < this.biggestStepCached) {
            trick = String.format("TRICK: for better performance you must set memory at least to %s\n", StringUtil.convertMemory((long)(this.biggestStepCached + 524288000L)));
        }
        String result = String.format("%s - \n%s\tinitial cache size: %s, cache size reevaluated: %s, totalCached: %s, numberStep: %s, numberEntries: %s\n\tStep min: %s, max: %s, mean: %s, standard deviation: %s\n\tEntry min: %s, max: %s, mean: %s, standard deviation: %s\n", trick, this.getClass().getSimpleName(), StringUtil.convertMemory((long)this.maxMemory), StringUtil.convertMemory((long)this.sizeCache), StringUtil.convertMemory((long)this.totalCached), this.numberStepCached, this.numberCached, StringUtil.convertMemory((long)this.smallestStepCached), StringUtil.convertMemory((long)this.biggestStepCached), StringUtil.convertMemory((long)stepMean), StringUtil.convertMemory((long)((long)stepStandardDeviation)), StringUtil.convertMemory((long)this.smallestCached), StringUtil.convertMemory((long)this.biggestCached), StringUtil.convertMemory((long)mean), StringUtil.convertMemory((long)((long)standardDeviation)));
        return result;
    }

    public static class IsisWeigher
    implements Weigher<String, Object> {
        protected IsisCacheBackendOnGuava backend;

        public IsisWeigher(IsisCacheBackendOnGuava backend) {
            this.backend = backend;
        }

        public int weigh(String key, Object value) {
            int result = key.length() * 2;
            if (value instanceof MatrixND) {
                long size = ((MatrixND)value).getNumberOfAssignedValue();
                result = (int)((long)result + size * 8L);
            } else if (value instanceof Collection) {
                result += ((Collection)value).size() * 8;
            } else if (value instanceof Number) {
                result += 8;
            } else if (value != null) {
                log.info((Object)("Cache can't compute value size of " + String.valueOf(value.getClass())));
            }
            this.backend.addStat(result);
            result = Math.max(1024, result);
            return result;
        }
    }

    public static class IsisCacheBackendOnGuavaFactory
    implements IsisCacheBackend.Factory {
        @Override
        public IsisCacheBackend createNew() {
            return new IsisCacheBackendOnGuava();
        }
    }
}

