/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity.wizard;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.input.equation.InputOneEquationUI;
import fr.ifremer.isisfish.ui.sensitivity.wizard.ContinuousDistributionPanel;
import fr.ifremer.isisfish.ui.sensitivity.wizard.ContinuousPanel;
import fr.ifremer.isisfish.ui.sensitivity.wizard.EquationContinuousPanelUI;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardUI;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import fr.ifremer.isisfish.ui.widget.editor.MonthComponent;
import fr.ifremer.isisfish.ui.widget.editor.StepComponent;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public class FactorWizardHandler {
    private static Log log = LogFactory.getLog(FactorWizardHandler.class);
    protected FactorWizardUI factorWizardUI;

    public FactorWizardHandler(FactorWizardUI factorWizardUI) {
        this.factorWizardUI = factorWizardUI;
    }

    protected void afterInit() {
        this.factorWizardUI.addPropertyChangeListener("continueSelected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    ((CardLayout)FactorWizardHandler.this.factorWizardUI.hidablePanel.getLayout()).show(FactorWizardHandler.this.factorWizardUI.hidablePanel, "continuousPanelContainer");
                } else {
                    ((CardLayout)FactorWizardHandler.this.factorWizardUI.hidablePanel.getLayout()).show(FactorWizardHandler.this.factorWizardUI.hidablePanel, "discretePanelContainer");
                }
            }
        });
    }

    protected TopiaContext getTopiaContext(FactorWizardUI factorWizardUI) throws TopiaException {
        RegionStorage regionStorage = factorWizardUI.getContextValue(RegionStorage.class);
        TopiaContext context = regionStorage.getStorage().beginTransaction();
        return context;
    }

    public void initNewFactor(FactorWizardUI factorWizardUI, TopiaEntityContextable bean, String property) {
        String beanProperty = StringUtils.uncapitalize((String)property);
        String path = bean.getTopiaId() + "#" + beanProperty;
        factorWizardUI.setFactorPath(path);
        factorWizardUI.getFactorNameField().setText(bean.toString() + "." + beanProperty);
        try {
            Object valueForPath = PropertyUtils.getProperty((Object)bean, (String)beanProperty);
            boolean continuePossible = SensitivityUtils.canBeContinue(valueForPath);
            boolean continueSelected = SensitivityUtils.isContinue(valueForPath);
            if (continuePossible) {
                ContinuousPanel comp = this.getContinuousPanel(valueForPath, bean, property);
                factorWizardUI.getContinuousPanelContainer().add((Component)comp, "Center");
            }
            factorWizardUI.setContinuePossible(continuePossible);
            factorWizardUI.setContinueSelected(continueSelected);
            factorWizardUI.getContinueRadio().setSelected(continueSelected);
        }
        catch (Exception ex) {
            throw new IsisFishRuntimeException("Can't init wizard", ex);
        }
    }

    public void initExistingFactor(FactorWizardUI factorWizardUI, Factor factor) {
        factorWizardUI.setEditingState(true);
        String factorPath = factor.getPath();
        Domain domain = factor.getDomain();
        String factorName = factor.getName();
        factorWizardUI.setFactorPath(factorPath);
        factorWizardUI.getComment().setText(factor.getComment());
        if (domain instanceof ContinuousDomain) {
            ContinuousPanel comp = this.getNewContinuousComponent(factorWizardUI, factor.getPath());
            comp.initWithFactor(factor);
            factorWizardUI.getContinuousPanelContainer().add((Component)comp, "Center");
            factorWizardUI.getContinueRadio().setSelected(true);
            factorWizardUI.setContinueSelected(true);
            factorWizardUI.setContinuePossible(true);
        } else {
            ContinuousPanel comp;
            if (domain != null) {
                DiscreteDomain dDomain = (DiscreteDomain)domain;
                int nb = dDomain.getValues().size();
                factorWizardUI.getDiscretNumber().setText(String.valueOf(nb));
                factorWizardUI.getTabPane().removeAll();
                SortedMap<Object, Object> values = dDomain.getValues();
                int i = 0;
                for (Object o : values.values()) {
                    ++i;
                    JComponent c = null;
                    if (o != null) {
                        c = this.getEditorWithValue(factorWizardUI, factor, dDomain, o);
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)"Null value in factor");
                    }
                    JScrollPane js = new JScrollPane(c);
                    String tabName = I18n.t((String)"isisfish.sensitivity.discretevaluelabel", (Object[])new Object[]{i});
                    factorWizardUI.getTabPane().addTab(tabName, js);
                }
            }
            if ((comp = this.getNewContinuousComponent(factorWizardUI, factor.getPath())) != null) {
                factorWizardUI.setContinuePossible(true);
                factorWizardUI.getContinuousPanelContainer().add((Component)comp, "Center");
            }
        }
        factorWizardUI.getFactorNameField().setText(factorName);
    }

    protected JComponent getEditorWithValue(FactorWizardUI factorWizardUI, Factor factor, Domain domain, Object value) {
        Object result = null;
        if (Double.class.isAssignableFrom(value.getClass())) {
            result = new JTextField();
            ((JTextComponent)result).setText(String.valueOf(value));
        } else if (Double.TYPE.isAssignableFrom(value.getClass())) {
            result = new JTextField();
            ((JTextComponent)result).setText(String.valueOf(value));
        } else if (MatrixND.class.isAssignableFrom(value.getClass())) {
            result = new MatrixPanelEditor();
            ((MatrixPanelEditor)result).setMatrix((MatrixND)value);
        } else if (domain instanceof RuleDiscreteDomain) {
            result = new RuleChooser((JAXXContext)factorWizardUI);
            ((RuleChooser)((Object)result)).setRulesList((List)value);
        } else if (domain instanceof EquationDiscreteDomain) {
            String factorPath = factor.getPath();
            if (factor.getPath().indexOf(35) != -1) {
                String topiaId = factorPath.substring(0, factorPath.lastIndexOf(35));
                String property = factorPath.substring(factorPath.lastIndexOf(35) + 1);
                try {
                    TopiaContext topiaContext = this.getTopiaContext(factorWizardUI);
                    TopiaEntityContextable entity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                    Equation equation = (Equation)PropertyUtils.getProperty((Object)entity, (String)property);
                    topiaContext.closeContext();
                    InputOneEquationUI ui = new InputOneEquationUI((JAXXContext)factorWizardUI);
                    ui.setAutoSaveModification(false);
                    ui.setFormuleCategory(equation.getCategory());
                    ui.setText(I18n.t((String)"isisfish.common.equation", (Object[])new Object[0]));
                    ui.setClazz(value.getClass());
                    ui.setBeanProperty(property);
                    ui.setBean(entity);
                    ui.getEditor().setText((String)value);
                    ui.setActive(true);
                    result = ui;
                }
                catch (Exception ex) {
                    throw new IsisFishRuntimeException("Can't restore initial factor database property", ex);
                }
            }
        } else if (value instanceof TimeUnit) {
            result = new JTextField();
            ((JTextComponent)result).setText(String.valueOf(((TimeUnit)value).getTime()));
        } else {
            if (value instanceof TopiaEntity) {
                RegionStorage regionStorage = factorWizardUI.getContextValue(RegionStorage.class);
                TopiaContext context = null;
                try {
                    context = regionStorage.getStorage().beginTransaction();
                    List list = context.findAll("from " + value.getClass().getName(), new Object[0]);
                    JComboBox<Object> c = new JComboBox<Object>(list.toArray());
                    c.setSelectedItem(value);
                    result = c;
                }
                catch (TopiaException ex) {
                    throw new IsisFishRuntimeException("Can't get entity list", ex);
                }
                finally {
                    if (context != null) {
                        try {
                            context.closeContext();
                        }
                        catch (TopiaException ex) {
                            throw new IsisFishRuntimeException("Can't get entity list", ex);
                        }
                    }
                }
            }
            if (value instanceof TimeStep) {
                TimeStep timeStep = (TimeStep)value;
                result = new StepComponent(timeStep.getMonth().getMonthNumber(), timeStep.getYear());
            } else if (value instanceof Month) {
                Month month = (Month)value;
                result = MonthComponent.createMounthCombo(month.getMonthNumber());
            } else if (value instanceof String) {
                result = new JTextField();
                ((JTextField)result).setText(String.valueOf(value));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Editor for value " + value + " is " + result));
        }
        return result;
    }

    protected ContinuousPanel getContinuousPanel(Object value, TopiaEntityContextable bean, String property) {
        ContinuousPanel result;
        if (value instanceof RangeOfValues) {
            int first;
            RangeOfValues rangeOfValues = (RangeOfValues)value;
            String values = rangeOfValues.getValues();
            String min = "0";
            if (values.matches("^\\ *[0-9]*\\ *\\-\\ *[0-9]*\\ *$") && (first = values.indexOf("-")) != -1) {
                min = values.substring(0, first);
            }
            result = new ContinuousDistributionPanel(min);
        } else if (value instanceof Equation) {
            Equation equation = (Equation)value;
            EquationContinuousPanelUI ui = new EquationContinuousPanelUI();
            ui.setSelectedEquation(equation);
            ui.setText(I18n.t((String)"isisfish.common.equation", (Object[])new Object[0]));
            ui.setFormuleCategory(equation.getCategory());
            ui.setClazz(equation.getClass());
            ui.setBeanProperty(property);
            ui.setBean(bean);
            result = ui;
        } else if (value instanceof MatrixND) {
            MatrixND matrix = (MatrixND)value;
            result = new ContinuousDistributionPanel(matrix.clone());
        } else if (value instanceof TimeUnit) {
            TimeUnit timeUnit = (TimeUnit)value;
            result = new ContinuousDistributionPanel(String.valueOf(timeUnit.getTime()));
        } else {
            result = new ContinuousDistributionPanel(String.valueOf(value));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Component for " + value + " (" + bean + ", " + property + ")"));
            log.debug((Object)(" > " + result));
        }
        return result;
    }

    public void addTabs(FactorWizardUI factorWizardUI) {
        int tab;
        String discreteNumber = factorWizardUI.getDiscretNumber().getText();
        int nbTab = Integer.parseInt(discreteNumber);
        int currentCount = factorWizardUI.getTabPane().getTabCount();
        for (tab = currentCount - 1; tab > nbTab - 1; --tab) {
            factorWizardUI.getTabPane().remove(tab);
        }
        for (tab = currentCount; tab < nbTab; ++tab) {
            JComponent c = this.getNewDiscreteComponent(factorWizardUI);
            String tabName = I18n.t((String)"isisfish.sensitivity.discretevaluelabel", (Object[])new Object[]{tab});
            factorWizardUI.getTabPane().addTab(tabName, c);
        }
        factorWizardUI.pack();
    }

    protected JComponent getNewDiscreteComponent(FactorWizardUI factorWizardUI) {
        Object result = null;
        String factorPath = factorWizardUI.getFactorPath();
        try {
            if (factorPath.indexOf(35) != -1) {
                String topiaId = factorPath.substring(0, factorPath.lastIndexOf(35));
                String property = factorPath.substring(factorPath.lastIndexOf(35) + 1);
                TopiaContext topiaContext = this.getTopiaContext(factorWizardUI);
                TopiaEntityContextable entity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                Object value = PropertyUtils.getProperty((Object)entity, (String)property);
                if (value instanceof Number) {
                    result = new JTextField(String.valueOf(value));
                } else if (value instanceof MatrixND) {
                    result = new MatrixPanelEditor();
                    MatrixND matrix = ((MatrixND)value).copy();
                    ((MatrixPanelEditor)result).setMatrix(matrix);
                } else if (value instanceof RangeOfValues) {
                    RangeOfValues rangeOfValues = (RangeOfValues)value;
                    result = new JTextField(rangeOfValues.getValues());
                } else if (value instanceof TimeUnit) {
                    TimeUnit timeUnit = (TimeUnit)value;
                    result = new JTextField(String.valueOf(timeUnit.getTime()));
                } else if (value instanceof Equation) {
                    Equation equation = (Equation)value;
                    InputOneEquationUI ui = new InputOneEquationUI((JAXXContext)factorWizardUI);
                    ui.setAutoSaveModification(false);
                    ui.setText(equation.getContent());
                    ui.setFormuleCategory(equation.getCategory());
                    ui.setText(I18n.t((String)"isisfish.common.equation", (Object[])new Object[0]));
                    ui.setClazz(value.getClass());
                    ui.setBeanProperty(property);
                    ui.setBean(entity);
                    ui.setActive(true);
                    result = ui;
                }
                topiaContext.closeContext();
            } else if (factorPath.equals("parameters.rules")) {
                result = new RuleChooser((JAXXContext)factorWizardUI);
            } else if (factorPath.startsWith("parameters.population.")) {
                Pattern pattern = Pattern.compile("^parameters\\.population\\.(\\w+)(\\.(.+)?)$");
                Matcher matcher = pattern.matcher(factorPath);
                if (matcher.matches()) {
                    String populationName = matcher.group(1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading population : " + populationName));
                    }
                    TopiaContext topiaContext = this.getTopiaContext(factorWizardUI);
                    Object pop = IsisFishDAOHelper.getPopulationDAO(topiaContext).findByName(populationName);
                    MatrixND N = this.getParameters().getNumberOf((Population)pop);
                    result = new MatrixPanelEditor();
                    ((MatrixPanelEditor)result).setMatrix(N.clone());
                    topiaContext.closeContext();
                }
            } else if (factorPath.startsWith("parameters.rule.")) {
                Pattern pattern = Pattern.compile("^parameters\\.rule\\.(\\d+)\\.parameter\\.(\\w+)(\\..+)?$");
                Matcher matcher = pattern.matcher(factorPath);
                if (matcher.matches()) {
                    int ruleIndex = Integer.parseInt(matcher.group(1));
                    Rule rule = this.getParameters().getRules().get(ruleIndex);
                    Class valueClazz = RuleStorage.getParameterType(rule, matcher.group(2));
                    Object value = RuleStorage.getParameterValue(rule, matcher.group(2));
                    result = this.getTypeDiscreteComponent(factorWizardUI, valueClazz, value);
                } else {
                    result = new JTextField("0.0");
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Can't find component for path " + factorPath));
            }
        }
        catch (Exception ex) {
            throw new IsisFishRuntimeException("Can't restore intial factor database property", ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Component for path " + factorPath + " is " + (Object)result));
        }
        if (!(result instanceof MatrixPanelEditor)) {
            result = new JScrollPane((Component)result);
        }
        return result;
    }

    protected ContinuousPanel getNewContinuousComponent(FactorWizardUI factorWizardUI, String factorPath) {
        ContinuousPanel result = null;
        try {
            if (factorPath.indexOf(35) != -1) {
                String topiaId = factorPath.substring(0, factorPath.lastIndexOf(35));
                String property = factorPath.substring(factorPath.lastIndexOf(35) + 1);
                TopiaContext topiaContext = this.getTopiaContext(factorWizardUI);
                TopiaEntityContextable entity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                Object value = PropertyUtils.getProperty((Object)entity, (String)property);
                if (value instanceof RangeOfValues) {
                    int first;
                    RangeOfValues rangeOfValues = (RangeOfValues)value;
                    String values = rangeOfValues.getValues();
                    String min = "0";
                    if (values.matches("^\\ *[0-9]*\\ *\\-\\ *[0-9]*\\ *$") && (first = values.indexOf("-")) != -1) {
                        min = values.substring(0, first);
                    }
                    result = new ContinuousDistributionPanel(min);
                } else if (value instanceof Equation) {
                    Equation equation = (Equation)value;
                    EquationContinuousPanelUI ui = new EquationContinuousPanelUI();
                    ui.setSelectedEquation(equation);
                    ui.setText(I18n.t((String)"isisfish.common.equation", (Object[])new Object[0]));
                    ui.setFormuleCategory(equation.getCategory());
                    ui.setClazz(equation.getClass());
                    ui.setBeanProperty(property);
                    ui.setBean(entity);
                    result = ui;
                } else if (value instanceof MatrixND) {
                    MatrixND matrix = (MatrixND)value;
                    result = new ContinuousDistributionPanel(matrix.clone());
                } else if (value instanceof TimeUnit) {
                    TimeUnit timeUnit = (TimeUnit)value;
                    result = new ContinuousDistributionPanel(String.valueOf(timeUnit.getTime()));
                } else {
                    result = new ContinuousDistributionPanel(String.valueOf(value));
                }
                topiaContext.closeContext();
            } else if (factorPath.startsWith("parameters.population.")) {
                Pattern pattern = Pattern.compile("^parameters\\.population\\.(\\w+)(\\.(.+)?)$");
                Matcher matcher = pattern.matcher(factorPath);
                if (matcher.matches()) {
                    String populationName = matcher.group(1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading population : " + populationName));
                    }
                    TopiaContext topiaContext = this.getTopiaContext(factorWizardUI);
                    Object pop = IsisFishDAOHelper.getPopulationDAO(topiaContext).findByName(populationName);
                    MatrixND N = this.getParameters().getNumberOf((Population)pop);
                    result = new ContinuousDistributionPanel(N.clone());
                    topiaContext.closeContext();
                }
            } else if (factorPath.startsWith("parameters.rule.")) {
                Pattern pattern = Pattern.compile("^parameters\\.rule\\.(\\d+)\\.parameter\\.(\\w+)(\\..+)?$");
                Matcher matcher = pattern.matcher(factorPath);
                if (matcher.matches()) {
                    int ruleIndex = Integer.parseInt(matcher.group(1));
                    Rule rule = this.getParameters().getRules().get(ruleIndex);
                    Class valueClazz = RuleStorage.getParameterType(rule, matcher.group(2));
                    Object value = RuleStorage.getParameterValue(rule, matcher.group(2));
                    result = this.getTypeContinousComponent(factorWizardUI, valueClazz, value);
                } else {
                    result = this.getContinuousPanel(0.0, null, null);
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Can't find component for path " + factorPath));
            }
        }
        catch (Exception ex) {
            throw new IsisFishRuntimeException("Can't init wizard", ex);
        }
        return result;
    }

    protected JComponent getTypeDiscreteComponent(FactorWizardUI factorWizardUI, Class type, Object value) {
        JComponent result = null;
        if (TopiaEntity.class.isAssignableFrom(type)) {
            try {
                TopiaContext context = this.getTopiaContext(factorWizardUI);
                List list = context.findAll("from " + type.getName(), new Object[0]);
                JComboBox<Object> c = new JComboBox<Object>(list.toArray());
                result = c;
                context.closeContext();
            }
            catch (TopiaException ex) {
                throw new IsisFishRuntimeException("Can't get entity list", ex);
            }
        } else {
            result = TimeStep.class.isAssignableFrom(type) ? new StepComponent(0, 0) : (Month.class.isAssignableFrom(type) ? MonthComponent.createMounthCombo(0) : (value != null ? new JTextField(value.toString()) : new JTextField()));
        }
        return result;
    }

    protected ContinuousPanel getTypeContinousComponent(FactorWizardUI factorWizardUI, Class type, Object value) {
        ContinuousDistributionPanel result = null;
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            result = value != null ? new ContinuousDistributionPanel(value.toString()) : new ContinuousDistributionPanel(0.0);
        }
        return result;
    }

    public void save(FactorWizardUI factorWizardUI) {
        ContinuousPanel continuousPanel = null;
        if (factorWizardUI.getContinuousPanelContainer().getComponentCount() > 0) {
            continuousPanel = (ContinuousPanel)factorWizardUI.getContinuousPanelContainer().getComponent(0);
        }
        boolean factorValid = true;
        if (continuousPanel != null) {
            factorValid = continuousPanel.isFactorValid();
        }
        if (!factorValid) {
            JOptionPane.showMessageDialog(factorWizardUI, I18n.t((String)"isisfish.sensitivity.factor.notvalid", (Object[])new Object[0]), I18n.t((String)"isisfish.sensitivity.title", (Object[])new Object[0]), 0);
            return;
        }
        if (factorWizardUI.getContinueRadio().isSelected()) {
            this.saveContinue(factorWizardUI.getFactorNameField().getText(), factorWizardUI.getComment().getText(), factorWizardUI.getFactorPath(), continuousPanel, factorWizardUI.isEditingState());
        } else {
            Component[] discreteComponents = factorWizardUI.getTabPane().getComponents();
            this.saveDiscret(factorWizardUI.getFactorNameField().getText(), factorWizardUI.getComment().getText(), factorWizardUI.getFactorPath(), discreteComponents, factorWizardUI.isEditingState());
        }
        factorWizardUI.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
        factorWizardUI.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void saveContinue(String name, String comment, String path, ContinuousPanel panel, boolean exist) {
        if (panel instanceof EquationContinuousPanelUI) {
            try {
                EquationContinuousPanelUI equationPanel = (EquationContinuousPanelUI)panel;
                String property = StringUtils.uncapitalize((String)equationPanel.getBeanProperty()) + "Content";
                TopiaEntityContextable bean = equationPanel.getBean();
                TopiaContext topiaContext = bean.getTopiaContext();
                PropertyUtils.setProperty((Object)bean, (String)property, (Object)equationPanel.getEditor().getEditor().getText());
                bean.update();
                topiaContext.commitTransaction();
                List<Factor> factors = equationPanel.getFactors();
                for (Factor factor : factors) {
                    factor.setName(name);
                    factor.setComment(comment);
                    factor.setPath(path);
                    this.addContinuousEquationFactor(factor, exist);
                }
                return;
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) return;
                log.error((Object)"Can't call method : ", (Throwable)ex);
                return;
            }
        } else {
            if (!(panel instanceof ContinuousDistributionPanel)) return;
            ContinuousDistributionPanel defaultPanel = (ContinuousDistributionPanel)panel;
            ContinuousDomain domain = defaultPanel.generateDomain();
            this.addContinuousFactor(name, comment, path, domain, exist);
        }
    }

    protected void saveDiscret(String name, String comment, String path, Component[] components, boolean exist) {
        ArrayList<Object> values = new ArrayList<Object>();
        boolean ruleFactor = false;
        boolean equationFactor = false;
        for (Component component : components) {
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            Object result = null;
            if (component instanceof JTextComponent) {
                result = ((JTextComponent)component).getText();
            } else if (component instanceof MatrixPanelEditor) {
                result = ((MatrixPanelEditor)component).getMatrix();
            } else if (component instanceof InputOneEquationUI) {
                result = ((InputOneEquationUI)component).getEditor().getText();
                equationFactor = true;
            } else if (component instanceof RuleChooser) {
                result = ((RuleChooser)((Object)component)).getRulesList();
                ruleFactor = true;
            } else if (component instanceof StepComponent) {
                result = new TimeStep(((StepComponent)component).getSelectedValue());
            } else if (component instanceof MonthComponent) {
                result = new Month(((MonthComponent)component).getSelectedValue());
            } else if (component instanceof JComboBox) {
                result = ((JComboBox)component).getSelectedItem();
            }
            values.add(result);
        }
        if (ruleFactor) {
            this.addDiscreteRuleFactor(name, comment, path, values, exist);
        } else if (equationFactor) {
            this.addDiscreteEquationFactor(name, comment, path, values, exist);
        } else {
            this.addDiscreteFactor(name, comment, path, values, exist);
        }
    }

    public void remove(FactorWizardUI factorWizardUI) {
        this.removeFactor(factorWizardUI.getFactorPath());
        factorWizardUI.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
        factorWizardUI.dispose();
    }

    protected void addFactor(Factor f) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add factor (" + f.getName() + ") : " + f.getPath()));
        }
        this.getFactorGroup().addFactor(f);
    }

    public void addContinuousFactor(String name, String comment, String path, ContinuousDomain domain, boolean exist) {
        Factor f = new Factor(name);
        f.setDomain(domain);
        f.setComment(comment);
        f.setPath(path);
        if (exist) {
            this.removeFactor(path);
        }
        this.addFactor(f);
    }

    public void addDiscreteFactor(String name, String comment, String path, List<Object> values, boolean exist) {
        this.addDiscreteFactor(new DiscreteDomain(), name, comment, path, values, exist);
    }

    public void addDiscreteRuleFactor(String name, String comment, String path, List<Object> values, boolean exist) {
        this.addDiscreteFactor(new RuleDiscreteDomain(), name, comment, path, values, exist);
    }

    public void addDiscreteEquationFactor(String name, String comment, String path, List<Object> values, boolean exist) {
        this.addDiscreteFactor(new EquationDiscreteDomain(), name, comment, path, values, exist);
    }

    protected void addDiscreteFactor(DiscreteDomain domain, String name, String comment, String path, List<Object> values, boolean exist) {
        Factor f = new Factor(name);
        TreeMap<Object, Object> domainValues = new TreeMap<Object, Object>();
        int label = 0;
        for (Object value : values) {
            domainValues.put(label, value);
            ++label;
        }
        domain.setValues(domainValues);
        f.setDomain(domain);
        f.setComment(comment);
        f.setPath(path);
        if (exist) {
            this.removeFactor(path);
        }
        this.addFactor(f);
    }

    public void addContinuousEquationFactor(Factor f, boolean exist) {
        if (exist) {
            this.removeFactor(f.getPath());
        }
        this.addFactor(f);
    }

    public void removeFactor(String factorPath) {
        this.removeFactor(this.getFactorGroup(), factorPath);
    }

    protected void removeFactor(FactorGroup factorGroup, String factorPath) {
        ArrayList<Factor> factorCopy = new ArrayList<Factor>(factorGroup.getFactors());
        for (Factor factor : factorCopy) {
            if (factor instanceof FactorGroup) {
                this.removeFactor((FactorGroup)factor, factorPath);
            }
            if (!factorPath.equals(factor.getPath())) continue;
            factorGroup.remove(factor);
        }
    }

    protected FactorGroup getFactorGroup() {
        return this.factorWizardUI.getContextValue(FactorGroup.class);
    }

    protected SimulationParameter getParameters() {
        return this.factorWizardUI.getContextValue(SimulationParameter.class);
    }
}

