/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.population.PopulationMigrationMigrationUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationMigrationMigrationHandler
extends InputContentHandler<PopulationMigrationMigrationUI> {
    private static final Log log = LogFactory.getLog(PopulationMigrationMigrationHandler.class);

    protected PopulationMigrationMigrationHandler(PopulationMigrationMigrationUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((PopulationMigrationMigrationUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    ((PopulationMigrationMigrationUI)((PopulationMigrationMigrationHandler)PopulationMigrationMigrationHandler.this).inputContentUI).fieldPopulationMigrationMigrationCoefficient.setText("");
                    ((PopulationMigrationMigrationUI)((PopulationMigrationMigrationHandler)PopulationMigrationMigrationHandler.this).inputContentUI).populationMigrationMigrationTable.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    // empty if block
                }
                PopulationMigrationMigrationHandler.this.setFieldPopulationMigrationMigrationGroupChooserModel();
                PopulationMigrationMigrationHandler.this.setFieldPopulationMigrationMigrationDepartureZoneChooserModel();
                PopulationMigrationMigrationHandler.this.setFieldPopulationMigrationMigrationArrivalZoneChooserModel();
                PopulationMigrationMigrationHandler.this.setAddButton();
            }
        });
    }

    protected void populationMigrationMigrationMatrixChanged(MatrixPanelEvent event) {
        if (((PopulationMigrationMigrationUI)this.inputContentUI).getPopInfo() != null) {
            ((PopulationMigrationMigrationUI)this.inputContentUI).getPopInfo().setMigrationMatrix(((PopulationMigrationMigrationUI)this.inputContentUI).populationMigrationMigrationTable.getMatrix().clone());
        }
    }

    public void init(PopulationSeasonInfo pi) {
        ((PopulationMigrationMigrationUI)this.inputContentUI).populationMigrationMigrationTable.setMatrix(((PopulationMigrationMigrationUI)this.inputContentUI).getPopInfo().getMigrationMatrix().copy());
    }

    protected void setFieldPopulationMigrationMigrationGroupChooserModel() {
        GenericComboModel<PopulationGroup> groups = new GenericComboModel<PopulationGroup>();
        if (((PopulationMigrationMigrationUI)this.inputContentUI).getBean() != null && ((PopulationMigrationMigrationUI)this.inputContentUI).getBean().getPopulationGroup() != null) {
            groups.setElementList(((PopulationMigrationMigrationUI)this.inputContentUI).getBean().getPopulationGroup());
        }
        ((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationGroupChooser.setModel(groups);
    }

    protected void setFieldPopulationMigrationMigrationDepartureZoneChooserModel() {
        GenericComboModel<Zone> zones = new GenericComboModel<Zone>();
        if (((PopulationMigrationMigrationUI)this.inputContentUI).getBean() != null && ((PopulationMigrationMigrationUI)this.inputContentUI).getBean().getPopulationZone() != null) {
            zones.setElementList(((PopulationMigrationMigrationUI)this.inputContentUI).getBean().getPopulationZone());
        }
        ((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationDepartureZoneChooser.setModel(zones);
    }

    protected void setFieldPopulationMigrationMigrationArrivalZoneChooserModel() {
        GenericComboModel<Zone> zones = new GenericComboModel<Zone>();
        if (((PopulationMigrationMigrationUI)this.inputContentUI).getBean() != null && ((PopulationMigrationMigrationUI)this.inputContentUI).getBean().getPopulationZone() != null) {
            zones.setElementList(((PopulationMigrationMigrationUI)this.inputContentUI).getBean().getPopulationZone());
        }
        ((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationArrivalZoneChooser.setModel(zones);
    }

    protected void add() {
        this.addMigration(((PopulationMigrationMigrationUI)this.inputContentUI).getPopInfo(), (PopulationGroup)((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationGroupChooser.getSelectedItem(), (Zone)((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationDepartureZoneChooser.getSelectedItem(), (Zone)((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationArrivalZoneChooser.getSelectedItem(), Double.parseDouble(((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationCoefficient.getText()));
        ((PopulationMigrationMigrationUI)this.inputContentUI).populationMigrationMigrationTable.setMatrix(((PopulationMigrationMigrationUI)this.inputContentUI).getPopInfo().getMigrationMatrix().clone());
    }

    public Object addMigration(PopulationSeasonInfo info, PopulationGroup group, Zone departure, Zone arrival, double coeff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"addMigration called");
        }
        try {
            MatrixND mat = info.getMigrationMatrix().copy();
            mat.setValue((Object)group, (Object)departure, (Object)arrival, coeff);
            info.setMigrationMatrix(mat);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add migration", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Migration"}), eee);
        }
        return null;
    }

    protected void remove() {
        int row = ((PopulationMigrationMigrationUI)this.inputContentUI).populationMigrationMigrationTable.getTable().getSelectedRow();
        if (row != -1) {
            Object group = ((PopulationMigrationMigrationUI)this.inputContentUI).populationMigrationMigrationTable.getTable().getValueAt(row, 0);
            Object departure = ((PopulationMigrationMigrationUI)this.inputContentUI).populationMigrationMigrationTable.getTable().getValueAt(row, 1);
            Object arrival = ((PopulationMigrationMigrationUI)this.inputContentUI).populationMigrationMigrationTable.getTable().getValueAt(row, 2);
            MatrixND mat = ((PopulationMigrationMigrationUI)this.inputContentUI).getPopInfo().getMigrationMatrix().clone();
            mat.setValue(group, departure, arrival, 0.0);
            ((PopulationMigrationMigrationUI)this.inputContentUI).getPopInfo().setMigrationMatrix(mat);
            ((PopulationMigrationMigrationUI)this.inputContentUI).populationMigrationMigrationTable.setMatrix(((PopulationMigrationMigrationUI)this.inputContentUI).getPopInfo().getMigrationMatrix().copy());
        }
    }

    protected void setAddButton() {
        ((PopulationMigrationMigrationUI)this.inputContentUI).add.setEnabled(((PopulationMigrationMigrationUI)this.inputContentUI).isActive() != false && ((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationGroupChooser.getSelectedItem() != null && !((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationCoefficient.getText().equals("") && ((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationDepartureZoneChooser.getSelectedItem() != null && ((PopulationMigrationMigrationUI)this.inputContentUI).fieldPopulationMigrationMigrationArrivalZoneChooser.getSelectedItem() != null);
    }
}

