/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.observation;

import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.observation.ObservationUI;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class ObservationHandler
extends InputContentHandler<ObservationUI> {
    private static final Log log = LogFactory.getLog(ObservationHandler.class);

    protected ObservationHandler(ObservationUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((ObservationUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    ((ObservationUI)((ObservationHandler)ObservationHandler.this).inputContentUI).fieldObservationValue.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    ObservationHandler.this.setObservationValueMatrix();
                }
            }
        });
    }

    protected void setObservationValueMatrix() {
        MatrixND prop = ((ObservationUI)this.inputContentUI).getBean().getValue();
        if (prop != null) {
            ((ObservationUI)this.inputContentUI).fieldObservationValue.setMatrix(prop.copy());
        } else {
            ((ObservationUI)this.inputContentUI).fieldObservationValue.setMatrix(null);
        }
    }

    protected void createObservationValueMatrix() {
        this.createObservationValueMatrix(((ObservationUI)this.inputContentUI).getBean());
        this.setObservationValueMatrix();
    }

    public void createObservationValueMatrix(Observation observation) {
        try {
            String val = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.observation.value.dimensions", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)val)) {
                String[] values = val.trim().split("(,|;|\\*|x|\\s)");
                ArrayList<Integer> dims = new ArrayList<Integer>();
                for (String value : values) {
                    if (value.isEmpty() || !StringUtils.isNumeric((CharSequence)value)) continue;
                    dims.add(Integer.valueOf(value));
                }
                int[] dim = new int[dims.size()];
                for (int i = 0; i < dims.size(); ++i) {
                    dim[i] = (Integer)dims.get(i);
                }
                MatrixND newMat = MatrixFactory.getInstance().create(dim);
                MatrixND mat = observation.getValue();
                if (mat != null) {
                    newMat.paste(mat);
                }
                observation.setValue(newMat);
                observation.update();
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove RecruitmentDistribution", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"RecruitmentDistribution"}), eee);
        }
    }

    protected void observationValueMatrixChanged(MatrixPanelEvent event) {
        MatrixND mat = ((ObservationUI)this.inputContentUI).fieldObservationValue.getMatrix();
        if (((ObservationUI)this.inputContentUI).getBean() != null && mat != null) {
            ((ObservationUI)this.inputContentUI).getBean().setValue(mat.copy());
        }
    }
}

