/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.CommonHandler;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardHandler;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardUI;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public class InputContentHandler<T extends InputContentUI<? extends TopiaEntityContextable>>
extends CommonHandler {
    private static final Log log = LogFactory.getLog(InputContentHandler.class);
    protected T inputContentUI;

    protected InputContentHandler(T inputContentUI) {
        this.inputContentUI = inputContentUI;
    }

    public void accept(InputContentUI<?> inputContentUI, ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        Class sensitivityBeanClass = (Class)source.getClientProperty("sensitivityBean");
        String sensitivityBeanID = (String)source.getClientProperty("sensitivityBeanID");
        String sensitivityMethod = (String)source.getClientProperty("sensitivityMethod");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event intercepted " + source));
            log.debug((Object)(" client property (bean) : " + sensitivityBeanClass));
            log.debug((Object)(" client property (beanID) : " + sensitivityBeanID));
            log.debug((Object)(" client property (method) : " + sensitivityMethod));
        }
        this.displayFactorWizard(inputContentUI, sensitivityBeanClass, sensitivityBeanID, sensitivityMethod);
    }

    public void displayFactorWizard(InputContentUI<?> inputContentUI, Class<? extends TopiaEntityContextable> sensitivityBeanClass, String sensitivityBeanID, String sensitivityMethod) {
        TopiaEntityContextable bean = null;
        bean = sensitivityBeanID == null ? inputContentUI.getSaveVerifier().getEntity(sensitivityBeanClass) : inputContentUI.getSaveVerifier().getEntity(sensitivityBeanClass, sensitivityBeanID);
        if (bean != null) {
            FactorWizardUI factorWizardUI = new FactorWizardUI((JAXXContext)inputContentUI);
            FactorWizardHandler handler = factorWizardUI.getHandler();
            handler.initNewFactor(factorWizardUI, bean, sensitivityMethod);
            factorWizardUI.pack();
            factorWizardUI.setLocationRelativeTo(inputContentUI);
            factorWizardUI.setVisible(true);
        } else if (log.isErrorEnabled()) {
            log.error((Object)("Can't find bean in current verifier (sensitivityBeanClass = " + sensitivityBeanClass + ", sensitivityBeanID = " + sensitivityBeanID + ")"));
        }
    }
}

