/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.types.TimeStep;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.profiling.Unit;

public class SimulationServiceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2414926794815727974L;
    private static Log log = LogFactory.getLog(SimulationServiceTableModel.class);
    protected static final String[] columnHeader = new String[]{I18n.t((String)"isisfish.queue.id", (Object[])new Object[0]), I18n.t((String)"isisfish.queue.plan", (Object[])new Object[0]), I18n.t((String)"isisfish.queue.launcher", (Object[])new Object[0]), I18n.t((String)"isisfish.queue.status", (Object[])new Object[0]), I18n.t((String)"isisfish.queue.progression", (Object[])new Object[0])};
    protected Class<?>[] columnClass = new Class[]{String.class, String.class, String.class, String.class, JProgressBar.class};
    protected SimulationService simulationService;
    protected ArrayList<SimulationJob> jobs;
    protected Map<String, SimulationJob> jobIds;
    protected Map<SimulationJob, JProgressBar> progress = new WeakHashMap<SimulationJob, JProgressBar>();
    protected AbstractJobListener jobListener;
    protected ControlListener controlListener;

    public SimulationServiceTableModel(SimulationService simulationService, boolean forDoToJobs) {
        this.simulationService = simulationService;
        this.jobListener = forDoToJobs ? new JobToDoListener(this) : new JobDoneListener(this);
        this.controlListener = new ControlListener(this);
        simulationService.addSimulationServiceListener(this.jobListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(SimulationJob job) {
        String id = job.getItem().getControl().getId();
        ArrayList<SimulationJob> arrayList = this.jobs;
        synchronized (arrayList) {
            if (!this.contains(job)) {
                this.jobs.add(job);
                this.jobIds.put(id, job);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimulationServiceTableModel.this.fireTableRowsInserted(SimulationServiceTableModel.this.jobs.size() - 1, SimulationServiceTableModel.this.jobs.size() - 1);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(SimulationJob job) {
        String id = job.getItem().getControl().getId();
        ArrayList<SimulationJob> arrayList = this.jobs;
        synchronized (arrayList) {
            final int index = this.jobs.indexOf(job);
            if (index >= 0) {
                this.jobs.remove(index);
                this.jobIds.remove(id);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimulationServiceTableModel.this.fireTableRowsDeleted(index, index);
                    }
                });
            }
        }
    }

    public void clearJob() {
        this.jobs.clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimulationServiceTableModel.this.fireTableDataChanged();
            }
        });
    }

    public ArrayList<SimulationJob> getJobs() {
        return this.jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobs(ArrayList<SimulationJob> jobs) {
        this.jobs = jobs;
        ArrayList<SimulationJob> arrayList = jobs;
        synchronized (arrayList) {
            this.jobIds = new HashMap<String, SimulationJob>(jobs.size());
            for (SimulationJob job : jobs) {
                this.jobIds.put(job.getItem().getControl().getId(), job);
            }
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(SimulationJob job) {
        String id = job.getItem().getControl().getId();
        ArrayList<SimulationJob> arrayList = this.jobs;
        synchronized (arrayList) {
            boolean result = this.jobIds.containsKey(id);
            return result;
        }
    }

    protected JProgressBar getProgressBar(SimulationJob job) {
        JProgressBar result = this.progress.get(job);
        if (result == null) {
            result = new JProgressBar(0, 0, 100);
            result.setStringPainted(true);
            this.progress.put(job, result);
        }
        return result;
    }

    public SimulationJob getJob(int row) {
        SimulationJob result = this.jobs.get(row);
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.jobs.size();
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = columnHeader.length;
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClass[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return columnHeader[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.jobs.size()) {
            if (columnIndex == 4) {
                return new JProgressBar();
            }
            return null;
        }
        Object result = "";
        SimulationJob job = this.jobs.get(rowIndex);
        SimulationControl control = job.getItem().getControl();
        String id = control.getId();
        SimulationParameter param = job.getItem().getParameter();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Update table model : id = " + control.getId() + ", control.getProgress() = " + control.getProgress() + ", control.getProgressMax() = " + control.getProgressMax() + ", control.getDate() = " + control.getStep()));
        }
        switch (columnIndex) {
            case 0: {
                result = id;
                break;
            }
            case 1: {
                int number;
                if (!param.getUseSimulationPlan() || (number = param.getSimulationPlanNumber()) < 0) break;
                result = number;
                break;
            }
            case 2: {
                if (job.getLauncher() == null) {
                    if (param.getUseSimulationPlan()) {
                        result = I18n.t((String)"isisfish.queue.masterplan", (Object[])new Object[0]);
                        break;
                    }
                    result = I18n.t((String)"isisfish.queue.notstarted", (Object[])new Object[0]);
                    break;
                }
                result = job.getLauncher().toString();
                break;
            }
            case 3: {
                if (control.isStopSimulationRequest()) {
                    result = I18n.t((String)"isisfish.launch.stop", (Object[])new Object[0]);
                    break;
                }
                result = control.getText();
                break;
            }
            case 4: {
                JProgressBar pb = this.getProgressBar(job);
                int value = (int)control.getProgress();
                int max = (int)control.getProgressMax();
                String restTime = "";
                int rest = max - value;
                double time = (double)rest * control.getTimeStepMeanTime();
                if (time > 0.0) {
                    long milli = (long)Unit.Time.s.convertTo(Unit.Time.milli, time);
                    restTime = DurationFormatUtils.formatDurationHMS((long)milli);
                }
                pb.setMaximum(max);
                pb.setValue(value);
                TimeStep step = control.getStep();
                if (step != null) {
                    pb.setString(step.getMonth() + "/" + step.getYear() + " (" + restTime + ")");
                } else {
                    pb.setString("");
                }
                result = pb;
            }
        }
        return result;
    }

    protected class ControlListener
    implements PropertyChangeListener {
        protected SimulationServiceTableModel model;

        public ControlListener(SimulationServiceTableModel model) {
            this.model = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SimulationControl control = (SimulationControl)evt.getSource();
            String id = control.getId();
            ArrayList<SimulationJob> arrayList = this.model.jobs;
            synchronized (arrayList) {
                SimulationJob job = this.model.jobIds.get(id);
                final int index = this.model.getJobs().indexOf(job);
                if (index >= 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SimulationServiceTableModel.this.fireTableRowsUpdated(index, index);
                        }
                    });
                }
            }
        }
    }

    class JobToDoListener
    implements AbstractJobListener,
    SimulationServiceListener {
        protected SimulationServiceTableModel model;

        public JobToDoListener(SimulationServiceTableModel model) {
            this.model = model;
            this.setData();
        }

        @Override
        public void setData() {
            ArrayList<SimulationJob> jobs = new ArrayList<SimulationJob>(SimulationServiceTableModel.this.simulationService.getJobs());
            for (SimulationJob job : jobs) {
                job.getItem().getControl().addPropertyChangeListener(SimulationServiceTableModel.this.controlListener);
            }
            this.model.setJobs(jobs);
        }

        @Override
        public void simulationStart(SimulationService simService, SimulationJob job) {
            this.model.addJob(job);
            job.getItem().getControl().addPropertyChangeListener(this.model.controlListener);
        }

        @Override
        public void simulationStop(SimulationService simService, SimulationJob job) {
            this.model.removeJob(job);
            job.getItem().getControl().removePropertyChangeListener(this.model.controlListener);
        }

        @Override
        public void clearJobDone(SimulationService simService) {
        }
    }

    class JobDoneListener
    implements AbstractJobListener,
    SimulationServiceListener {
        protected SimulationServiceTableModel model;

        public JobDoneListener(SimulationServiceTableModel model) {
            this.model = model;
            this.setData();
        }

        @Override
        public void setData() {
            this.model.setJobs(new ArrayList<SimulationJob>(SimulationServiceTableModel.this.simulationService.getJobDones()));
        }

        @Override
        public void simulationStart(SimulationService simService, SimulationJob job) {
            this.model.removeJob(job);
        }

        @Override
        public void simulationStop(SimulationService simService, SimulationJob job) {
            this.model.addJob(job);
        }

        @Override
        public void clearJobDone(SimulationService simService) {
            this.model.clearJob();
        }
    }

    protected static interface AbstractJobListener
    extends SimulationServiceListener {
        public void setData();
    }
}

