/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Season;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RecruitmentInput;
import fr.ifremer.isisfish.types.RecruitmentInputMap;
import fr.ifremer.isisfish.types.ReproductionData;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class PopulationMonitor {
    private static Log log = LogFactory.getLog(PopulationMonitor.class);
    protected List<Population> pops = null;
    protected Map<Population, MatrixND> Ns = new HashMap<Population, MatrixND>();
    protected Map<Population, Map<TimeStep, ReproductionData>> reproductions = new HashMap<Population, Map<TimeStep, ReproductionData>>();
    protected Map<Population, Map.Entry<TimeStep, MatrixND>> discards = new HashMap<Population, Map.Entry<TimeStep, MatrixND>>();
    protected Map<Population, MatrixND> catchs = new HashMap<Population, MatrixND>();
    protected Map<Population, MatrixND> holdCatchs = new HashMap<Population, MatrixND>();
    protected double totalHoldCatch = 0.0;

    public void init(List<Population> pops) {
        this.pops = Collections.unmodifiableList(new ArrayList<Population>(pops));
        for (Population pop : this.pops) {
            this.reproductions.put(pop, new HashMap());
        }
    }

    public List<Population> getPopulations() {
        return this.pops;
    }

    public double getBiomass(Species species) {
        double result = 0.0;
        for (Population pop : species.getPopulation()) {
            result += this.getBiomass(pop);
        }
        return result;
    }

    public double getBiomass(Population pop) {
        double result = 0.0;
        MatrixND n = this.getN(pop);
        if (n != null) {
            n = n.sumOverDim(1);
            MatrixIterator i = n.iteratorNotZero();
            while (i.next()) {
                Object[] coord = i.getSemanticsCoordinates();
                PopulationGroup group = (PopulationGroup)coord[0];
                result += i.getValue() * group.getMeanWeight();
            }
        }
        return result;
    }

    public MatrixND getN(Population pop) {
        MatrixND result = this.Ns.get(pop);
        if (result != null) {
            result.setSemantic(0, pop.getPopulationGroup());
            result.setSemantic(1, pop.getPopulationZone());
        }
        return result;
    }

    public void setN(Population pop, MatrixND mat) {
        this.Ns.put(pop, mat);
    }

    public MatrixND getReproduction(TimeStep step, Population pop) {
        return this.getReproductionData(step, pop).getRepro();
    }

    public ReproductionData getReproductionData(TimeStep step, Population pop) {
        return this.reproductions.get(pop).get(step);
    }

    public void setReproduction(TimeStep step, Population pop, MatrixND aN, MatrixND aBiomass, MatrixND repro) {
        this.reproductions.get(pop).put(step, new ReproductionData(aN, aBiomass, repro));
    }

    public void applyReproductionMortality(Population pop) {
        for (ReproductionData nAndRepro : this.reproductions.get(pop).values()) {
            MatrixND reproduction = nAndRepro.getRepro();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Matrix repro before mortality: " + reproduction));
            }
            MatrixIterator mi = reproduction.iteratorNotZero();
            while (mi.next()) {
                Object[] sems = mi.getSemanticsCoordinates();
                Zone z = (Zone)sems[0];
                double coeff = pop.getNaturalDeathBirth(z);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("NaturalDeath zone " + z + "=" + coeff));
                }
                mi.setValue(mi.getValue() * Math.exp(-coeff / (double)Month.NUMBER_OF_MONTH));
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Matrix repro after mortality: " + reproduction));
        }
    }

    public MatrixND getRecruitment(TimeStep step, Population pop) {
        MatrixND matEtalement = pop.getRecruitmentDistribution();
        int etalement = matEtalement.getDim(0);
        MatrixND result = MatrixFactory.getInstance().create(new List[]{pop.getPopulationGroup(), pop.getPopulationZone()});
        HashMap recruitmentInputMap = null;
        Season foundReproductionSeasonInfo = null;
        for (int e = 0; e < etalement; ++e) {
            int pos;
            TimeStep t = new TimeStep(step.getStep() - e - pop.getMonthGapBetweenReproRecrutement());
            ReproductionData reproductionData = this.reproductions.get(pop).get(t);
            if (reproductionData == null) continue;
            Month reproMonth = t.getMonth();
            PopulationSeasonInfo reproductionSeasonInfo = pop.getPopulationSeasonInfo(reproMonth);
            if (reproductionSeasonInfo != null && reproductionSeasonInfo.isReproduction() && foundReproductionSeasonInfo == null) {
                foundReproductionSeasonInfo = reproductionSeasonInfo;
                int monthCount = foundReproductionSeasonInfo.getMonths().size();
                recruitmentInputMap = new RecruitmentInputMap(monthCount);
                int pos2 = reproductionSeasonInfo.getMonths().indexOf(reproMonth);
                for (int p = 0; p < monthCount; ++p) {
                    TimeStep t2 = new TimeStep(t.getStep() + p - pos2);
                    ReproductionData reproductionData2 = this.reproductions.get(pop).get(t2);
                    RecruitmentInput recruitmentInput2 = reproductionData2 != null ? new RecruitmentInput(reproductionData2) : new RecruitmentInput();
                    recruitmentInputMap.put(p, recruitmentInput2);
                }
            }
            if (foundReproductionSeasonInfo != null && (pos = foundReproductionSeasonInfo.getMonths().indexOf(reproMonth)) != -1) {
                RecruitmentInput recruitmentInput = (RecruitmentInput)recruitmentInputMap.get(pos);
                Double contribution = matEtalement.getValue(e);
                recruitmentInput.setRecruitementContribution(contribution);
            }
            MatrixND repro = reproductionData.getRepro();
            int indiceClasse = 0;
            PopulationGroup classe = pop.getPopulationGroup().get(indiceClasse);
            List<Zone> zoneRepros = pop.getReproductionZone();
            double coeff = matEtalement.getValue(e);
            MatrixND matRepro = repro.copy();
            matRepro = matRepro.mults(coeff);
            matRepro.setSemantic(0, zoneRepros);
            MatrixND mapping = pop.getMappingZoneReproZoneRecru();
            for (Zone zoneRepro : zoneRepros) {
                MatrixND submapping = mapping.getSubMatrix(0, new Object[]{zoneRepro});
                MatrixIterator i = submapping.iterator();
                while (i.hasNext()) {
                    i.next();
                    Object[] sem = i.getSemanticsCoordinates();
                    Zone zoneRecru = (Zone)sem[1];
                    double c = i.getValue();
                    result.setValue((Object)classe, (Object)zoneRecru, c * matRepro.getValue((Object)zoneRepro) + result.getValue((Object)classe, (Object)zoneRecru));
                }
            }
        }
        if (pop.getSpecies().isAgeGroupType()) {
            MatrixND N = pop.N2DToN1D(result);
            TimeStep stepRepro = new TimeStep(step.getStep() - pop.getMonthGapBetweenReproRecrutement());
            List<PopulationSeasonInfo> infos = pop.getPopulationSeasonInfo();
            ArrayList<PopulationSeasonInfo> usedSeasons = new ArrayList<PopulationSeasonInfo>();
            block4: while (step.after(stepRepro)) {
                stepRepro = stepRepro.next();
                Month month = stepRepro.getMonth();
                for (PopulationSeasonInfo info : infos) {
                    if (!month.equals(info.getFirstMonth())) continue;
                    usedSeasons.add(info);
                    stepRepro = new TimeStep(stepRepro.getStep() + info.getMonths().size() - 1);
                    continue block4;
                }
            }
            for (PopulationSeasonInfo info : usedSeasons) {
                Month month = info.getFirstMonth();
                MatrixND CA = info.getGroupChangeMatrix(month);
                N = N.mult(CA);
            }
            result = pop.split2D(N);
        }
        if (recruitmentInputMap != null) {
            result = pop.getRecruitmentMatrix(step, pop, (RecruitmentInputMap)recruitmentInputMap, result);
        }
        return result;
    }

    public void holdCatch(Population pop, MatrixND catchPerStrategyMet) {
        this.catchs.put(pop, catchPerStrategyMet);
        MatrixND holdCatch = this.holdCatchs.get(pop);
        if (holdCatch == null) {
            holdCatch = catchPerStrategyMet.copy();
            this.holdCatchs.put(pop, holdCatch);
        } else {
            holdCatch.add(catchPerStrategyMet);
        }
        MatrixIterator i = catchPerStrategyMet.iteratorNotZero();
        while (i.next()) {
            this.totalHoldCatch += i.getValue();
        }
    }

    public MatrixND getCatch(Population pop) {
        MatrixND result = this.catchs.get(pop);
        return result;
    }

    public MatrixND getHoldCatch(Population pop) {
        MatrixND result = this.holdCatchs.get(pop);
        return result;
    }

    public double getTotalHoldCatch(Population pop) {
        double result = this.totalHoldCatch;
        return result;
    }

    public void clearCatch() {
        this.catchs.clear();
        this.holdCatchs.clear();
        this.totalHoldCatch = 0.0;
    }

    public MatrixND getDiscard(TimeStep step, Population pop) {
        this.checkStep(step, "You can only get discard for current step simulation, for old discard you must use ResultStorage");
        MatrixND result = null;
        Map.Entry<TimeStep, MatrixND> discard = this.discards.get(pop);
        if (discard != null && discard.getKey().equals(step)) {
            result = discard.getValue();
        }
        return result;
    }

    public void setDiscard(TimeStep step, Population pop, MatrixND discard) {
        this.checkStep(step, "You can only change discard for current step simulation");
        MatrixND tmp = discard.copy();
        this.discards.put(pop, new AbstractMap.SimpleEntry<TimeStep, MatrixND>(step, tmp));
    }

    public void addDiscard(TimeStep step, Population pop, MatrixND discard) {
        this.checkStep(step, "You can only add discard for current step simulation");
        MatrixND oneDiscard = this.getDiscard(step, pop);
        if (oneDiscard == null) {
            oneDiscard = discard.copy();
        } else {
            oneDiscard.add(discard);
        }
        this.setDiscard(step, pop, oneDiscard);
    }

    public void checkStep(TimeStep step, String msg) {
        SimulationContext sim = SimulationContext.get();
        TimeStep simStep = sim.getSimulationControl().getStep();
        if (!step.equals(simStep)) {
            throw new IsisFishRuntimeException(msg);
        }
    }
}

