/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.OptimizationContext;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlanContextInternal;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class OptimizationContextInternal
extends SimulationPlanContextInternal
implements OptimizationContext {
    protected SimulationJob job;
    protected int generationNumber = 0;
    protected List<List<SimulationStorage>> generations = new ArrayList<List<SimulationStorage>>();
    protected List<SimulationStorage> nextSimulations;

    public OptimizationContextInternal(String id, SimulationParameter param, SimulationJob job) {
        super(id, param);
        this.job = job;
    }

    @Override
    public List<SimulationStorage> getNextSimulations() {
        if (this.nextSimulations == null) {
            this.nextSimulations = new ArrayList<SimulationStorage>();
        }
        return this.nextSimulations;
    }

    public List<SimulationStorage> clearNextSimulation() {
        List<SimulationStorage> result = this.nextSimulations;
        if (CollectionUtils.isNotEmpty(result)) {
            this.generations.add(result);
            this.nextSimulations = null;
        }
        return result;
    }

    @Override
    public List<SimulationStorage> getLastSimulations() {
        List<SimulationStorage> result = this.getGeneration(this.generations.size() - 1);
        return result;
    }

    @Override
    public SimulationStorage newSimulation() {
        try {
            String simId = this.id + "_" + this.number;
            SimulationParameter childParam = this.param.copy();
            childParam.setSimulationPlanNumber(this.number);
            childParam.setOptimizationGeneration(this.generations.size());
            childParam.setOptimizationGenerationIndividual(this.getNextSimulations().size());
            SimulationStorage result = SimulationStorage.importAndRenameZip(this.job.getItem().getSimulationZip(), simId);
            result.setParameter(childParam);
            this.incNumber();
            this.addSimulation(result);
            return result;
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException("can't create new simulation", eee);
        }
    }

    protected void addSimulation(SimulationStorage s) {
        this.getNextSimulations().add(s);
    }

    @Override
    public SimulationStorage newSimulation(Factor ... factors) {
        SimulationStorage s = this.newSimulation();
        ArrayList<Factor> colFactors = new ArrayList<Factor>();
        Collections.addAll(colFactors, factors);
        String script = FactorHelper.generatePreScript(colFactors);
        SimulationParameter childParam = s.getParameter();
        childParam.setGeneratedPreScript(script);
        return s;
    }

    @Override
    public int getCurrentGeneration() {
        return this.generationNumber;
    }

    public void incGenerationNumber() {
        ++this.generationNumber;
    }

    public int getSimulationNumber() {
        return this.number;
    }

    @Override
    public List<SimulationStorage> getGeneration(int n) {
        List<SimulationStorage> result = null;
        if (this.generations.size() == n) {
            result = this.getNextSimulations();
        } else if (n >= 0 && CollectionUtils.isNotEmpty(this.generations)) {
            result = this.generations.get(n);
        }
        return result;
    }
}

