/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Distribution;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;

public class DomXMLParser {
    private static Log log = LogFactory.getLog(DomXMLParser.class);

    public static DesignPlan parseDesignPlan(Element rootElement, TopiaContext topiaContext) {
        DesignPlan plan = new DesignPlan();
        String version = rootElement.attributeValue("version");
        List factorGroupElements = rootElement.elements("factors");
        FactorGroup factorGroup = null;
        if (!factorGroupElements.isEmpty()) {
            factorGroup = "3".equals(version) ? DomXMLParser.parseFactorGroupV3((Element)factorGroupElements.get(0), topiaContext) : ("2".equals(version) ? DomXMLParser.parseFactorGroupV2((Element)factorGroupElements.get(0), topiaContext) : DomXMLParser.parseFactorGroup((Element)factorGroupElements.get(0), topiaContext));
        }
        plan.setFactorGroup(factorGroup);
        return plan;
    }

    @Deprecated
    protected static FactorGroup parseFactorGroup(Element fgElement, TopiaContext topiaContext) {
        String factorGroupName = fgElement.attributeValue("name");
        String factorGroupType = fgElement.attributeValue("type");
        boolean continuous = "continuous".equalsIgnoreCase(factorGroupType);
        FactorGroup factorGroup = new FactorGroup(factorGroupName, continuous);
        List factorGroupElements = fgElement.selectNodes("child::factors");
        for (Element factorGroupElement : factorGroupElements) {
            FactorGroup subFactorGroup = DomXMLParser.parseFactorGroup(factorGroupElement, topiaContext);
            factorGroup.addFactor(subFactorGroup);
        }
        List factorElements = fgElement.selectNodes("child::factor");
        for (Element factorElement : factorElements) {
            List valueElements;
            Element percentageElement;
            Element equationElement;
            Element coefficientElement;
            Element matrixElement;
            Domain domain;
            Element fixedElement;
            Factor factor;
            String type = factorElement.attributeValue("type");
            String name = factorElement.attributeValue("name");
            String property = factorElement.attributeValue("property");
            String path = factorElement.element("target").getTextTrim();
            if ("real".equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element("domain").element("fixed");
                if (property.endsWith("continuous")) {
                    if (property.equals("matrixcontinuous")) {
                        domain = new ContinuousDomain(Distribution.QUNIFPC);
                        matrixElement = fixedElement.element("mx");
                        MatrixND matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                        ((ContinuousDomain)domain).addDistributionParam("reference", matrix);
                        coefficientElement = fixedElement.element("coefficient");
                        ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(coefficientElement.attributeValue("value")));
                    } else if (property.equals("equationcontinuous")) {
                        domain = new ContinuousDomain(Distribution.QUNIFPC);
                        equationElement = fixedElement.element("equation");
                        ((ContinuousDomain)domain).addDistributionParam("reference", Double.valueOf(equationElement.attributeValue("reference")));
                        String variable = equationElement.attributeValue("variable");
                        factor.setEquationVariableName(variable);
                        name = StringUtils.removeEnd((String)name, (String)("." + variable));
                        factor.setName(name);
                        coefficientElement = fixedElement.element("coefficient");
                        ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(coefficientElement.attributeValue("value")));
                    } else {
                        percentageElement = fixedElement.element("percentage");
                        if (percentageElement != null) {
                            domain = new ContinuousDomain(Distribution.QUNIFPC);
                            ((ContinuousDomain)domain).addDistributionParam("reference", Double.valueOf(percentageElement.attributeValue("reference")));
                            ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(percentageElement.attributeValue("coefficient")));
                        } else {
                            domain = new ContinuousDomain(Distribution.QUNIFMM);
                            Element rangeElement = fixedElement.element("range");
                            ((ContinuousDomain)domain).addDistributionParam("min", Double.valueOf(rangeElement.attributeValue("min")));
                            ((ContinuousDomain)domain).addDistributionParam("max", Double.valueOf(rangeElement.attributeValue("max")));
                        }
                    }
                    factor.setCardinality(Integer.valueOf(fixedElement.attributeValue("cardinality")));
                    factor.setDomain(domain);
                } else if ("discrete".equals(property)) {
                    domain = new DiscreteDomain();
                    valueElements = fixedElement.element("enumeration").elements("value");
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        ((DiscreteDomain)domain).getValues().put(label, Double.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factorGroup.addFactor(factor);
                continue;
            }
            if ("integer".equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element("domain").element("fixed");
                if ("continuous".equals(property)) {
                    if (property.equals("matrixcontinuous")) {
                        domain = new ContinuousDomain(Distribution.QUNIFPC);
                        matrixElement = fixedElement.element("mx");
                        MatrixND matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                        ((ContinuousDomain)domain).addDistributionParam("reference", matrix);
                        coefficientElement = fixedElement.element("coefficient");
                        ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(coefficientElement.attributeValue("value")));
                    } else if (property.equals("equationcontinuous")) {
                        domain = new ContinuousDomain(Distribution.QUNIFPC);
                        equationElement = fixedElement.element("equation");
                        ((ContinuousDomain)domain).addDistributionParam("reference", Double.valueOf(equationElement.attributeValue("reference")));
                        String variable = equationElement.attributeValue("variable");
                        factor.setEquationVariableName(variable);
                        name = StringUtils.removeEnd((String)name, (String)("." + variable));
                        factor.setName(name);
                        coefficientElement = fixedElement.element("coefficient");
                        ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(coefficientElement.attributeValue("value")));
                    } else {
                        percentageElement = fixedElement.element("percentage");
                        if (percentageElement != null) {
                            domain = new ContinuousDomain(Distribution.QUNIFPC);
                            ((ContinuousDomain)domain).addDistributionParam("reference", Double.valueOf(percentageElement.attributeValue("reference")));
                            ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(percentageElement.attributeValue("coefficient")));
                        } else {
                            domain = new ContinuousDomain(Distribution.QUNIFMM);
                            Element rangeElement = fixedElement.element("range");
                            ((ContinuousDomain)domain).addDistributionParam("min", Integer.valueOf(rangeElement.attributeValue("min")));
                            ((ContinuousDomain)domain).addDistributionParam("max", Integer.valueOf(rangeElement.attributeValue("max")));
                        }
                    }
                    factor.setCardinality(Integer.valueOf(fixedElement.attributeValue("cardinality")));
                    factor.setDomain(domain);
                } else if ("discrete".equals(property)) {
                    domain = new DiscreteDomain();
                    valueElements = fixedElement.element("enumeration").elements("value");
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        ((DiscreteDomain)domain).getValues().put(label, Integer.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factorGroup.addFactor(factor);
                continue;
            }
            if (!"rule".equals(type)) continue;
            factor = new Factor(name);
            factor.setPath(path);
            fixedElement = factorElement.element("domain").element("fixed");
            if ("discrete".equals(property)) {
                domain = new RuleDiscreteDomain();
                valueElements = fixedElement.element("enumeration").elements("value");
                int label = 0;
                for (Element valueElement : valueElements) {
                    Element rulesElement = valueElement.element("rules");
                    List<Rule> rulesValue = MexicoHelper.getRulesFromXml(rulesElement, topiaContext);
                    ((DiscreteDomain)domain).getValues().put(label, rulesValue);
                    ++label;
                }
                factor.setDomain(domain);
            }
            factorGroup.addFactor(factor);
        }
        return factorGroup;
    }

    protected static FactorGroup parseFactorGroupV2(Element fgElement, TopiaContext topiaContext) {
        String factorGroupName = fgElement.attributeValue("name");
        String factorGroupType = fgElement.attributeValue("type");
        boolean continuous = "continuous".equalsIgnoreCase(factorGroupType);
        FactorGroup factorGroup = new FactorGroup(factorGroupName, continuous);
        List factorGroupElements = fgElement.selectNodes("child::factors");
        for (Element factorGroupElement : factorGroupElements) {
            FactorGroup subFactorGroup = DomXMLParser.parseFactorGroupV2(factorGroupElement, topiaContext);
            factorGroup.addFactor(subFactorGroup);
        }
        List factorElements = fgElement.selectNodes("child::factor");
        for (Element factorElement : factorElements) {
            String content;
            List valueElements;
            Element maxElement;
            Element minElement;
            Element rangeElement;
            String variable;
            MatrixND maxMatrix;
            MatrixND minMatrix;
            Element maxElement2;
            Element minElement2;
            MatrixND matrix;
            Domain domain;
            Element referenceElement;
            Element fixedElement;
            Factor factor;
            String type = factorElement.attributeValue("type");
            String name = factorElement.attributeValue("name");
            String property = factorElement.attributeValue("property");
            String path = factorElement.element("target").getTextTrim();
            String cardinalityString = factorElement.attributeValue("cardinality");
            Integer cardinality = 0;
            if (StringUtils.isNotEmpty((CharSequence)cardinalityString)) {
                cardinality = Integer.valueOf(cardinalityString);
            }
            if ("real".equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element("domain").element("fixed");
                if (property.endsWith("continuous")) {
                    if (property.equals("matrixcontinuous")) {
                        referenceElement = fixedElement.element("reference");
                        if (referenceElement != null) {
                            domain = new ContinuousDomain(Distribution.QUNIFPC);
                            Element matrixElement = referenceElement.element("mx");
                            matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                            ((ContinuousDomain)domain).addDistributionParam("reference", matrix);
                            ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(referenceElement.attributeValue("coefficient")));
                        } else {
                            domain = new ContinuousDomain(Distribution.QUNIFMM);
                            Element rangeElement2 = fixedElement.element("range");
                            minElement2 = rangeElement2.element("min");
                            maxElement2 = rangeElement2.element("max");
                            minMatrix = MexicoHelper.getMatrixFromXml(minElement2.element("mx"), topiaContext);
                            maxMatrix = MexicoHelper.getMatrixFromXml(maxElement2.element("mx"), topiaContext);
                            ((ContinuousDomain)domain).addDistributionParam("min", minMatrix);
                            ((ContinuousDomain)domain).addDistributionParam("max", maxMatrix);
                        }
                    } else if (property.equals("equationcontinuous")) {
                        variable = fixedElement.attributeValue("variable");
                        factor.setEquationVariableName(variable);
                        name = StringUtils.removeEnd((String)name, (String)("." + variable));
                        factor.setName(name);
                        Element referenceElement2 = fixedElement.element("reference");
                        if (referenceElement2 != null) {
                            domain = new ContinuousDomain(Distribution.QUNIFPC);
                            ((ContinuousDomain)domain).addDistributionParam("reference", Double.valueOf(referenceElement2.getTextTrim()));
                            ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(referenceElement2.attributeValue("coefficient")));
                        } else {
                            domain = new ContinuousDomain(Distribution.QUNIFMM);
                            rangeElement = fixedElement.element("range");
                            minElement = rangeElement.element("min");
                            maxElement = rangeElement.element("max");
                            ((ContinuousDomain)domain).addDistributionParam("min", minElement.getTextTrim());
                            ((ContinuousDomain)domain).addDistributionParam("max", maxElement.getTextTrim());
                        }
                    } else {
                        referenceElement = fixedElement.element("reference");
                        if (referenceElement != null) {
                            domain = new ContinuousDomain(Distribution.QUNIFPC);
                            ((ContinuousDomain)domain).addDistributionParam("reference", Double.valueOf(referenceElement.getTextTrim()));
                            ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(referenceElement.attributeValue("coefficient")));
                        } else {
                            domain = new ContinuousDomain(Distribution.QUNIFMM);
                            Element rangeElement3 = fixedElement.element("range");
                            minElement2 = rangeElement3.element("min");
                            maxElement2 = rangeElement3.element("max");
                            ((ContinuousDomain)domain).addDistributionParam("min", Double.valueOf(minElement2.getTextTrim()));
                            ((ContinuousDomain)domain).addDistributionParam("max", Double.valueOf(maxElement2.getTextTrim()));
                        }
                    }
                    factor.setDomain(domain);
                } else if ("discrete".equals(property)) {
                    domain = new DiscreteDomain();
                    valueElements = fixedElement.element("enumeration").elements("value");
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        ((DiscreteDomain)domain).getValues().put(label, Double.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factor.setCardinality(cardinality);
                factorGroup.addFactor(factor);
                continue;
            }
            if ("integer".equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element("domain").element("fixed");
                if ("continuous".equals(property)) {
                    if (property.equals("matrixcontinuous")) {
                        referenceElement = fixedElement.element("reference");
                        if (referenceElement != null) {
                            domain = new ContinuousDomain(Distribution.QUNIFPC);
                            Element matrixElement = referenceElement.element("mx");
                            matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                            ((ContinuousDomain)domain).addDistributionParam("reference", matrix);
                            ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(referenceElement.attributeValue("coefficient")));
                        } else {
                            domain = new ContinuousDomain(Distribution.QUNIFMM);
                            Element rangeElement4 = fixedElement.element("range");
                            minElement2 = rangeElement4.element("min");
                            maxElement2 = rangeElement4.element("max");
                            minMatrix = MexicoHelper.getMatrixFromXml(minElement2.element("mx"), topiaContext);
                            maxMatrix = MexicoHelper.getMatrixFromXml(maxElement2.element("mx"), topiaContext);
                            ((ContinuousDomain)domain).addDistributionParam("min", minMatrix);
                            ((ContinuousDomain)domain).addDistributionParam("max", maxMatrix);
                        }
                    } else if (property.equals("equationcontinuous")) {
                        variable = fixedElement.attributeValue("variable");
                        factor.setEquationVariableName(variable);
                        name = StringUtils.removeEnd((String)name, (String)("." + variable));
                        factor.setName(name);
                        Element referenceElement3 = fixedElement.element("reference");
                        if (referenceElement3 != null) {
                            domain = new ContinuousDomain(Distribution.QUNIFPC);
                            ((ContinuousDomain)domain).addDistributionParam("reference", Double.valueOf(referenceElement3.getTextTrim()));
                            ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(referenceElement3.attributeValue("coefficient")));
                        } else {
                            domain = new ContinuousDomain(Distribution.QUNIFMM);
                            rangeElement = fixedElement.element("range");
                            minElement = rangeElement.element("min");
                            maxElement = rangeElement.element("max");
                            ((ContinuousDomain)domain).addDistributionParam("min", Double.valueOf(minElement.getTextTrim()));
                            ((ContinuousDomain)domain).addDistributionParam("max", Double.valueOf(maxElement.getTextTrim()));
                        }
                    } else {
                        referenceElement = fixedElement.element("reference");
                        if (referenceElement != null) {
                            domain = new ContinuousDomain(Distribution.QUNIFPC);
                            ((ContinuousDomain)domain).addDistributionParam("reference", Double.valueOf(referenceElement.getTextTrim()));
                            ((ContinuousDomain)domain).addDistributionParam("coefficient", Double.valueOf(referenceElement.attributeValue("coefficient")));
                        } else {
                            domain = new ContinuousDomain(Distribution.QUNIFMM);
                            Element rangeElement5 = fixedElement.element("range");
                            minElement2 = rangeElement5.element("min");
                            maxElement2 = rangeElement5.element("max");
                            ((ContinuousDomain)domain).addDistributionParam("min", Integer.valueOf(minElement2.getTextTrim()));
                            ((ContinuousDomain)domain).addDistributionParam("max", Integer.valueOf(maxElement2.getTextTrim()));
                        }
                    }
                    factor.setDomain(domain);
                } else if ("discrete".equals(property)) {
                    domain = new DiscreteDomain();
                    valueElements = fixedElement.element("enumeration").elements("value");
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        ((DiscreteDomain)domain).getValues().put(label, Integer.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factor.setCardinality(cardinality);
                factorGroup.addFactor(factor);
                continue;
            }
            if ("rule".equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element("domain").element("fixed");
                if ("discrete".equals(property)) {
                    domain = new RuleDiscreteDomain();
                    valueElements = fixedElement.element("enumeration").elements("value");
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        Element rulesElement = valueElement.element("rules");
                        List<Rule> rulesValue = MexicoHelper.getRulesFromXml(rulesElement, topiaContext);
                        ((DiscreteDomain)domain).getValues().put(label, rulesValue);
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factor.setCardinality(cardinality);
                factorGroup.addFactor(factor);
                continue;
            }
            if ("equation".equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element("domain").element("fixed");
                if ("discrete".equals(property)) {
                    domain = new EquationDiscreteDomain();
                    valueElements = fixedElement.element("enumeration").elements("value");
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        content = StringEscapeUtils.unescapeXml((String)valueElement.getText());
                        ((DiscreteDomain)domain).getValues().put(label, content);
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                factor.setCardinality(cardinality);
                factorGroup.addFactor(factor);
                continue;
            }
            if (!"string".equals(type)) continue;
            factor = new Factor(name);
            factor.setPath(path);
            fixedElement = factorElement.element("domain").element("fixed");
            if ("discrete".equals(property)) {
                domain = new DiscreteDomain();
                valueElements = fixedElement.element("enumeration").elements("value");
                int label = 0;
                for (Element valueElement : valueElements) {
                    content = valueElement.getText();
                    Object object = MexicoHelper.getObjectFromString(content, topiaContext);
                    ((DiscreteDomain)domain).getValues().put(label, object);
                    ++label;
                }
                factor.setDomain(domain);
            }
            factor.setCardinality(cardinality);
            factorGroup.addFactor(factor);
        }
        return factorGroup;
    }

    protected static FactorGroup parseFactorGroupV3(Element fgElement, TopiaContext topiaContext) {
        FactorGroup rootGroup = new FactorGroup(null);
        HashMap<String, FactorGroup> groups = new HashMap<String, FactorGroup>();
        List factorElements = fgElement.elements("factor");
        for (Element factorElement : factorElements) {
            Element varNameElement;
            Element groupTypeElement;
            Element groupElement;
            Element targetElement;
            String name = factorElement.attributeValue("name");
            String groupName = null;
            String groupType = null;
            Factor factor = new Factor(name);
            Element cardinalityElement = (Element)factorElement.selectSingleNode("child::feature[@name='cardinality']");
            if (cardinalityElement != null) {
                factor.setCardinality(Integer.valueOf(cardinalityElement.getTextTrim()));
            }
            if ((targetElement = (Element)factorElement.selectSingleNode("child::feature[@name='target']")) != null) {
                factor.setPath(targetElement.getTextTrim());
            }
            if ((groupElement = (Element)factorElement.selectSingleNode("child::feature[@name='group']")) != null) {
                groupName = groupElement.getTextTrim();
            }
            if ((groupTypeElement = (Element)factorElement.selectSingleNode("child::feature[@name='grouptype']")) != null) {
                groupType = groupTypeElement.getTextTrim();
            }
            if ((varNameElement = (Element)factorElement.selectSingleNode("child::feature[@name='equationVariableName']")) != null) {
                factor.setEquationVariableName(varNameElement.getTextTrim());
            }
            Element domainElement = factorElement.element("domain");
            String distributionName = domainElement.attributeValue("distributionName");
            String type = domainElement.attributeValue("type");
            if ("categorical".equals(distributionName)) {
                int valueName;
                DiscreteDomain domain;
                List levelElements = domainElement.elements("level");
                if ("rule".equals(type)) {
                    domain = new RuleDiscreteDomain();
                    valueName = 0;
                    for (Element levelElement : levelElements) {
                        Element rulesElement = levelElement.element("rules");
                        List<Rule> rulesValue = MexicoHelper.getRulesFromXml(rulesElement, topiaContext);
                        domain.getValues().put(valueName++, rulesValue);
                    }
                } else if ("equation".equals(type)) {
                    domain = new EquationDiscreteDomain();
                    valueName = 0;
                    for (Element levelElement : levelElements) {
                        String object = StringEscapeUtils.unescapeXml((String)levelElement.getText());
                        domain.getValues().put(valueName++, object);
                    }
                } else if ("string".equals(type)) {
                    domain = new DiscreteDomain();
                    valueName = 0;
                    for (Element levelElement : levelElements) {
                        Object object = MexicoHelper.getObjectFromString(levelElement.getTextTrim(), topiaContext);
                        domain.getValues().put(valueName++, object);
                    }
                } else if ("integer".equals(type)) {
                    domain = new DiscreteDomain();
                    valueName = 0;
                    for (Element levelElement : levelElements) {
                        Integer levelValue = Integer.valueOf(levelElement.getTextTrim());
                        domain.getValues().put(valueName++, levelValue);
                    }
                } else {
                    domain = new DiscreteDomain();
                    valueName = 0;
                    for (Element levelElement : levelElements) {
                        Double levelValue = Double.valueOf(levelElement.getTextTrim());
                        domain.getValues().put(valueName++, levelValue);
                    }
                }
                factor.setDomain(domain);
            } else if ("sequence".equals(distributionName)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Skip factor %s : unknown distribution name : %s !", name, distributionName));
                }
            } else {
                Distribution distribution = Distribution.valueOf(distributionName.toUpperCase());
                if (distribution == null) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)String.format("Skip factor %s : can't found distribution name : %s !", name, distributionName));
                    continue;
                }
                ContinuousDomain domain = new ContinuousDomain(distribution);
                Distribution.DistributionParam[] paramsDef = distribution.getDistibutionParams();
                for (Distribution.DistributionParam paramDef : paramsDef) {
                    Element paramElement = (Element)domainElement.selectSingleNode("distributionParameter[@name='" + paramDef.getName() + "']");
                    String paramName = paramElement.attributeValue("name");
                    String paramType = paramElement.attributeValue("type");
                    if ("matrix".equals(paramType)) {
                        Element mxElement = paramElement.element("mx");
                        MatrixND mxMatrix = MexicoHelper.getMatrixFromXml(mxElement, topiaContext);
                        domain.addDistributionParam(paramName, mxMatrix);
                        continue;
                    }
                    if (!"decimal".equals(paramType)) continue;
                    Double doubleValue = Double.parseDouble(paramElement.getTextTrim());
                    domain.addDistributionParam(paramName, doubleValue);
                }
                factor.setDomain(domain);
            }
            FactorGroup group = rootGroup;
            if (StringUtils.isNotBlank((CharSequence)groupName) && (group = (FactorGroup)groups.get(groupName)) == null) {
                group = new FactorGroup(groupName, "continuous".equals(groupType));
                groups.put(groupName, group);
                rootGroup.addFactor(group);
            }
            group.addFactor(factor);
        }
        return rootGroup;
    }
}

