/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging.console;

import fr.ifremer.isisfish.logging.LogLevel;
import fr.ifremer.isisfish.logging.LogLevelUtil;
import fr.ifremer.isisfish.logging.console.LogConsole;
import fr.ifremer.isisfish.logging.console.LogConsoleModel;
import fr.ifremer.isisfish.logging.console.LogMail;
import fr.ifremer.isisfish.logging.io.FileOffsetReader;
import fr.ifremer.isisfish.logging.io.LineReader;
import fr.ifremer.isisfish.logging.io.LineReaderUtil;
import fr.ifremer.isisfish.logging.io.MemoryOffsetReader;
import fr.ifremer.isisfish.logging.io.OffsetReader;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JEditorPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class LogConsoleHandler
implements PropertyChangeListener,
MouseWheelListener,
AdjustmentListener {
    private static final Log log = LogFactory.getLog(LogConsoleHandler.class);
    protected LineReader reader;
    protected List<LineReaderUtil.LevelsLineReader> levelsReaders;
    protected LogConsoleModel model;
    protected File readerDirectory;
    protected boolean dontAdjust = true;
    protected LogMail logMail;
    protected PropertyChangeSupport propertyListeners = new PropertyChangeSupport(this);

    public LogConsoleHandler(LogConsoleModel model) throws IOException {
        this.model = model;
        this.levelsReaders = new ArrayList<LineReaderUtil.LevelsLineReader>();
        File logFile = model.getLogFile();
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), "isis-log-cache");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        this.readerDirectory = new File(tmpDir, logFile.getParentFile().getName() + logFile.getName() + "_offsets");
        this.readerDirectory.deleteOnExit();
        log.info((Object)this);
    }

    public void start() throws IOException {
        long t0 = System.currentTimeMillis();
        if (!this.readerDirectory.exists()) {
            this.readerDirectory.mkdir();
        }
        LineReader reader = this.getLevelReader(0);
        this.openReader(reader);
        log.info((Object)("with reader " + this.reader + " in " + (System.currentTimeMillis() - t0)));
    }

    public void close() throws Exception {
        for (LineReaderUtil.LevelsLineReader levelsReader : this.levelsReaders) {
            try {
                levelsReader.close();
            }
            catch (IOException e) {
                log.warn((Object)I18n.t((String)"could not close reader %1$s", (Object[])new Object[]{levelsReader}));
            }
        }
        if (this.reader != null && this.reader.isOpen()) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                log.warn((Object)I18n.t((String)"could not close reader %1$s", (Object[])new Object[]{this.reader}));
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void read(long offset) throws IOException {
        if (offset < 0L) {
            offset = 0L;
        }
        String[] result = this.reader.readLine(offset, this.model.nbLinesInEditor);
        this.model.setFirstLinePosition(offset);
        this.model.allItems.clear();
        this.model.allItems.addAll(Arrays.asList(result));
        this.model.fireStateChanged();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int unitsToScroll = e.getUnitsToScroll();
        long newOffset = this.model.getFirstLinePosition() + (long)unitsToScroll;
        if (unitsToScroll > 0 ? this.model.isEOF() : this.model.isBOF()) {
            return;
        }
        try {
            this.dontAdjust = true;
            this.read(newOffset);
        }
        catch (IOException e1) {
            log.warn((Object)I18n.t((String)"could not read at offset %1$s for reason %2$s", (Object[])new Object[]{newOffset, e1.getMessage()}));
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!e.getValueIsAdjusting() && !this.dontAdjust) {
            try {
                this.dontAdjust = true;
                this.read(e.getValue());
            }
            catch (IOException e1) {
                log.warn((Object)I18n.t((String)"could not read at offset %1$s for reason %2$s", (Object[])new Object[]{e.getValue(), e1.getMessage()}));
            }
        }
        this.dontAdjust = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String properyName = evt.getPropertyName();
        if (properyName.equals("dispose")) {
            try {
                this.close();
            }
            catch (Exception e) {
                log.warn((Object)I18n.t((String)"isisfish.error.log.console.dispose", (Object[])new Object[]{this, e.getMessage()}));
            }
            return;
        }
        if (properyName.equals("reset")) {
            this.model.setLevels(0);
            this.model.setSearchText("");
            this.changeFilter();
            return;
        }
        if (properyName.equals("editorSize")) {
            JEditorPane comp = (JEditorPane)evt.getNewValue();
            int height = comp.getHeight();
            int nbLines = height / 14 - 2;
            int oldValue = this.model.getNbLinesInEditor();
            if (oldValue != nbLines) {
                log.info((Object)("change newLinesInEditor : " + oldValue + " --> " + nbLines));
                this.model.setNbLinesInEditor(nbLines);
                if (!this.model.allItems.isEmpty()) {
                    if (this.model.allItems.size() > nbLines) {
                        while (this.model.allItems.size() > nbLines) {
                            this.model.allItems.remove(this.model.allItems.size() - 1);
                        }
                    } else {
                        long lastPos = this.model.getLastLinePosition() + 1L;
                        while (this.model.allItems.size() < nbLines) {
                            try {
                                String newLine = this.reader.readLine(lastPos++);
                                if (newLine != null) {
                                    this.model.allItems.add(newLine);
                                }
                                break;
                            }
                            catch (IOException e) {
                                if (!log.isErrorEnabled()) continue;
                                log.error((Object)"Can't read log file", (Throwable)e);
                            }
                        }
                    }
                }
                this.model.fireStateChanged();
            }
            return;
        }
        if (properyName.equals("text")) {
            String newValue = (String)evt.getNewValue();
            this.model.setSearchText(newValue);
            this.changeFilter();
            return;
        }
        LogLevel level = LogLevel.valueOf(properyName);
        if (level != null) {
            Boolean newValue = (Boolean)evt.getNewValue();
            int oldLevels = this.model.getLevels();
            int newLevels = newValue != false ? LogLevelUtil.addToSet(level.ordinal(), oldLevels) : LogLevelUtil.removeFromSet(level.ordinal(), oldLevels);
            this.model.setLevels(newLevels);
            this.changeFilter();
        }
    }

    protected void changeFilter() {
        LineReader parent;
        String searchText = this.model.getSearchText();
        int levels = this.model.getLevels();
        log.info((Object)("levels:" + this.model.levels + ", searchText:" + searchText));
        try {
            parent = this.getLevelReader(levels);
        }
        catch (IOException e) {
            log.warn((Object)("could not get level reader [" + levels + "] for reason " + e.getMessage()));
            return;
        }
        LineReader reader = parent;
        if (!searchText.trim().equals("")) {
            reader = this.getPatternReader(searchText, parent);
        }
        if (this.reader instanceof LineReaderUtil.PatternLineReader) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException e) {
                log.warn((Object)("could not close pattern reader [" + this.reader + "] for reason " + e.getMessage()));
            }
        }
        try {
            this.openReader(reader);
            this.read(0L);
            this.dontAdjust = true;
            this.model.fireStateChanged();
        }
        catch (IOException e) {
            log.warn((Object)("could not open reader [" + this.reader + "] for reason " + e.getMessage()));
        }
    }

    protected LineReader getPatternReader(String searchText, LineReader parent) {
        LineReaderUtil.PatternLineReader reader = new LineReaderUtil.PatternLineReader(parent, (OffsetReader)new MemoryOffsetReader(5000), searchText, 0);
        reader.setId(parent.getId() + ":" + searchText);
        log.info((Object)reader);
        return reader;
    }

    protected LineReader getLevelReader(int levels) throws IOException {
        String levelsStr = levels + "";
        LineReader reader = null;
        for (LineReaderUtil.LevelsLineReader levelsReader : this.levelsReaders) {
            if (!levelsReader.getId().equals(levelsStr)) continue;
            reader = levelsReader;
        }
        if (reader == null) {
            File offsetFile = new File(this.readerDirectory, "offsets_" + levels);
            FileOffsetReader offsetReader = new FileOffsetReader(offsetFile);
            if (levels == 0) {
                reader = new LineReaderUtil.LevelsLineReader(this.model.getLogFile(), (OffsetReader)offsetReader, new LogLevel[0]);
            } else {
                LogLevel[] logLevels = LogLevelUtil.getLogLevels(levels);
                reader = new LineReaderUtil.LevelsLineReader(this.getLevelReader(0), (OffsetReader)offsetReader, logLevels);
            }
            reader.setId(levelsStr);
            this.levelsReaders.add((LineReaderUtil.LevelsLineReader)reader);
        }
        if (!reader.isOpen()) {
            reader.open();
        }
        log.info((Object)reader);
        return reader;
    }

    protected void openReader(LineReader reader) throws IOException {
        this.reader = reader;
        if (!this.reader.isOpen()) {
            this.reader.open();
        }
        this.model.nbLines = this.reader.getNbLines();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(propertyName, listener);
    }

    public void openLogMail(LogConsole parent) {
        if (this.logMail == null) {
            this.logMail = new LogMail(this.model.getFrom(), this.model.getLogFile(), this.model.getLogFile().getParentFile(), this.model.getSmtpServer());
        }
        this.logMail.setLocationRelativeTo(parent);
        this.logMail.setVisible(true);
    }
}

