/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore.migration;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import fr.ifremer.isisfish.ui.input.equation.EquationEditorPaneUI;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.version.Version;

public class MigrationV33V40
extends TopiaMigrationCallbackByClass.MigrationCallBackForVersion {
    private static Log log = LogFactory.getLog(MigrationV33V40.class);

    public MigrationV33V40(Version version, TopiaMigrationCallbackByClass callback) {
        super(version, callback);
    }

    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {
        Session session = tx.getHibernate();
        SQLQuery query = session.createSQLQuery("SELECT p.topiaid as pop, g.topiaid as popgroup, g.id, (select count(*) FROM POPULATIONGROUP WHERE population = p.topiaid) as c FROM POPULATION p, POPULATIONGROUP g WHERE p.MATURITYGROUP = g.TOPIAID");
        List maturityGroupResult = query.list();
        query = session.createSQLQuery("SELECT population, id, REPRODUCTIONRATE FROM POPULATIONGROUP");
        List reproductionResults = query.list();
        tx.executeSQL("alter table POPULATIONGROUP drop column REPRODUCTIONRATE;");
        tx.executeSQL("alter table POPULATION drop column MATURITYGROUP;");
        tx.executeSQL("alter table POPULATION add column MATURITYOGIVEEQUATION VARCHAR(255);");
        tx.executeSQL("alter table POPULATION add column REPRODUCTIONRATEEQUATION VARCHAR(255);");
        tx.executeSQL("alter table Result ALTER COLUMN resultdate RENAME TO resultstep;");
        tx.executeSQL("alter table ActiveRule ALTER COLUMN activeruledate RENAME TO activerulestep;");
        tx.executeSQL("alter table POPULATION add column CAPTURABILITYEQUATION VARCHAR(255);");
        tx.executeSQL("alter table POPULATION add column CAPTURABILITYEQUATIONUSED BIT default false;");
        tx.executeSQL("alter table POPULATION add column fbargroupmin integer default 0");
        tx.executeSQL("alter table POPULATION add column fbargroupmax integer default 0");
        tx.executeSQL("alter table POPULATION add column IF NOT EXISTS RecruitmentEQUATION VARCHAR(255);");
        tx.executeSQL("alter table POPULATION add column IF NOT EXISTS abundanceReferenceMonth integer default null;");
        tx.executeSQL("alter table POPULATION add column IF NOT EXISTS computeFOnLandings BIT default false;");
        tx.executeSQL("alter table POPULATION add column IF NOT EXISTS FishingMortalityOtherFleets VARCHAR(255);");
        for (Object maturityRow : maturityGroupResult) {
            String population = (String)maturityRow[0];
            String populationgroup = (String)maturityRow[1];
            int groupId = (Integer)maturityRow[2];
            int groupCount = ((BigInteger)maturityRow[3]).intValue();
            if (populationgroup == null) continue;
            Population pop = (Population)tx.findByTopiaId(population);
            String content = this.getMaturityEquationContent(groupId, groupCount);
            ((PopulationImpl)pop).setMaturityOgiveEquationContent(content);
            pop.update();
        }
        List pops = tx.findAll("from " + Population.class.getName(), new Object[0]);
        for (Population pop : pops) {
            String content = this.getReproductionRateContent(pop, reproductionResults);
            ((PopulationImpl)pop).setReproductionRateEquationContent(content);
            pop.update();
        }
        if (IsisFish.config.isLaunchUI()) {
            List equations = tx.findAll("from " + Equation.class.getName(), new Object[0]);
            for (Equation equation : equations) {
                EquationEditorPaneUI frame;
                block7: {
                    if (StringUtils.isBlank((CharSequence)equation.getContent())) continue;
                    String content = equation.getContent();
                    int ok = EvaluatorHelper.check(equation.getJavaInterface(), content, null);
                    if (ok == 0) continue;
                    content = StringUtils.replace((String)content, (String)"Date ", (String)"TimeStep ");
                    content = StringUtils.replace((String)content, (String)".getDate()", (String)".getStep()");
                    content = StringUtils.replace((String)content, (String)"new Date(", (String)"new TimeStep(");
                    ok = EvaluatorHelper.check(equation.getJavaInterface(), content, null);
                    if (ok == 0) {
                        equation.setContent(content);
                        equation.update();
                        continue;
                    }
                    frame = new EquationEditorPaneUI();
                    frame.setTitle(I18n.t((String)"isisfish.message.import.equation.convert", (Object[])new Object[0]));
                    try {
                        frame.getHandler().setEquation(equation.getCategory(), equation.getName(), equation.getJavaInterface(), content);
                    }
                    catch (Exception ex) {
                        if (!log.isErrorEnabled()) break block7;
                        log.error((Object)"Can't migrate equation", (Throwable)ex);
                    }
                }
                frame.setVisible(true);
                if (!frame.isResultOk().booleanValue()) continue;
                equation.setContent(frame.getEditor().getText());
                equation.update();
            }
        }
    }

    protected String getReproductionRateContent(Population pop, List<Object[]> reproductionResults) {
        StringBuffer b = new StringBuffer();
        b.append("if (group == null) return 0;\n");
        b.append("switch (group.getId()) {\n");
        for (Object[] reproContent : reproductionResults) {
            String popid = (String)reproContent[0];
            int gid = (Integer)reproContent[1];
            double rate = (Double)reproContent[2];
            if (!pop.getTopiaId().equals(popid)) continue;
            b.append("   case " + gid + ": return " + rate + ";\n");
        }
        b.append("  default: return 0;\n");
        b.append("}\n");
        return b.toString();
    }

    protected String getMaturityEquationContent(int groupId, int groupCount) {
        StringBuffer b = new StringBuffer();
        b.append("if (group == null) return 0;\n");
        b.append("switch (group.getId()) {\n");
        for (int i = 0; i < groupCount; ++i) {
            if (i > groupId) {
                b.append("   case " + i + ": return 0;\n");
                continue;
            }
            b.append("   case " + i + ": return 1;\n");
        }
        b.append("  default: return 0;\n");
        b.append("}\n");
        return b.toString();
    }
}

