/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore.migration;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.migration.MigrationV0V32;
import fr.ifremer.isisfish.datastore.migration.MigrationV32V33;
import fr.ifremer.isisfish.datastore.migration.MigrationV33V40;
import fr.ifremer.isisfish.datastore.migration.MigrationV40V41;
import fr.ifremer.isisfish.datastore.migration.MigrationV41V421;
import fr.ifremer.isisfish.datastore.migration.MigrationV421V43;
import fr.ifremer.isisfish.datastore.migration.MigrationV43V44;
import java.util.List;
import javax.swing.JOptionPane;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.Versions;

public class DatabaseMigrationClass
extends TopiaMigrationCallbackByClass {
    protected static final Version VERSION_32 = Versions.valueOf((String)"3.2");
    protected static final Version VERSION_33 = Versions.valueOf((String)"3.3");
    protected static final Version VERSION_40 = Versions.valueOf((String)"4.0");
    protected static final Version VERSION_41 = Versions.valueOf((String)"4.1");
    protected static final Version VERSION_421 = Versions.valueOf((String)"4.2.1");
    protected static final Version VERSION_43 = Versions.valueOf((String)"4.3");
    protected static final Version VERSION_44 = Versions.valueOf((String)"4.4");

    public DatabaseMigrationClass() {
        super((TopiaMigrationCallbackByClass.MigrationCallBackForVersionResolver)new MigrationResolver());
    }

    public Version[] getAvailableVersions() {
        Version[] result = new Version[]{VERSION_32, VERSION_33, VERSION_40, VERSION_41, VERSION_421, VERSION_43, VERSION_44};
        return result;
    }

    public Version getApplicationVersion() {
        Version appVersion = Versions.valueOf((String)IsisFishDAOHelper.getModelVersion());
        return appVersion;
    }

    public boolean askUser(Version dbVersion, List<Version> versions) {
        boolean result = false;
        int answer = JOptionPane.showConfirmDialog(null, I18n.t((String)"isisfish.misc.databasemigration.question", (Object[])new Object[]{dbVersion, versions.get(versions.size() - 1)}), I18n.t((String)"isisfish.misc.databasemigration.title", (Object[])new Object[0]), 0, 3);
        if (answer == 0) {
            result = true;
        }
        return result;
    }

    protected static class MigrationResolver
    implements TopiaMigrationCallbackByClass.MigrationCallBackForVersionResolver {
        protected MigrationResolver() {
        }

        public Class<? extends TopiaMigrationCallbackByClass.MigrationCallBackForVersion> getCallBack(Version version) {
            Class result = null;
            if (version.equals((Object)VERSION_32)) {
                result = MigrationV0V32.class;
            } else if (version.equals((Object)VERSION_33)) {
                result = MigrationV32V33.class;
            } else if (version.equals((Object)VERSION_40)) {
                result = MigrationV33V40.class;
            } else if (version.equals((Object)VERSION_41)) {
                result = MigrationV40V41.class;
            } else if (version.equals((Object)VERSION_421)) {
                result = MigrationV41V421.class;
            } else if (version.equals((Object)VERSION_43)) {
                result = MigrationV421V43.class;
            } else if (version.equals((Object)VERSION_44)) {
                result = MigrationV43V44.class;
            }
            return result;
        }
    }
}

