package fr.ifremer.isisfish.ui.simulator;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ResultChoiceUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SENSITIVITY = "sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LIST_RESULT_NAMES_SELECTION_MODEL = "listResultNames.selectionModel";
    public static final String BINDING_RESULT_DELETE_AFTER_EXPORT_CHECK_BOX_VISIBLE = "resultDeleteAfterExportCheckBox.visible";
    public static final String BINDING_SENSITIVITY_ONLY_KEEP_FIRST_RESULT_CHECK_BOX_VISIBLE = "sensitivityOnlyKeepFirstResultCheckBox.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVPW8TQRDdGJzEDuYjVkKigAjBokE6Iz4aEgFJIAJjPhSDhDAFa98kXljvHrt74UKB+An8BOhpkOioEAU1BQ3iLyBEQYuYvbN9PjCJwcLF2dqZ9+bNu53xyy8krRU5fJ8GgaN8YVgTnNLi7dvXa/ehbi6ArivmGalI9BlKkVSVjLmdc23IkWrZwosteHFZNj0pQHSh58skq80mB90AMIYcTCLqWhcrnfB84PmqzdoR1Yv1+bevqWfu0xcpQgIP1WWxldntUHEnO8skxVxDxrHSBi1yKtZRhmJiHfXm7Nkyp1pfo014SJ6QkTIZ9qhCMkPm+m855AjxgWfIaKF0gwrgxw0primHrSloAn5rpteYbjg+czRr+pwihbMK2udmuSFZHW5d9ryQZtiQkQYVLgdlyKm/4rgUwWKiMQ1CM8M2mNk0ZJ9t2bE2OEtScqAizkTdZVoLdY/btMDRj9AoJzq1SZlObq5QqtSV5Nx2ioD9CUAcSqL2cKZNpNY6rlt64kIYtqkTsQ2Fm7TGbYWpxEuPAGEsWeKQCukvAAcDi2sG1MXAkwrdgfqDJRkYMpEo2T638JkOy9Eu064LvnkFwFthqi2+GzSbRGYKpSXfGClQcj5RKTpuZSsyk+gHx8OJxyO+v0NVklY+t1ZNVX+fqFUMRbM09cssWcIw+mMy//HN59cr7QHKYe2Jnqld848X21PSw+vHbOk90fT4hvHiVerNV0lGo8H1aDkc6CGs0gqjOKwX3ToLdy5R3UCK9Mint+8m733YQVIrJMsldVeozb9MMqaBr7AhuRt4586HinY9GsXnXqvNkGFONyVaSXYvuNTQ2RoTLvp7NkATDvQwoaOklnn/PV95db5txBAKm/5jemxG+g4ZZoIzAeEuaa2JnrtjzNPguzJeB70WxJD9znqtuTsWPou9Os03pGKPpTCUL3K2LprhWhpfiMTMUoN7rOYbwNYtx8mwJ/vrdFgi30eJnQaCcOLO/DvHrjpwvgrCBQXKZp3ozTXdB1cuulZMiqvShQHJdifI+IBsoxEbuFvwHNqWxx6f28Lw7RlwJ27g30Br8Q0kpLIFw9zArfTHcPe/aiggw0/4+HD3AAkAAA==";
    private static final Log log = LogFactory.getLog(ResultChoiceUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ResultChoiceHandler handler;
    protected JList<String> listResultNames;
    protected JCheckBox resultDeleteAfterExportCheckBox;
    protected Boolean sensitivity;
    protected JCheckBox sensitivityOnlyKeepFirstResultCheckBox;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JLabel $JLabel0;
    private ResultChoiceUI $JPanel0 = this;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ResultChoiceUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ResultChoiceUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultChoiceUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ResultChoiceUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultChoiceUI() {
        $initialize();
    }

    public ResultChoiceUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultChoiceUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ResultChoiceUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveConfigResultNames();
    }

    public void doItemStateChanged__on__resultDeleteAfterExportCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.getParameters().setResultDeleteAfterExport(resultDeleteAfterExportCheckBox.isSelected());
    }

    public void doItemStateChanged__on__sensitivityOnlyKeepFirstResultCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.getParameters().setSensitivityAnalysisOnlyKeepFirst(sensitivityOnlyKeepFirstResultCheckBox.isSelected());
    }

    public void doValueChanged__on__listResultNames(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveParametersResultNames(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ResultChoiceHandler getHandler() {
        return handler;
    }

    public JList<String> getListResultNames() {
        return listResultNames;
    }

    public JCheckBox getResultDeleteAfterExportCheckBox() {
        return resultDeleteAfterExportCheckBox;
    }

    public Boolean getSensitivity() {
        return sensitivity;
    }

    public JCheckBox getSensitivityOnlyKeepFirstResultCheckBox() {
        return sensitivityOnlyKeepFirstResultCheckBox;
    }

    public Boolean isSensitivity() {
        return sensitivity !=null && sensitivity;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSensitivity(Boolean sensitivity) {
        Boolean oldValue = this.sensitivity;
        this.sensitivity = sensitivity;
        firePropertyChange(PROPERTY_SENSITIVITY, oldValue, sensitivity);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHandler() {
        $objectMap.put("handler", handler = new ResultChoiceHandler(this));
    }

    protected void createListResultNames() {
        $objectMap.put("listResultNames", listResultNames = new JList<String>());
        
        listResultNames.setName("listResultNames");
        listResultNames.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__listResultNames"));
    }

    protected void createResultDeleteAfterExportCheckBox() {
        $objectMap.put("resultDeleteAfterExportCheckBox", resultDeleteAfterExportCheckBox = new JCheckBox());
        
        resultDeleteAfterExportCheckBox.setName("resultDeleteAfterExportCheckBox");
        resultDeleteAfterExportCheckBox.setText(t("isisfish.params.resultDeleteAfterExport"));
        resultDeleteAfterExportCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__resultDeleteAfterExportCheckBox"));
    }

    protected void createSensitivity() {
        $objectMap.put("sensitivity", sensitivity = false);
    }

    protected void createSensitivityOnlyKeepFirstResultCheckBox() {
        $objectMap.put("sensitivityOnlyKeepFirstResultCheckBox", sensitivityOnlyKeepFirstResultCheckBox = new JCheckBox());
        
        sensitivityOnlyKeepFirstResultCheckBox.setName("sensitivityOnlyKeepFirstResultCheckBox");
        sensitivityOnlyKeepFirstResultCheckBox.setText(t("isisfish.params.sensitivityOnlyKeepFirstResult"));
        sensitivityOnlyKeepFirstResultCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__sensitivityOnlyKeepFirstResultCheckBox"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JLabel0, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listResultNames);
        // inline complete setup of $Table0
        $Table0.add(resultDeleteAfterExportCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sensitivityOnlyKeepFirstResultCheckBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        listResultNames.setCellRenderer(new fr.ifremer.isisfish.ui.models.result.ResultInfoNameListRenderer());
        listResultNames.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        resultDeleteAfterExportCheckBox.setSelected(handler.getParameters().isResultDeleteAfterExport());
        sensitivityOnlyKeepFirstResultCheckBox.setSelected(handler.getParameters().isSensitivityAnalysisOnlyKeepFirst());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createSensitivity();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setHorizontalAlignment(0);
        $JLabel0.setText(t("isisfish.resultChoice.save"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createListResultNames();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createResultDeleteAfterExportCheckBox();
        createSensitivityOnlyKeepFirstResultCheckBox();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.common.saveNextSimulation"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LIST_RESULT_NAMES_SELECTION_MODEL, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (listResultNames != null) {
                    listResultNames.addPropertyChangeListener("selectionModel", this);
                }
                if (listResultNames != null) {
                    listResultNames.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (listResultNames != null) {
                    listResultNames.setSelectionModel(new jaxx.runtime.swing.OneClicListSelectionModel(listResultNames.getSelectionModel(), listResultNames.getModel()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (listResultNames != null) {
                    listResultNames.removePropertyChangeListener("selectionModel", this);
                }
                if (listResultNames != null) {
                    listResultNames.removePropertyChangeListener("model", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESULT_DELETE_AFTER_EXPORT_CHECK_BOX_VISIBLE, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                resultDeleteAfterExportCheckBox.setVisible(!isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SENSITIVITY_ONLY_KEEP_FIRST_RESULT_CHECK_BOX_VISIBLE, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                sensitivityOnlyKeepFirstResultCheckBox.setVisible(isSensitivity());
            }
        });
    }

}