package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationZonesEditorUI extends InputContentUI<fr.ifremer.isisfish.entities.Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_POPULATION_MAPPING_ZONE_REPRO_ZONE_RECRU_ENABLED = "fieldPopulationMappingZoneReproZoneRecru.enabled";
    public static final String BINDING_FIELD_POPULATION_ZONES_RECRUITMENT_ENABLED = "fieldPopulationZonesRecruitment.enabled";
    public static final String BINDING_FIELD_POPULATION_ZONES_REPRODUCTION_ENABLED = "fieldPopulationZonesReproduction.enabled";
    public static final String BINDING_POPULATION_ZONES_PRESENCE_ENABLED = "populationZonesPresence.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHp5XfiGIJvxSlSFU0ZIt48AAKhB+BpiihkhB6YdqdtkN2Z8eZWVk8GP8E/wS9ezHx5sl48OzBi/FfMMaDV+ObbekPWEqT7WF2O/Pe533f2zfv/S/ULgWaOMCeZwiXKWoTI7W0u/s0d0DyaoXIvKBcOQKVf5EoimZRr1ndlwpNZtPaPVlxTy47NncYYXXec2nUI9WRRWSJEKXQ9UaPvJTJTPV4zuOuOKZWRQVR3/75HX1jvn4XRcjjoK4fUomf51XLpC2NotRUKAaRXuCkhVkRZAjKiqC3T+8tW1jKJ9gmz9Er1JlGHRwLgCl0s/WUfYbv73GF+hMbjLtq2WEKzHc2ZhRaKAiDFgSxCTwllQUqS4ZLDaoNDe5w18KKOszYqr7uQTC5alKIs7PBuY/vUKgtRzBT6E4QEKJRRYmso9QcO0uYmRYRCq2EErNextQrcswjqLAupmfIQ6itkdrCjFh1wRPPcM4iUImRhm9XtvbPtGWs6tCVSKVxjlgzJ8H+rjYaPGV7X/+/Gnw2G3DWl0hl8sKxLC0WAg03BKodNXoN88aqbAkiCcsTha40CqVSaZfx4Hi+2IlGdLxAiWWeqPo24cIx3bze0HYJvdwKhs4GQMeDoXnhUmVDx1SZd08V7UFA0aZO4DYx55CvpvpKyy9AV2jaEUWDQRhoJRurkl4E9Ywi9Nqm/+p3SbmtKlEEutbQIDA2jNrYqN3rSBa1Cxe2oaOypyfNNhyVZ8zIiRmjgf7pv6GB759+flw7HiwxiD0YaFo3F+HCQ44cbhHVoS+Xp4qrqJWEQsxlUbckFgxVf2iOBQjLVI5BHMTzO8bQ7sY6liVAtHf++PxlaP/bBRRdQz2Wg801rO03ULcqQaeVHMv0+MKir+jiYZeeiFobXDHC9DWCWXdp3sQKx3OUmfBlHntQhbGAKlSl5Lq//h3IfFg8rkQElI2eaV6rRvse6qDMooz4Q7YyPwOHai+XxDWd2pwMmpwR/Rzllanx0F/nglJtU8SDAR2bL0ePYwXNlHMVgVy104KfhH5bapGptx/p5QzCWEuEVb2shSE003AjtIbzCQr12pRR27Uz9CVpIibeAqqPC1IgQhAzNOy82ky2RMg2IdxuibAfmtAsi6nQWdwLnUVrhGZZTIcmGKE7vTVCMw0zQPgPBsKd1ToLAAA=";
    private static final Log log = LogFactory.getLog(PopulationZonesEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected MatrixPanelEditor fieldPopulationMappingZoneReproZoneRecru;
    protected JList<Zone> fieldPopulationZonesRecruitment;
    protected JList<Zone> fieldPopulationZonesReproduction;
    protected PopulationZonesEditorHandler handler;
    protected JList<Zone> populationZonesPresence;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationZonesEditorUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationZonesEditorUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationZonesEditorUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationZonesEditorUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationZonesEditorUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationZonesEditorUI() {
        $initialize();
    }

    public PopulationZonesEditorUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationZonesEditorUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationZonesEditorUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doMatrixChanged__on__fieldPopulationMappingZoneReproZoneRecru(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.populationMappingZoneReproZoneRecruMatrixChanged(event);
    }

    public void doValueChanged__on__fieldPopulationZonesRecruitment(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.recruitementChanged();
    }

    public void doValueChanged__on__fieldPopulationZonesReproduction(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.reproductionChanged();
    }

    public void doValueChanged__on__populationZonesPresence(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.presenceChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public MatrixPanelEditor getFieldPopulationMappingZoneReproZoneRecru() {
        return fieldPopulationMappingZoneReproZoneRecru;
    }

    public JList<Zone> getFieldPopulationZonesRecruitment() {
        return fieldPopulationZonesRecruitment;
    }

    public JList<Zone> getFieldPopulationZonesReproduction() {
        return fieldPopulationZonesReproduction;
    }

    public PopulationZonesEditorHandler getHandler() {
        return handler;
    }

    public JList<Zone> getPopulationZonesPresence() {
        return populationZonesPresence;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createFieldPopulationMappingZoneReproZoneRecru() {
        $objectMap.put("fieldPopulationMappingZoneReproZoneRecru", fieldPopulationMappingZoneReproZoneRecru = new MatrixPanelEditor(false));
        
        fieldPopulationMappingZoneReproZoneRecru.setName("fieldPopulationMappingZoneReproZoneRecru");
        fieldPopulationMappingZoneReproZoneRecru.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__fieldPopulationMappingZoneReproZoneRecru"));
        fieldPopulationMappingZoneReproZoneRecru.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.Population.class);
        fieldPopulationMappingZoneReproZoneRecru.putClientProperty("sensitivityMethod", "MappingZoneReproZoneRecru");
    }

    protected void createFieldPopulationZonesRecruitment() {
        $objectMap.put("fieldPopulationZonesRecruitment", fieldPopulationZonesRecruitment = new JList<Zone>());
        
        fieldPopulationZonesRecruitment.setName("fieldPopulationZonesRecruitment");
        fieldPopulationZonesRecruitment.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldPopulationZonesRecruitment"));
    }

    protected void createFieldPopulationZonesReproduction() {
        $objectMap.put("fieldPopulationZonesReproduction", fieldPopulationZonesReproduction = new JList<Zone>());
        
        fieldPopulationZonesReproduction.setName("fieldPopulationZonesReproduction");
        fieldPopulationZonesReproduction.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldPopulationZonesReproduction"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationZonesEditorHandler(this));
    }

    protected void createPopulationZonesPresence() {
        $objectMap.put("populationZonesPresence", populationZonesPresence = new JList<Zone>());
        
        populationZonesPresence.setName("populationZonesPresence");
        populationZonesPresence.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__populationZonesPresence"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(2, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane2, new GridBagConstraints(2, 1, 1, 1, 0.3, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationMappingZoneReproZoneRecru), new GridBagConstraints(0, 3, 3, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(populationZonesPresence);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(fieldPopulationZonesReproduction);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(fieldPopulationZonesRecruitment);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        $JScrollPane0.setMinimumSize(new Dimension(0,0));
        $JScrollPane0.setPreferredSize(new Dimension(0,0));
        $JScrollPane1.setMinimumSize(new Dimension(0,0));
        $JScrollPane1.setPreferredSize(new Dimension(0,0));
        $JScrollPane2.setMinimumSize(new Dimension(0,0));
        $JScrollPane2.setPreferredSize(new Dimension(0,0));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.populationZones.selectPopulationAreas"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationZones.selectSpawningAreas"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationZones.selectRecruitmentAreas"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createPopulationZonesPresence();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFieldPopulationZonesReproduction();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createFieldPopulationZonesRecruitment();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.populationZones.betweenSpawningRecruitmentAreas"));
        createFieldPopulationMappingZoneReproZoneRecru();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_ZONES_PRESENCE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationZonesPresence.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_ZONES_REPRODUCTION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationZonesReproduction.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_ZONES_RECRUITMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationZonesRecruitment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MAPPING_ZONE_REPRO_ZONE_RECRU_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMappingZoneReproZoneRecru.setEnabled(isActive());
            }
        });
    }

}