package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationMigrationMigrationUI extends InputContentUI<Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_COEF_NON_VIDE = "coefNonVide";
    public static final String PROPERTY_GPOP_SELECTED = "gPopSelected";
    public static final String PROPERTY_POP_INFO = "popInfo";
    public static final String PROPERTY_ZONE_ARRIVAL_SELECTED = "zoneArrivalSelected";
    public static final String PROPERTY_ZONE_DEPART_SELECTED = "zoneDepartSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_ARRIVAL_ZONE_CHOOSER_ENABLED = "fieldPopulationMigrationMigrationArrivalZoneChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_COEFFICIENT_ENABLED = "fieldPopulationMigrationMigrationCoefficient.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_DEPARTURE_ZONE_CHOOSER_ENABLED = "fieldPopulationMigrationMigrationDepartureZoneChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_GROUP_CHOOSER_ENABLED = "fieldPopulationMigrationMigrationGroupChooser.enabled";
    public static final String BINDING_POPULATION_MIGRATION_MIGRATION_TABLE_ENABLED = "populationMigrationMigrationTable.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28TRxSemPwgCS2QlAgErZI2QKuWMRChqkpESZwaHOzwwwQhfOnYO7YHrWeGmdmwcED8Cf0T2nsvlXrrqeqh5x56qfovVFUPvSLezNpeb9jYq7o+jNf73ve9771588bf/4WmtEIrT0gYYhVwwzoU72w+enSn/oQ2zDbVDcWkEQpFn4kcytXQvNd/rw36qFa28HwXni+IjhSc8gH0ehnNafPcp7pNqTHo/SSioXW+2jevhzJQPda+qDTWb//5O/eN9+q7HEKhBHVLkMryKFScyWQZ5Zhn0AJE2id5n/AWyFCMt0DvO/ZdwSda75IOfYpeopkympZEAZlBH2ZP2XE4fCgNOrFa4jIwBcENuO+VLhtUbCrMmop2KHxrpptMt3HAMLOOWAoZ+MQwwfHd/mOFtVTyYa8kpYsybdBknRJu0MU0XgjKDKN6gCwGzkCwEm8Kg65kxFYp0YJbTMxyrAX2KvWhfyhU96QtJLbFxVtC+CAtdl14AVXbplBV0wNYy3uxx6L12FSK7RP/EJf5hqDNXcEfMo8eMM20Cfd8qgy6/X8U+VbENlhp4T2HNGyKIdbPoHXwzl3CqT+gYfUBqfsUNvp0ojUjb2eznh/0AUdXd8qkTv3LB4ndW+u00ve91GTU94ZpvqlEIAttIbQtw6kEIbRtXWyJMMnZi3/F/r6QtH02Ml4BNqPJGswdk6VEuAc0NEWLT3LOrW6LRtABAGR8ZhBhAIB7RvmWwKspAq+NFBi1W6DoY+isbmEs+JP0KqylBFkbGaTbscNDHCEenI/FRI22AmMET/qtyCGRXAPBxgjVwjxgAMYdYtp2USzELejxint0bfmVBx4qST8Np0Lsuybc6FoUOpvoVRjQOB7Q8QSdqKEpFcBraO7a2zP9PpiiaX76wDS3hM76emnx95/+/LHYG+ELEPtUquvADQSjVSohoaGZDX08mt+BYX6+QuR6Dc1qNyrc9XQuRVi1awZxEC+aUBaObxHdBoqpmT9+/mXp69+OoFwRzfmCeEVi/Uto1rQVVEH4Xii/vOEUHXt2FNYTVhucdsrthsC+vrvhEUOW64x7sLPXQ6jCuZQq9KXUZ3/9d7H6w41eJSZA2ZlD3eNqTD1G04z7jFN3nXVvqtTra15qGngivpHS7qgJ+31edo/bTbfeTkt10h5PmFEbUfRlYqDN6oGhkKsF3XFJ2Kd7GTnt64pddtMZPh6b4dNMDHt2eTgOwzANl8ZmWBs7i2wMwzRcG5vh87GzyMYwTMMX2RkO0bA+dhbZGIZlcT3DaZ23Z5SoivCi/xD/mWqUmM2xC2IZ3gAIsOdRmQwAAA==";
    private static final Log log = LogFactory.getLog(PopulationMigrationMigrationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected Population bean;
    protected Boolean coefNonVide;
    protected JComboBox<Zone> fieldPopulationMigrationMigrationArrivalZoneChooser;
    protected JTextField fieldPopulationMigrationMigrationCoefficient;
    protected JComboBox<Zone> fieldPopulationMigrationMigrationDepartureZoneChooser;
    protected JComboBox<PopulationGroup> fieldPopulationMigrationMigrationGroupChooser;
    protected Boolean gPopSelected;
    protected PopulationMigrationMigrationHandler handler;
    protected PopulationSeasonInfo popInfo;
    protected MatrixPanelEditor populationMigrationMigrationTable;
    protected JButton remove;
    protected Boolean zoneArrivalSelected;
    protected Boolean zoneDepartSelected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private PopulationMigrationMigrationUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationMigrationMigrationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationMigrationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationMigrationMigrationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationMigrationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationMigrationUI() {
        $initialize();
    }

    public PopulationMigrationMigrationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationMigrationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationMigrationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.add();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.remove();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doItemStateChanged__on__fieldPopulationMigrationMigrationArrivalZoneChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doItemStateChanged__on__fieldPopulationMigrationMigrationDepartureZoneChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doItemStateChanged__on__fieldPopulationMigrationMigrationGroupChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doMatrixChanged__on__populationMigrationMigrationTable(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.populationMigrationMigrationMatrixChanged(event);
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public Population getBean() {
        return bean;
    }

    public Boolean getCoefNonVide() {
        return coefNonVide;
    }

    public JComboBox<Zone> getFieldPopulationMigrationMigrationArrivalZoneChooser() {
        return fieldPopulationMigrationMigrationArrivalZoneChooser;
    }

    public JTextField getFieldPopulationMigrationMigrationCoefficient() {
        return fieldPopulationMigrationMigrationCoefficient;
    }

    public JComboBox<Zone> getFieldPopulationMigrationMigrationDepartureZoneChooser() {
        return fieldPopulationMigrationMigrationDepartureZoneChooser;
    }

    public JComboBox<PopulationGroup> getFieldPopulationMigrationMigrationGroupChooser() {
        return fieldPopulationMigrationMigrationGroupChooser;
    }

    public Boolean getGPopSelected() {
        return gPopSelected;
    }

    public PopulationMigrationMigrationHandler getHandler() {
        return handler;
    }

    public PopulationSeasonInfo getPopInfo() {
        return popInfo;
    }

    public MatrixPanelEditor getPopulationMigrationMigrationTable() {
        return populationMigrationMigrationTable;
    }

    public JButton getRemove() {
        return remove;
    }

    public Boolean getZoneArrivalSelected() {
        return zoneArrivalSelected;
    }

    public Boolean getZoneDepartSelected() {
        return zoneDepartSelected;
    }

    public Boolean isCoefNonVide() {
        return coefNonVide !=null && coefNonVide;
    }

    public Boolean isGPopSelected() {
        return gPopSelected !=null && gPopSelected;
    }

    public Boolean isZoneArrivalSelected() {
        return zoneArrivalSelected !=null && zoneArrivalSelected;
    }

    public Boolean isZoneDepartSelected() {
        return zoneDepartSelected !=null && zoneDepartSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setCoefNonVide(Boolean coefNonVide) {
        Boolean oldValue = this.coefNonVide;
        this.coefNonVide = coefNonVide;
        firePropertyChange(PROPERTY_COEF_NON_VIDE, oldValue, coefNonVide);
    }

    public void setGPopSelected(Boolean gPopSelected) {
        Boolean oldValue = this.gPopSelected;
        this.gPopSelected = gPopSelected;
        firePropertyChange(PROPERTY_GPOP_SELECTED, oldValue, gPopSelected);
    }

    public void setPopInfo(PopulationSeasonInfo popInfo) {
        PopulationSeasonInfo oldValue = this.popInfo;
        this.popInfo = popInfo;
        firePropertyChange(PROPERTY_POP_INFO, oldValue, popInfo);
    }

    public void setZoneArrivalSelected(Boolean zoneArrivalSelected) {
        Boolean oldValue = this.zoneArrivalSelected;
        this.zoneArrivalSelected = zoneArrivalSelected;
        firePropertyChange(PROPERTY_ZONE_ARRIVAL_SELECTED, oldValue, zoneArrivalSelected);
    }

    public void setZoneDepartSelected(Boolean zoneDepartSelected) {
        Boolean oldValue = this.zoneDepartSelected;
        this.zoneDepartSelected = zoneDepartSelected;
        firePropertyChange(PROPERTY_ZONE_DEPART_SELECTED, oldValue, zoneDepartSelected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setEnabled(false);
        add.setText(t("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCoefNonVide() {
        $objectMap.put("coefNonVide", coefNonVide = false);
    }

    protected void createFieldPopulationMigrationMigrationArrivalZoneChooser() {
        $objectMap.put("fieldPopulationMigrationMigrationArrivalZoneChooser", fieldPopulationMigrationMigrationArrivalZoneChooser = new JComboBox<Zone>());
        
        fieldPopulationMigrationMigrationArrivalZoneChooser.setName("fieldPopulationMigrationMigrationArrivalZoneChooser");
        fieldPopulationMigrationMigrationArrivalZoneChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationMigrationMigrationArrivalZoneChooser"));
    }

    protected void createFieldPopulationMigrationMigrationCoefficient() {
        $objectMap.put("fieldPopulationMigrationMigrationCoefficient", fieldPopulationMigrationMigrationCoefficient = new JTextField());
        
        fieldPopulationMigrationMigrationCoefficient.setName("fieldPopulationMigrationMigrationCoefficient");
        fieldPopulationMigrationMigrationCoefficient.setColumns(15);
    }

    protected void createFieldPopulationMigrationMigrationDepartureZoneChooser() {
        $objectMap.put("fieldPopulationMigrationMigrationDepartureZoneChooser", fieldPopulationMigrationMigrationDepartureZoneChooser = new JComboBox<Zone>());
        
        fieldPopulationMigrationMigrationDepartureZoneChooser.setName("fieldPopulationMigrationMigrationDepartureZoneChooser");
        fieldPopulationMigrationMigrationDepartureZoneChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationMigrationMigrationDepartureZoneChooser"));
    }

    protected void createFieldPopulationMigrationMigrationGroupChooser() {
        $objectMap.put("fieldPopulationMigrationMigrationGroupChooser", fieldPopulationMigrationMigrationGroupChooser = new JComboBox<PopulationGroup>());
        
        fieldPopulationMigrationMigrationGroupChooser.setName("fieldPopulationMigrationMigrationGroupChooser");
        fieldPopulationMigrationMigrationGroupChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationMigrationMigrationGroupChooser"));
    }

    protected void createGPopSelected() {
        $objectMap.put("gPopSelected", gPopSelected = false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationMigrationMigrationHandler(this));
    }

    protected void createPopInfo() {
        $objectMap.put("popInfo", popInfo = null);
    }

    protected void createPopulationMigrationMigrationTable() {
        $objectMap.put("populationMigrationMigrationTable", populationMigrationMigrationTable = new MatrixPanelEditor());
        
        populationMigrationMigrationTable.setName("populationMigrationMigrationTable");
        populationMigrationMigrationTable.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__populationMigrationMigrationTable"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(t("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createZoneArrivalSelected() {
        $objectMap.put("zoneArrivalSelected", zoneArrivalSelected = false);
    }

    protected void createZoneDepartSelected() {
        $objectMap.put("zoneDepartSelected", zoneDepartSelected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationMigrationGroupChooser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationMigrationCoefficient, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationMigrationDepartureZoneChooser, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationMigrationArrivalZoneChooser, new GridBagConstraints(3, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(add, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(populationMigrationMigrationTable, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        populationMigrationMigrationTable.setLinearModel(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopInfo();
        createGPopSelected();
        createZoneDepartSelected();
        createZoneArrivalSelected();
        createCoefNonVide();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.common.populationGroup"));
        createFieldPopulationMigrationMigrationGroupChooser();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationMigrationMigration.coefficient"));
        createFieldPopulationMigrationMigrationCoefficient();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = fieldPopulationMigrationMigrationCoefficient.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationMigrationMigration.departureZone"));
        createFieldPopulationMigrationMigrationDepartureZoneChooser();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.populationMigrationMigration.arrivalZone"));
        createFieldPopulationMigrationMigrationArrivalZoneChooser();
        createAdd();
        createPopulationMigrationMigrationTable();
        createRemove();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_GROUP_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationMigrationGroupChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_COEFFICIENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationMigrationCoefficient.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_DEPARTURE_ZONE_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationMigrationDepartureZoneChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_ARRIVAL_ZONE_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationMigrationArrivalZoneChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_MIGRATION_TABLE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationMigrationMigrationTable.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                remove.setEnabled(isActive());
            }
        });
    }

}