package fr.ifremer.isisfish.ui.input.gear;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RangeOfValuesUI extends InputContentUI<Gear> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_GEAR_PARAM_POSSIBLE_VALUE_ENABLED = "fieldGearParamPossibleValue.enabled";
    public static final String BINDING_FIELD_GEAR_PARAM_POSSIBLE_VALUE_TEXT = "fieldGearParamPossibleValue.text";
    public static final String BINDING_FIELD_GEAR_PARAM_TYPE_ENABLED = "fieldGearParamType.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVTPW8TQRAdO3GMEz6Co1iJYqSEREKAWENDEwSBIBNHhlj5QBFuWOfW8UbrvWV3j5wbxE/gJ0BPg0RHhSioKWgQfwEhClrE7NnxBzlkcLFn7cx782b2zetvkDIaFg5oGBIdSMubjKzf3t3dqB2wPXuXmT3NlfU1tH+JJCSrMOF1742FxWrZwQsdeGHVbypfMtmHXi7DuLEtwUyDMWvh3CBiz5jCVje8HKpAH7F2RcWxvvzxPfnCe/4qCRAqVJfGVuaHoXqdjJYhyT0LWaz0lBYElfsoQ3O5j3pPubtVQY15QJvsCTyDdBnGFNVIZuH8v7cccUT4UFmYXCpJFdhVX1pM3yldtXCtrgmva9Zk+DXc1LlpkIAT7hLJPqOabKI0tlF/SEXAzE5JqYhwzMJojVFpYSGOAvm55cyQe0jRg6QbVHqCaQvX/7PwWhvYX933Wjg/N6qQmEOcHFmvUMlEX7mlbVoTDPucGXiZdnYUc5nZLiBb50x4TnOFatrcbilmYXqgBI675t/xQ4eY7gLnBoEV3xiO7JF2C7kBhm0W2qJL71BomBtQh44kPUf2LJOoQkoHeI3tVI+beBNDbfvO/GFfRxhFf+WmPr/7+rZ45NkRrD0dm9q3cuglpX2Fj8Zd6TNtwwaWi8J9qparkDFM4L5G+5iPEbbVCaM4rHfWwYmDkzVqGkiRSn95/yH3+NMIJIswLnzqFanLL0HGNjROwRdeqG6tRIpOHp7Ac9Jpw/dl0r0hrtHpGx61dL7GpYczvhniFPIxU+hKqWU+/pzaerNyNIkEKpv9a3pvGqlHMMal4JJF+9tZzdh9nVCGBZ7fW8G4pUy476zqWHYxOi8cb9VdX3THpTBwn8uRZPfvShTLD2XAhbHouyEcvwGAvlKCkwUAAA==";
    private static final Log log = LogFactory.getLog(RangeOfValuesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Gear bean;
    protected JTextField fieldGearParamPossibleValue;
    protected JComboBox<String> fieldGearParamType;
    protected RangeOfValuesHandler handler;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private RangeOfValuesUI $InputContentUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RangeOfValuesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RangeOfValuesUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public RangeOfValuesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public RangeOfValuesUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RangeOfValuesUI() {
        $initialize();
    }

    public RangeOfValuesUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public RangeOfValuesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public RangeOfValuesUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__fieldGearParamType(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.gearParamChanged();
    }

    public void doKeyReleased__on__fieldGearParamPossibleValue(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.gearParamChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Gear getBean() {
        return bean;
    }

    public JTextField getFieldGearParamPossibleValue() {
        return fieldGearParamPossibleValue;
    }

    public JComboBox<String> getFieldGearParamType() {
        return fieldGearParamType;
    }

    public RangeOfValuesHandler getHandler() {
        return handler;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Gear bean) {
        Gear oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createFieldGearParamPossibleValue() {
        $objectMap.put("fieldGearParamPossibleValue", fieldGearParamPossibleValue = new JTextField());
        
        fieldGearParamPossibleValue.setName("fieldGearParamPossibleValue");
        fieldGearParamPossibleValue.setColumns(15);
        fieldGearParamPossibleValue.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldGearParamPossibleValue"));
    }

    protected void createFieldGearParamType() {
        $objectMap.put("fieldGearParamType", fieldGearParamType = new JComboBox<String>());
        
        fieldGearParamType.setName("fieldGearParamType");
        fieldGearParamType.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldGearParamType"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new RangeOfValuesHandler(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add(fieldGearParamType, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldGearParamPossibleValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFieldGearParamType();
        createFieldGearParamPossibleValue();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_PARAM_TYPE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldGearParamType.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_PARAM_POSSIBLE_VALUE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldGearParamPossibleValue.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_PARAM_POSSIBLE_VALUE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null && getBean().getPossibleValue() != null) {
                    SwingUtil.setText(fieldGearParamPossibleValue, getBean().getPossibleValue() == null ? "" : getBean().getPossibleValue().getValues());
                }
            }
        });
    }

}